/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.costrec.function;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.macc.sca.algox.costrec.CostRecoveryParams;

public class CostRecoverySplitInvOrgQtyFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = -3889215032352238098L;
    private RowMeta srcMeta;
    private Map<String, List<Object[]>> proFinishQtyMap;

    public CostRecoverySplitInvOrgQtyFunction(RowMeta rowMeta, CostRecoveryParams crParams, Map<String, List<Object[]>> proFinishQtyMap) {
        this.srcMeta = rowMeta;
        this.proFinishQtyMap = proFinishQtyMap;
    }

    public RowMeta getSrcMeta() {
        return this.srcMeta;
    }

    public void setSrcMeta(RowMeta srcMeta) {
        this.srcMeta = srcMeta;
    }

    public RowMeta getResultRowMeta() {
        return this.srcMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector coll) {
        Iterator<RowX> it = iterable.iterator();
        ArrayList newRowX = Lists.newArrayList();
        while (it.hasNext()) {
            RowX row = it.next();
            Long materialId = row.getLong(this.srcMeta.getFieldIndex("materialId"));
            Long materialVerId = row.getLong(this.srcMeta.getFieldIndex("materialVerId"));
            Long materialAuxPropId = row.getLong(this.srcMeta.getFieldIndex("materialAuxPropId"));
            BigDecimal finishQty = row.getBigDecimal(this.srcMeta.getFieldIndex("finishQty"));
            BigDecimal finishAmount = row.getBigDecimal(this.srcMeta.getFieldIndex("finishAmount"));
            String key = materialId + "@" + materialVerId + "@" + materialAuxPropId;
            List<Object[]> invQtyMapList = this.proFinishQtyMap.get(key);
            if (invQtyMapList == null || invQtyMapList.size() == 0) continue;
            BigDecimal totalProFinQty = BigDecimal.ZERO;
            for (Object[] objArr : invQtyMapList) {
                BigDecimal qty = (BigDecimal)objArr[1];
                totalProFinQty = totalProFinQty.add(qty);
            }
            if (totalProFinQty.compareTo(BigDecimal.ZERO) == 0) continue;
            RowX maxQtyRowX = null;
            BigDecimal compareQty = BigDecimal.ZERO;
            BigDecimal diffAmt = finishAmount;
            BigDecimal diffQty = finishQty;
            for (Object[] objArr : invQtyMapList) {
                Long invOrgId = (Long)objArr[0];
                BigDecimal qty = (BigDecimal)objArr[1];
                BigDecimal ratio = qty.divide(totalProFinQty, 10, RoundingMode.HALF_UP);
                BigDecimal invFinQty = finishQty.multiply(ratio).setScale(10, RoundingMode.HALF_UP);
                BigDecimal invFinAmt = finishAmount.multiply(ratio).setScale(10, RoundingMode.HALF_UP);
                RowX invRowX = row.copy();
                invRowX.set(this.srcMeta.getFieldIndex("productQty"), (Object)qty);
                invRowX.set(this.srcMeta.getFieldIndex("invOrgId"), (Object)invOrgId);
                invRowX.set(this.srcMeta.getFieldIndex("finishQty"), (Object)invFinQty);
                invRowX.set(this.srcMeta.getFieldIndex("finishAmount"), (Object)invFinAmt);
                if (maxQtyRowX == null || qty.compareTo(compareQty) > 0) {
                    maxQtyRowX = invRowX;
                    compareQty = qty;
                }
                diffQty = diffQty.subtract(invFinQty);
                diffAmt = diffAmt.subtract(invFinAmt);
                newRowX.add(invRowX);
            }
            if (maxQtyRowX == null) continue;
            if (diffAmt.compareTo(BigDecimal.ZERO) != 0) {
                int index = this.srcMeta.getFieldIndex("finishAmount");
                maxQtyRowX.set(index, (Object)maxQtyRowX.getBigDecimal(index).add(diffAmt));
            }
            if (diffQty.compareTo(BigDecimal.ZERO) == 0) continue;
            int index = this.srcMeta.getFieldIndex("finishQty");
            maxQtyRowX.set(index, (Object)maxQtyRowX.getBigDecimal(index).add(diffQty));
        }
        for (RowX rowX : newRowX) {
            coll.collect(rowX);
        }
    }
}

