/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.costrec.function;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.sca.algox.costrec.CostRecCalcHelper;
import kd.macc.sca.algox.costrec.CostRecoveryParams;
import kd.macc.sca.algox.utils.BigDecimalUtils;
import org.apache.commons.lang3.StringUtils;

public class CostRecoverySubMatAmtProcessFunction
extends GroupReduceFunction {
    private static final Log logger = LogFactory.getLog(CostRecoverySubMatAmtProcessFunction.class);
    private static final long serialVersionUID = 1L;
    private RowMeta srcMeta;
    private CostRecoveryParams crParams;

    public CostRecoverySubMatAmtProcessFunction(RowMeta srcMeta, CostRecoveryParams crParams) {
        this.srcMeta = srcMeta;
        this.crParams = crParams;
    }

    public RowMeta getResultRowMeta() {
        return this.srcMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        String keytreepath;
        List<RowX> list;
        BigDecimal topQty = BigDecimal.ZERO;
        BigDecimal topAmt = BigDecimal.ZERO;
        int index = 0;
        Long tmpMaterialId = 0L;
        Long tmpCalckeycolId = 0L;
        Long tmpMaterialVerId = 0L;
        Long tmpMaterialAuxPropId = 0L;
        Long topMaterialId = 0L;
        Long topCalckeycolId = 0L;
        LinkedHashMap levelMap = Maps.newLinkedHashMap();
        HashMap parentBigDeciamlMap = Maps.newHashMap();
        HashMap difAmtMap = Maps.newHashMap();
        for (RowX row : iterable) {
            int level;
            String keytreepath2 = row.getString(this.srcMeta.getFieldIndex("keytreepath"));
            if (StringUtils.isEmpty((CharSequence)keytreepath2)) {
                String treepath = row.getString(this.srcMeta.getFieldIndex("treepath"));
                keytreepath2 = CostRecCalcHelper.getKeytreepath(treepath);
                row.set(this.srcMeta.getFieldIndex("keytreepath"), (Object)keytreepath2);
            }
            if (index == 0) {
                topMaterialId = row.getLong(this.srcMeta.getFieldIndex("materialId"));
                topCalckeycolId = row.getLong(this.srcMeta.getFieldIndex("calckeycolId"));
                tmpMaterialId = row.getLong(this.srcMeta.getFieldIndex("tmpMaterialId"));
                tmpMaterialVerId = row.getLong(this.srcMeta.getFieldIndex("tmpMaterialVerId"));
                tmpMaterialAuxPropId = row.getLong(this.srcMeta.getFieldIndex("tmpMaterialAuxPropId"));
                tmpCalckeycolId = row.getLong(this.srcMeta.getFieldIndex("tmpCalckeycolId"));
                topAmt = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("tmpAmount")));
                topQty = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("tmpQty")));
            }
            if (levelMap.get(level = row.getInteger(this.srcMeta.getFieldIndex("level")).intValue()) == null) {
                list = Lists.newArrayList();
                levelMap.put(level, list);
            }
            list = (List)levelMap.get(level);
            list.add(row);
            ++index;
        }
        TreeSet sortSet = new TreeSet((o1, o2) -> o1.compareTo((Integer)o2));
        sortSet.addAll(levelMap.keySet());
        sortSet.comparator();
        Iterator<Object> it = sortSet.iterator();
        ParentBigDecimal topBigDecimal = new ParentBigDecimal();
        topBigDecimal.qty = topQty;
        topBigDecimal.amt = topAmt;
        String topMatKey = CostRecCalcHelper.getKeyIdStr(topMaterialId, topCalckeycolId);
        parentBigDeciamlMap.put(topMatKey, topBigDecimal);
        while (it.hasNext()) {
            list = (List)levelMap.get(it.next());
            HashMap currDifAmtMap = Maps.newHashMap();
            HashMap currDifAmtForListMap = Maps.newHashMapWithExpectedSize((int)16);
            HashMap tmpRowMap = Maps.newHashMap();
            for (RowX rowX : list) {
                keytreepath = rowX.getString(this.srcMeta.getFieldIndex("keytreepath"));
                String tmpTree = keytreepath.substring(0, keytreepath.lastIndexOf("@"));
                ParentBigDecimal tmpBigDecimal = (ParentBigDecimal)parentBigDeciamlMap.get(tmpTree);
                if (tmpBigDecimal == null) {
                    logger.info(String.format("\u8fd8\u539f\u5f02\u5e38SubMat\uff1atreepath %s, tmpTree\uff1a%s", keytreepath, tmpTree));
                    continue;
                }
                BigDecimal parentAmt = tmpBigDecimal.amt;
                BigDecimal unitQty = BigDecimalUtils.getBigDecimalOrZero(rowX.getBigDecimal(this.srcMeta.getFieldIndex("qty")));
                BigDecimal amtCoeff = BigDecimalUtils.getBigDecimalOrZero(rowX.getBigDecimal(this.srcMeta.getFieldIndex("amountCoeff")));
                BigDecimal finQty = unitQty.multiply(topBigDecimal.qty).setScale(10, RoundingMode.HALF_UP);
                BigDecimal finAmount = amtCoeff.multiply(topBigDecimal.amt).setScale(this.crParams.getAmtScale(), RoundingMode.HALF_UP);
                rowX.set(this.srcMeta.getFieldIndex("finQty"), (Object)finQty);
                rowX.set(this.srcMeta.getFieldIndex("finAmount"), (Object)finAmount);
                BigDecimal compareAmt = (BigDecimal)difAmtMap.get(tmpTree);
                if (compareAmt == null || finAmount.compareTo(compareAmt) > 0) {
                    difAmtMap.put(tmpTree, finAmount);
                    tmpRowMap.put(tmpTree, rowX);
                }
                if (currDifAmtMap.get(tmpTree) == null) {
                    currDifAmtMap.put(tmpTree, parentAmt);
                }
                List rowList = currDifAmtForListMap.computeIfAbsent(tmpTree, p -> Lists.newArrayList());
                rowList.add(rowX);
                BigDecimal tmp = (BigDecimal)currDifAmtMap.get(tmpTree);
                currDifAmtMap.put(tmpTree, tmp.subtract(finAmount));
            }
            for (Map.Entry entry : currDifAmtMap.entrySet()) {
                String parentTreePath = (String)entry.getKey();
                BigDecimal difAmt = (BigDecimal)entry.getValue();
                if (BigDecimal.ZERO.compareTo(difAmt) == 0) continue;
                if (difAmt.abs().compareTo(new BigDecimal("0.01")) <= 0) {
                    RowX row = (RowX)tmpRowMap.get(parentTreePath);
                    BigDecimal bigde = row.getBigDecimal(this.srcMeta.getFieldIndex("finAmount"));
                    bigde = bigde.add(difAmt);
                    row.set(this.srcMeta.getFieldIndex("finAmount"), (Object)bigde);
                    continue;
                }
                logger.info(String.format("\u591a\u7ea7\u8c03\u5dee\uff1a%s parentTreePath\uff1a%s", difAmt, parentTreePath));
                List rowList = (List)currDifAmtForListMap.get(parentTreePath);
                BigDecimal tmpTotalAmt = BigDecimal.ZERO;
                for (RowX row : rowList) {
                    BigDecimal tmp = row.getBigDecimal(this.srcMeta.getFieldIndex("finAmount"));
                    tmpTotalAmt = tmpTotalAmt.add(tmp);
                }
                if (tmpTotalAmt.compareTo(BigDecimal.ZERO) == 0) {
                    RowX row = (RowX)tmpRowMap.get(parentTreePath);
                    if (row == null) continue;
                    BigDecimal bigde = row.getBigDecimal(this.srcMeta.getFieldIndex("finAmount"));
                    bigde = bigde.add(difAmt);
                    row.set(this.srcMeta.getFieldIndex("finAmount"), (Object)bigde);
                    continue;
                }
                RowX tmpRow = null;
                BigDecimal compareTmp = BigDecimal.ZERO;
                BigDecimal calDifAmt = difAmt;
                for (RowX row : rowList) {
                    if (difAmt.compareTo(BigDecimal.ZERO) == 0) break;
                    BigDecimal tmp = row.getBigDecimal(this.srcMeta.getFieldIndex("finAmount"));
                    if (tmpRow == null || tmp.compareTo(compareTmp) > 0) {
                        compareTmp = tmp;
                        tmpRow = row;
                    }
                    BigDecimal radio = tmp.divide(tmpTotalAmt, 10, RoundingMode.HALF_UP);
                    BigDecimal tmpDifAmt = calDifAmt.multiply(radio).setScale(this.crParams.getAmtScale(), RoundingMode.HALF_UP);
                    logger.info(String.format("\u6811\u8def\u5f84\uff1a%s \u539f\u503c:%s \u4e8c\u7ea7\u5dee\u5f02\uff1a%s ", row.getString(this.srcMeta.getFieldIndex("treepath")), tmp, tmpDifAmt));
                    row.set(this.srcMeta.getFieldIndex("finAmount"), (Object)tmp.add(tmpDifAmt));
                    difAmt = difAmt.subtract(tmpDifAmt);
                }
                if (difAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                logger.info(String.format("\u4e8c\u6b21\u8c03\u5dee\u540e\u8fd8\u6709\u7684\u5dee\u5f02\uff1a%s ", difAmt));
                if (tmpRow == null) continue;
                BigDecimal tmp = tmpRow.getBigDecimal(this.srcMeta.getFieldIndex("finAmount"));
                tmpRow.set(this.srcMeta.getFieldIndex("finAmount"), (Object)tmp.add(difAmt));
            }
            for (RowX rowX : list) {
                BigDecimal qty = rowX.getBigDecimal(this.srcMeta.getFieldIndex("finQty"));
                BigDecimal amt = rowX.getBigDecimal(this.srcMeta.getFieldIndex("finAmount"));
                String keytreepath3 = rowX.getString(this.srcMeta.getFieldIndex("keytreepath"));
                ParentBigDecimal pbd = (ParentBigDecimal)parentBigDeciamlMap.get(keytreepath3);
                if (pbd == null) {
                    pbd = new ParentBigDecimal();
                    parentBigDeciamlMap.put(keytreepath3, pbd);
                }
                pbd.amt = pbd.amt.add(amt);
                pbd.qty = pbd.qty.add(qty);
            }
        }
        it = sortSet.iterator();
        String matKey = CostRecCalcHelper.getKeyIdStr(tmpMaterialId, tmpCalckeycolId);
        while (it.hasNext()) {
            List list2 = (List)levelMap.get(it.next());
            for (RowX row : list2) {
                row.set(this.srcMeta.getFieldIndex("materialId"), (Object)tmpMaterialId);
                row.set(this.srcMeta.getFieldIndex("materialVerId"), (Object)tmpMaterialVerId);
                row.set(this.srcMeta.getFieldIndex("materialAuxPropId"), (Object)tmpMaterialAuxPropId);
                row.set(this.srcMeta.getFieldIndex("calckeycolId"), (Object)tmpCalckeycolId);
                int level = row.getInteger(this.srcMeta.getFieldIndex("level"));
                String string2 = row.getString(this.srcMeta.getFieldIndex("treepath"));
                string2 = tmpMaterialId + "@" + string2;
                keytreepath = row.getString(this.srcMeta.getFieldIndex("keytreepath"));
                row.set(this.srcMeta.getFieldIndex("level"), (Object)(++level));
                row.set(this.srcMeta.getFieldIndex("treepath"), (Object)string2);
                row.set(this.srcMeta.getFieldIndex("keytreepath"), (Object)(matKey + "@" + keytreepath));
                collector.collect(row);
            }
        }
    }

    private static class ParentBigDecimal {
        private BigDecimal qty = BigDecimal.ZERO;
        private BigDecimal amt = BigDecimal.ZERO;

        private ParentBigDecimal() {
        }
    }
}

