/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.costrec.function;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.sca.algox.utils.BigDecimalUtils;
import kd.macc.sca.algox.utils.MultivariateHelper;

public class CostRecoveryTransCalcFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private static final Log logger = LogFactory.getLog(CostRecoveryTransCalcFunction.class);
    private RowMeta srcMeta;
    private Map<String, Map<Long, BigDecimal[]>> invOrgRelationMap;
    private boolean isPurTrans = false;

    public RowMeta getSrcMeta() {
        return this.srcMeta;
    }

    public void setSrcMeta(RowMeta srcMeta) {
        this.srcMeta = srcMeta;
    }

    public RowMeta getResultRowMeta() {
        return this.srcMeta;
    }

    public CostRecoveryTransCalcFunction(RowMeta rowMeta, Map<String, Map<Long, BigDecimal[]>> invOrgRelationMap, boolean isPurTrans) {
        this.srcMeta = rowMeta;
        this.invOrgRelationMap = invOrgRelationMap;
        this.isPurTrans = isPurTrans;
    }

    public void reduce(Iterable<RowX> iterable, Collector coll) {
        int i;
        ArrayList list = Lists.newArrayList();
        ArrayList noList = Lists.newArrayList();
        HashMap invOrgIndexMap = Maps.newHashMapWithExpectedSize((int)16);
        int index = 0;
        HashMap nonCalcRowXMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap indexGetRowMap = Maps.newHashMapWithExpectedSize((int)16);
        String orgIdKey = this.isPurTrans ? "calOrgId" : "invOrgId";
        for (RowX row : iterable) {
            Long inInvOrgId = row.getLong(this.srcMeta.getFieldIndex(orgIdKey));
            Long materialId = row.getLong(this.srcMeta.getFieldIndex("materialId"));
            Long materialVerId = row.getLong(this.srcMeta.getFieldIndex("materialVerId"));
            Long materialAuxPropId = row.getLong(this.srcMeta.getFieldIndex("materialAuxPropId"));
            Long calckeycolId = row.getLong(this.srcMeta.getFieldIndex("calckeycolId"));
            int isFlag = row.getInteger(this.srcMeta.getFieldIndex("isFlagEquation"));
            if (isFlag == 0) {
                noList.add(row);
                continue;
            }
            list.add(row);
            String key = inInvOrgId + "@" + materialId + "@" + materialVerId + "@" + materialAuxPropId + "@" + calckeycolId;
            if (this.invOrgRelationMap.get(key) != null) {
                invOrgIndexMap.put(inInvOrgId, index);
                indexGetRowMap.put(index, row);
                ++index;
                continue;
            }
            nonCalcRowXMap.put(inInvOrgId, row);
        }
        for (RowX row : noList) {
            BigDecimal bg1 = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("actAmountForFinish")));
            BigDecimal bg2 = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("actAmountForTrans")));
            BigDecimal bg3 = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("actAmountForPurs")));
            if (bg1.compareTo(BigDecimal.ZERO) == 0 && bg2.compareTo(BigDecimal.ZERO) == 0 && bg3.compareTo(BigDecimal.ZERO) == 0) {
                logger.info(String.format("\u4e0d\u53c2\u4e0e\u65b9\u7a0b\u5f0f\u8ba1\u7b97\u4e14\u4e0d\u6536\u96c6\uff1aisPurTrans:%s rowX:%s", this.isPurTrans, row.toString()));
                continue;
            }
            coll.collect(row);
            logger.info(String.format("\u4e0d\u53c2\u4e0e\u65b9\u7a0b\u5f0f\u8ba1\u7b97\uff1aisPurTrans:%s rowX:%s", this.isPurTrans, row.toString()));
        }
        if (list.size() <= 1) {
            for (RowX rowX : list) {
                coll.collect(rowX);
                logger.info(String.format("\u53ea\u6709\u4e00\u6761\u7684\u8bb0\u5f55\uff0c\u4e0d\u53c2\u4e0e\u65b9\u7a0b\u5f0f\u8ba1\u7b97\uff1aisPurTrans:%s rowX:%s", this.isPurTrans, rowX.toString()));
            }
            return;
        }
        BigDecimal[][] coefQty = new BigDecimal[invOrgIndexMap.size()][invOrgIndexMap.size()];
        BigDecimal[] calQty = new BigDecimal[invOrgIndexMap.size()];
        BigDecimal[][] coefAmt = new BigDecimal[invOrgIndexMap.size()][invOrgIndexMap.size()];
        BigDecimal[] calAmt = new BigDecimal[invOrgIndexMap.size()];
        index = 0;
        for (RowX row : list) {
            int i2;
            Long inInvOrgId = row.getLong(this.srcMeta.getFieldIndex(orgIdKey));
            if (invOrgIndexMap.get(inInvOrgId) == null) continue;
            Long materialId = row.getLong(this.srcMeta.getFieldIndex("materialId"));
            Long materialVerId = row.getLong(this.srcMeta.getFieldIndex("materialVerId"));
            Long materialAuxPropId = row.getLong(this.srcMeta.getFieldIndex("materialAuxPropId"));
            Long calckeycolId = row.getLong(this.srcMeta.getFieldIndex("calckeycolId"));
            String key = inInvOrgId + "@" + materialId + "@" + materialVerId + "@" + materialAuxPropId + "@" + calckeycolId;
            Map<Long, BigDecimal[]> invMap = this.invOrgRelationMap.get(key);
            BigDecimal proActQty = row.getBigDecimal(this.srcMeta.getFieldIndex("proActQty"));
            BigDecimal proActAmt = row.getBigDecimal(this.srcMeta.getFieldIndex("proActAmt"));
            BigDecimal actQty = BigDecimal.ZERO;
            BigDecimal actAmount = BigDecimal.ZERO;
            if (!this.isPurTrans) {
                actQty = row.getBigDecimal(this.srcMeta.getFieldIndex("actQtyForFinish"));
                actAmount = row.getBigDecimal(this.srcMeta.getFieldIndex("actAmountForFinish"));
            } else {
                actQty = row.getBigDecimal(this.srcMeta.getFieldIndex("actQtyForTrans"));
                actAmount = row.getBigDecimal(this.srcMeta.getFieldIndex("actAmountForTrans"));
            }
            int selfIndex = (Integer)invOrgIndexMap.get(inInvOrgId);
            if (invMap != null) {
                BigDecimal transOutAmt;
                BigDecimal transOutQty;
                BigDecimal[] outBds;
                BigDecimal allInQty = BigDecimal.ZERO;
                BigDecimal allInAmt = BigDecimal.ZERO;
                for (Map.Entry<Long, BigDecimal[]> entry : invMap.entrySet()) {
                    outBds = entry.getValue();
                    transOutQty = outBds[0];
                    transOutAmt = outBds[1];
                    allInQty = allInQty.add(transOutQty);
                    allInAmt = allInAmt.add(transOutAmt);
                }
                coefQty[index][selfIndex] = BigDecimal.ZERO.subtract(proActQty.add(allInQty));
                coefAmt[index][selfIndex] = BigDecimal.ZERO.subtract(proActAmt.add(allInAmt));
                for (Map.Entry<Long, BigDecimal[]> entry : invMap.entrySet()) {
                    outBds = entry.getValue();
                    transOutQty = outBds[0];
                    transOutAmt = outBds[1];
                    Long invOrgId = entry.getKey();
                    if (invOrgIndexMap.get(invOrgId) != null) {
                        int otherIndex = (Integer)invOrgIndexMap.get(invOrgId);
                        coefQty[index][otherIndex] = transOutQty;
                        coefAmt[index][otherIndex] = transOutAmt;
                        continue;
                    }
                    RowX tmpRow = (RowX)nonCalcRowXMap.get(invOrgId);
                    if (tmpRow == null) continue;
                    BigDecimal unitQty = BigDecimalUtils.getBigDecimalOrZero(tmpRow.getBigDecimal(this.srcMeta.getFieldIndex("unitQty")));
                    BigDecimal amountCoeff = BigDecimalUtils.getBigDecimalOrZero(tmpRow.getBigDecimal(this.srcMeta.getFieldIndex("amountCoeff")));
                    BigDecimal tmpQty = transOutQty.multiply(unitQty).setScale(10, RoundingMode.HALF_UP);
                    BigDecimal tmpAmt = amountCoeff.multiply(transOutAmt).setScale(10, RoundingMode.HALF_UP);
                    actQty = actQty.add(tmpQty);
                    actAmount = actAmount.add(tmpAmt);
                }
            } else {
                coefQty[index][selfIndex] = BigDecimal.ZERO.subtract(proActQty);
                coefAmt[index][selfIndex] = BigDecimal.ZERO.subtract(proActAmt);
            }
            for (i2 = 0; i2 < coefQty[index].length; ++i2) {
                if (coefQty[index][i2] != null) continue;
                coefQty[index][i2] = BigDecimal.ZERO;
            }
            for (i2 = 0; i2 < coefAmt[index].length; ++i2) {
                if (coefAmt[index][i2] != null) continue;
                coefAmt[index][i2] = BigDecimal.ZERO;
            }
            calQty[index] = BigDecimal.ZERO.subtract(actQty);
            calAmt[index] = BigDecimal.ZERO.subtract(actAmount);
            ++index;
        }
        BigDecimal[] qtyResult = MultivariateHelper.resolve(coefQty, calQty);
        BigDecimal[] amtResult = MultivariateHelper.resolve(coefAmt, calAmt);
        for (i = 0; i < qtyResult.length; ++i) {
            RowX row = (RowX)indexGetRowMap.get(i);
            if (row == null) continue;
            row.set(this.srcMeta.getFieldIndex("unitQty"), (Object)qtyResult[i]);
        }
        for (i = 0; i < amtResult.length; ++i) {
            RowX row = (RowX)indexGetRowMap.get(i);
            if (row == null) continue;
            row.set(this.srcMeta.getFieldIndex("amountCoeff"), (Object)amtResult[i]);
        }
        for (RowX rowX : list) {
            coll.collect(rowX);
        }
    }
}

