/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.costrec.input;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.Collector;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.JoinDataSetX;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.enums.SysParamEnum;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.sca.algox.calc.input.LevelMatCode;
import kd.macc.sca.algox.costrec.CostRecCalcHelper;
import kd.macc.sca.algox.costrec.CostRecoveryParams;
import kd.macc.sca.algox.costrec.input.ActCalcFinishConvFunction;
import kd.macc.sca.algox.costrec.input.CostRecBaseDataInputService;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.DataSetXLogUtil;
import kd.macc.sca.algox.utils.IInfoMsgHandler;
import kd.macc.sca.algox.utils.MaterialLevelHelper;

public class AcaCostRecDataInputService
extends CostRecBaseDataInputService {
    private static final String ALGOKEY = "AcaCostRecDataInputService";
    private static final Log logger = LogFactory.getLog(AcaCostRecDataInputService.class);

    @Override
    public List<Set<String>> getMatLvlList(List<List<String>> nestMatGroupsIds, Set<String> nestMatTreePaths) {
        if ("1".equals(CadBgParamUtils.getCadBgParamForString((String)"acaCostRecNestCalc", (String)"1"))) {
            return this.getMatLvlListNew(nestMatGroupsIds, nestMatTreePaths);
        }
        List lvlList = (List)DispatchServiceHelper.invokeBizService((String)"macc", (String)"aca", (String)"ActCostCalcService", (String)"buildCostReductCalcLvl", (Object[])new Object[]{this.getCrParams().getCalOrgId(), this.getCrParams().getCostAccountId(), this.getCrParams().getPeriodId(), this.getCrParams().getManuOrgId()});
        ArrayList<Set<String>> lvlKeyList = new ArrayList<Set<String>>(lvlList.size());
        for (Set lvl : lvlList) {
            HashSet<String> lvlKey = new HashSet<String>(lvl.size());
            lvlKeyList.add(lvlKey);
            for (Long mat : lvl) {
                lvlKey.add(CostRecCalcHelper.getKeyIdStr(mat, 0L));
            }
        }
        return lvlKeyList;
    }

    private List<Set<String>> getMatLvlListNew(List<List<String>> nestMatGroupsIds, Set<String> nestMatTreePaths) {
        CostRecoveryParams args = this.getCrParams();
        DataSet allocDataSet = this.buildCalcResultDataSet(args).distinct();
        ArrayList<List<String>> nestMatGroups = new ArrayList<List<String>>(10);
        if (nestMatTreePaths == null) {
            nestMatTreePaths = new HashSet<String>(10);
        }
        List<List<LevelMatCode>> materlvl = MaterialLevelHelper.getMatLevelList(allocDataSet, null, null, null, nestMatGroups, nestMatTreePaths, nestMatGroupsIds != null);
        Set<String> prodIds = this.buildCurrentFactMatSet(args);
        Set<String> preProdIds = this.buildPreProductList(args);
        prodIds.addAll(preProdIds);
        for (List list : nestMatGroups) {
            ArrayList<String> nestMatGroupId = new ArrayList<String>(10);
            for (String mat : list) {
                nestMatGroupId.add(CostRecCalcHelper.getKeyIdStr(this.getMaterialIdFromNestGroup(mat), this.getMatKeycolFromNestGroup(mat)));
            }
            nestMatGroupsIds.add(nestMatGroupId);
            prodIds.removeAll(nestMatGroupId);
        }
        ArrayList<Set<String>> lvlMatList = new ArrayList<Set<String>>(10);
        if (materlvl == null) {
            materlvl = new ArrayList<List<LevelMatCode>>(10);
        }
        for (List<LevelMatCode> curCalcMat : materlvl) {
            if (curCalcMat.isEmpty()) continue;
            HashSet curCalcMatIdSet = Sets.newHashSetWithExpectedSize((int)curCalcMat.size());
            for (LevelMatCode actCalcMaterial : curCalcMat) {
                curCalcMatIdSet.add(CostRecCalcHelper.getKeyIdStr(actCalcMaterial.getSubmaterial(), actCalcMaterial.getSubcalckeycol()));
            }
            if (curCalcMatIdSet.isEmpty()) continue;
            lvlMatList.add(curCalcMatIdSet);
            prodIds.removeAll(curCalcMatIdSet);
        }
        if (!prodIds.isEmpty()) {
            if (lvlMatList.isEmpty()) {
                lvlMatList.add(prodIds);
            } else {
                ((Set)lvlMatList.get(lvlMatList.size() - 1)).addAll(prodIds);
            }
        }
        return lvlMatList;
    }

    private Set<String> buildPreProductList(CostRecoveryParams args) {
        QFilter prdStructureFilter = new QFilter("org", "=", (Object)args.getCalOrgId());
        prdStructureFilter.and("costaccount", "=", (Object)args.getCostAccountId());
        prdStructureFilter.and("period", "=", (Object)args.getPeriodId());
        if (!CadEmptyUtils.isEmpty(args.getManuOrgId())) {
            prdStructureFilter.and("prdorg", "=", (Object)args.getManuOrgId());
        }
        prdStructureFilter.and("billstatus", "=", (Object)"C");
        String selectFields = "material.id as material," + (args.isCalcKeycol() ? "calckeycol.id" : "0L") + " as calckeycol";
        DataSet prdStructure = QueryServiceHelper.queryDataSet((String)"AcaCostRecDataInputServiceprdstructure", (String)"sca_halfprdstructure", (String)selectFields, (QFilter[])prdStructureFilter.toArray(), null);
        HashSet<String> preProductSet = new HashSet<String>(10);
        for (Row row : prdStructure) {
            preProductSet.add(CostRecCalcHelper.getKeyIdStr(row.getLong("material"), row.getLong("calckeycol")));
        }
        return preProductSet;
    }

    public Set<String> buildCurrentFactMatSet(CostRecoveryParams args) {
        QFilter filter = new QFilter("org", "=", (Object)args.getCalOrgId());
        filter.and("appnum", "=", (Object)"aca");
        filter.and("bookdate", ">=", (Object)args.getStartDate());
        filter.and("bookdate", "<=", (Object)args.getEndDate());
        filter.and("billstatus", "=", (Object)"C");
        if (!CadEmptyUtils.isEmpty(args.getManuOrgId())) {
            filter.and("manuorg", "=", (Object)args.getManuOrgId());
        }
        String selectFields = "entryentity.costobject.material material," + (args.isCalcKeycol() ? "entryentity.costobject.calckeycol" : "0L") + " calckeycol";
        DataSet factned = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cad_factnedoutputbill", (String)selectFields, (QFilter[])filter.toArray(), null);
        HashSet currentFactMatSet = Sets.newHashSetWithExpectedSize((int)32);
        for (Row row : factned) {
            currentFactMatSet.add(CostRecCalcHelper.getKeyIdStr(row.getLong("material"), row.getLong("calckeycol")));
        }
        return currentFactMatSet;
    }

    private DataSet buildCalcResultDataSet(CostRecoveryParams args) {
        QFilter filter = new QFilter("period", "=", (Object)args.getPeriodId());
        filter.and("org", "=", (Object)args.getCalOrgId());
        filter.and("costaccount", "=", (Object)args.getCostAccountId());
        if (!CadEmptyUtils.isEmpty(args.getManuOrgId())) {
            filter.and("costobject.manuorg.id", "=", (Object)args.getManuOrgId());
        }
        filter.and("entryentity.submaterial", ">", (Object)0L);
        filter.and("entryentity.relacostobject.producttype", "!=", (Object)"B");
        DataSet calcResult = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"aca_calcresult", (String)("entryentity.relacostobject.material AS material,'' AS materialnumber,0L AS auxpty,0L AS matversion," + (args.isCalcKeycol() ? "entryentity.relacostobject.calckeycol" : "0L") + " AS calckeycol,entryentity.submaterial AS submaterial,'' AS submaterialnumber,0L AS subauxpty,0L AS submatversion," + (args.isCalcKeycol() ? "entryentity.calckeycol" : "0L") + " AS subcalckeycol,entryentity.currcomqty as pdFinQty,entryentity.currcomamount as pdFinAmt"), (QFilter[])filter.toArray(), null);
        return calcResult.filter("pdFinQty!=0 or pdFinAmt!=0").removeFields(new String[]{"pdFinQty", "pdFinAmt"});
    }

    @Override
    public DataSet buildFinishDataSet(Long orgId, Long costaccountId, Set<String> materialSet, IInfoMsgHandler inMsgHandler) {
        DataSet finDataDs = this.getFinishDsFromFact(orgId, costaccountId, materialSet, inMsgHandler);
        ArrayList<String> fieldNames = new ArrayList<String>(Arrays.asList(finDataDs.getRowMeta().getFieldNames()));
        fieldNames.remove("subMaterialId");
        fieldNames.remove("subMertialVerId");
        fieldNames.remove("subMerialAuxPropId");
        fieldNames.remove("subCalckeycolId");
        fieldNames.add("case when subMaterialId>0 then subMaterialId else materialId end subMaterialId");
        fieldNames.add("case when subMaterialId>0 then subMertialVerId else materialVerId end subMertialVerId");
        fieldNames.add("case when subMaterialId>0 then subMerialAuxPropId else materialAuxPropId end subMerialAuxPropId");
        fieldNames.add("case when subMaterialId>0 then subCalckeycolId else calckeycolId end subCalckeycolId");
        finDataDs = finDataDs.select(fieldNames.toArray(new String[0]));
        return finDataDs;
    }

    private DataSet getFinishDsFromFact(Long orgId, Long costaccountId, Set<String> materialSet, IInfoMsgHandler inMsgHandler) {
        DataSet invDs = this.getCalResultFactDs(orgId, costaccountId, materialSet);
        DataSet detailDs = this.getCalResultDetailDs(orgId, costaccountId, materialSet);
        JobSession session = AlgoX.createSession((String)"CostRec-FinishDs");
        DataSetX invDsX = session.fromInput((Input)new DataSetInput(invDs));
        DataSetX detailDsX = session.fromInput((Input)new DataSetInput(detailDs));
        if (SysParamEnum.RESTOREDIMENSION_ORGANDMANUORG.getValue().equals(this.getCrParams().getCalDimension())) {
            DataSet invStInfoDs = this.getCalCostRecordInfoByMaterialId(orgId, costaccountId, materialSet);
            DataSetX invStInfoDsX = session.fromInput((Input)new DataSetInput(invStInfoDs));
            invDsX = invDsX.leftJoin(invStInfoDsX).on("sourcebillentry", "bizbillentryid").select(invDsX.getRowMeta().getFieldNames(), new String[]{"invOrgId"});
            invDsX = invDsX.groupBy(new String[]{"hid", "hcostobject", "invOrgId"}).reduceGroup(new GroupReduceFunction(){
                private static final long serialVersionUID = 1L;

                public RowMeta getResultRowMeta() {
                    return this.sourceRowMeta;
                }

                public void reduce(Iterable<RowX> iterable, Collector collector) {
                    List<RowX> rowXList = DataSetXLogUtil.getListFromIterable(iterable);
                    Object[] sumObj = null;
                    HashSet<Long> entryIds = new HashSet<Long>(10);
                    for (RowX row : rowXList) {
                        Long srcEntryId = row.getLong(this.sourceRowMeta.getFieldIndex("sourcebillentry"));
                        BigDecimal proFinQty = row.getBigDecimal(this.sourceRowMeta.getFieldIndex("productQty"));
                        if (proFinQty == null) {
                            proFinQty = BigDecimal.ZERO;
                        }
                        if (!entryIds.add(srcEntryId)) continue;
                        if (sumObj == null) {
                            sumObj = new Object[]{srcEntryId, proFinQty, proFinQty};
                            continue;
                        }
                        sumObj[2] = proFinQty.add((BigDecimal)sumObj[2]);
                        if (proFinQty.compareTo((BigDecimal)sumObj[1]) <= 0) continue;
                        sumObj[0] = srcEntryId;
                        sumObj[1] = proFinQty;
                    }
                    for (RowX row : rowXList) {
                        if (sumObj != null) {
                            row.set(this.sourceRowMeta.getFieldIndex("sourcebillentry"), (Object)sumObj[0]);
                            row.set(this.sourceRowMeta.getFieldIndex("productQty"), (Object)sumObj[2]);
                        }
                        collector.collect(row);
                    }
                }
            });
            invDsX = invDsX.groupBy(new String[]{"hid", "hcostobject", "hmaterialId", "hmaterialVerId", "hmaterialAuxPropId", "hcalckeycolId", "sourcebillentry", "hsubElementId", "invOrgId"}).max("productQty").sum("pdFinAmount");
            DataSet elementDs = AcaCostRecDataInputService.getElementDs();
            elementDs = elementDs.select("subelement,subelementType hsubElementType, element helementId");
            DataSetX elementDsX = session.fromInput((Input)new DataSetInput(elementDs));
            invDsX = invDsX.leftJoin(elementDsX).on("hsubElementId", "subelement").select(invDsX.getRowMeta().getFieldNames(), new String[]{"hsubElementType", "helementId"});
        } else {
            invDsX = invDsX.addFields(new Field[]{new Field("invOrgId", (DataType)DataType.LongType)}, new Object[]{0L});
        }
        JoinDataSetX finResultDsx = null;
        DataSetX productQtyDsx = null;
        if (SysParamEnum.RESTOREDIMENSION_ORGANDMANUORG.getValue().equals(this.getCrParams().getCalDimension())) {
            detailDsX = detailDsX.groupBy(new String[]{"id", "costobject", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId", "subMaterialId", "subMatUnitPrecision", "subMertialVerId", "subMerialAuxPropId", "subCalckeycolId", "elementId", "subElementId", "subElementType"}).sum("finishQty").sum("finishAmount");
            invDsX = invDsX.groupBy(new String[]{"hid", "hcostobject", "hmaterialId", "hmaterialVerId", "hmaterialAuxPropId", "hcalckeycolId", "sourcebillentry", "helementId", "hsubElementId", "hsubElementType", "invOrgId"}).max("productQty").sum("pdFinAmount");
            JoinDataSetX resultDsx = invDsX.leftJoin(detailDsX).on("hid", "id").on("hcostobject", "costobject").on("hsubElementId", "subElementId").select(invDsX.getRowMeta().getFieldNames(), detailDsX.getRowMeta().getFieldNames());
            resultDsx = DataSetXLogUtil.logDataSetX((DataSetX)resultDsx, this.getCrParams().getDebugColName(), this.getCrParams().getDebugColValue(), ResManager.loadKDString((String)"\u5165\u5e93\u6570\u636e\u4e0e\u5b8c\u5de5\u6570\u636e\u5173\u8054\uff1a", (String)"AcaCostRecDataInputService_0", (String)"macc-sca-algox", (Object[])new Object[0]), inMsgHandler);
            resultDsx = resultDsx.map(new MapFunction(){
                private static final long serialVersionUID = 1L;

                public RowMeta getResultRowMeta() {
                    return this.sourceRowMeta;
                }

                public RowX map(RowX row) {
                    Long materialId = row.getLong(this.sourceRowMeta.getFieldIndex("materialId"));
                    if (!CadEmptyUtils.isEmpty(materialId)) {
                        return row;
                    }
                    row.set(this.sourceRowMeta.getFieldIndex("id"), row.get(this.sourceRowMeta.getFieldIndex("hid")));
                    row.set(this.sourceRowMeta.getFieldIndex("costobject"), row.get(this.sourceRowMeta.getFieldIndex("hcostobject")));
                    row.set(this.sourceRowMeta.getFieldIndex("materialId"), row.get(this.sourceRowMeta.getFieldIndex("hmaterialId")));
                    row.set(this.sourceRowMeta.getFieldIndex("materialVerId"), row.get(this.sourceRowMeta.getFieldIndex("hmaterialVerId")));
                    row.set(this.sourceRowMeta.getFieldIndex("materialAuxPropId"), row.get(this.sourceRowMeta.getFieldIndex("hmaterialAuxPropId")));
                    row.set(this.sourceRowMeta.getFieldIndex("calckeycolId"), row.get(this.sourceRowMeta.getFieldIndex("hcalckeycolId")));
                    row.set(this.sourceRowMeta.getFieldIndex("elementId"), row.get(this.sourceRowMeta.getFieldIndex("helementId")));
                    row.set(this.sourceRowMeta.getFieldIndex("subElementId"), row.get(this.sourceRowMeta.getFieldIndex("hsubElementId")));
                    row.set(this.sourceRowMeta.getFieldIndex("subElementType"), row.get(this.sourceRowMeta.getFieldIndex("hsubElementType")));
                    return row;
                }
            });
            resultDsx = DataSetXLogUtil.logDataSetX((DataSetX)resultDsx, this.getCrParams().getDebugColName(), this.getCrParams().getDebugColValue(), ResManager.loadKDString((String)"\u6309\u5165\u5e93\u5355\u6298\u7b97\u524d\u6570\u636e\uff1a", (String)"AcaCostRecDataInputService_1", (String)"macc-sca-algox", (Object[])new Object[0]), inMsgHandler);
            resultDsx = resultDsx.groupBy(new String[]{"id", "costobject", "subElementId"}).reduceGroup((GroupReduceFunction)new ActCalcFinishConvFunction(this.getCrParams().getAmtScale()));
            resultDsx = DataSetXLogUtil.logDataSetX((DataSetX)resultDsx, this.getCrParams().getDebugColName(), this.getCrParams().getDebugColValue(), ResManager.loadKDString((String)"\u6309\u5165\u5e93\u5355\u6298\u7b97\u540e\u6570\u636e\uff1a", (String)"AcaCostRecDataInputService_2", (String)"macc-sca-algox", (Object[])new Object[0]), inMsgHandler);
            productQtyDsx = resultDsx.groupBy(new String[]{"id", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId", "invOrgId", "sourcebillentry"}).max("productQty");
            productQtyDsx = productQtyDsx.groupBy(new String[]{"materialId", "materialVerId", "materialAuxPropId", "calckeycolId", "invOrgId"}).sum("productQty");
            finResultDsx = resultDsx.groupBy(new String[]{"invOrgId", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "subCalckeycolId", "elementId", "subElementId", "subElementType"}).sum("finishQty").sum("finishAmount");
            finResultDsx = finResultDsx.leftJoin(productQtyDsx).on("invOrgId", "invOrgId").on("materialId", "materialId").on("materialVerId", "materialVerId").on("materialAuxPropId", "materialAuxPropId").on("calckeycolId", "calckeycolId").select(finResultDsx.getRowMeta().getFieldNames(), new String[]{"productQty"});
        } else {
            detailDsX = detailDsX.groupBy(new String[]{"materialId", "materialVerId", "materialAuxPropId", "calckeycolId", "subMaterialId", "subMatUnitPrecision", "subMertialVerId", "subMerialAuxPropId", "subCalckeycolId", "elementId", "subElementId", "subElementType"}).sum("finishQty").sum("finishAmount");
            invDsX = invDsX.groupBy(new String[]{"hmaterialId", "hmaterialVerId", "hmaterialAuxPropId", "hcalckeycolId", "sourcebillentry", "invOrgId"}).max("productQty");
            invDsX = DataSetXLogUtil.logDataSetX(invDsX, this.getCrParams().getDebugColName(), this.getCrParams().getDebugColValue(), ResManager.loadKDString((String)"\u5165\u5e93\u5355\u5b8c\u5de5\u6570\u91cf\uff1a", (String)"AcaCostRecDataInputService_3", (String)"macc-sca-algox", (Object[])new Object[0]), inMsgHandler);
            productQtyDsx = invDsX.groupBy(new String[]{"hmaterialId", "hmaterialVerId", "hmaterialAuxPropId", "hcalckeycolId", "invOrgId"}).sum("productQty");
            finResultDsx = productQtyDsx.leftJoin(detailDsX).on("hmaterialId", "materialId").on("hmaterialVerId", "materialVerId").on("hmaterialAuxPropId", "materialAuxPropId").on("hcalckeycolId", "calckeycolId").select(new String[]{"hmaterialId", "hmaterialVerId", "hmaterialAuxPropId", "hcalckeycolId", "invOrgId", "productQty"}, detailDsX.getRowMeta().getFieldNames());
            finResultDsx = DataSetXLogUtil.logDataSetX((DataSetX)finResultDsx, this.getCrParams().getDebugColName(), this.getCrParams().getDebugColValue(), ResManager.loadKDString((String)"\u5173\u8054\u4ea7\u54c1\u6570\u91cf\uff1a", (String)"AcaCostRecDataInputService_4", (String)"macc-sca-algox", (Object[])new Object[0]), inMsgHandler);
            final Long elementId = this.getCrParams().getDefaultElementId();
            final Long subelementId = this.getCrParams().getDefaultSubElementId();
            finResultDsx = finResultDsx.map(new MapFunction(){
                private static final long serialVersionUID = 1L;

                public RowMeta getResultRowMeta() {
                    return this.sourceRowMeta;
                }

                public RowX map(RowX row) {
                    Long materialId = row.getLong(this.sourceRowMeta.getFieldIndex("materialId"));
                    if (!CadEmptyUtils.isEmpty(materialId)) {
                        return row;
                    }
                    row.set(this.sourceRowMeta.getFieldIndex("materialId"), row.get(this.sourceRowMeta.getFieldIndex("hmaterialId")));
                    row.set(this.sourceRowMeta.getFieldIndex("materialVerId"), row.get(this.sourceRowMeta.getFieldIndex("hmaterialVerId")));
                    row.set(this.sourceRowMeta.getFieldIndex("materialAuxPropId"), row.get(this.sourceRowMeta.getFieldIndex("hmaterialAuxPropId")));
                    row.set(this.sourceRowMeta.getFieldIndex("calckeycolId"), row.get(this.sourceRowMeta.getFieldIndex("hcalckeycolId")));
                    row.set(this.sourceRowMeta.getFieldIndex("elementId"), (Object)elementId);
                    row.set(this.sourceRowMeta.getFieldIndex("subElementId"), (Object)subelementId);
                    row.set(this.sourceRowMeta.getFieldIndex("subElementType"), (Object)"001");
                    return row;
                }
            });
        }
        finResultDsx = finResultDsx.addFields(new Field[]{new Field("isUnAbsorbd", (DataType)DataType.StringType)}, new Object[]{"A"});
        DataSetOutput resultSet = new DataSetOutput(finResultDsx.getRowMeta());
        finResultDsx.output((Output)resultSet);
        try {
            long start = System.currentTimeMillis();
            session.commit(20, TimeUnit.MINUTES);
            logger.info("\u751f\u6210\u8ba1\u7b97\u7ed3\u679c\u5355\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            logger.error("\u751f\u6210\u8ba1\u7b97\u7ed3\u679c\u5355\u51fa\u9519\uff1a", (Throwable)e);
            throw e;
        }
        return session.readDataSet(resultSet.getId());
    }

    private DataSet getCalResultDetailDs(Long orgId, Long costaccountId, Set<String> materialSet) {
        QFilter filter = new QFilter("org.id", "=", (Object)orgId);
        filter.and("costaccount.id", "=", (Object)costaccountId);
        if (this.getCrParams().getManuOrgId() != 0L) {
            filter.and("entryentity.relacostobject.manuorg.id", "=", (Object)this.getCrParams().getManuOrgId());
        }
        filter.and("period.id", "=", (Object)this.getCrParams().getPeriodId());
        if (this.getCrParams().isCalcKeycol()) {
            filter.and(CostRecCalcHelper.getMatKeyQFilter(materialSet, "entryentity.relacostobject.material.id", "entryentity.relacostobject.calckeycol.id"));
        } else {
            filter.and(CostRecCalcHelper.getMatQFilter(materialSet, "entryentity.relacostobject.material.id"));
        }
        filter.and("entryentity.type", "=", (Object)"detail");
        filter.and("entryentity.relaproducttype", "!=", (Object)"B");
        return QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"aca_calcresult", (String)("id,entryentity.relacostobject costobject,entryentity.relacostobject.material materialId,entryentity.relacostobject.bomversion  materialVerId," + (this.getCrParams().isCalcKeycol() ? "entryentity.relacostobject.calckeycol.auxproperty" : "entryentity.relacostobject.auxpty") + "  materialAuxPropId," + (this.getCrParams().isCalcKeycol() ? "entryentity.relacostobject.calckeycol" : "0L") + "  calckeycolId,entryentity.submaterial  subMaterialId,entryentity.submaterial.baseunit.precision as subMatUnitPrecision,entryentity.submatversion  subMertialVerId," + (this.getCrParams().isCalcKeycol() ? "entryentity.calckeycol.auxproperty" : "entryentity.subauxpty") + "  subMerialAuxPropId," + (this.getCrParams().isCalcKeycol() ? "entryentity.calckeycol" : "0L") + "  subCalckeycolId,entryentity.element  elementId,entryentity.subelement  subElementId,entryentity.subelement.type  subElementType,entryentity.currcomqty finishQty,entryentity.currcomamount finishAmount"), (QFilter[])filter.toArray(), null);
    }

    private DataSet getCalResultFactDs(Long orgId, Long costaccountId, Set<String> materialSet) {
        QFilter filter = new QFilter("org.id", "=", (Object)orgId);
        filter.and("costaccount.id", "=", (Object)costaccountId);
        if (this.getCrParams().getManuOrgId() != 0L) {
            filter.and("inventoryentryentity.invcostobject.manuorg.id", "=", (Object)this.getCrParams().getManuOrgId());
        }
        filter.and("period.id", "=", (Object)this.getCrParams().getPeriodId());
        if (this.getCrParams().isCalcKeycol()) {
            filter.and(CostRecCalcHelper.getMatKeyQFilter(materialSet, "inventoryentryentity.invcostobject.material.id", "inventoryentryentity.invcostobject.calckeycol.id"));
        } else {
            filter.and(CostRecCalcHelper.getMatQFilter(materialSet, "inventoryentryentity.invcostobject.material.id"));
        }
        filter.and("inventoryentryentity.invproducttype", "!=", (Object)"B");
        filter.and("inventoryentryentity.carrytype", "!=", (Object)"B");
        return QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"aca_calcresult", (String)("id hid,inventoryentryentity.invcostobject hcostobject,inventoryentryentity.invcostobject.material hmaterialId,inventoryentryentity.invcostobject.bomversion  hmaterialVerId," + (this.getCrParams().isCalcKeycol() ? "inventoryentryentity.invcostobject.calckeycol.auxproperty" : "inventoryentryentity.invcostobject.auxpty") + "  hmaterialAuxPropId," + (this.getCrParams().isCalcKeycol() ? "inventoryentryentity.invcostobject.calckeycol" : "0L") + "  hcalckeycolId,inventoryentryentity.sourcebillentry sourcebillentry,inventoryentryentity.inventorysubelement  hsubElementId,inventoryentryentity.inventoryqty  productQty,inventoryentryentity.inventoryamount  pdFinAmount"), (QFilter[])filter.toArray(), null);
    }

    public static DataSet getElementDs() {
        return QueryServiceHelper.queryDataSet((String)"AcaCostRecDataInputServicegetElement", (String)"cad_elementdetail", (String)"subelement,subelement.type subelementType, element", null, null);
    }

    private DataSet getCalCostRecordInfoByMaterialId(Long orgId, Long costaccountId, Set<String> materialIds) {
        QFilter qFilter = new QFilter("calorg", "=", (Object)orgId);
        qFilter.and("costaccount", "=", (Object)costaccountId);
        qFilter.and("period", "=", (Object)this.getCrParams().getPeriodId());
        qFilter.and("bookdate", ">=", (Object)this.getCrParams().getStartDate());
        qFilter.and("bookdate", "<=", (Object)this.getCrParams().getEndDate());
        qFilter.and(CostRecCalcHelper.getMatQFilter(materialIds, "entry.material.id"));
        qFilter.and("calbilltype", "=", (Object)"IN");
        return QueryServiceHelper.queryDataSet((String)"getCalCostRecord", (String)"cal_costrecord_subentity", (String)"id AS recordid,entry.bizbillentryid AS bizbillentryid,storageorgunit invOrgId", (QFilter[])qFilter.toArray(), null);
    }

    private DataSet getFinishDsFromThird(Long orgId, Long costaccountId, Set<Long> materialSet) {
        logger.info("{}@{}:****factnedDataSet start****", (Object)this.getCrParams().getCalcReportId(), (Object)costaccountId);
        long start = System.currentTimeMillis();
        DataSet calResultDs = this.getCalResultDs(orgId, costaccountId, materialSet);
        logger.info("{}@{}:****factnedDataSet \u83b7\u53d6\u6570\u636e****{}", new Object[]{this.getCrParams().getCalcReportId(), costaccountId, System.currentTimeMillis() - start});
        ArrayList<String> fieldNames = new ArrayList<String>(Arrays.asList(calResultDs.getRowMeta().getFieldNames()));
        fieldNames.remove("subMaterialId");
        fieldNames.remove("subMertialVerId");
        fieldNames.remove("subMerialAuxPropId");
        fieldNames.add("case when subMaterialId>0 then subMaterialId else materialId end subMaterialId");
        fieldNames.add("case when subMaterialId>0 then subMertialVerId else materialVerId end subMertialVerId");
        fieldNames.add("case when subMaterialId>0 then subMerialAuxPropId else materialAuxPropId end subMerialAuxPropId");
        calResultDs = calResultDs.select(fieldNames.toArray(new String[0]));
        if (SysParamEnum.RESTOREDIMENSION_ORGANDMANUORG.getValue().equals(this.getCrParams().getCalDimension())) {
            ArrayList<Long> sourceBillEntryId = new ArrayList<Long>();
            DataSet calResultEntryDs = calResultDs.copy().select("invEntryId").distinct();
            for (Row row : calResultEntryDs) {
                sourceBillEntryId.add(row.getLong("invEntryId"));
            }
            QFilter invQfilter = new QFilter("billentry.id", "in", sourceBillEntryId);
            String invField = "org.id as invOrgId,id as invBillId,billentry.id as sourceBillEntryId";
            DataSet invDataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"im_mdc_mftmanuinbill", (String)invField, (QFilter[])invQfilter.toArray(), null);
            DataSet invOvDataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"im_mdc_omcmplinbill", (String)invField, (QFilter[])invQfilter.toArray(), null);
            DataSet prodinDataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"im_productinbill", (String)invField, (QFilter[])invQfilter.toArray(), null);
            invDataSet = invDataSet.union(new DataSet[]{invOvDataSet, prodinDataSet});
            calResultDs = calResultDs.join(invDataSet).on("invBillId", "invBillId").on("invEntryId", "sourceBillEntryId").select(new String[]{"invEntryId", "materialId", "materialVerId", "materialAuxPropId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "elementId", "subElementId", "subElementType", "finishQty", "finishAmount", "productQty"}, new String[]{"invOrgId"}).finish();
            logger.info("{}@{}:****factnedDataSet \u83b7\u53d6\u6570\u636e****{}", new Object[]{this.getCrParams().getCalcReportId(), costaccountId, System.currentTimeMillis() - start});
        }
        DataSet productDs = calResultDs.copy().groupBy(new String[]{"invOrgId", "invEntryId", "materialId", "materialVerId", "materialAuxPropId"}).max("productQty").finish().groupBy(new String[]{"invOrgId", "materialId", "materialVerId", "materialAuxPropId"}).sum("productQty").finish();
        DataSet subMaterialDs = calResultDs.groupBy(new String[]{"invOrgId", "materialId", "materialVerId", "materialAuxPropId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "elementId", "subElementId", "subElementType"}).sum("finishQty").sum("finishAmount").finish();
        subMaterialDs = subMaterialDs.join(productDs).on("invOrgId", "invOrgId").on("materialId", "materialId").on("materialVerId", "materialVerId").on("materialAuxPropId", "materialAuxPropId").select(new String[]{"invOrgId", "materialId", "materialVerId", "materialAuxPropId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "elementId", "subElementId", "subElementType", "finishQty", "finishAmount"}, new String[]{"productQty"}).finish();
        subMaterialDs = subMaterialDs.addField("'A'", "isUnAbsorbd");
        logger.info("{}@{}:****factnedDataSet end****{}", new Object[]{this.getCrParams().getCalcReportId(), costaccountId, System.currentTimeMillis() - start});
        return subMaterialDs;
    }

    private DataSet getCalResultDs(Long orgId, Long costaccountId, Set<Long> materialSet) {
        QFilter filter = new QFilter("org.id", "=", (Object)orgId);
        filter.and("costaccount.id", "=", (Object)costaccountId);
        if (this.getCrParams().getManuOrgId() != 0L) {
            filter.and("convsubmatentryentity.convcostobject.manuorg.id", "=", (Object)this.getCrParams().getManuOrgId());
        }
        filter.and("period.id", "=", (Object)this.getCrParams().getPeriodId());
        filter.and("convsubmatentryentity.convcostobject.material.id", "in", materialSet);
        filter.and("convsubmatentryentity.convproducttype", "!=", (Object)"B");
        return QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"aca_calcresult", (String)"convsubmatentryentity.convcostobject.material materialId,convsubmatentryentity.convcostobject.bomversion  materialVerId,convsubmatentryentity.convcostobject.auxpty  materialAuxPropId,convsubmatentryentity.convsubmat  subMaterialId,convsubmatentryentity.convsubmatver  subMertialVerId,convsubmatentryentity.convsubauxpty  subMerialAuxPropId,convsubmatentryentity.convelement  elementId,convsubmatentryentity.convsubelement  subElementId,convsubmatentryentity.convsubelement.type  subElementType,convsubmatentryentity.convproqty productQty,convsubmatentryentity.convqty finishQty,convsubmatentryentity.convamt finishAmount,convsubmatentryentity.convsrcbill invBillId,convsubmatentryentity.convsrcbillentry invEntryId,0L invOrgId,convsubmatentryentity.convcostobject costobject,billno", (QFilter[])filter.toArray(), null);
    }
}

