/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.costrec.input;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.macc.sca.algox.utils.BigDecimalUtils;

public class ActCalcFinishConvFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private int amtScale;

    public ActCalcFinishConvFunction(int amtScale) {
        this.amtScale = amtScale;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        ArrayList listRows = Lists.newArrayList();
        for (RowX row : iterable) {
            listRows.add(row);
        }
        if (listRows.size() <= 1) {
            this.collectRow(listRows, collector);
            return;
        }
        HashMap costObjectStCostMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap entryToStOrgMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap entryQtyMap = Maps.newHashMapWithExpectedSize((int)16);
        for (RowX rowx : listRows) {
            Long srcEntryId = rowx.getLong(this.sourceRowMeta.getFieldIndex("sourcebillentry"));
            if (costObjectStCostMap.containsKey(srcEntryId)) continue;
            costObjectStCostMap.put(srcEntryId, BigDecimalUtils.getBigDecimalOrZero(rowx.getBigDecimal(this.sourceRowMeta.getFieldIndex("pdFinAmount"))));
            entryToStOrgMap.put(srcEntryId, rowx.getLong(this.sourceRowMeta.getFieldIndex("invOrgId")));
            entryQtyMap.put(srcEntryId, BigDecimalUtils.getBigDecimalOrZero(rowx.getBigDecimal(this.sourceRowMeta.getFieldIndex("productQty"))));
        }
        if (costObjectStCostMap.size() <= 1) {
            this.collectRow(listRows, collector);
            return;
        }
        List<RowX> colloctorRowx = this.conversionDetail(listRows, costObjectStCostMap, entryToStOrgMap, entryQtyMap, collector);
        for (RowX rowx : colloctorRowx) {
            collector.collect(rowx);
        }
    }

    private List<RowX> conversionDetail(List<RowX> listRows, Map<Long, BigDecimal> costObjectStCostMap, Map<Long, Long> entryToStOrgMap, Map<Long, BigDecimal> entryQtyMap, Collector collector) {
        int finQtyIndex = this.sourceRowMeta.getFieldIndex("finishQty");
        int finAmtIndex = this.sourceRowMeta.getFieldIndex("finishAmount");
        Map<Long, BigDecimal> costobjectAllocRadioMap = this.getCostobjectAllocRadio(costObjectStCostMap);
        List<RowX> allocRowXs = this.getAllocRowxs(listRows, costobjectAllocRadioMap);
        ArrayList colloctorRowx = Lists.newArrayList();
        for (RowX rowx : allocRowXs) {
            RowX maxRow = null;
            BigDecimal qtyDiff = BigDecimalUtils.getBigDecimalOrZero(rowx.getBigDecimal(finQtyIndex));
            BigDecimal amtDiff = BigDecimalUtils.getBigDecimalOrZero(rowx.getBigDecimal(finAmtIndex));
            Integer subMatUnitPrecision = rowx.getInteger(this.sourceRowMeta.getFieldIndex("subMatUnitPrecision"));
            if (subMatUnitPrecision == null) {
                subMatUnitPrecision = 0;
            }
            for (Map.Entry<Long, BigDecimal> entry : costobjectAllocRadioMap.entrySet()) {
                RowX targetRow = rowx.copy();
                BigDecimal qty = BigDecimalUtils.getBigDecimalOrZero(targetRow.getBigDecimal(finQtyIndex));
                BigDecimal amt = BigDecimalUtils.getBigDecimalOrZero(targetRow.getBigDecimal(finAmtIndex));
                amt = amt.multiply(entry.getValue()).setScale(this.amtScale, RoundingMode.HALF_UP);
                qty = qty.multiply(entry.getValue()).setScale((int)subMatUnitPrecision, RoundingMode.HALF_UP);
                qtyDiff = qtyDiff.subtract(qty);
                amtDiff = amtDiff.subtract(amt);
                if (maxRow == null || maxRow.getBigDecimal(finAmtIndex).compareTo(amt) < 0) {
                    maxRow = targetRow;
                }
                targetRow.set(this.sourceRowMeta.getFieldIndex("sourcebillentry"), (Object)entry.getKey());
                targetRow.set(this.sourceRowMeta.getFieldIndex("invOrgId"), (Object)entryToStOrgMap.get(entry.getKey()));
                targetRow.set(this.sourceRowMeta.getFieldIndex("productQty"), (Object)entryQtyMap.get(entry.getKey()));
                targetRow.set(finQtyIndex, (Object)qty);
                targetRow.set(finAmtIndex, (Object)amt);
                colloctorRowx.add(targetRow);
            }
            if (qtyDiff.compareTo(BigDecimal.ZERO) != 0 && maxRow != null) {
                maxRow.set(finQtyIndex, (Object)maxRow.getBigDecimal(finQtyIndex).add(qtyDiff));
            }
            if (amtDiff.compareTo(BigDecimal.ZERO) == 0 || maxRow == null) continue;
            maxRow.set(finAmtIndex, (Object)maxRow.getBigDecimal(finAmtIndex).add(amtDiff));
        }
        return colloctorRowx;
    }

    private List<RowX> getAllocRowxs(List<RowX> rowXList, Map<Long, BigDecimal> costobjectAllocRadioMap) {
        Long selEntryId = 0L;
        Iterator<Long> iterator = costobjectAllocRadioMap.keySet().iterator();
        while (iterator.hasNext()) {
            Long entryId;
            selEntryId = entryId = iterator.next();
        }
        ArrayList allocRowXs = Lists.newArrayList();
        for (RowX rowx : rowXList) {
            Long entryId = rowx.getLong(this.sourceRowMeta.getFieldIndex("sourcebillentry"));
            if (!selEntryId.equals(entryId)) continue;
            allocRowXs.add(rowx);
        }
        return allocRowXs;
    }

    private Map<Long, BigDecimal> getCostobjectAllocRadio(Map<Long, BigDecimal> costObjectCostMap) {
        HashMap costobjectAllocRadioMap = Maps.newHashMapWithExpectedSize((int)16);
        BigDecimal totalAmt = BigDecimal.ZERO;
        BigDecimal maxValue = null;
        for (Map.Entry<Long, BigDecimal> entry : costObjectCostMap.entrySet()) {
            totalAmt = totalAmt.add(entry.getValue());
            if (maxValue != null && maxValue.compareTo(entry.getValue().abs()) >= 0) continue;
            maxValue = entry.getValue().abs();
        }
        if (totalAmt.compareTo(BigDecimal.ZERO) == 0 && ((totalAmt = maxValue) == null || totalAmt.compareTo(BigDecimal.ZERO) == 0)) {
            for (Map.Entry<Long, BigDecimal> entry : costObjectCostMap.entrySet()) {
                costobjectAllocRadioMap.put(entry.getKey(), BigDecimal.ZERO);
            }
            return costobjectAllocRadioMap;
        }
        for (Map.Entry<Long, BigDecimal> entry : costObjectCostMap.entrySet()) {
            costobjectAllocRadioMap.put(entry.getKey(), entry.getValue().divide(totalAmt, 10, RoundingMode.HALF_UP));
        }
        return costobjectAllocRadioMap;
    }

    private void collectRow(List<RowX> listRows, Collector collector) {
        for (RowX row : listRows) {
            collector.collect(row);
        }
    }
}

