/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.costrec.input;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.input.OrmInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.enums.SysParamEnum;
import kd.macc.sca.algox.costrec.CostRecCalcHelper;
import kd.macc.sca.algox.costrec.CostRecoveryParams;
import kd.macc.sca.algox.costrec.function.CostRecDealKeycolFunction;
import kd.macc.sca.algox.costrec.input.CostRecDataInputService;
import kd.macc.sca.algox.utils.DataSetHelper;
import kd.macc.sca.algox.utils.DataSetXHelper;
import kd.macc.sca.algox.utils.PeriodHelper;

public abstract class CostRecBaseDataInputService
implements CostRecDataInputService {
    private static final String ALGOKEY = "CostRecBaseDataInputService";
    private static final Log logger = LogFactory.getLog(CostRecBaseDataInputService.class);
    private CostRecoveryParams crParams;

    public CostRecoveryParams getCrParams() {
        return this.crParams;
    }

    public void setCrParams(CostRecoveryParams crParams) {
        this.crParams = crParams;
    }

    @Override
    public DataSet buildPreConstrDataSet(Long orgId, Long costaccountId, Long periodId, Set<String> materialIdSet) {
        QFilter filter = new QFilter("org.id", "=", (Object)orgId);
        filter.and("billstatus", "=", (Object)"C");
        filter.and("costaccount.id", "=", (Object)costaccountId);
        if (this.getCrParams().getManuOrgId() != 0L) {
            filter.and("prdorg.id", "=", (Object)this.getCrParams().getManuOrgId());
        }
        filter.and("period.id", "=", (Object)periodId);
        filter.and(CostRecCalcHelper.getMatKeyQFilter(materialIdSet, "material.id", "calckeycol.id"));
        return QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"sca_halfprdhide", (String)"storageorgunit.id as invOrgId,entryentity.level as level,entryentity.treepath as treepath,entryentity.keytreepath as keytreepath,material.id as materialId,materialversion.id as materialVerId,auxprop.id as materialAuxPropId,calckeycol as calckeycolId,entryentity.submaterial.id  as subMaterialId,entryentity.submaterialversion.id as subMertialVerId,entryentity.submaterialauxprop.id as subMerialAuxPropId,entryentity.subcalckeycol.id as subCalckeycolId,entryentity.element.id as elementId,entryentity.subelement.id as subElementId,entryentity.subelement.type as subElementType,entryentity.qty as qty,entryentity.amountCoeff as amountCoeff,entryentity.isunabsorb as isUnAbsorbd", (QFilter[])filter.toArray(), null);
    }

    @Override
    public DataSet buildPreConstrDataSet(Long orgId, Long costaccountId, Long periodId, Set<String> materialIdSet, Map<String, Set<String>> matQueryLastMap) {
        if (materialIdSet.isEmpty() || matQueryLastMap == null || matQueryLastMap.isEmpty()) {
            return this.buildPreConstrDataSet(orgId, costaccountId, periodId, materialIdSet);
        }
        QFilter basefilter = new QFilter("org.id", "=", (Object)orgId);
        basefilter.and("billstatus", "=", (Object)"C");
        basefilter.and("costaccount.id", "=", (Object)costaccountId);
        if (this.getCrParams().getManuOrgId() != 0L) {
            basefilter.and("prdorg.id", "=", (Object)this.getCrParams().getManuOrgId());
        }
        QFilter filter = new QFilter("period.id", "=", (Object)periodId);
        filter.and(CostRecCalcHelper.getMatKeyQFilter(materialIdSet, "material.id", "calckeycol.id"));
        DataSet ds = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"sca_halfprdhide", (String)"id,material.id as materialId,calckeycol as calckeycolId", (QFilter[])new QFilter[]{basefilter, filter}, null);
        HashSet<Long> ids = new HashSet<Long>(10);
        HashSet<Object> hasPrdMaterials = new HashSet<Object>(10);
        for (Row row : ds) {
            ids.add(row.getLong("id"));
            String materialKey = CostRecCalcHelper.getKeyIdStr(row.getLong("materialId"), row.getLong("calckeycolId"));
            hasPrdMaterials.add(materialKey);
        }
        HashSet<String> notHasPrdMat = new HashSet<String>(materialIdSet);
        notHasPrdMat.removeAll(hasPrdMaterials);
        HashSet<String> needQueryMat = new HashSet<String>();
        for (String key : notHasPrdMat) {
            block2: for (Map.Entry<String, Set<String>> entry : matQueryLastMap.entrySet()) {
                for (String mat : entry.getValue()) {
                    if (!key.startsWith(mat)) continue;
                    needQueryMat.add(key);
                    continue block2;
                }
            }
        }
        if (!needQueryMat.isEmpty()) {
            HashMap<String, Long> matPrdMap = new HashMap<String, Long>(10);
            filter = new QFilter("period.id", "<", (Object)periodId);
            filter.and(CostRecCalcHelper.getMatKeyQFilter(needQueryMat, "material.id", "calckeycol.id"));
            ds = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"sca_halfprdhide", (String)"id,org,storageorgunit,material.id as materialId,calckeycol as calckeycolId", (QFilter[])new QFilter[]{basefilter, filter}, (String)"period desc");
            for (Row row : ds) {
                String orgKey = row.getString("org") + "@" + row.getString("storageorgunit");
                String materialKey = CostRecCalcHelper.getKeyIdStr(row.getLong("materialId"), row.getLong("calckeycolId"));
                if (matPrdMap.containsKey(materialKey) || !matQueryLastMap.containsKey(orgKey) || !matQueryLastMap.get(orgKey).contains(row.getString("materialId") + "-")) continue;
                matPrdMap.put(materialKey, row.getLong("id"));
            }
            ids.addAll(matPrdMap.values());
        }
        filter = new QFilter("id", "in", ids);
        return QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"sca_halfprdhide", (String)"storageorgunit.id as invOrgId,entryentity.level as level,entryentity.treepath as treepath,entryentity.keytreepath as keytreepath,material.id as materialId,materialversion.id as materialVerId,auxprop.id as materialAuxPropId,calckeycol as calckeycolId,entryentity.submaterial.id  as subMaterialId,entryentity.submaterialversion.id as subMertialVerId,entryentity.submaterialauxprop.id as subMerialAuxPropId,entryentity.subcalckeycol.id as subCalckeycolId,entryentity.element.id as elementId,entryentity.subelement.id as subElementId,entryentity.subelement.type as subElementType,entryentity.qty as qty,entryentity.amountCoeff as amountCoeff,entryentity.isunabsorb as isUnAbsorbd", (QFilter[])filter.toArray(), null);
    }

    @Override
    public DataSet buildBalanceDataSet(Long orgId, Long costaccountId, Set<String> materialIdSet) {
        boolean isNewPeriodBal = (Boolean)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBalanceService", (String)"isNewPeriodBal", (Object[])new Object[0]);
        DataSet balDataSet = null;
        HashSet<Long> materialIds = new HashSet<Long>(10);
        HashSet<Long> calckeyIds = new HashSet<Long>(10);
        CostRecCalcHelper.getMaterialIdFromKey(materialIdSet, materialIds, calckeyIds);
        balDataSet = isNewPeriodBal ? this.getNewBalanceDataSet(orgId, costaccountId, materialIds, calckeyIds, this.getCrParams().getCalcKeys()) : this.getOldBalanceDataSet(orgId, costaccountId, materialIds, calckeyIds, this.getCrParams().getCalcKeys());
        if (!balDataSet.isEmpty()) {
            if (!this.getCrParams().isCalcKeycol()) {
                DataSet matAuxDs = this.getAffectPriceDs(materialIds);
                balDataSet = balDataSet.leftJoin(matAuxDs).on("materialId", "effectpricemat").select(new String[]{"invOrgId", "materialId", "preProQty", "balanceAmount", "materialVerId", "calckeycolId", "case when effectpricemat>0 then materialAuxPropId else 0L end materialAuxPropId"}).finish();
            }
        } else {
            balDataSet = Algo.create((String)"dataset").createDataSet(new ArrayList(10).iterator(), balDataSet.getRowMeta());
        }
        balDataSet = balDataSet.addField("'A'", "isUnAbsorbd");
        return balDataSet;
    }

    private DataSet getNewBalanceDataSet(Long orgId, Long costaccountId, Set<Long> materialIdSet, Set<Long> calckeyIdSet, Set<String> calcKeys) {
        QFilter balfilter = new QFilter("calorg.id", "=", (Object)orgId);
        balfilter.and("costaccount.id", "=", (Object)costaccountId);
        if (this.getCrParams().getManuOrgId() != 0L) {
            List invLists = OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)this.getCrParams().getManuOrgId());
            balfilter.and("storageorgunit.id", "in", (Object)invLists);
        }
        DynamicObject periodInfo = BusinessDataServiceHelper.loadSingle((Object)this.getCrParams().getPeriodId(), (String)"bd_period");
        int periodNum = periodInfo.getInt("periodyear") * 100 + periodInfo.getInt("periodnumber");
        balfilter.and("period", "<=", (Object)periodNum);
        balfilter.and("endperiod", ">", (Object)periodNum);
        balfilter.and("material.id", "in", materialIdSet);
        String invOrgIdField = "0L invOrgId";
        if (SysParamEnum.RESTOREDIMENSION_ORGANDMANUORG.getValue().equals(this.getCrParams().getCalDimension())) {
            invOrgIdField = "storageorgunit.id as invOrgId";
        }
        StringBuilder selectField = new StringBuilder();
        selectField.append(invOrgIdField);
        selectField.append(",material.id as materialId,mversion.id as materialVerId,assist.id as materialAuxPropId");
        selectField.append(",costsubelement");
        selectField.append(",case when period = ").append(periodNum).append(" then baseqty else baseqty_bal end as preProQty");
        selectField.append(",case when period = ").append(periodNum).append(" then actualcost else actualcost_bal end as balanceAmount");
        if (!calcKeys.isEmpty()) {
            selectField.append(",caldimension.caldimension caldimension");
        }
        for (String key : calcKeys) {
            if ("auxpty".equals(key)) continue;
            selectField.append(",").append(key);
        }
        DataSet ds = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_bal", (String)selectField.toString(), (QFilter[])balfilter.toArray(), null);
        if (calcKeys.isEmpty()) {
            if (this.getCrParams().isCalbyCostElement()) {
                DataSet qtyDs = ds.copy().filter("costsubelement=" + this.crParams.getDefaultSubElementId()).select("invOrgId,materialId,materialVerId,materialAuxPropId,preProQty,0 as balanceAmount");
                return ds.select("invOrgId,materialId,materialVerId,materialAuxPropId,0 as preProQty,balanceAmount").union(qtyDs).groupBy(new String[]{"invOrgId", "materialId", "materialVerId", "materialAuxPropId"}).sum("preProQty").sum("balanceAmount").finish().addField("0L", "calckeycolId");
            }
            return ds.groupBy(new String[]{"invOrgId", "materialId", "materialVerId", "materialAuxPropId"}).sum("preProQty").sum("balanceAmount").finish().addField("0L", "calckeycolId");
        }
        JobSession session = AlgoX.createSession((String)"CostRec-NewBalanceData");
        DataSetX invDsX = session.fromInput((Input)new DataSetInput(ds));
        DataSetX keycolDsx = session.fromInput((Input)this.getKeycolDs(calckeyIdSet));
        ArrayList<String> fields = new ArrayList<String>(Arrays.asList(ds.getRowMeta().getFieldNames()));
        fields.remove("costsubelement");
        fields.remove("balanceAmount");
        fields.remove("preProQty");
        DataSetX resultDsx = null;
        if (this.getCrParams().isCalbyCostElement()) {
            DataSetX qtyDsx = invDsX.filter("costsubelement=" + this.crParams.getDefaultSubElementId()).select(CostRecCalcHelper.stringArrUnion(fields.toArray(new String[0]), {"preProQty"}));
            qtyDsx = DataSetXHelper.addBigDecimalFields(qtyDsx, new String[]{"balanceAmount"});
            DataSetX amtDsx = invDsX.select(CostRecCalcHelper.stringArrUnion(fields.toArray(new String[0]), {"balanceAmount"}));
            amtDsx = DataSetXHelper.addBigDecimalFields(amtDsx, new String[]{"preProQty"});
            resultDsx = DataSetXHelper.union(qtyDsx, amtDsx);
        } else {
            resultDsx = invDsX;
        }
        resultDsx = resultDsx.groupBy(fields.toArray(new String[0])).sum("preProQty").sum("balanceAmount");
        resultDsx = resultDsx.filter("preProQty<>0 or balanceAmount<>0");
        resultDsx = resultDsx.addFields(new Field[]{new Field("keycol", (DataType)DataType.StringType)}, new Object[]{""});
        resultDsx = resultDsx.groupBy(new String[]{"materialId"}).reduceGroup((GroupReduceFunction)new CostRecDealKeycolFunction(this.getCrParams().getAppnum(), this.getCrParams().getCalcKeys(), this.getCrParams().getExKeycols()));
        resultDsx = resultDsx.leftJoin(keycolDsx).on("keycol", "keycol").select(resultDsx.getRowMeta().getFieldNames(), new String[]{"calckeycolId"});
        resultDsx = resultDsx.groupBy(new String[]{"invOrgId", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId"}).sum("preProQty").sum("balanceAmount");
        DataSetOutput resultSet = new DataSetOutput(resultDsx.getRowMeta());
        resultDsx.output((Output)resultSet);
        try {
            long start = System.currentTimeMillis();
            session.commit(20, TimeUnit.MINUTES);
            logger.info("\u671f\u521d\u4f59\u989d\u5339\u914d\u7ef4\u5ea6\u4fe1\u606f\uff1a{}", (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            logger.error("\u671f\u521d\u4f59\u989d\u5339\u914d\u7ef4\u5ea6\u4fe1\u606f\u51fa\u9519\uff1a", (Throwable)e);
            throw e;
        }
        return session.readDataSet(resultSet.getId());
    }

    private DataSet getOldBalanceDataSet(Long orgId, Long costaccountId, Set<Long> materialIdSet, Set<Long> calckeyIdSet, Set<String> calcKeys) {
        QFilter balfilter = new QFilter("calorg.id", "=", (Object)orgId);
        balfilter.and("costaccount.id", "=", (Object)costaccountId);
        if (this.getCrParams().getManuOrgId() != 0L) {
            List invLists = OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)this.getCrParams().getManuOrgId());
            balfilter.and("storageorgunit.id", "in", (Object)invLists);
        }
        DynamicObject periodInfo = BusinessDataServiceHelper.loadSingle((Object)this.getCrParams().getPeriodId(), (String)"bd_period");
        int periodNum = periodInfo.getInt("periodyear") * 100 + periodInfo.getInt("periodnumber");
        balfilter.and("period", "<=", (Object)periodNum);
        balfilter.and("endperiod", ">", (Object)periodNum);
        balfilter.and("material.id", "in", materialIdSet);
        String invOrgIdField = "0L invOrgId";
        if (SysParamEnum.RESTOREDIMENSION_ORGANDMANUORG.getValue().equals(this.getCrParams().getCalDimension())) {
            invOrgIdField = "storageorgunit.id as invOrgId";
        }
        StringBuilder selectField = new StringBuilder();
        selectField.append(invOrgIdField);
        selectField.append(",calorg.id as calOrgId,material.id as materialId,mversion.id as materialVerId,assist.id as materialAuxPropId");
        selectField.append(",period");
        selectField.append(",case when period = ").append(periodNum).append(" then periodbeginqty else periodendqty end as preProQty");
        selectField.append(",case when period = ").append(periodNum).append(" then periodbeginactualcost else periodendactualcost end as balanceAmount");
        if (!calcKeys.isEmpty()) {
            selectField.append(",caldimension.caldimension caldimension");
        }
        for (String key : calcKeys) {
            if ("auxpty".equals(key)) continue;
            selectField.append(",").append(key);
        }
        DataSet balDataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_balance", (String)selectField.toString(), (QFilter[])balfilter.toArray(), null);
        if (calcKeys.isEmpty()) {
            return balDataSet.groupBy(new String[]{"invOrgId", "materialId", "materialVerId", "materialAuxPropId"}).sum("preProQty").sum("balanceAmount").finish().filter("preProQty<>0").addField("0L", "calckeycolId");
        }
        JobSession session = AlgoX.createSession((String)"CostRec-OldBalanceData");
        DataSetX invDsX = session.fromInput((Input)new DataSetInput(balDataSet));
        DataSetX keycolDsx = session.fromInput((Input)this.getKeycolDs(calckeyIdSet));
        ArrayList<String> fields = new ArrayList<String>(Arrays.asList(invDsX.getRowMeta().getFieldNames()));
        fields.remove("balanceAmount");
        fields.remove("preProQty");
        DataSetX resultDsx = invDsX.groupBy(fields.toArray(new String[0])).sum("preProQty").sum("balanceAmount");
        resultDsx = resultDsx.filter("preProQty<>0 or balanceAmount<>0");
        resultDsx = resultDsx.addFields(new Field[]{new Field("keycol", (DataType)DataType.StringType)}, new Object[]{""});
        resultDsx = resultDsx.groupBy(new String[]{"materialId"}).reduceGroup((GroupReduceFunction)new CostRecDealKeycolFunction(this.getCrParams().getAppnum(), this.getCrParams().getCalcKeys(), this.getCrParams().getExKeycols()));
        resultDsx = resultDsx.leftJoin(keycolDsx).on("keycol", "keycol").select(resultDsx.getRowMeta().getFieldNames(), new String[]{"calckeycolId"});
        resultDsx = resultDsx.groupBy(new String[]{"invOrgId", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId"}).sum("preProQty").sum("balanceAmount");
        DataSetOutput resultSet = new DataSetOutput(resultDsx.getRowMeta());
        resultDsx.output((Output)resultSet);
        try {
            long start = System.currentTimeMillis();
            session.commit(20, TimeUnit.MINUTES);
            logger.info("\u671f\u521d\u4f59\u989d\u5339\u914d\u7ef4\u5ea6\u4fe1\u606f\uff1a{}", (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            logger.error("\u671f\u521d\u4f59\u989d\u5339\u914d\u7ef4\u5ea6\u4fe1\u606f\u51fa\u9519\uff1a", (Throwable)e);
            throw e;
        }
        return session.readDataSet(resultSet.getId());
    }

    private DataSet getAffectPriceDs(Set<Long> materialIdSet) {
        QFilter filter = new QFilter("id", "in", materialIdSet);
        filter.and("isuseauxpty", "=", (Object)Boolean.TRUE);
        filter.and("auxptyentry.isaffectprice", "=", (Object)Boolean.TRUE);
        return QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"bd_material", (String)"id as effectpricemat", (QFilter[])new QFilter[]{filter}, null).distinct();
    }

    private DataSet getEnableMatVersionDs(Set<Long> materialIdSet) {
        QFilter filter = new QFilter("id", "in", materialIdSet);
        filter.and("isenablematerialversion", "=", (Object)Boolean.TRUE);
        return QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"bd_material", (String)"id as effectvermat", (QFilter[])new QFilter[]{filter}, null).distinct();
    }

    private OrmInput getKeycolDs(Set<Long> calckeyIdSet) {
        QFilter filter = new QFilter("id", "in", calckeyIdSet);
        return new OrmInput("CostRecBaseDataInputServicecalcresult", "cad_keycol", "id calckeycolId,keycol", filter.toArray());
    }

    @Override
    public DataSet buildTransInDataSet(Long costaccountId, Long calOrgId, Set<String> materialIdSet) {
        HashSet<Long> materialIds = new HashSet<Long>(10);
        HashSet<Long> calckeyIds = new HashSet<Long>(10);
        CostRecCalcHelper.getMaterialIdFromKey(materialIdSet, materialIds, calckeyIds);
        QFilter calFilter = new QFilter("calorg", "=", (Object)calOrgId);
        calFilter.and("costaccount", "=", (Object)costaccountId);
        calFilter.and("period", "=", (Object)this.crParams.getPeriodId());
        calFilter.and("billstatus", "=", (Object)Character.valueOf('C'));
        calFilter.and("entry.material", "in", materialIds);
        QFilter coadjFilter = new QFilter("calorg", "=", (Object)calOrgId);
        coadjFilter.and("costaccount", "=", (Object)costaccountId);
        coadjFilter.and("period", "=", (Object)this.crParams.getPeriodId());
        coadjFilter.and("billstatus", "=", (Object)Character.valueOf('C'));
        coadjFilter.and("entryentity.material", "in", materialIds);
        QFilter transFilter = new QFilter("bizentityobject", "=", (Object)"im_transdirbill");
        transFilter.and("transtype", "=", (Object)Character.valueOf('B'));
        QFilter transInFilter = new QFilter("calBillType", "=", (Object)"IN");
        DataSet transInBillIdDs = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_costrecord_subentity", (String)"entry.id as costRecordEntryId,bizbillid", (QFilter[])new QFilter[]{calFilter, transFilter, transInFilter}, null);
        HashSet costRecordEntryIdSet = Sets.newHashSetWithExpectedSize((int)160);
        HashSet transDirBillIdSet = Sets.newHashSetWithExpectedSize((int)160);
        for (Object row : transInBillIdDs) {
            costRecordEntryIdSet.add(row.getLong("costRecordEntryId"));
            transDirBillIdSet.add(row.getLong("bizbillid"));
        }
        StringBuilder commonFilterSb = new StringBuilder();
        commonFilterSb.append("costaccount.id as costaccountId,calorg.id as calOrgId,period.id as periodId,period.id as outPeriodId,0 as getHalfHidePeriodId");
        commonFilterSb.append(",entry.id as entryId,entry.material.id as materialId,entry.mversion.id as materialVerId,entry.assist.id as materialAuxPropId");
        for (String string : this.getCrParams().getCalcKeys()) {
            if ("auxpty".equals(string)) continue;
            commonFilterSb.append(",").append("entry.").append(string).append(" as ").append(string);
        }
        StringBuilder commonSelectSb = new StringBuilder();
        commonSelectSb.append("costaccountId,calOrgId,periodId,outPeriodId,getHalfHidePeriodId");
        commonSelectSb.append(",materialId,materialVerId,materialAuxPropId,transInOrgId,transInQty,bizBillId,standardCost+adjustamt transInAmt");
        for (String key : this.getCrParams().getCalcKeys()) {
            if ("auxpty".equals(key)) continue;
            commonSelectSb.append(",").append(key);
        }
        if (!this.getCrParams().getCalcKeys().isEmpty()) {
            commonFilterSb.append(",").append("entry.noupdatecalfields noupdatecalfields");
            commonSelectSb.append(",").append("noupdatecalfields");
        }
        String string = commonFilterSb.toString();
        String commonSelect = commonSelectSb.toString();
        DataSet transInCostRecordDs = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_costrecord_subentity", (String)(string + ",storageorgunit.id as transInOrgId,entry.baseqty as transInQty,case when entry.accounttype=='D' then entry.standardcost else entry.actualcost end as standardCost,bizbillid as bizBillId"), (QFilter[])new QFilter[]{new QFilter("bizbillid", "in", (Object)transDirBillIdSet), transInFilter}, null);
        QFilter caFilter = new QFilter("entryentity.invbillentryid", "in", (Object)costRecordEntryIdSet);
        caFilter.and("createtype", "in", (Object)Sets.newHashSet((Object[])new String[]{"W", "Y", "Z"}));
        DataSet caDs = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_stdcostdiffbill", (String)"entryentity.invbillentryid as invbillentryid,entryentity.adjustamt as adjustamt", (QFilter[])new QFilter[]{caFilter, coadjFilter}, null);
        caDs = caDs.groupBy(new String[]{"invbillentryid"}).sum("adjustamt").finish();
        transInCostRecordDs = transInCostRecordDs.leftJoin(caDs).on("entryId", "invbillentryid").select(transInCostRecordDs.getRowMeta().getFieldNames(), new String[]{"adjustamt"}).finish();
        transInCostRecordDs = transInCostRecordDs.select(commonSelect);
        DataSet invTransOutOrgDs = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"im_transdirbill", (String)"outorg.id as transOutOrgId,id as bizBillId", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)transDirBillIdSet)}, null);
        invTransOutOrgDs = invTransOutOrgDs.groupBy(new String[]{"transOutOrgId", "bizBillId"}).finish();
        DataSet transInDataSet = transInCostRecordDs.join(invTransOutOrgDs).on("bizBillId", "bizBillId").select(transInCostRecordDs.getRowMeta().getFieldNames(), new String[]{"transOutOrgId"}).finish();
        transFilter = new QFilter("bizentityobject", "=", (Object)"im_transinbill");
        transFilter.and("transtype", "=", (Object)Character.valueOf('B'));
        transInBillIdDs = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_costrecord_subentity", (String)"entry.id as costRecordEntryId,bizbillid", (QFilter[])new QFilter[]{calFilter, transFilter, transInFilter}, null);
        HashSet transInBillIdSet = Sets.newHashSetWithExpectedSize((int)160);
        costRecordEntryIdSet.clear();
        for (Row row : transInBillIdDs) {
            costRecordEntryIdSet.add(row.getLong("costRecordEntryId"));
            transInBillIdSet.add(row.getLong("bizbillid"));
        }
        if (transInBillIdSet.size() > 0) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
            transInCostRecordDs = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_costrecord_subentity", (String)(string + ",storageorgunit.id as transInOrgId,entry.baseqty as transInQty,case when entry.accounttype=='D' then entry.standardcost else entry.actualcost end as standardCost,bizbillid as bizBillId"), (QFilter[])new QFilter[]{new QFilter("bizbillid", "in", (Object)transInBillIdSet), transInFilter}, null);
            caFilter = new QFilter("entryentity.invbillentryid", "in", (Object)costRecordEntryIdSet);
            caFilter.and("createtype", "in", (Object)Sets.newHashSet((Object[])new String[]{"W", "Y", "Z"}));
            caDs = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_stdcostdiffbill", (String)"entryentity.invbillentryid as invbillentryid,entryentity.adjustamt as adjustamt", (QFilter[])new QFilter[]{caFilter, coadjFilter}, null);
            caDs = caDs.groupBy(new String[]{"invbillentryid"}).sum("adjustamt").finish();
            transInCostRecordDs = transInCostRecordDs.leftJoin(caDs).on("entryId", "invbillentryid").select(transInCostRecordDs.getRowMeta().getFieldNames(), new String[]{"adjustamt"}).finish();
            transInCostRecordDs = transInCostRecordDs.select(commonSelect);
            invTransOutOrgDs = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"im_transinbill", (String)"id as bizBillId,outorg.id as transOutOrgId,billentry.srcbillId as srcbillId,billentry.srcbillentity as srcbillentity", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)transInBillIdSet)}, null);
            DataSet relTransOutDs = invTransOutOrgDs.copy().filter("srcbillentity='im_transoutbill'");
            DataSet relTransInDs = invTransOutOrgDs.copy().filter("srcbillentity='im_transinbill'");
            LinkedHashSet srcbillidSet = Sets.newLinkedHashSetWithExpectedSize((int)16);
            for (Object row : relTransInDs.copy()) {
                srcbillidSet.add(Long.parseLong(row.getString("srcbillId")));
            }
            DataSet tmpTransInBillDs = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"im_transinbill", (String)"id as bizBillId,billentry.srcbillId as srcbillId", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)srcbillidSet)}, null);
            relTransInDs = relTransInDs.join(tmpTransInBillDs).on("srcbillId", "bizBillId").select(new String[]{"bizBillId", "transOutOrgId"}, new String[]{"srcbillId"}).finish();
            relTransOutDs = relTransOutDs.removeFields(new String[]{"srcbillentity"});
            invTransOutOrgDs = DataSetHelper.union(relTransOutDs, relTransInDs);
            srcbillidSet.clear();
            for (Row row : invTransOutOrgDs.copy()) {
                srcbillidSet.add(Long.parseLong(row.getString("srcbillId")));
            }
            DataSet transOutBillDs = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"im_transoutbill", (String)"id as bizBillId,biztime as bizDate", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)srcbillidSet)}, null);
            ArrayList newValues = Lists.newArrayList();
            for (Row row : transOutBillDs.copy()) {
                Object[] values = new Object[2];
                values[0] = row.getLong("bizBillId");
                Date bizDate = row.getDate("bizDate");
                values[1] = sdf.format(bizDate);
                newValues.add(values);
            }
            RowMeta rm = new RowMeta(new String[]{"bizBillId", "periodNumber"}, new DataType[]{DataType.LongType, DataType.StringType});
            DataSet periodIdDs = Algo.create((String)"kd.macc.sca.algox.costrec.CostRecoveryDataInputFactory.buildTransInDataSet").createDataSet(newValues.iterator(), rm);
            DataSet periodDs = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"bd_period", (String)"id as periodId,number as periodNumber", null, null);
            periodIdDs = periodIdDs.join(periodDs).on("periodNumber", "periodNumber").select(new String[]{"bizBillId", "periodId"}).finish();
            newValues = Lists.newArrayList();
            for (Row row : periodIdDs) {
                Object[] values = new Object[3];
                values[0] = row.getLong("bizBillId");
                Long periodId = row.getLong("periodId");
                values[1] = periodId;
                if (periodId.longValue() != this.crParams.getPeriodId()) {
                    logger.info("\u5b58\u5728\u8de8\u671f\u7684\u5206\u5e03\u8c03\u5165\u5355\uff1a" + row.getLong("bizBillId"));
                    values[2] = PeriodHelper.getNextPeriodId(periodId);
                } else {
                    values[2] = 0L;
                }
                newValues.add(values);
            }
            rm = new RowMeta(new String[]{"bizBillId", "periodId", "getHalfHidePeriodId"}, new DataType[]{DataType.LongType, DataType.LongType, DataType.LongType});
            periodIdDs = Algo.create((String)"kd.macc.sca.algox.costrec.CostRe9coveryDataInputFactory.buildTransInDataSet").createDataSet(newValues.iterator(), rm);
            invTransOutOrgDs = invTransOutOrgDs.leftJoin(periodIdDs).on("srcbillId", "bizBillId").select(invTransOutOrgDs.getRowMeta().getFieldNames(), new String[]{"periodId", "getHalfHidePeriodId"}).finish();
            invTransOutOrgDs = invTransOutOrgDs.select(new String[]{"bizBillId", "transOutOrgId", "srcbillId", "case when periodId is null then " + this.crParams.getPeriodId() + "L else periodId end as periodId", "case when getHalfHidePeriodId is null then 0L else getHalfHidePeriodId end as getHalfHidePeriodId"});
            invTransOutOrgDs = invTransOutOrgDs.groupBy(new String[]{"bizBillId", "transOutOrgId", "srcbillId", "periodId", "getHalfHidePeriodId"}).finish();
            ArrayList<String> fieldArr = new ArrayList<String>(Arrays.asList("costaccountId", "calOrgId", "periodId", "bizBillId", "materialId", "materialVerId", "materialAuxPropId", "transInOrgId", "transInQty", "transInAmt"));
            for (String key : this.getCrParams().getCalcKeys()) {
                if ("auxpty".equals(key)) continue;
                fieldArr.add(key);
            }
            if (!this.getCrParams().getCalcKeys().isEmpty()) {
                fieldArr.add("noupdatecalfields");
            }
            transInCostRecordDs = transInCostRecordDs.join(invTransOutOrgDs).on("bizBillId", "bizBillId").select(fieldArr.toArray(new String[0]), new String[]{"transOutOrgId", "periodId outPeriodId", "getHalfHidePeriodId"}).finish();
            transInDataSet = DataSetHelper.union(transInDataSet, transInCostRecordDs);
        }
        if (this.getCrParams().getCalcKeys().isEmpty()) {
            return transInDataSet.groupBy(new String[]{"calOrgId", "periodId", "outPeriodId", "getHalfHidePeriodId", "materialId", "materialVerId", "materialAuxPropId", "transInOrgId", "transOutOrgId"}).sum("transInQty").sum("transInAmt").finish().addField("0L", "calckeycolId");
        }
        JobSession session = AlgoX.createSession((String)"CostRec-buildTransInDataSet");
        DataSetX resultDsx = session.fromInput((Input)new DataSetInput(transInDataSet));
        DataSetX keycolDsx = session.fromInput((Input)this.getKeycolDs(calckeyIds));
        resultDsx = resultDsx.addFields(new Field[]{new Field("keycol", (DataType)DataType.StringType)}, new Object[]{""});
        resultDsx = resultDsx.groupBy(new String[]{"materialId"}).reduceGroup((GroupReduceFunction)new CostRecDealKeycolFunction(this.getCrParams().getAppnum(), this.getCrParams().getCalcKeys(), this.getCrParams().getExKeycols()));
        resultDsx = resultDsx.leftJoin(keycolDsx).on("keycol", "keycol").select(resultDsx.getRowMeta().getFieldNames(), new String[]{"calckeycolId"});
        resultDsx = resultDsx.groupBy(new String[]{"calOrgId", "periodId", "outPeriodId", "getHalfHidePeriodId", "materialId", "materialVerId", "materialAuxPropId", "calckeycolId", "transInOrgId", "transOutOrgId"}).sum("transInQty").sum("transInAmt");
        DataSetOutput resultSet = new DataSetOutput(resultDsx.getRowMeta());
        resultDsx.output((Output)resultSet);
        try {
            long start = System.currentTimeMillis();
            session.commit(20, TimeUnit.MINUTES);
            logger.info("\u671f\u521d\u4f59\u989d\u5339\u914d\u7ef4\u5ea6\u4fe1\u606f\uff1a{}", (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            logger.error("\u671f\u521d\u4f59\u989d\u5339\u914d\u7ef4\u5ea6\u4fe1\u606f\u51fa\u9519\uff1a", (Throwable)e);
            throw e;
        }
        return session.readDataSet(resultSet.getId());
    }

    @Override
    public DataSet buildPurInDataSet(Set<String> materialIdSet) {
        HashSet<Long> materialIds = new HashSet<Long>(10);
        HashSet<Long> calckeyIds = new HashSet<Long>(10);
        CostRecCalcHelper.getMaterialIdFromKey(materialIdSet, materialIds, calckeyIds);
        QFilter supFilter = new QFilter("internal_company.id", "in", this.crParams.getRelationCalOrgIds());
        DataSet supIdDs = QueryServiceHelper.queryDataSet((String)"CostRecBaseDataInputServicesupplier", (String)"bd_supplier", (String)"id", (QFilter[])new QFilter[]{supFilter}, null);
        HashSet supIdSet = Sets.newHashSetWithExpectedSize((int)16);
        for (Row row : supIdDs) {
            supIdSet.add(row.getLong("id"));
        }
        QFilter calFilter = new QFilter("calorg", "in", this.crParams.getRelationCalOrgIds());
        calFilter.and("costaccount", "in", this.crParams.getRelationCostAccountIds());
        calFilter.and("period", "=", (Object)this.crParams.getPeriodId());
        calFilter.and("billstatus", "=", (Object)Character.valueOf('C'));
        calFilter.and("issplitcreate", "=", (Object)false);
        calFilter.and("entry.material", "in", materialIds);
        QFilter pursFilter = new QFilter("bizentityobject", "=", (Object)"im_purinbill");
        pursFilter.and(new QFilter("supplier.id", "in", (Object)supIdSet));
        StringBuilder commonFilterSb = new StringBuilder();
        commonFilterSb.append("costaccount.id as costaccountId,calorg.id as calOrgId,period.id as periodId,calBillType,bizentityobject");
        commonFilterSb.append(",entry.material.id as materialId,entry.mversion.id as materialVerId,entry.assist.id as materialAuxPropId");
        for (String key : this.getCrParams().getCalcKeys()) {
            if ("auxpty".equals(key)) continue;
            commonFilterSb.append(",").append("entry.").append(key).append(" as ").append(key);
        }
        if (!this.getCrParams().getCalcKeys().isEmpty()) {
            commonFilterSb.append(",").append("entry.noupdatecalfields noupdatecalfields");
        }
        String commonFilter = commonFilterSb.toString();
        DataSet transInCostRecordDs = QueryServiceHelper.queryDataSet((String)"CostRecBaseDataInputServicecostrecord", (String)"cal_costrecord_subentity", (String)(commonFilter + ",storageorgunit.id as invOrgId,entry.baseqty as pursInQty,entry.actualcost as pursInAmt,'P' as transType,supplier.internal_company.id as salesCalOrgId,bizbillid as bizBillId"), (QFilter[])new QFilter[]{calFilter, pursFilter}, null);
        if (this.getCrParams().getCalcKeys().isEmpty()) {
            return transInCostRecordDs.groupBy(new String[]{"calOrgId", "periodId", "materialId", "materialVerId", "materialAuxPropId", "invOrgId", "salesCalOrgId"}).sum("pursInQty").sum("pursInAmt").finish().addField("0L", "calckeycolId");
        }
        JobSession session = AlgoX.createSession((String)"CostRec-buildPurInDataSet");
        DataSetX resultDsx = session.fromInput((Input)new DataSetInput(transInCostRecordDs));
        DataSetX keycolDsx = session.fromInput((Input)this.getKeycolDs(calckeyIds));
        resultDsx = resultDsx.addFields(new Field[]{new Field("keycol", (DataType)DataType.StringType)}, new Object[]{""});
        resultDsx = resultDsx.groupBy(new String[]{"materialId"}).reduceGroup((GroupReduceFunction)new CostRecDealKeycolFunction(this.getCrParams().getAppnum(), this.getCrParams().getCalcKeys(), this.getCrParams().getExKeycols()));
        resultDsx = resultDsx.leftJoin(keycolDsx).on("keycol", "keycol").select(resultDsx.getRowMeta().getFieldNames(), new String[]{"calckeycolId"});
        resultDsx = resultDsx.groupBy(new String[]{"calOrgId", "periodId", "materialId", "materialVerId", "materialAuxPropId", "invOrgId", "salesCalOrgId", "calckeycolId"}).sum("pursInQty").sum("pursInAmt");
        DataSetOutput resultSet = new DataSetOutput(resultDsx.getRowMeta());
        resultDsx.output((Output)resultSet);
        try {
            long start = System.currentTimeMillis();
            session.commit(20, TimeUnit.MINUTES);
            logger.info("\u671f\u521d\u4f59\u989d\u5339\u914d\u7ef4\u5ea6\u4fe1\u606f\uff1a{}", (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            logger.error("\u671f\u521d\u4f59\u989d\u5339\u914d\u7ef4\u5ea6\u4fe1\u606f\u51fa\u9519\uff1a", (Throwable)e);
            throw e;
        }
        return session.readDataSet(resultSet.getId());
    }

    protected Long getMaterialIdFromNestGroup(String nestGroup) {
        String[] keyArr = nestGroup.split("@");
        return Long.parseLong(keyArr[0]);
    }

    protected Long getMatKeycolFromNestGroup(String nestGroup) {
        String[] keyArr = nestGroup.split("@");
        if (keyArr.length > 7) {
            return Long.parseLong(keyArr[7]);
        }
        return 0L;
    }
}

