/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.report;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.algox.MapFunction;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.MaterialGroupHelper;
import kd.macc.cad.common.utils.WriteLogUtils;
import kd.macc.sca.algox.report.args.OutlayCostsCompNewQueryArgs;
import kd.macc.sca.algox.report.function.OutlayCostsCalcMatNumberFunction;
import kd.macc.sca.algox.report.function.OutlayCostsCalcUnitCost2Function;
import kd.macc.sca.algox.utils.DataSetXHelper;

public class OutlayCostsCompNewQuery2Plugin
extends AbstractReportListDataPlugin {
    protected static final Log logger = LogFactory.getLog(OutlayCostsCompNewQuery2Plugin.class);
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private static final String algoKey = "kd.macc.sca.algox.report.OutlayCostsCompNewQueryPlugin";
    private static final String[] SUM_PERIOD_GROUP = new String[]{"bookcurrency", "costcenter", "costcenternumber"};
    private static final String[] NOT_SUM_PERIOD_GROUP = new String[]{"period", "periodnumber", "bookcurrency", "costcenter", "costcenternumber"};

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        OutlayCostsCompNewQueryArgs args = new OutlayCostsCompNewQueryArgs();
        QFilter filter = OutlayCostsCompNewQuery2Plugin.getQFilter(reportQueryParam, args);
        long start = System.currentTimeMillis();
        QFilter detailQuery = new QFilter("entryentity1.type1", "in", (Object)new String[]{"1", " ", ""});
        DataSet leftDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_diffcalcresult", (String)this.getQueryFields(), (QFilter[])new QFilter[]{filter, detailQuery}, null);
        logger.info(String.format("\u3010\u5dee\u5f02\u5206\u644a-\u8ba1\u7b97\u7ed3\u679c\u5355\u53d6\u6570\u3011\u8017\u65f6:%s", System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        QFilter compQuery = new QFilter("entryentity1.type1", "in", (Object)new String[]{"5", " ", ""});
        DataSet compDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_diffcalcresult", (String)this.getQueryTotalFields(), (QFilter[])new QFilter[]{filter, compQuery}, null);
        logger.info(String.format("\u3010\u5dee\u5f02\u5206\u644a-\u8ba1\u7b97\u7ed3\u679c\u5355\u53d6\u6570\u3011\u8017\u65f6:%s", System.currentTimeMillis() - start));
        leftDataSet = leftDataSet.leftJoin(compDataSet).on("org", "org").on("costaccount", "costaccount").on("maincostobject", "maincostobject").on("costobject", "costobject").on("period", "period").select(leftDataSet.getRowMeta().getFieldNames(), new String[]{"startqtys1", "currqtys1", "compqtys1", "totalqtys1", "endqtys1"}).finish();
        ArrayList<String> fieldNames = new ArrayList<String>(Arrays.asList(leftDataSet.getRowMeta().getFieldNames()));
        fieldNames.remove("startqtys1");
        fieldNames.remove("currqtys1");
        fieldNames.remove("compqtys1");
        fieldNames.remove("totalqtys1");
        fieldNames.remove("endqtys1");
        fieldNames.remove("startqtys");
        fieldNames.remove("currqtys");
        fieldNames.remove("compqtys");
        fieldNames.remove("totalqtys");
        fieldNames.remove("endqtys");
        fieldNames.add("case when startqtys1 is null then startqtys else startqtys1 end startqtys");
        fieldNames.add("case when currqtys1 is null then currqtys else currqtys1 end currqtys");
        fieldNames.add("case when compqtys1 is null then compqtys else compqtys1 end compqtys");
        fieldNames.add("case when totalqtys1 is null then totalqtys else totalqtys1 end totalqtys");
        fieldNames.add("case when endqtys1 is null then endqtys else endqtys1 end endqtys");
        leftDataSet = leftDataSet.select(fieldNames.toArray(new String[0]));
        JobSession session = AlgoX.createSession((String)algoKey);
        DataSetX inputDataSetX = session.fromInput((Input)new DataSetInput(leftDataSet));
        if (!this.isSubelement() && !this.isDetail()) {
            args.setNoDetails(true);
            inputDataSetX = this.processNoDetails(inputDataSetX, args);
            inputDataSetX = inputDataSetX.addFields(new Field[]{new Field("tmpstartqtys", (DataType)DataType.BigDecimalType), new Field("tmpcurrqtys", (DataType)DataType.BigDecimalType), new Field("tmpcompqtys", (DataType)DataType.BigDecimalType), new Field("tmpendqtys", (DataType)DataType.BigDecimalType), new Field("tmptotalqtys", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
        }
        if (this.isSubelement()) {
            args.setNoDetails(false);
            inputDataSetX = this.processDetails(inputDataSetX, args);
        }
        inputDataSetX = inputDataSetX.addFields(new Field[]{new Field("periodsumrow", (DataType)DataType.IntegerType), new Field("ccsumrow", (DataType)DataType.IntegerType), new Field("totalsumrow", (DataType)DataType.IntegerType)}, new Object[]{0, 0, 0});
        inputDataSetX = this.processSumRow(inputDataSetX, args);
        inputDataSetX = inputDataSetX.addFields(new Field[]{new Field("currprice", (DataType)DataType.BigDecimalType), new Field("curractcostupprice", (DataType)DataType.BigDecimalType), new Field("currdiffsum", (DataType)DataType.BigDecimalType), new Field("compprice", (DataType)DataType.BigDecimalType), new Field("compactcostupprice", (DataType)DataType.BigDecimalType), new Field("compdiffsum", (DataType)DataType.BigDecimalType), new Field("startprice", (DataType)DataType.BigDecimalType), new Field("startactcostupprice", (DataType)DataType.BigDecimalType), new Field("startdiffsum", (DataType)DataType.BigDecimalType), new Field("endprice", (DataType)DataType.BigDecimalType), new Field("endactcostupprice", (DataType)DataType.BigDecimalType), new Field("enddiffsum", (DataType)DataType.BigDecimalType), new Field("totalprice", (DataType)DataType.BigDecimalType), new Field("totalactcostupprice", (DataType)DataType.BigDecimalType), new Field("totaldiffsum", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
        inputDataSetX = inputDataSetX.map((MapFunction)new OutlayCostsCalcUnitCost2Function(inputDataSetX.getRowMeta(), args));
        DataSetOutput resultSet = new DataSetOutput(inputDataSetX.getRowMeta());
        String resultId = resultSet.getId();
        inputDataSetX.output((Output)resultSet);
        start = System.currentTimeMillis();
        session.commit(10, TimeUnit.HOURS);
        logger.info(String.format("\u3010algox\u8ba1\u7b97\u3011\u8017\u65f6:%s", System.currentTimeMillis() - start));
        DataSet resultData = session.readDataSet(resultId);
        String opName = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u67e5\u8be2", (String)"OutlayCostsCompNewQuery2Plugin_0", (String)"macc-sca-algox", (Object[])new Object[0]), (String)"OutlayCostsCompNewQuery2Plugin_0", (String)"macc-aca-report", (Object[])new Object[0]);
        String opDescription = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5b9e\u9645\u6210\u672c\u7efc\u5408\u67e5\u8be2\u67e5\u8be2\u6210\u529f\u3002", (String)"OutlayCostsCompNewQuery2Plugin_2", (String)"macc-sca-algox", (Object[])new Object[0]), (String)"OutlayCostsCompNewQuery2Plugin_2", (String)"macc-sca-algox", (Object[])new Object[0]);
        WriteLogUtils.addLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opName, (String)opDescription, (String)"sca_outlaycostscompreport");
        return resultData;
    }

    private DataSetX processSumRow(DataSetX inputDataSetX, OutlayCostsCompNewQueryArgs args) {
        boolean isDetail = this.isDetail();
        int displaymodel = this.displaymodel();
        DataSetX resutltHeadRowX = inputDataSetX.filter("issumrow=1");
        DataSetX headRowX = inputDataSetX.filter("issumrow=1");
        DataSetX totalDataSetX = headRowX.groupBy(new String[]{"bookcurrency"}).sum("startqtys").sum("currqtys").sum("compqtys").sum("totalqtys").sum("endqtys").sum("startqty").sum("startamt").sum("startdiffqty").sum("startmadediff").sum("startmadeupamt").sum("startunjoindiffamt").sum("startstdcostupamt").sum("startorddiff").sum("startinvoicediff").sum("startfeediff").sum("startfalldiff").sum("startotherdiff").sum("startactcostupamt").sum("currqty").sum("curramt").sum("currdiffqty").sum("currmadediff").sum("currmadeupamt").sum("currunjoindiffamt").sum("currstdcostupamt").sum("currorddiff").sum("currinvoicediff").sum("currfeediff").sum("currfalldiff").sum("currotherdiff").sum("curractcostupamt").sum("compqty").sum("compamt").sum("compdiffqty").sum("compmadediff").sum("compmadeupamt").sum("compunjoindiffamt").sum("compstdcostupamt").sum("comporddiff").sum("compinvoicediff").sum("compfeediff").sum("compfalldiff").sum("compotherdiff").sum("compactcostupamt").sum("totalqty").sum("totalamt").sum("totaldiffqty").sum("totalmadediff").sum("totalmadeupamt").sum("totalunjoindiffamt").sum("totalstdcostupamt").sum("totalorddiff").sum("totalinvoicediff").sum("totalfeediff").sum("totalfalldiff").sum("totalotherdiff").sum("totalactcostupamt").sum("endqty").sum("endamt").sum("enddiffqty").sum("endmadediff").sum("endmadeupamt").sum("endunjoindiffamt").sum("endstdcostupamt").sum("endorddiff").sum("endinvoicediff").sum("endfeediff").sum("endfalldiff").sum("endotherdiff").sum("endactcostupamt");
        totalDataSetX = totalDataSetX.addFields(new Field[]{new Field("totalsumrow", (DataType)DataType.IntegerType)}, new Object[]{1});
        resutltHeadRowX = DataSetXHelper.unionIfRowDiff(resutltHeadRowX, totalDataSetX);
        if (!this.isSumByPeriod()) {
            DataSetX periodSumDataSetX = headRowX.groupBy(new String[]{"period", "periodnumber", "bookcurrency"}).sum("startqtys").sum("currqtys").sum("compqtys").sum("totalqtys").sum("endqtys").sum("startqty").sum("startamt").sum("startdiffqty").sum("startmadediff").sum("startmadeupamt").sum("startunjoindiffamt").sum("startstdcostupamt").sum("startorddiff").sum("startinvoicediff").sum("startfeediff").sum("startfalldiff").sum("startotherdiff").sum("startactcostupamt").sum("currqty").sum("curramt").sum("currdiffqty").sum("currmadediff").sum("currmadeupamt").sum("currunjoindiffamt").sum("currstdcostupamt").sum("currorddiff").sum("currinvoicediff").sum("currfeediff").sum("currfalldiff").sum("currotherdiff").sum("curractcostupamt").sum("compqty").sum("compamt").sum("compdiffqty").sum("compmadediff").sum("compmadeupamt").sum("compunjoindiffamt").sum("compstdcostupamt").sum("comporddiff").sum("compinvoicediff").sum("compfeediff").sum("compfalldiff").sum("compotherdiff").sum("compactcostupamt").sum("totalqty").sum("totalamt").sum("totaldiffqty").sum("totalmadediff").sum("totalmadeupamt").sum("totalunjoindiffamt").sum("totalstdcostupamt").sum("totalorddiff").sum("totalinvoicediff").sum("totalfeediff").sum("totalfalldiff").sum("totalotherdiff").sum("totalactcostupamt").sum("endqty").sum("endamt").sum("enddiffqty").sum("endmadediff").sum("endmadeupamt").sum("endunjoindiffamt").sum("endstdcostupamt").sum("endorddiff").sum("endinvoicediff").sum("endfeediff").sum("endfalldiff").sum("endotherdiff").sum("endactcostupamt");
            periodSumDataSetX = periodSumDataSetX.addFields(new Field[]{new Field("periodsumrow", (DataType)DataType.IntegerType)}, new Object[]{1});
            resutltHeadRowX = DataSetXHelper.unionIfRowDiff(resutltHeadRowX, periodSumDataSetX);
        }
        if (displaymodel == 1 || displaymodel == 2) {
            String[] groupBy = null;
            groupBy = !this.isSumByPeriod() ? NOT_SUM_PERIOD_GROUP : SUM_PERIOD_GROUP;
            DataSetX ccSumDataSetX = headRowX.groupBy(groupBy).sum("startqtys").sum("currqtys").sum("compqtys").sum("totalqtys").sum("endqtys").sum("startqty").sum("startamt").sum("startdiffqty").sum("startmadediff").sum("startmadeupamt").sum("startunjoindiffamt").sum("startstdcostupamt").sum("startorddiff").sum("startinvoicediff").sum("startfeediff").sum("startfalldiff").sum("startotherdiff").sum("startactcostupamt").sum("currqty").sum("curramt").sum("currdiffqty").sum("currmadediff").sum("currmadeupamt").sum("currunjoindiffamt").sum("currstdcostupamt").sum("currorddiff").sum("currinvoicediff").sum("currfeediff").sum("currfalldiff").sum("currotherdiff").sum("curractcostupamt").sum("compqty").sum("compamt").sum("compdiffqty").sum("compmadediff").sum("compmadeupamt").sum("compunjoindiffamt").sum("compstdcostupamt").sum("comporddiff").sum("compinvoicediff").sum("compfeediff").sum("compfalldiff").sum("compotherdiff").sum("compactcostupamt").sum("totalqty").sum("totalamt").sum("totaldiffqty").sum("totalmadediff").sum("totalmadeupamt").sum("totalunjoindiffamt").sum("totalstdcostupamt").sum("totalorddiff").sum("totalinvoicediff").sum("totalfeediff").sum("totalfalldiff").sum("totalotherdiff").sum("totalactcostupamt").sum("endqty").sum("endamt").sum("enddiffqty").sum("endmadediff").sum("endmadeupamt").sum("endunjoindiffamt").sum("endstdcostupamt").sum("endorddiff").sum("endinvoicediff").sum("endfeediff").sum("endfalldiff").sum("endotherdiff").sum("endactcostupamt");
            ccSumDataSetX = ccSumDataSetX.addFields(new Field[]{new Field("ccsumrow", (DataType)DataType.IntegerType)}, new Object[]{1});
            resutltHeadRowX = DataSetXHelper.unionIfRowDiff(resutltHeadRowX, ccSumDataSetX);
        }
        resutltHeadRowX = resutltHeadRowX.filter("issumrow=0");
        inputDataSetX = DataSetXHelper.unionIfRowDiff(inputDataSetX, resutltHeadRowX);
        ArrayList orderList = Lists.newArrayListWithCapacity((int)16);
        orderList.add("totalsumrow");
        if (!this.isSumByPeriod()) {
            orderList.add("periodnumber");
        }
        orderList.add("periodsumrow");
        if (displaymodel == 1) {
            orderList.add("costcenternumber");
            orderList.add("periodsumrow");
            orderList.add("ccsumrow");
            orderList.add("costobjectbillno");
            orderList.add("bizstatus");
        } else if (displaymodel == 2) {
            orderList.add("costcenternumber");
            orderList.add("ccsumrow");
            orderList.add("productnumber");
        } else if (displaymodel == 3) {
            orderList.add("productnumber");
        }
        orderList.add("issumrow desc");
        if (!args.isNoDetails()) {
            if (isDetail) {
                orderList.add("elementnumber");
                orderList.add("subelementnumber");
                orderList.add("materialnumber");
            } else {
                orderList.add("elementnumber");
                orderList.add("subelementnumber");
            }
        }
        inputDataSetX = inputDataSetX.orderBy(orderList.toArray(new String[0]));
        return inputDataSetX;
    }

    protected DataSetX processDetails(DataSetX detailDataSetX, OutlayCostsCompNewQueryArgs args) {
        boolean isDetail = this.isDetail();
        int displayModel = this.displaymodel();
        boolean matGroup = this.isMatGroup();
        String headAllFields = "period,periodnumber,proMatName,proNumber,proMatUnitId,proMatVerId,proMatAuxId,costcenter,costcenternumber,entryproduct,productnumber,maincostobject,costobject,costobjectbillno,bizstatus,bookcurrency";
        DataSetX headRowX = detailDataSetX.groupBy(headAllFields.split(",")).max("startqtys").max("currqtys").max("compqtys").max("totalqtys").max("endqtys").sum("startqty").sum("startamt").sum("startdiffqty").sum("startmadediff").sum("startmadeupamt").sum("startunjoindiffamt").sum("startstdcostupamt").sum("startorddiff").sum("startinvoicediff").sum("startfeediff").sum("startfalldiff").sum("startotherdiff").sum("startactcostupamt").sum("currqty").sum("curramt").sum("currdiffqty").sum("currmadediff").sum("currmadeupamt").sum("currunjoindiffamt").sum("currstdcostupamt").sum("currorddiff").sum("currinvoicediff").sum("currfeediff").sum("currfalldiff").sum("currotherdiff").sum("curractcostupamt").sum("compqty").sum("compamt").sum("compdiffqty").sum("compmadediff").sum("compmadeupamt").sum("compunjoindiffamt").sum("compstdcostupamt").sum("comporddiff").sum("compinvoicediff").sum("compfeediff").sum("compfalldiff").sum("compotherdiff").sum("compactcostupamt").sum("totalqty").sum("totalamt").sum("totaldiffqty").sum("totalmadediff").sum("totalmadeupamt").sum("totalunjoindiffamt").sum("totalstdcostupamt").sum("totalorddiff").sum("totalinvoicediff").sum("totalfeediff").sum("totalfalldiff").sum("totalotherdiff").sum("totalactcostupamt").sum("endqty").sum("endamt").sum("enddiffqty").sum("endmadediff").sum("endmadeupamt").sum("endunjoindiffamt").sum("endstdcostupamt").sum("endorddiff").sum("endinvoicediff").sum("endfeediff").sum("endfalldiff").sum("endotherdiff").sum("endactcostupamt");
        StringBuilder groupFields = new StringBuilder();
        groupFields.append("proMatName,proNumber,proMatUnitId,proMatVerId,proMatAuxId");
        if (!this.isSumByPeriod()) {
            groupFields.append(",period,periodnumber");
        }
        if (displayModel == 1) {
            groupFields.append(",costcenter,costcenternumber,maincostobject,costobject,costobjectbillno,bizstatus,bookcurrency");
        } else if (displayModel == 2) {
            groupFields.append(",costcenter,costcenternumber,entryproduct,productnumber,bookcurrency");
        } else if (displayModel == 3) {
            groupFields.append(",entryproduct,productnumber,bookcurrency");
        }
        ArrayList headFieldArr = Lists.newArrayList((Object[])groupFields.toString().split(","));
        groupFields.append(",element,elementnumber,elementname,subelement,subelementnumber,subelementname");
        if (matGroup) {
            detailDataSetX = this.matFilter(detailDataSetX);
            groupFields.append(",materialgroup");
        } else if (isDetail) {
            detailDataSetX = this.matFilter(detailDataSetX);
            groupFields = groupFields.append(",material,materialnumber,materialname,matversion,auxpty,baseunit,materialgroup");
        }
        String[] groupFieldArr = groupFields.toString().split(",");
        detailDataSetX = detailDataSetX.groupBy(groupFieldArr).max("startqtys").max("currqtys").max("compqtys").max("totalqtys").max("endqtys").sum("startqty").sum("startamt").sum("startdiffqty").sum("startmadediff").sum("startmadeupamt").sum("startunjoindiffamt").sum("startstdcostupamt").sum("startorddiff").sum("startinvoicediff").sum("startfeediff").sum("startfalldiff").sum("startotherdiff").sum("startactcostupamt").sum("currqty").sum("curramt").sum("currdiffqty").sum("currmadediff").sum("currmadeupamt").sum("currunjoindiffamt").sum("currstdcostupamt").sum("currorddiff").sum("currinvoicediff").sum("currfeediff").sum("currfalldiff").sum("currotherdiff").sum("curractcostupamt").sum("compqty").sum("compamt").sum("compdiffqty").sum("compmadediff").sum("compmadeupamt").sum("compunjoindiffamt").sum("compstdcostupamt").sum("comporddiff").sum("compinvoicediff").sum("compfeediff").sum("compfalldiff").sum("compotherdiff").sum("compactcostupamt").sum("totalqty").sum("totalamt").sum("totaldiffqty").sum("totalmadediff").sum("totalmadeupamt").sum("totalunjoindiffamt").sum("totalstdcostupamt").sum("totalorddiff").sum("totalinvoicediff").sum("totalfeediff").sum("totalfalldiff").sum("totalotherdiff").sum("totalactcostupamt").sum("endqty").sum("endamt").sum("enddiffqty").sum("endmadediff").sum("endmadeupamt").sum("endunjoindiffamt").sum("endstdcostupamt").sum("endorddiff").sum("endinvoicediff").sum("endfeediff").sum("endfalldiff").sum("endotherdiff").sum("endactcostupamt");
        headRowX = headRowX.groupBy(headFieldArr.toArray(new String[0])).sum("startqtys").sum("currqtys").sum("compqtys").sum("totalqtys").sum("endqtys").sum("startqty").sum("startamt").sum("startdiffqty").sum("startmadediff").sum("startmadeupamt").sum("startunjoindiffamt").sum("startstdcostupamt").sum("startorddiff").sum("startinvoicediff").sum("startfeediff").sum("startfalldiff").sum("startotherdiff").sum("startactcostupamt").sum("currqty").sum("curramt").sum("currdiffqty").sum("currmadediff").sum("currmadeupamt").sum("currunjoindiffamt").sum("currstdcostupamt").sum("currorddiff").sum("currinvoicediff").sum("currfeediff").sum("currfalldiff").sum("currotherdiff").sum("curractcostupamt").sum("compqty").sum("compamt").sum("compdiffqty").sum("compmadediff").sum("compmadeupamt").sum("compunjoindiffamt").sum("compstdcostupamt").sum("comporddiff").sum("compinvoicediff").sum("compfeediff").sum("compfalldiff").sum("compotherdiff").sum("compactcostupamt").sum("totalqty").sum("totalamt").sum("totaldiffqty").sum("totalmadediff").sum("totalmadeupamt").sum("totalunjoindiffamt").sum("totalstdcostupamt").sum("totalorddiff").sum("totalinvoicediff").sum("totalfeediff").sum("totalfalldiff").sum("totalotherdiff").sum("totalactcostupamt").sum("endqty").sum("endamt").sum("enddiffqty").sum("endmadediff").sum("endmadeupamt").sum("endunjoindiffamt").sum("endstdcostupamt").sum("endorddiff").sum("endinvoicediff").sum("endfeediff").sum("endfalldiff").sum("endotherdiff").sum("endactcostupamt");
        if (!this.isSumByPeriod()) {
            if (displayModel == 1) {
                detailDataSetX = detailDataSetX.leftJoin(headRowX).on("period", "period").on("costcenter", "costcenter").on("maincostobject", "maincostobject").on("costobject", "costobject").on("bizstatus", "bizstatus").select(detailDataSetX.getRowMeta().getFieldNames(), new String[]{"startqtys tmpstartqtys", "currqtys tmpcurrqtys", "compqtys tmpcompqtys", "totalqtys tmptotalqtys", "endqtys tmpendqtys"});
            } else if (displayModel == 2) {
                detailDataSetX = detailDataSetX.leftJoin(headRowX).on("period", "period").on("costcenter", "costcenter").on("entryproduct", "entryproduct").select(detailDataSetX.getRowMeta().getFieldNames(), new String[]{"startqtys tmpstartqtys", "currqtys tmpcurrqtys", "compqtys tmpcompqtys", "totalqtys tmptotalqtys", "endqtys tmpendqtys"});
            } else if (displayModel == 3) {
                detailDataSetX = detailDataSetX.leftJoin(headRowX).on("period", "period").on("entryproduct", "entryproduct").select(detailDataSetX.getRowMeta().getFieldNames(), new String[]{"startqtys tmpstartqtys", "currqtys tmpcurrqtys", "compqtys tmpcompqtys", "totalqtys tmptotalqtys", "endqtys tmpendqtys"});
            }
        } else if (displayModel == 1) {
            detailDataSetX = detailDataSetX.leftJoin(headRowX).on("costcenter", "costcenter").on("maincostobject", "maincostobject").on("costobject", "costobject").on("bizstatus", "bizstatus").select(detailDataSetX.getRowMeta().getFieldNames(), new String[]{"startqtys tmpstartqtys", "currqtys tmpcurrqtys", "compqtys tmpcompqtys", "totalqtys tmptotalqtys", "endqtys tmpendqtys"});
        } else if (displayModel == 2) {
            detailDataSetX = detailDataSetX.leftJoin(headRowX).on("costcenter", "costcenter").on("entryproduct", "entryproduct").select(detailDataSetX.getRowMeta().getFieldNames(), new String[]{"startqtys tmpstartqtys", "currqtys tmpcurrqtys", "compqtys tmpcompqtys", "totalqtys tmptotalqtys", "endqtys tmpendqtys"});
        } else if (displayModel == 3) {
            detailDataSetX = detailDataSetX.leftJoin(headRowX).on("entryproduct", "entryproduct").select(detailDataSetX.getRowMeta().getFieldNames(), new String[]{"startqtys tmpstartqtys", "currqtys tmpcurrqtys", "compqtys tmpcompqtys", "totalqtys tmptotalqtys", "endqtys tmpendqtys"});
        }
        headRowX = headRowX.addFields(new Field[]{new Field("issumrow", (DataType)DataType.IntegerType)}, new Object[]{1});
        headRowX = headRowX.addFields(new Field[]{new Field("element", (DataType)DataType.LongType), new Field("elementnumber", (DataType)DataType.StringType), new Field("elementname", (DataType)DataType.StringType), new Field("subelement", (DataType)DataType.LongType), new Field("subelementnumber", (DataType)DataType.StringType), new Field("subelementname", (DataType)DataType.StringType)}, new Object[]{0L, " ", " ", 0L, " ", " "});
        if (isDetail) {
            headRowX = headRowX.addFields(new Field[]{new Field("material", (DataType)DataType.LongType), new Field("materialnumber", (DataType)DataType.StringType), new Field("materialname", (DataType)DataType.StringType), new Field("matversion", (DataType)DataType.LongType), new Field("auxpty", (DataType)DataType.LongType), new Field("baseunit", (DataType)DataType.LongType)}, new Object[]{0L, " ", " ", 0L, 0L, 0L});
        }
        if (matGroup) {
            detailDataSetX = detailDataSetX.addFields(new Field[]{new Field("material", (DataType)DataType.LongType), new Field("materialnumber", (DataType)DataType.StringType), new Field("materialname", (DataType)DataType.StringType), new Field("matversion", (DataType)DataType.LongType), new Field("auxpty", (DataType)DataType.LongType), new Field("baseunit", (DataType)DataType.LongType)}, new Object[]{0L, " ", " ", 0L, 0L, 0L});
        }
        detailDataSetX = detailDataSetX.addFields(new Field[]{new Field("issumrow", (DataType)DataType.IntegerType)}, new Object[]{0});
        detailDataSetX = DataSetXHelper.unionIfRowDiff(detailDataSetX, headRowX);
        if (!isDetail) {
            detailDataSetX = detailDataSetX.addFields(new Field[]{new Field("materialname", (DataType)DataType.StringType), new Field("materialnumber", (DataType)DataType.StringType), new Field("matversion", (DataType)DataType.LongType), new Field("auxpty", (DataType)DataType.LongType), new Field("baseunit", (DataType)DataType.LongType)}, new Object[]{" ", " ", 0L, 0L, 0L});
        }
        return detailDataSetX;
    }

    private DataSetX matFilter(DataSetX detailDataSetX) {
        FilterInfo filter = this.getQueryParam().getFilter();
        DynamicObject materialGrpStd = filter.getDynamicObject("materialgrpstd");
        DynamicObjectCollection materialGroup = filter.getDynamicObjectCollection("mulmaterialgroup");
        DynamicObjectCollection materials = filter.getDynamicObjectCollection("materials");
        DataSet filterMatDataSet = MaterialGroupHelper.getClassifiedMaterialDataSet((DynamicObject)materialGrpStd, (DynamicObjectCollection)materialGroup, (DynamicObjectCollection)materials);
        JobSession session = AlgoX.createSession((String)algoKey);
        DataSetX matGroupDataSetX = session.fromInput((Input)new DataSetInput(filterMatDataSet));
        detailDataSetX = detailDataSetX.map((MapFunction)new OutlayCostsCalcMatNumberFunction(detailDataSetX.getRowMeta()));
        detailDataSetX = detailDataSetX.join(matGroupDataSetX).on("materialnumber", "materialnumber").select(detailDataSetX.getRowMeta().getFieldNames(), new String[]{"materialgroup", "materialgroupnumber"});
        if (materialGroup != null && materialGroup.size() > 0) {
            detailDataSetX = detailDataSetX.filter("materialgroup is not null");
        }
        return detailDataSetX;
    }

    protected DataSetX processNoDetails(DataSetX dataSetX, OutlayCostsCompNewQueryArgs args) {
        int displaymodel = this.displaymodel();
        StringBuilder groupFields = new StringBuilder();
        groupFields.append("maincostobject,costobject,costobjectbillno,entryproduct,productnumber,bizstatus,bookcurrency,costcenter,costcenternumber,period,periodnumber,proMatName,proNumber,proMatUnitId,proMatVerId,proMatAuxId");
        String[] groupFieldArr = groupFields.toString().split(",");
        dataSetX = dataSetX.groupBy(groupFieldArr).max("startqtys").max("currqtys").max("compqtys").max("totalqtys").max("endqtys").sum("startqty").sum("startamt").sum("startdiffqty").sum("startmadediff").sum("startmadeupamt").sum("startunjoindiffamt").sum("startstdcostupamt").sum("startorddiff").sum("startinvoicediff").sum("startfeediff").sum("startfalldiff").sum("startotherdiff").sum("startactcostupamt").sum("currqty").sum("curramt").sum("currdiffqty").sum("currmadediff").sum("currmadeupamt").sum("currunjoindiffamt").sum("currstdcostupamt").sum("currorddiff").sum("currinvoicediff").sum("currfeediff").sum("currfalldiff").sum("currotherdiff").sum("curractcostupamt").sum("compqty").sum("compamt").sum("compdiffqty").sum("compmadediff").sum("compmadeupamt").sum("compunjoindiffamt").sum("compstdcostupamt").sum("comporddiff").sum("compinvoicediff").sum("compfeediff").sum("compfalldiff").sum("compotherdiff").sum("compactcostupamt").sum("totalqty").sum("totalamt").sum("totaldiffqty").sum("totalmadediff").sum("totalmadeupamt").sum("totalunjoindiffamt").sum("totalstdcostupamt").sum("totalorddiff").sum("totalinvoicediff").sum("totalfeediff").sum("totalfalldiff").sum("totalotherdiff").sum("totalactcostupamt").sum("endqty").sum("endamt").sum("enddiffqty").sum("endmadediff").sum("endmadeupamt").sum("endunjoindiffamt").sum("endstdcostupamt").sum("endorddiff").sum("endinvoicediff").sum("endfeediff").sum("endfalldiff").sum("endotherdiff").sum("endactcostupamt");
        groupFields.setLength(0);
        groupFields.append("proMatName,proNumber,proMatUnitId,proMatVerId,proMatAuxId");
        if (!this.isSumByPeriod()) {
            groupFields.append(",period,periodnumber");
        }
        if (displaymodel == 1) {
            groupFields.append(",maincostobject,costcenter,costcenternumber,costobject,costobjectbillno,bizstatus,bookcurrency");
        } else if (displaymodel == 2) {
            groupFields.append(",costcenter,costcenternumber,entryproduct,productnumber,bookcurrency");
        } else if (displaymodel == 3) {
            groupFields.append(",entryproduct,productnumber,bookcurrency");
        }
        groupFieldArr = groupFields.toString().split(",");
        dataSetX = dataSetX.groupBy(groupFieldArr).sum("startqtys").sum("currqtys").sum("compqtys").sum("totalqtys").sum("endqtys").sum("startqty").sum("startamt").sum("startdiffqty").sum("startmadediff").sum("startmadeupamt").sum("startunjoindiffamt").sum("startstdcostupamt").sum("startorddiff").sum("startinvoicediff").sum("startfeediff").sum("startfalldiff").sum("startotherdiff").sum("startactcostupamt").sum("currqty").sum("curramt").sum("currdiffqty").sum("currmadediff").sum("currmadeupamt").sum("currunjoindiffamt").sum("currstdcostupamt").sum("currorddiff").sum("currinvoicediff").sum("currfeediff").sum("currfalldiff").sum("currotherdiff").sum("curractcostupamt").sum("compqty").sum("compamt").sum("compdiffqty").sum("compmadediff").sum("compmadeupamt").sum("compunjoindiffamt").sum("compstdcostupamt").sum("comporddiff").sum("compinvoicediff").sum("compfeediff").sum("compfalldiff").sum("compotherdiff").sum("compactcostupamt").sum("totalqty").sum("totalamt").sum("totaldiffqty").sum("totalmadediff").sum("totalmadeupamt").sum("totalunjoindiffamt").sum("totalstdcostupamt").sum("totalorddiff").sum("totalinvoicediff").sum("totalfeediff").sum("totalfalldiff").sum("totalotherdiff").sum("totalactcostupamt").sum("endqty").sum("endamt").sum("enddiffqty").sum("endmadediff").sum("endmadeupamt").sum("endunjoindiffamt").sum("endstdcostupamt").sum("endorddiff").sum("endinvoicediff").sum("endfeediff").sum("endfalldiff").sum("endotherdiff").sum("endactcostupamt");
        if (displaymodel == 1) {
            dataSetX = !this.isSumByPeriod() ? dataSetX.orderBy(new String[]{"maincostobject", "periodnumber", "costcenternumber", "costobjectbillno"}) : dataSetX.orderBy(new String[]{"maincostobject", "costcenternumber", "costobjectbillno"});
        } else if (displaymodel == 2) {
            dataSetX = !this.isSumByPeriod() ? dataSetX.orderBy(new String[]{"periodnumber", "costcenternumber", "productnumber"}) : dataSetX.orderBy(new String[]{"costcenternumber", "productnumber"});
        } else if (displaymodel == 3) {
            dataSetX = !this.isSumByPeriod() ? dataSetX.orderBy(new String[]{"periodnumber", "productnumber"}) : dataSetX.orderBy(new String[]{"productnumber"});
        }
        dataSetX = dataSetX.addFields(new Field[]{new Field("materialname", (DataType)DataType.StringType), new Field("materialnumber", (DataType)DataType.StringType), new Field("baseunit", (DataType)DataType.LongType), new Field("matversion", (DataType)DataType.LongType), new Field("auxpty", (DataType)DataType.LongType), new Field("issumrow", (DataType)DataType.IntegerType)}, new Object[]{" ", " ", 0L, 0L, 0L, 1});
        return dataSetX;
    }

    protected RowMeta getRowMeta() {
        List<Field> field = this.getRowMetaField();
        return new RowMeta(field.toArray(new Field[0]));
    }

    protected int getListFieldIndex(String field) {
        Field[] fields = this.getRowMeta().getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!field.equals(fields[i].getName())) continue;
            return i;
        }
        return -1;
    }

    private boolean isDetail() {
        try {
            ReportQueryParam queryParam = this.getQueryParam();
            boolean isdetail = queryParam.getFilter().getBoolean("isdetail");
            return isdetail;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u53c2\u6570\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    private boolean isMatGroup() {
        try {
            ReportQueryParam queryParam = this.getQueryParam();
            return queryParam.getFilter().getBoolean("ismaterialgroup");
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u53c2\u6570\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    private int displaymodel() {
        try {
            ReportQueryParam queryParam = this.getQueryParam();
            int isdetail = queryParam.getFilter().getInt("displaymodel");
            return isdetail;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u53c2\u6570\u5931\u8d25", (Throwable)e);
            return 1;
        }
    }

    private boolean isSubelement() {
        try {
            ReportQueryParam queryParam = this.getQueryParam();
            boolean issubelement = queryParam.getFilter().getBoolean("issubelement");
            return issubelement;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u53c2\u6570\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    private boolean isSumByPeriod() {
        try {
            ReportQueryParam queryParam = this.getQueryParam();
            boolean issubelement = queryParam.getFilter().getBoolean("issumbyperiod");
            return issubelement;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u53c2\u6570\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public static QFilter getQFilter(ReportQueryParam reportQueryParam, OutlayCostsCompNewQueryArgs args) {
        FilterItemInfo currencyfilterItem;
        Object currency;
        String bizstatus;
        FilterInfo filterInfo = reportQueryParam.getFilter();
        Object value = null;
        value = OutlayCostsCompNewQuery2Plugin.getFilterItemValue(filterInfo, "org");
        QFilter filter = new QFilter("org", "in", value);
        value = OutlayCostsCompNewQuery2Plugin.getFilterItemValue(filterInfo, "costaccount");
        filter.and(new QFilter("costaccount", "in", value));
        value = OutlayCostsCompNewQuery2Plugin.getFilterItemValue(filterInfo, "startperiod");
        filter.and(new QFilter("period", ">=", value));
        value = OutlayCostsCompNewQuery2Plugin.getFilterItemValue(filterInfo, "endperiod");
        filter.and(new QFilter("period", "<=", value));
        value = OutlayCostsCompNewQuery2Plugin.getFilterItemValue(filterInfo, "fcostcenter");
        if (value != null) {
            filter.and(new QFilter("costcenter", "in", value));
        }
        if ((bizstatus = (String)OutlayCostsCompNewQuery2Plugin.getFilterItemValue(filterInfo, "fbizstatus")) != null && ("A".equals(bizstatus) || "B".equals(bizstatus))) {
            filter.and(new QFilter("bizstatus", "=", (Object)bizstatus));
        }
        if (!filterInfo.getBoolean("displayunallocdiff")) {
            QFilter diffFIlter = new QFilter("isunallocdiff", "=", (Object)Boolean.FALSE);
            diffFIlter.or("entryentity1.relacostobject1.producttype", "=", (Object)"B");
            filter.and(diffFIlter);
        }
        if ((value = OutlayCostsCompNewQuery2Plugin.getFilterItemValue(filterInfo, "fcostobject")) != null) {
            Set<Long> objectIds = OutlayCostsCompNewQuery2Plugin.getDiffCalcResultMainCostObjectId(filter, value);
            filter.and(new QFilter("costobject", "in", objectIds));
        }
        if ((value = OutlayCostsCompNewQuery2Plugin.getFilterItemValue(filterInfo, "product")) != null) {
            filter.and(new QFilter("entryentity1.relacostobject1.material", "in", value));
        }
        if ((currency = (currencyfilterItem = filterInfo.getFilterItem("currency")).getValue()) instanceof DynamicObject) {
            DynamicObject currencydyo = (DynamicObject)currency;
            int amtScale = currencydyo.getInt("amtprecision");
            int priceScale = currencydyo.getInt("priceprecision");
            args.setAmtSacle(amtScale);
            args.setPriceSacle(priceScale);
        }
        return filter;
    }

    private static Set<Long> getDiffCalcResultMainCostObjectId(QFilter filter, Object costobjectVal) {
        filter.and("entryentity1.relacostobject1", "in", costobjectVal);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"diffcalcresult", (String)"sca_diffcalcresult", (String)"costobject", (QFilter[])new QFilter[]{filter}, null);
        ds = ds.groupBy(new String[]{"costobject"}).finish();
        HashSet<Long> objectIds = new HashSet<Long>(16);
        for (Row row : ds) {
            objectIds.add(row.getLong("costobject"));
        }
        return objectIds;
    }

    public ReportQueryParam getQueryParam() {
        return super.getQueryParam();
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        return super.getColumns(columns);
    }

    public Object getSelectedObj() {
        return super.getSelectedObj();
    }

    public void setProgress(int percent) {
        super.setProgress(percent);
    }

    private String getQueryTotalFields() {
        StringBuilder sb = new StringBuilder();
        sb.append("org AS org");
        sb.append(",costaccount AS costaccount");
        sb.append(",costobject AS maincostobject");
        sb.append(",entryentity1.relacostobject1 costobject");
        sb.append(",period AS period");
        sb.append(",entryentity1.startqty1 AS startqtys1");
        sb.append(",entryentity1.currqty1 AS currqtys1");
        sb.append(",entryentity1.compqty1 AS compqtys1");
        sb.append(",entryentity1.totalqty1 AS totalqtys1");
        sb.append(",entryentity1.endqty1 AS endqtys1");
        return sb.toString();
    }

    private String getQueryFields() {
        StringBuilder sb = new StringBuilder();
        sb.append("org AS org");
        sb.append(",costaccount AS costaccount");
        sb.append(",costobject AS maincostobject");
        sb.append(",entryentity1.relacostobject1 costobject");
        sb.append(",entryentity1.relacostobject1.billno AS costobjectbillno");
        sb.append(",entryentity1.relacostobject1.material AS entryproduct");
        sb.append(",entryentity1.relacostobject1.material.number AS productnumber");
        sb.append(",entryentity1.relacostobject1.material.name AS productname");
        sb.append(",bizstatus AS bizstatus");
        sb.append(",currency AS bookcurrency");
        sb.append(",costcenter AS costcenter");
        sb.append(",costcenter.number AS costcenternumber");
        sb.append(",period AS period");
        sb.append(",period.number AS periodnumber");
        sb.append(",startqtys");
        sb.append(",currqtys");
        sb.append(",compqtys");
        sb.append(",endqtys");
        sb.append(",totalqtys");
        sb.append(",entryentity1.relacostobject1.material.name AS proMatName");
        sb.append(",entryentity1.relacostobject1.material.number AS proNumber");
        sb.append(",entryentity1.relacostobject1.material.baseunit.id AS proMatUnitId");
        sb.append(",entryentity1.relacostobject1.bomversion AS proMatVerId");
        sb.append(",entryentity1.relacostobject1.auxpty AS proMatAuxId");
        sb.append(",entryentity1.element1 AS element");
        sb.append(",entryentity1.element1.number AS elementnumber");
        sb.append(",entryentity1.element1.name AS elementname");
        sb.append(",entryentity1.subelement1 AS subelement");
        sb.append(",entryentity1.subelement1.number AS subelementnumber");
        sb.append(",entryentity1.subelement1.name AS subelementname");
        sb.append(",entryentity1.material1 AS material");
        sb.append(",entryentity1.material1.number AS materialnumber");
        sb.append(",entryentity1.material1.name AS materialname");
        sb.append(",entryentity1.auxpty1 AS auxpty");
        sb.append(",entryentity1.matversion1 AS matversion");
        sb.append(",entryentity1.baseunit1 AS baseunit");
        sb.append(",entryentity1.startqty1 AS startqty");
        sb.append(",entryentity1.startamt1 AS startamt");
        sb.append(",entryentity1.startdiffqty1 AS startdiffqty");
        sb.append(",entryentity1.startmadediff1 AS startmadediff");
        sb.append(",entryentity1.startmadeupamt1 AS startmadeupamt");
        sb.append(",entryentity1.startunjoindiffamt1 AS startunjoindiffamt");
        sb.append(",entryentity1.startstdcostupamt1 AS startstdcostupamt");
        sb.append(",entryentity1.startorddiff1 AS startorddiff");
        sb.append(",entryentity1.startinvoicediff1 AS startinvoicediff");
        sb.append(",entryentity1.startfeediff1 AS startfeediff");
        sb.append(",entryentity1.startfalldiff1 AS startfalldiff");
        sb.append(",entryentity1.startotherdiff1 AS startotherdiff");
        sb.append(",entryentity1.startactcostupamt1 AS startactcostupamt");
        sb.append(",entryentity1.currqty1 AS currqty");
        sb.append(",entryentity1.curramt1 AS curramt");
        sb.append(",entryentity1.currdiffqty1 AS currdiffqty");
        sb.append(",entryentity1.currmadediff1 AS currmadediff");
        sb.append(",entryentity1.currmadeupamt1 AS currmadeupamt");
        sb.append(",entryentity1.currunjoindiffamt1 AS currunjoindiffamt");
        sb.append(",entryentity1.currstdcostupamt1 AS currstdcostupamt");
        sb.append(",entryentity1.currorddiff1 AS currorddiff");
        sb.append(",entryentity1.currinvoicediff1 AS currinvoicediff");
        sb.append(",entryentity1.currfeediff1 AS currfeediff");
        sb.append(",entryentity1.currfalldiff1 AS currfalldiff");
        sb.append(",entryentity1.currotherdiff1 AS currotherdiff");
        sb.append(",entryentity1.curractcostupamt1 AS curractcostupamt");
        sb.append(",entryentity1.compqty1 AS compqty");
        sb.append(",entryentity1.compamt1 AS compamt");
        sb.append(",entryentity1.compdiffqty1 AS compdiffqty");
        sb.append(",entryentity1.compmadediff1 AS compmadediff");
        sb.append(",entryentity1.compmadeupamt1 AS compmadeupamt");
        sb.append(",entryentity1.compunjoindiffamt1 AS compunjoindiffamt");
        sb.append(",entryentity1.compstdcostupamt1 AS compstdcostupamt");
        sb.append(",entryentity1.comporddiff1 AS comporddiff");
        sb.append(",entryentity1.compinvoicediff1 AS compinvoicediff");
        sb.append(",entryentity1.compfeediff1 AS compfeediff");
        sb.append(",entryentity1.compfalldiff1 AS compfalldiff");
        sb.append(",entryentity1.compotherdiff1 AS compotherdiff");
        sb.append(",entryentity1.compactcostupamt1 AS compactcostupamt");
        sb.append(",entryentity1.totalqty1 AS totalqty");
        sb.append(",entryentity1.totalamt1 AS totalamt");
        sb.append(",entryentity1.totaldiffqty1 AS totaldiffqty");
        sb.append(",entryentity1.totalmadediff1 AS totalmadediff");
        sb.append(",entryentity1.totalmadeupamt1 AS totalmadeupamt");
        sb.append(",entryentity1.totalunjoindiffamt1 AS totalunjoindiffamt");
        sb.append(",entryentity1.totalstdcostupamt1 AS totalstdcostupamt");
        sb.append(",entryentity1.totalorddiff1 AS totalorddiff");
        sb.append(",entryentity1.totalinvoicediff1 AS totalinvoicediff");
        sb.append(",entryentity1.totalfeediff1 AS totalfeediff");
        sb.append(",entryentity1.totalfalldiff1 AS totalfalldiff");
        sb.append(",entryentity1.totalotherdiff1 AS totalotherdiff");
        sb.append(",entryentity1.totalactcostupamt1 AS totalactcostupamt");
        sb.append(",entryentity1.endqty1 AS endqty");
        sb.append(",entryentity1.endamt1 AS endamt");
        sb.append(",entryentity1.enddiffqty1 AS enddiffqty");
        sb.append(",entryentity1.endmadediff1 AS endmadediff");
        sb.append(",entryentity1.endmadeupamt1 AS endmadeupamt");
        sb.append(",entryentity1.endunjoindiffamt1 AS endunjoindiffamt");
        sb.append(",entryentity1.endstdcostupamt1 AS endstdcostupamt");
        sb.append(",entryentity1.endorddiff1 AS endorddiff");
        sb.append(",entryentity1.endinvoicediff1 AS endinvoicediff");
        sb.append(",entryentity1.endfeediff1 AS endfeediff");
        sb.append(",entryentity1.endfalldiff1 AS endfalldiff");
        sb.append(",entryentity1.endotherdiff1 AS endotherdiff");
        sb.append(",entryentity1.endactcostupamt1 AS endactcostupamt");
        return sb.toString();
    }

    protected List<Field> getRowMetaField() {
        ArrayList<Field> field = new ArrayList<Field>(10);
        field.add(new Field("period", (DataType)DataType.LongType));
        field.add(new Field("costcenter", (DataType)DataType.LongType));
        field.add(new Field("costobject", (DataType)DataType.LongType));
        field.add(new Field("bizstatus", (DataType)DataType.StringType));
        field.add(new Field("entryproduct", (DataType)DataType.LongType));
        field.add(new Field("elementname", (DataType)DataType.StringType));
        field.add(new Field("subelement", (DataType)DataType.LongType));
        field.add(new Field("materialname", (DataType)DataType.StringType));
        field.add(new Field("matversion", (DataType)DataType.LongType));
        field.add(new Field("auxpty", (DataType)DataType.LongType));
        field.add(new Field("baseunit", (DataType)DataType.LongType));
        field.add(new Field("bookcurrency", (DataType)DataType.LongType));
        field.add(new Field("currqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("currprice", (DataType)DataType.BigDecimalType));
        field.add(new Field("curramt", (DataType)DataType.BigDecimalType));
        field.add(new Field("currdiffqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("currmadediff", (DataType)DataType.BigDecimalType));
        field.add(new Field("currmadeupamt", (DataType)DataType.BigDecimalType));
        field.add(new Field("currunjoindiffamt", (DataType)DataType.BigDecimalType));
        field.add(new Field("currstdcostupamt", (DataType)DataType.BigDecimalType));
        field.add(new Field("currorddiff", (DataType)DataType.BigDecimalType));
        field.add(new Field("currinvoicediff", (DataType)DataType.BigDecimalType));
        field.add(new Field("currfeediff", (DataType)DataType.BigDecimalType));
        field.add(new Field("currfalldiff", (DataType)DataType.BigDecimalType));
        field.add(new Field("currotherdiff", (DataType)DataType.BigDecimalType));
        field.add(new Field("currdiffsum", (DataType)DataType.BigDecimalType));
        field.add(new Field("curractcostupprice", (DataType)DataType.BigDecimalType));
        field.add(new Field("curractcostupamt", (DataType)DataType.BigDecimalType));
        field.add(new Field("compqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("compprice", (DataType)DataType.BigDecimalType));
        field.add(new Field("compamt", (DataType)DataType.BigDecimalType));
        field.add(new Field("compdiffqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("compmadediff", (DataType)DataType.BigDecimalType));
        field.add(new Field("compmadeupamt", (DataType)DataType.BigDecimalType));
        field.add(new Field("compunjoindiffamt", (DataType)DataType.BigDecimalType));
        field.add(new Field("compstdcostupamt", (DataType)DataType.BigDecimalType));
        field.add(new Field("comporddiff", (DataType)DataType.BigDecimalType));
        field.add(new Field("compinvoicediff", (DataType)DataType.BigDecimalType));
        field.add(new Field("compfeediff", (DataType)DataType.BigDecimalType));
        field.add(new Field("compfalldiff", (DataType)DataType.BigDecimalType));
        field.add(new Field("compotherdiff", (DataType)DataType.BigDecimalType));
        field.add(new Field("compdiffsum", (DataType)DataType.BigDecimalType));
        field.add(new Field("compactcostupprice", (DataType)DataType.BigDecimalType));
        field.add(new Field("compactcostupamt", (DataType)DataType.BigDecimalType));
        return field;
    }

    public static Object getFilterItemValue(FilterInfo filterInfo, String propName) {
        FilterItemInfo filterItem = filterInfo.getFilterItem(propName);
        if (filterItem != null && filterItem.getValue() != null) {
            Object value = filterItem.getValue();
            if (value instanceof DynamicObject) {
                return ((DynamicObject)value).getPkValue();
            }
            if (value instanceof DynamicObjectCollection) {
                DynamicObjectCollection values = (DynamicObjectCollection)value;
                return values.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            }
            return value;
        }
        return null;
    }
}

