/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.report.function;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.sca.algox.report.args.OutlayCostsCompNewQueryArgs;

public class OutlayCostsCalcUnitCostFunction
extends MapFunction {
    private static final long serialVersionUID = 7067739166749300592L;
    private static final Log logger = LogFactory.getLog(OutlayCostsCalcUnitCostFunction.class);
    private RowMeta srcMeta;
    private OutlayCostsCompNewQueryArgs args;

    public OutlayCostsCalcUnitCostFunction(RowMeta rowMeta, OutlayCostsCompNewQueryArgs args) {
        this.srcMeta = rowMeta;
        this.args = args;
    }

    public RowMeta getResultRowMeta() {
        return this.srcMeta;
    }

    public RowX map(RowX row) {
        int issumrow = row.getInteger(this.srcMeta.getFieldIndex("issumrow"));
        int periodsumrow = row.getInteger(this.srcMeta.getFieldIndex("periodsumrow"));
        int ccsumrow = row.getInteger(this.srcMeta.getFieldIndex("ccsumrow"));
        int totalsumrow = row.getInteger(this.srcMeta.getFieldIndex("totalsumrow"));
        if (this.args.isNoDetails() || issumrow == 1 || ccsumrow == 1 || periodsumrow == 1 || totalsumrow == 1) {
            row.set(this.srcMeta.getFieldIndex("currqty"), (Object)row.getBigDecimal(this.srcMeta.getFieldIndex("currqtys")));
            row.set(this.srcMeta.getFieldIndex("compqty"), (Object)row.getBigDecimal(this.srcMeta.getFieldIndex("compqtys")));
            if (issumrow == 1) {
                row.set(this.srcMeta.getFieldIndex("materialname"), row.get(this.srcMeta.getFieldIndex("proMatName")));
                row.set(this.srcMeta.getFieldIndex("materialnumber"), row.get(this.srcMeta.getFieldIndex("proNumber")));
                row.set(this.srcMeta.getFieldIndex("baseunit"), row.get(this.srcMeta.getFieldIndex("proMatUnitId")));
                row.set(this.srcMeta.getFieldIndex("matversion"), row.get(this.srcMeta.getFieldIndex("proMatVerId")));
                row.set(this.srcMeta.getFieldIndex("auxpty"), row.get(this.srcMeta.getFieldIndex("proMatAuxId")));
            } else if (ccsumrow == 1) {
                row.set(this.srcMeta.getFieldIndex("materialname"), (Object)ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u5408\u8ba1", (String)"OutlayCostsCalcUnitCostFunction_0", (String)"macc-sca-algox", (Object[])new Object[0]));
                row.set(this.srcMeta.getFieldIndex("baseunit"), (Object)0L);
                row.set(this.srcMeta.getFieldIndex("matversion"), (Object)0L);
                row.set(this.srcMeta.getFieldIndex("auxpty"), (Object)0L);
            } else if (periodsumrow == 1) {
                row.set(this.srcMeta.getFieldIndex("materialname"), (Object)ResManager.loadKDString((String)"\u671f\u95f4\u5408\u8ba1", (String)"OutlayCostsCalcUnitCostFunction_1", (String)"macc-sca-algox", (Object[])new Object[0]));
                row.set(this.srcMeta.getFieldIndex("baseunit"), (Object)0L);
                row.set(this.srcMeta.getFieldIndex("matversion"), (Object)0L);
                row.set(this.srcMeta.getFieldIndex("auxpty"), (Object)0L);
            } else if (totalsumrow == 1) {
                row.set(this.srcMeta.getFieldIndex("materialname"), (Object)ResManager.loadKDString((String)"\u603b\u5408\u8ba1", (String)"OutlayCostsCalcUnitCostFunction_2", (String)"macc-sca-algox", (Object[])new Object[0]));
                row.set(this.srcMeta.getFieldIndex("baseunit"), (Object)0L);
                row.set(this.srcMeta.getFieldIndex("matversion"), (Object)0L);
                row.set(this.srcMeta.getFieldIndex("auxpty"), (Object)0L);
            }
        }
        BigDecimal currdiffsum = this.getOrZero(row.get(this.srcMeta.getFieldIndex("currdiffqty"))).add(this.getOrZero(row.get(this.srcMeta.getFieldIndex("currmadediff")))).add(this.getOrZero(row.get(this.srcMeta.getFieldIndex("currmadeupamt")))).add(this.getOrZero(row.get(this.srcMeta.getFieldIndex("currunjoindiffamt")))).add(this.getOrZero(row.get(this.srcMeta.getFieldIndex("currstdcostupamt")))).add(this.getOrZero(row.get(this.srcMeta.getFieldIndex("currorddiff")))).add(this.getOrZero(row.get(this.srcMeta.getFieldIndex("currinvoicediff")))).add(this.getOrZero(row.get(this.srcMeta.getFieldIndex("currfeediff")))).add(this.getOrZero(row.get(this.srcMeta.getFieldIndex("currfalldiff")))).add(this.getOrZero(row.get(this.srcMeta.getFieldIndex("currotherdiff"))));
        row.set(this.srcMeta.getFieldIndex("currdiffsum"), (Object)currdiffsum);
        BigDecimal compdiffsum = this.getOrZero(row.get(this.srcMeta.getFieldIndex("compdiffqty"))).add(this.getOrZero(row.get(this.srcMeta.getFieldIndex("compmadediff")))).add(this.getOrZero(row.get(this.srcMeta.getFieldIndex("compmadeupamt")))).add(this.getOrZero(row.get(this.srcMeta.getFieldIndex("compunjoindiffamt")))).add(this.getOrZero(row.get(this.srcMeta.getFieldIndex("compstdcostupamt")))).add(this.getOrZero(row.get(this.srcMeta.getFieldIndex("comporddiff")))).add(this.getOrZero(row.get(this.srcMeta.getFieldIndex("compinvoicediff")))).add(this.getOrZero(row.get(this.srcMeta.getFieldIndex("compfeediff")))).add(this.getOrZero(row.get(this.srcMeta.getFieldIndex("compfalldiff")))).add(this.getOrZero(row.get(this.srcMeta.getFieldIndex("compotherdiff"))));
        row.set(this.srcMeta.getFieldIndex("compdiffsum"), (Object)compdiffsum);
        BigDecimal curramt = this.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("curramt")));
        BigDecimal currqtys = this.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("tmpcurrqtys")));
        if (currqtys.compareTo(BigDecimal.ZERO) == 0) {
            currqtys = row.getBigDecimal(this.srcMeta.getFieldIndex("currqtys"));
        }
        BigDecimal curractcostupamt = this.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("curractcostupamt")));
        if (currqtys != null && currqtys.compareTo(BigDecimal.ZERO) > 0) {
            if (currqtys != null) {
                BigDecimal currprice = curramt.divide(currqtys, this.args.getPriceSacle(), RoundingMode.HALF_UP);
                row.set(this.srcMeta.getFieldIndex("currprice"), (Object)currprice);
            }
            if (curractcostupamt != null) {
                BigDecimal curractcostupprice = curractcostupamt.divide(currqtys, this.args.getPriceSacle(), RoundingMode.HALF_UP);
                row.set(this.srcMeta.getFieldIndex("curractcostupprice"), (Object)curractcostupprice);
            }
        }
        BigDecimal compamt = this.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("compamt")));
        BigDecimal compqtys = this.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("tmpcompqtys")));
        if (compqtys.compareTo(BigDecimal.ZERO) == 0) {
            compqtys = row.getBigDecimal(this.srcMeta.getFieldIndex("compqtys"));
        }
        BigDecimal compactcostupamt = this.getOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("compactcostupamt")));
        if (compqtys != null && compqtys.compareTo(BigDecimal.ZERO) > 0) {
            if (compamt != null) {
                BigDecimal compprice = compamt.divide(compqtys, this.args.getPriceSacle(), RoundingMode.HALF_UP);
                row.set(this.srcMeta.getFieldIndex("compprice"), (Object)compprice);
            }
            if (compactcostupamt != null) {
                BigDecimal compactcostupprice = compactcostupamt.divide(compqtys, this.args.getPriceSacle(), RoundingMode.HALF_UP);
                row.set(this.srcMeta.getFieldIndex("compactcostupprice"), (Object)compactcostupprice);
            }
        }
        if (ccsumrow == 1 || periodsumrow == 1 || totalsumrow == 1) {
            row.set(this.srcMeta.getFieldIndex("currprice"), (Object)BigDecimal.ZERO);
            row.set(this.srcMeta.getFieldIndex("curractcostupprice"), (Object)BigDecimal.ZERO);
            row.set(this.srcMeta.getFieldIndex("compprice"), (Object)BigDecimal.ZERO);
            row.set(this.srcMeta.getFieldIndex("compactcostupprice"), (Object)BigDecimal.ZERO);
        }
        return row;
    }

    private BigDecimal getOrZero(Object object) {
        if (object == null || !(object instanceof BigDecimal)) {
            return BigDecimal.ZERO;
        }
        return (BigDecimal)object;
    }
}

