/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore;

import java.util.Date;
import java.util.List;
import kd.bos.algo.AlgoException;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.sca.algox.constants.RestoreCalcCheck;
import kd.macc.sca.algox.restore.DiffCalcTaskType;
import kd.macc.sca.algox.restore.action.AfterCalcAction;
import kd.macc.sca.algox.restore.action.DiffCalcCheckAction;
import kd.macc.sca.algox.restore.action.IDiffCalcAction;
import kd.macc.sca.algox.restore.common.CostCalcResultManager;
import kd.macc.sca.algox.restore.common.DiffCalcContext;
import kd.macc.sca.algox.restore.common.DiffCalcDataArgs;
import kd.macc.sca.algox.restore.common.DiffCalcResult;
import kd.macc.sca.algox.utils.RestoreCalcReportHelper;
import kd.macc.sca.algox.utils.TimeUtils;
import kd.macc.sca.algox.wip.CalcMutexHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class DiffCalcEngine {
    private static final Log logger = LogFactory.getLog(DiffCalcEngine.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiffCalcResult diffCalc(DiffCalcDataArgs costCalcArgs) {
        logger.info(this.buildLogMessage("DiffCalcCalc", costCalcArgs));
        DiffCalcContext context = new DiffCalcContext();
        context.setInputArgs(costCalcArgs);
        context.setTaskType(DiffCalcTaskType.DiffCalc);
        context.setTaskConfigId(RestoreCalcCheck.CALCTASKID);
        CostCalcResultManager resultManager = new CostCalcResultManager();
        try {
            long start = System.currentTimeMillis();
            logger.info("\u5dee\u5f02\u5206\u644a\u8ba1\u7b97\u5f00\u59cb\uff1a{}", (Object)costCalcArgs);
            DiffCalcResult result = this.doCalculate(context, resultManager);
            logger.info("\u5dee\u5f02\u5206\u644a\u8ba1\u7b97\u603b\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
            DiffCalcResult diffCalcResult = result;
            return diffCalcResult;
        }
        catch (Exception e) {
            logger.error("\u5dee\u5f02\u5206\u644a\u8ba1\u7b97\u62a5\u9519\uff1a" + e.getMessage(), (Throwable)e);
            this.writeErroToTaskRecord(costCalcArgs.getTaskRecordId(), e, costCalcArgs);
            DiffCalcResult diffCalcResult = this.getCalcResult(context, resultManager, false);
            return diffCalcResult;
        }
        finally {
            logger.info("ActPeriodEndCalc-\u91ca\u653e\u7f51\u63a7");
            RestoreCalcReportHelper.saveDiffCalcReport(costCalcArgs.getCalcReportId(), BusinessDataServiceHelper.loadSingle((Object)costCalcArgs.getTaskRecordId(), (String)"sca_taskrecord"), costCalcArgs.getPeriodId());
            CalcMutexHelper.releaseXMutex("diffcalc", costCalcArgs.getCostaccountId());
        }
    }

    public DiffCalcResult diffCalcCheck(DiffCalcDataArgs costCalcArgs) {
        logger.info(this.buildLogMessage("ActPeriodEndCalcCheck", costCalcArgs));
        DiffCalcContext context = new DiffCalcContext();
        context.setInputArgs(costCalcArgs);
        context.setTaskType(DiffCalcTaskType.DiffCalcCheck);
        context.setTaskConfigId(RestoreCalcCheck.CHECKTASKID);
        CostCalcResultManager resultManager = new CostCalcResultManager();
        try {
            return this.doCalculate(context, resultManager);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            this.writeErroToTaskRecord(costCalcArgs.getTaskRecordId(), e, costCalcArgs);
            return this.getCalcResult(context, resultManager, false);
        }
    }

    private DiffCalcResult doCalculate(DiffCalcContext context, CostCalcResultManager resultManager) {
        logger.info("context.getTaskType() " + (Object)((Object)context.getTaskType()));
        List<IDiffCalcAction> actions = IDiffCalcAction.create(context.getTaskType());
        DLock lock = null;
        try {
            for (IDiffCalcAction action : actions) {
                String lockId;
                boolean isLocked;
                action.setContext(context);
                action.setResultManager(resultManager);
                if (action instanceof DiffCalcCheckAction && DiffCalcTaskType.DiffCalc == context.getTaskType() && !(isLocked = (lock = DLock.create((String)(lockId = "settleaccount_cal" + context.getInputArgs().getCostaccountId()), (String)"fi-cal-settleaccount-dlock")).tryLock())) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u7c3f\u6b63\u5728\u8fdb\u884c\u7ed3\u8d26\u6216\u53cd\u7ed3\u8d26\u6216\u5dee\u5f02\u5206\u644a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"DiffCalcEngine_3", (String)"macc-sca-algox", (Object[])new Object[0]));
                }
                logger.info("\u5dee\u5f02\u5206\u644a\u8ba1\u7b97doAction\uff1a{},\u5f00\u59cb", action.getClass());
                long start = System.currentTimeMillis();
                action.execute();
                logger.info("\u5dee\u5f02\u5206\u644a\u8ba1\u7b97doAction\u7ed3\u675f\uff1a{},\u7ed3\u675f:\u8017\u65f6:{}", action.getClass(), (Object)(System.currentTimeMillis() - start));
                if (!resultManager.isSkipNextAction()) continue;
                break;
            }
        }
        catch (Exception ex) {
            logger.error("\u5dee\u5f02\u5206\u644a-action\u8ba1\u7b97\u51fa\u73b0\u9519\u8bef", (Throwable)ex);
            DiffCalcResult result = resultManager.buildResult();
            result.setAllSuccess(false);
            throw ex;
        }
        finally {
            if (lock != null) {
                lock.close();
            }
            AfterCalcAction action = new AfterCalcAction();
            action.setContext(context);
            if (!context.isCalc()) {
                if (resultManager.getResult() == null) {
                    resultManager.buildResult();
                }
                resultManager.getResult().setAllSuccess(false);
            }
            action.setResultManager(resultManager);
            action.execute();
        }
        return this.getCalcResult(context, resultManager, true);
    }

    private DiffCalcResult getCalcResult(DiffCalcContext context, CostCalcResultManager resultManager, boolean isSuccess) {
        DiffCalcResult result = resultManager.buildResult();
        result.setAllSuccess(isSuccess);
        result.setCalcReportId(context.getInputArgs().getCalcReportId());
        result.setCheckResultId(context.getInputArgs().getCheckResultId());
        result.setTaskRecordId(context.getInputArgs().getTaskRecordId());
        return result;
    }

    private void writeErroToTaskRecord(Long taskRecordId, Exception ex, DiffCalcDataArgs args) {
        if (taskRecordId == null || ex == null) {
            return;
        }
        String errormsg = ResManager.loadKDString((String)"\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u652f\u6301\u4eba\u5458\u3002", (String)"DiffCalcEngine_0", (String)"macc-sca-algox", (Object[])new Object[0]);
        String errInfo = this.wrapExceptionErrorInfo(ex);
        if (ex instanceof KDBizException) {
            if (!kd.bos.util.StringUtils.isEmpty((String)ex.getMessage())) {
                errormsg = ex.getMessage();
                KDBizException kdex = (KDBizException)ex;
                if (!"cal".equals(kdex.getErrorCode().getCode())) {
                    errInfo = ex.getMessage();
                }
            }
        } else if (ex instanceof AlgoException) {
            int i = 5;
            Throwable th = ex;
            while (th.getCause() != null && !((th = th.getCause()) instanceof KDBizException) && --i >= 0) {
            }
            if (th instanceof KDBizException && !kd.bos.util.StringUtils.isEmpty((String)th.getMessage())) {
                errormsg = th.getMessage();
                errInfo = th.getMessage();
            }
        }
        this.writeErrorTaskRecordByParam(taskRecordId, args, errormsg, errInfo, null);
    }

    private void writeErrorTaskRecordByParam(Long taskRecordId, DiffCalcDataArgs args, String errInfo, String subParam, String subNextEntity) {
        DynamicObject record = BusinessDataServiceHelper.loadSingleFromCache((Object)taskRecordId, (String)"sca_taskrecord", (String)"id,progress,time,starttime,status,nextpagepara,entryentity.seq,entryentity.subname,entryentity.detailconfig,entryentity.substatus,entryentity.substarttime,entryentity.subtime,entryentity.detail,entryentity.subnextentity,entryentity.subparam,entryentity.subparam_tag");
        if (record == null) {
            return;
        }
        Long time = TimeUtils.getSecond(record.getDate("starttime"), new Date());
        if (Long.compare(0L, time) == 0) {
            time = 1L;
        }
        record.set("progress", (Object)100);
        record.set("time", (Object)time);
        record.set("status", (Object)"3");
        DynamicObjectCollection entrys = record.getDynamicObjectCollection("entryentity");
        DynamicObject doingEntry = null;
        for (DynamicObject entry : entrys) {
            if ("2".equals(entry.getString("substatus"))) {
                doingEntry = entry;
                break;
            }
            if (doingEntry != null || !"1".equals(entry.getString("substatus"))) continue;
            doingEntry = entry;
        }
        if (doingEntry == null) {
            if (!entrys.isEmpty()) {
                doingEntry = (DynamicObject)entrys.get(entrys.size() - 1);
            } else {
                doingEntry = entrys.addNew();
                doingEntry.set("subname", (Object)ResManager.loadKDString((String)"\u8ba1\u7b97\u5931\u8d25", (String)"DiffCalcEngine_1", (String)"macc-sca-algox", (Object[])new Object[0]));
                doingEntry.set("seq", (Object)(entrys.size() + 1));
            }
        }
        if (doingEntry != null) {
            if (doingEntry.getInt("subtime") == 0) {
                doingEntry.set("substarttime", (Object)new Date());
                doingEntry.set("subtime", (Object)"1");
            }
            doingEntry.set("substatus", (Object)"3");
            doingEntry.set("detail", (Object)(errInfo.length() > 255 ? errInfo.substring(0, 255) : errInfo));
            if (kd.bos.util.StringUtils.isNotEmpty((String)subNextEntity)) {
                doingEntry.set("subnextentity", (Object)subNextEntity);
            }
            String infoMsg = doingEntry.getString("subparam_tag");
            infoMsg = kd.bos.util.StringUtils.isNotEmpty((String)subNextEntity) ? subParam : infoMsg + subParam;
            doingEntry.set("subparam", (Object)"");
            doingEntry.set("subparam_tag", (Object)StringUtils.substring((String)infoMsg, (int)0, (int)2000000));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
    }

    private String wrapExceptionErrorInfo(Exception ex) {
        StringBuilder erroStr = new StringBuilder();
        String errormsg = ex.getCause() == null ? (ex.getLocalizedMessage() == null ? "" : ex.getLocalizedMessage()) : ex.getCause().getMessage();
        erroStr.append(errormsg).append('\n');
        erroStr.append(ExceptionUtils.getStackTrace((Throwable)ex));
        return erroStr.toString();
    }

    private String buildLogMessage(String mothedName, DiffCalcDataArgs costCalcArgs) {
        StringBuilder sb = new StringBuilder();
        sb.append(ResManager.loadKDString((String)"\u5dee\u5f02\u5206\u644a\u8ba1\u7b97-", (String)"DiffCalcEngine_2", (String)"macc-sca-algox", (Object[])new Object[0])).append(mothedName).append(": ");
        sb.append("checkResult=").append(costCalcArgs.getCheckResultId()).append(", ");
        sb.append("org=").append(costCalcArgs.getOrgId()).append(", ");
        sb.append("costAcct=").append(costCalcArgs.getCostaccountId()).append(", ");
        sb.append("period=").append(costCalcArgs.getPeriodId()).append(", ");
        return sb.toString();
    }
}

