/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore.action;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.macc.cad.common.utils.TimeUtils;
import kd.macc.sca.algox.restore.DiffCalcDataInputFactory;
import kd.macc.sca.algox.restore.DiffCalcTaskType;
import kd.macc.sca.algox.restore.action.AbstractDiffCalcAction;
import kd.macc.sca.algox.restore.common.DiffCalcDataArgs;
import kd.macc.sca.algox.restore.common.TaskRecordEntryRow;
import kd.macc.sca.algox.restore.common.TaskRecordHeader;
import kd.macc.sca.algox.utils.ScaCalcHelper;
import net.sf.json.JSONObject;

public class AfterCalcAction
extends AbstractDiffCalcAction {
    private static final Log logger = LogFactory.getLog(AfterCalcAction.class);

    @Override
    protected void doExecute() {
        if (this.getContext().getTaskType() == DiffCalcTaskType.DiffCalcCheck) {
            this.afterCheckOnly();
        } else {
            this.afterCalc();
        }
    }

    private void afterCalc() {
        this.updateTaskRecorder();
        this.getResultManager().getTaskRecorder().createCheckDetailHead(this.getContext().getInputArgs());
        long periodId = this.getContext().getInputArgs().getPeriodId();
        long orgid = this.getContext().getInputArgs().getOrgId();
        ThreadPools.executeOnce((String)"AfterCalcAction.deleteCalcResult", () -> this.deleteCalcResult(orgid, periodId));
    }

    private void afterCheckOnly() {
        TaskRecordHeader taskRecord = this.getResultManager().getTaskRecorder().getTaskRecord();
        if (taskRecord != null) {
            if ("2".equals(taskRecord.getStatus())) {
                taskRecord.setStatus("4");
                taskRecord.setDirtyFlag("Status");
            }
            JSONObject subPagePara = new JSONObject();
            subPagePara.accumulate("checkResultId", (Object)this.getContext().getInputArgs().getCheckResultId());
            taskRecord.setNextPagePara(subPagePara.toString());
            taskRecord.setDirtyFlag("NextPagePara");
            this.getResultManager().getTaskRecorder().saveHeader();
        }
    }

    private void updateTaskRecorder() {
        Set<Long> costobjectRangeIds;
        DiffCalcDataArgs args = this.getContext().getInputArgs();
        TaskRecordHeader taskRecordHeader = this.getResultManager().getTaskRecorder().getTaskRecord();
        Long time = TimeUtils.getSecondTime((Date)taskRecordHeader.getStartTime(), (Date)new Date());
        if (Long.compare(0L, time) == 0) {
            time = 1L;
        }
        int failCount = this.getContext().getCheckNoPassCount();
        boolean isSuccess = this.getResultManager().getResult() != null ? this.getResultManager().getResult().isAllSuccess() : true;
        for (TaskRecordEntryRow entryRow : taskRecordHeader.getEntryRows().values()) {
            if (!"6".equals(entryRow.getSubStatus()) && !"3".equals(entryRow.getSubStatus())) continue;
            isSuccess = false;
            break;
        }
        int sucCcCount = 0;
        int sucCoCount = 0;
        if (isSuccess && !(costobjectRangeIds = this.getContext().getCostobjectDiffCalcResultIdMap().keySet()).isEmpty()) {
            DataSet ds = DiffCalcDataInputFactory.getCostcenterAndCostobjectDs(costobjectRangeIds);
            Set<Long> costcenterIds = ScaCalcHelper.getLongIdSetFromDs(ds, "costcenter", false);
            sucCcCount = costcenterIds.size();
            sucCoCount = costobjectRangeIds.size();
        }
        JSONObject pagePara = new JSONObject();
        pagePara.accumulate("orgId", (Object)args.getOrgId());
        pagePara.accumulate("costAccountId", (Object)args.getCostaccountId());
        pagePara.accumulate("periodId", (Object)args.getPeriodId());
        pagePara.accumulate("currencyId", (Object)args.getCurrencyId());
        pagePara.accumulate("time", (Object)time);
        pagePara.accumulate("checkFailCount", failCount);
        pagePara.accumulate("checkNoPassCount", this.getContext().getCheckNoPassCount());
        pagePara.accumulate("checkRemaindCount", this.getContext().getCheckRemaindCount());
        pagePara.accumulate("checkResultId", (Object)args.getCheckResultId());
        pagePara.accumulate("calcReportId", (Object)args.getCalcReportId());
        pagePara.accumulate("successCcCount", sucCcCount);
        pagePara.accumulate("successCoCount", sucCoCount);
        pagePara.accumulate("isSuccess", isSuccess);
        taskRecordHeader.setNextPagePara(pagePara.toString());
        taskRecordHeader.setTime(time);
        taskRecordHeader.setProgress(100);
        if ("2".equals(taskRecordHeader.getStatus()) || !isSuccess) {
            if (isSuccess && failCount == 0) {
                taskRecordHeader.setStatus("4");
            } else {
                taskRecordHeader.setStatus("3");
            }
        }
        this.getResultManager().getTaskRecorder().saveHeader();
    }

    private void deleteCalcResult(long orgid, long periodId) {
        QFilter filter = new QFilter("org", "=", (Object)orgid);
        filter.and("costaccount", "=", (Object)999999L);
        filter.and("period", "=", (Object)periodId);
        ArrayList idList = Lists.newArrayListWithCapacity((int)1000);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"restore.action.AfterCalcAction.deleteCalcResult", (String)"sca_diffcalcresult", (String)"id", (QFilter[])filter.toArray(), null);
        for (Row row : ds) {
            idList.add(row.getLong("id"));
        }
        int count = 0;
        List spList = Lists.partition((List)idList, (int)500);
        for (List listTmp : spList) {
            filter = new QFilter("id", "in", (Object)listTmp);
            int x = DeleteServiceHelper.delete((String)"sca_diffcalcresult", (QFilter[])filter.toArray());
            count += x;
        }
        logger.info("\u3010\u5dee\u5f02\u5206\u644a\u8ba1\u7b97\u3011\u5df2\u5220\u9664\u5dee\u5f02\u8ba1\u7b97\u7ed3\u679c\u5355 {} \u6761\u6807\u8bc6\u7684\u8bb0\u5f55", (Object)count);
        filter = new QFilter("org", "=", (Object)orgid);
        filter.and("costaccount", "=", (Object)999999L);
        filter.and("period", "=", (Object)periodId);
        int x = DeleteServiceHelper.delete((String)"sca_purchdiffalloc", (QFilter[])filter.toArray());
        logger.info("\u3010\u5dee\u5f02\u5206\u644a\u8ba1\u7b97\u3011\u5df2\u5220\u9664\u5dee\u5f02\u5206\u914d\u5355 {} \u6761\u6807\u8bc6\u7684\u8bb0\u5f55", (Object)x);
    }
}

