/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore.action;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.RowFactory;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.dto.MaterialCodeDto;
import kd.macc.cad.common.helper.MaterialLevelCompareHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.TimeUtils;
import kd.macc.sca.algox.costrec.DebugInfoMsgHandler;
import kd.macc.sca.algox.restore.CalServiceHelper;
import kd.macc.sca.algox.restore.DiffCalcDataInputFactory;
import kd.macc.sca.algox.restore.DiffReportItemEnum;
import kd.macc.sca.algox.restore.action.AbstractDiffCalcAction;
import kd.macc.sca.algox.restore.action.task.DiffAllocParam;
import kd.macc.sca.algox.restore.action.task.DiffAllocTaskAction;
import kd.macc.sca.algox.restore.common.DiffCalcDataArgs;
import kd.macc.sca.algox.restore.common.DiffCalcHelper;
import kd.macc.sca.algox.utils.DataSetXLogUtil;
import kd.macc.sca.algox.utils.LogUtils;
import kd.macc.sca.algox.utils.ScaCalcHelper;
import kd.macc.sca.common.costcalc.CalcResultObjectInfo;
import kd.macc.sca.common.helper.ProAllocStdHelper;

public abstract class DiffCalcBaseAction
extends AbstractDiffCalcAction {
    public static final Log logger = LogFactory.getLog(DiffCalcBaseAction.class);
    private String lvlShowMsg = ResManager.loadKDString((String)"\u7b2c%s\u5c42\u7269\u6599", (String)"DiffCalcBaseAction_0", (String)"macc-sca-algox", (Object[])new Object[0]);
    private String speLvlShowMsg = ResManager.loadKDString((String)"\u7b2c%s\u5c42\u65e0\u9886\u6599\u9700\u8981\u7ed3\u8f6c\u7684\u7269\u6599", (String)"DiffCalcBaseAction_9", (String)"macc-sca-algox", (Object[])new Object[0]);
    private static RowMeta nestMatUsePreDiffRowMeta = null;
    private static RowMeta nestMatUseQtyRowMeta = null;

    @Override
    protected void doExecute() {
        if (this.getContext().isDiffCheck()) {
            return;
        }
        if (!this.getContext().isCalc()) {
            return;
        }
        DiffCalcDataArgs args = this.getContext().getInputArgs();
        if (args.isRetryMode() && args.getRetryLevel() == 99) {
            return;
        }
        Collection<MaterialCodeDto> allmats = this.getMaterialCodeMap().values();
        Long nonTaskEntryId = 0L;
        if (!args.isSpecifyMatCalc() && args.getDomatcoll() && !args.isRetryMode()) {
            nonTaskEntryId = this.getResultManager().getTaskRecorder().saveTaskRecordEntry(DiffReportItemEnum.getName(DiffReportItemEnum.NONDIFFCOLL.getValue()), 0L, "1");
        }
        List<Long[]> levelTaskEntryIds = null;
        if (args.isRetryMode()) {
            DynamicObject taskRecordDyo = BusinessDataServiceHelper.loadSingle((String)"sca_taskrecord", (QFilter[])new QFilter("id", "=", (Object)args.getTaskRecordId()).toArray());
            levelTaskEntryIds = this.createLevelTaskEntryByRetryMode(args, taskRecordDyo);
        } else {
            levelTaskEntryIds = this.createLevelTaskEntry(args);
        }
        if (!args.isSpecifyMatCalc() && args.getDomatcoll() && !args.isRetryMode() && this.scaDiffColExecute()) {
            this.nonProdDiffColl(args, allmats, nonTaskEntryId);
        }
        if (!args.isRetryMode()) {
            MaterialLevelCompareHelper.saveLevelCode(this.getContext().getMatLvlList(), this.getContext().getNestMatGroups(), (Long)this.getContext().getInputArgs().getCalcReportId());
        }
        this.levelCalc(args, levelTaskEntryIds);
    }

    private List<Long[]> createLevelTaskEntryByRetryMode(DiffCalcDataArgs args, DynamicObject taskRecordDyo) {
        List<List<MaterialCodeDto>> matLvlList = this.getContext().getMatLvlList();
        ArrayList<Long[]> levelTaskEntryIds = new ArrayList<Long[]>(matLvlList.size());
        DynamicObjectCollection entryColl = taskRecordDyo.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < matLvlList.size(); ++i) {
            Long[] levelTaskEntryIdArr = new Long[4];
            if (i == 0 && !args.getDomatcoll() && !args.isSpecifyMatCalc()) {
                levelTaskEntryIds.add(i, levelTaskEntryIdArr);
                continue;
            }
            String levelStr = this.getLevelStr(i);
            if (i != 0 || args.isSpecifyMatCalc()) {
                String curName = DiffReportItemEnum.getName(DiffReportItemEnum.DIFFROLLOUT.getValue());
                String curItem = levelStr + curName;
                levelTaskEntryIdArr[0] = this.getRetryTaskentryId(entryColl, curItem);
            }
            String curItem = levelStr + DiffReportItemEnum.getName(DiffReportItemEnum.DIFFCOLL.getValue());
            long taskEntryId = this.getRetryTaskentryId(entryColl, curItem);
            levelTaskEntryIdArr[1] = taskEntryId;
            String curAllocItem = levelStr + DiffReportItemEnum.getName(DiffReportItemEnum.DIFFALLOC.getValue());
            long taskAllocEntryId = this.getRetryTaskentryId(entryColl, curAllocItem);
            levelTaskEntryIdArr[2] = taskAllocEntryId;
            if (i != 0 || args.isSpecifyMatCalc()) {
                String nestCurItem = levelStr + DiffReportItemEnum.getName(DiffReportItemEnum.DIFFNESTROLLOUT.getValue());
                long nestEntryId = this.getRetryTaskentryId(entryColl, nestCurItem);
                levelTaskEntryIdArr[3] = nestEntryId;
            }
            levelTaskEntryIds.add(i, levelTaskEntryIdArr);
        }
        return levelTaskEntryIds;
    }

    private Long getRetryTaskentryId(DynamicObjectCollection entryColl, String curItem) {
        for (DynamicObject dynamicObject : entryColl) {
            if (!dynamicObject.getString("subname").startsWith(curItem)) continue;
            return dynamicObject.getLong("id");
        }
        return 0L;
    }

    private List<Long[]> createLevelTaskEntry(DiffCalcDataArgs args) {
        List<List<MaterialCodeDto>> matLvlList = this.getContext().getMatLvlList();
        ArrayList<Long[]> levelTaskEntryIds = new ArrayList<Long[]>(matLvlList.size());
        for (int i = 0; i < matLvlList.size(); ++i) {
            Long[] levelTaskEntryIdArr = new Long[4];
            if (i == 0 && !args.getDomatcoll() && !args.isSpecifyMatCalc()) {
                levelTaskEntryIds.add(i, levelTaskEntryIdArr);
                continue;
            }
            String levelStr = this.getLevelStr(i);
            if (i != 0 || args.isSpecifyMatCalc()) {
                String curName = DiffReportItemEnum.getName(DiffReportItemEnum.DIFFROLLOUT.getValue());
                String curItem = levelStr + curName;
                long taskEntryId = this.getResultManager().getTaskRecorder().saveTaskRecordEntry(curItem, 0L, "1");
                levelTaskEntryIdArr[0] = taskEntryId;
            }
            String curItem = levelStr + DiffReportItemEnum.getName(DiffReportItemEnum.DIFFCOLL.getValue());
            long taskEntryId = this.getResultManager().getTaskRecorder().saveTaskRecordEntry(curItem, 0L, "1");
            levelTaskEntryIdArr[1] = taskEntryId;
            String curAllocItem = levelStr + DiffReportItemEnum.getName(DiffReportItemEnum.DIFFALLOC.getValue());
            long taskAllocEntryId = this.getResultManager().getTaskRecorder().saveTaskRecordEntry(curAllocItem, 0L, "1");
            levelTaskEntryIdArr[2] = taskAllocEntryId;
            if (i != 0 || args.isSpecifyMatCalc()) {
                String nestCurItem = levelStr + DiffReportItemEnum.getName(DiffReportItemEnum.DIFFNESTROLLOUT.getValue());
                long nestEntryId = this.getResultManager().getTaskRecorder().saveTaskRecordEntry(nestCurItem, 0L, "1");
                levelTaskEntryIdArr[3] = nestEntryId;
            }
            levelTaskEntryIds.add(i, levelTaskEntryIdArr);
        }
        return levelTaskEntryIds;
    }

    private void levelCalc(DiffCalcDataArgs args, List<Long[]> levelTaskEntryIds) {
        List<List<MaterialCodeDto>> matLvlList = this.getContext().getMatLvlList();
        List<List<String>> nestMatGroups = this.getContext().getNestMatGroups();
        int progess = (int)Math.floor(60.0 / (double)((matLvlList.size() + 1) * 3));
        HashSet calcMatIds = Sets.newHashSet();
        int totalMaterialCount = 0;
        for (int i = 0; i < matLvlList.size(); ++i) {
            ArrayList<List<String>> curNestMatGroups = new ArrayList<List<String>>();
            Set<String> curCalMatIds = DiffCalcHelper.getCurrMaterialIds(matLvlList.get(i), nestMatGroups, curNestMatGroups);
            if (curCalMatIds.isEmpty()) continue;
            totalMaterialCount += curCalMatIds.size();
        }
        int currentMaterialCount = 0;
        for (int i = 0; i < matLvlList.size(); ++i) {
            if (!this.getContext().isCalc()) {
                return;
            }
            Long[] levelTaskEntryIdArr = levelTaskEntryIds.get(i);
            ArrayList<List<String>> curNestMatGroups = new ArrayList<List<String>>();
            Set<String> curCalMatIds = DiffCalcHelper.getCurrMaterialIds(matLvlList.get(i), nestMatGroups, curNestMatGroups);
            if (curCalMatIds.isEmpty()) continue;
            currentMaterialCount += curCalMatIds.size();
            if (args.getRetryLevel() > 0 && args.getRetryLevel() > i + 1) continue;
            logger.info("\u5dee\u5f02\u5206\u644a-\u7b2c{}\u5c42\uff0c\u7269\u6599\u7ef4\u5ea6\u6570\u91cf\u4e3a{}", (Object)(i + 1), (Object)curCalMatIds.size());
            logger.info("\u5dee\u5f02\u5206\u644a-\u7b2c{}\u5c42\uff0c\u5d4c\u5957\u7ec4\u7269\u6599\u4e3a{}", (Object)(i + 1), (Object)curNestMatGroups.size());
            if (i == 0 && !args.getDomatcoll() && !args.isSpecifyMatCalc()) continue;
            String suffix = String.format(ResManager.loadKDString((String)"( \u5df2\u6267\u884c\u7269\u6599\u3010%1$s\u3011/\u603b\u7269\u6599\u6570\u3010%2$s\u3011)", (String)"DiffCalcBaseAction_8", (String)"macc-sca-algox", (Object[])new Object[0]), currentMaterialCount, totalMaterialCount);
            List<MaterialCodeDto> curCalMats = DiffCalcHelper.getLvlMaterialList(curCalMatIds, this.getMaterialCodeMap());
            for (MaterialCodeDto matCode : curCalMats) {
                calcMatIds.add(matCode.getMaterial());
            }
            String curCalMatNumbers = DiffCalcDataInputFactory.getMaterialInfo(curCalMats, this.getContext().getDiffMatLvlDim());
            if (i != 0 || args.isSpecifyMatCalc()) {
                this.diffTransOut(i, args, null, null, curCalMats, curNestMatGroups, calcMatIds, progess, levelTaskEntryIdArr[0], suffix);
                if (!this.getContext().isCalc()) {
                    return;
                }
            }
            this.diffColl(i, args, curCalMats, curCalMatNumbers, curNestMatGroups, progess, levelTaskEntryIdArr[1], suffix);
            if (!this.getContext().isCalc()) {
                return;
            }
            this.diffalloc(i, args, curCalMats, progess, levelTaskEntryIdArr[2], suffix);
            if (!this.getContext().isCalc()) {
                return;
            }
            if (i == 0 && !args.isSpecifyMatCalc()) continue;
            List<MaterialCodeDto> curNestCalMats = DiffCalcHelper.getLvlNestGroupMaterialList(curNestMatGroups, this.getMaterialCodeMap());
            if (!curNestCalMats.isEmpty()) {
                this.diffTransOut(i, args, curNestCalMats, curNestMatGroups, null, null, null, progess, levelTaskEntryIdArr[3], suffix);
                continue;
            }
            this.getResultManager().getTaskRecorder().upateTaskRecordDetail(levelTaskEntryIdArr[3], "2");
            this.getResultManager().getTaskRecorder().upateTaskRecordDetail(levelTaskEntryIdArr[3], "4", -1, suffix);
        }
    }

    private void diffTransOut(int level, DiffCalcDataArgs args, List<MaterialCodeDto> preNestCalMats, List<List<String>> preNestMatGroups, List<MaterialCodeDto> curCalMats, List<List<String>> currNestMatGroups, Set<Long> calcMatIds, int progess, Long taskEntryId, String suffix) {
        Set<String> errorNumber;
        String curName = DiffReportItemEnum.getName(DiffReportItemEnum.DIFFROLLOUT.getValue());
        if (curCalMats == null) {
            curName = DiffReportItemEnum.getName(DiffReportItemEnum.DIFFNESTROLLOUT.getValue());
        }
        String curItem = this.getLevelStr(level) + curName;
        if (CadEmptyUtils.isEmpty((Long)taskEntryId)) {
            Tuple2<Integer, Long> recorderTuple = this.getResultManager().getTaskRecorder().saveTaskRecordEntryRtEntryId(curItem, 0L, "2", null);
            taskEntryId = (Long)recorderTuple.t2;
        } else {
            this.getResultManager().getTaskRecorder().upateTaskRecordDetail(taskEntryId, "2");
        }
        this.saveDiffCalcReport();
        DebugInfoMsgHandler msgHander = null;
        if (StringUtils.isNotEmpty((String)this.getContext().getInputArgs().getDebugColValue())) {
            msgHander = new DebugInfoMsgHandler(this.getContext().getInputArgs().getTaskRecordId(), taskEntryId);
        }
        args.setTaskEntryId(taskEntryId);
        if (!CadEmptyUtils.isEmpty(preNestCalMats)) {
            this.diffTransOutDeal(args, preNestCalMats, preNestMatGroups, true, msgHander, level);
            if ("1".equals(CadBgParamUtils.getCadBgParamForString((String)"scaMatCollDiffDeal", (String)"1"))) {
                List<List<Map<String, Object>>> nestMatGroups = DiffCalcHelper.getLvlNestGroupMapDimList(preNestMatGroups, this.getMaterialCodeMap(), this.getContext().getDiffMatLvlDim(), this.getContext().getMatAuxptysMap());
                ArrayList<Map<String, Object>> nestMats = new ArrayList<Map<String, Object>>();
                CalServiceHelper.putCurrMatAllocToCalV2(args, nestMats, nestMatGroups, level == 0, null, null, null, true);
            }
        }
        if (curCalMats != null && !curCalMats.isEmpty()) {
            int batchSize = CadBgParamUtils.getCadParamForInt((String)"scaDiffTransoutBSize", (int)2000);
            List<List<MaterialCodeDto>> mtoLists = this.transoutSplitBatch(curCalMats, batchSize);
            logger.info("\u5dee\u5f02\u5206\u644a-\u5dee\u5f02\u8f6c\u51fa-{}\u5c42\u7269\u6599\u5206\u6279\uff1a{}\uff0c\u6bcf\u6279\uff1a{}", new Object[]{level, mtoLists.size(), batchSize});
            int index = 1;
            for (List<MaterialCodeDto> mtos : mtoLists) {
                logger.info("\u5dee\u5f02\u5206\u644a-\u5dee\u5f02\u8f6c\u51fa-{}\u5c42\u5f53\u524d\u6279\uff1a{}\uff0c\u6279\u4e2a\u6570\uff1a{}", new Object[]{level, index++, mtos.size()});
                this.diffTransOutDeal(args, mtos, currNestMatGroups, false, msgHander, level);
            }
        }
        DiffCalcHelper.isHasCheckDetail(args, args.getTaskEntryId(), curItem);
        if (this.getContext().isDiffCheckNotAudit() && !(errorNumber = DiffCalcDataInputFactory.checkCostAdjustAudit(args, calcMatIds)).isEmpty()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u5dee\u5f02\u5355\uff1a%s", (String)"DiffCalcBaseAction_1", (String)"macc-sca-algox", (Object[])new Object[0]), errorNumber.toString()));
        }
        this.getResultManager().getTaskRecorder().upateTaskRecordDetail(taskEntryId, "4", -1, suffix);
        this.updateTaskRecordProcess(progess, "2");
    }

    private List<List<MaterialCodeDto>> transoutSplitBatch(List<MaterialCodeDto> curCalMats, int batchSize) {
        ArrayList<List<MaterialCodeDto>> mtoLists = new ArrayList<List<MaterialCodeDto>>(10);
        if (curCalMats.size() < batchSize) {
            mtoLists.add(curCalMats);
            return mtoLists;
        }
        int avgBatchSize = this.getBatchAvgSize(batchSize, curCalMats.size());
        HashMap<Long, List> materialMtoMap = new HashMap<Long, List>(curCalMats.size());
        for (MaterialCodeDto dto : curCalMats) {
            materialMtoMap.computeIfAbsent(dto.getMaterial(), t -> new ArrayList(10)).add(dto);
        }
        ArrayList listDtos = new ArrayList(10);
        for (List dtos : materialMtoMap.values()) {
            if (listDtos.size() >= avgBatchSize) {
                mtoLists.add(listDtos);
                listDtos = new ArrayList(10);
            }
            listDtos.addAll(dtos);
        }
        if (!listDtos.isEmpty()) {
            mtoLists.add(listDtos);
        }
        return mtoLists;
    }

    protected abstract void diffTransOutDeal(DiffCalcDataArgs var1, List<MaterialCodeDto> var2, List<List<String>> var3, boolean var4, DebugInfoMsgHandler var5, int var6);

    private void diffalloc(int level, DiffCalcDataArgs args, List<MaterialCodeDto> curCalMats, int progess, Long taskEntryId, String suffix) {
        String curItem = this.getLevelStr(level) + DiffReportItemEnum.getName(DiffReportItemEnum.DIFFALLOC.getValue());
        if (CadEmptyUtils.isEmpty((Long)taskEntryId)) {
            Tuple2<Integer, Long> recorderTuple = this.getResultManager().getTaskRecorder().saveTaskRecordEntryRtEntryId(curItem, 0L, "2", null);
            taskEntryId = (Long)recorderTuple.t2;
        } else {
            this.getResultManager().getTaskRecorder().upateTaskRecordDetail(taskEntryId, "2");
        }
        this.saveDiffCalcReport();
        DebugInfoMsgHandler msgHander = new DebugInfoMsgHandler(this.getContext().getInputArgs().getTaskRecordId(), taskEntryId);
        args.setTaskEntryId(taskEntryId);
        Set<Long> curCalMatIds = DiffCalcHelper.getDimMatIdMapFromLvl(curCalMats);
        this.diffallocBatchDeal(level, args, curCalMats, msgHander, curCalMatIds);
        DiffCalcHelper.isHasCheckDetail(args, args.getTaskEntryId(), curItem);
        DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"OutsourcedCostTraceableService", (String)"doTraceCost", (Object[])new Object[]{args.getCostaccountId(), args.getPeriodId(), curCalMatIds});
        this.getResultManager().getTaskRecorder().upateTaskRecordDetail(taskEntryId, "4", -1, suffix);
        this.updateTaskRecordProcess(progess, "2");
    }

    private void diffallocBatchDeal(int level, DiffCalcDataArgs args, List<MaterialCodeDto> curCalMats, DebugInfoMsgHandler msgHander, Set<Long> curCalMatIds) {
        int batchSize = this.getContext().getDiffallocBatchSize();
        if (level > 0 && args.getParallel() && curCalMatIds.size() < batchSize && curCalMatIds.size() > 250) {
            batchSize = curCalMatIds.size() / 3 + 1;
        }
        if (curCalMatIds.size() > batchSize) {
            HashMap materialDtoMap = Maps.newHashMapWithExpectedSize((int)1024);
            for (MaterialCodeDto dto : curCalMats) {
                materialDtoMap.computeIfAbsent(dto.getMaterial(), t -> new ArrayList(10)).add(dto);
            }
            ArrayList<Long> calMatIds = new ArrayList<Long>(curCalMatIds);
            Collections.shuffle(calMatIds);
            batchSize = this.getBatchAvgSize(batchSize, calMatIds.size());
            List lists = Lists.partition(calMatIds, (int)batchSize);
            logger.info("\u5dee\u5f02\u5206\u644a-\u5dee\u5f02\u5206\u914d\uff1a\u5c42\u7ea7{}\uff0c\u5206\u6279\u6570{}\uff0c\u6bcf\u6279{}", new Object[]{level, lists.size(), batchSize});
            List<List<MaterialCodeDto>> batchDtoLists = this.getBatchList(lists, materialDtoMap);
            boolean isAllocParallel = "1".equals(CadBgParamUtils.getCadBgParamForString((String)"scaDiffAllocPair", (String)"1"));
            if (isAllocParallel) {
                this.createCalcResult(args, curCalMats, level);
                int batchIndex = 0;
                ArrayList<Long> paramIds = new ArrayList<Long>(10);
                ArrayList<DynamicObject> paramDyns = new ArrayList<DynamicObject>(10);
                for (List<MaterialCodeDto> batchDtos : batchDtoLists) {
                    ArrayList<String> matDims = new ArrayList<String>(batchDtos.size());
                    for (MaterialCodeDto dto : batchDtos) {
                        matDims.add(dto.getMaterialKey());
                    }
                    ++batchIndex;
                    DiffAllocParam params = new DiffAllocParam();
                    params.setArgs(args);
                    params.setBatchExecuteSize(this.getContext().getBatchExecuteSize());
                    params.setCurCalMats(matDims);
                    params.setMsgHander(msgHander);
                    params.setLevel(level);
                    params.setBatchNo(batchIndex);
                    params.setDiffMatLvlDim(this.getContext().getDiffMatLvlDim());
                    params.setDiffProAllocStdMap(this.getContext().getDiffProAllocStdMap());
                    params.setCostobjectDiffCalcResultIdMap(this.getContext().getCostobjectDiffCalcResultIdMap());
                    params.setDiffAllocMatQuSize(this.getContext().getDiffAllocMatQuSize());
                    params.setDiffCostadjBatch(this.getContext().isDiffCostadjBatch());
                    params.setDiffAllocDealUAlloc(this.getContext().isDiffAllocDealUAlloc());
                    params.setDiffAllocSaveCadjId(this.getContext().isDiffAllocSaveCadjId());
                    paramIds.add(this.genParParamDynId("diffalloc", params, paramDyns));
                }
                SaveServiceHelper.save((DynamicObject[])paramDyns.toArray(new DynamicObject[0]));
                String taskName = ResManager.loadKDString((String)"\u5dee\u5f02\u5206\u644a-\u5dee\u5f02\u5206\u914d", (String)"DiffCalcBaseAction_5", (String)"macc-sca-algox", (Object[])new Object[0]);
                HashSet<String> taskIds = new HashSet<String>(16);
                batchIndex = 0;
                for (Long paramId : paramIds) {
                    taskIds.add(this.sendTask(taskName, paramId, lists.size(), ++batchIndex, DiffAllocTaskAction.class.getName()));
                }
                this.waitTaskExecute(taskName, taskIds, paramIds);
            } else {
                int i = 0;
                for (List<MaterialCodeDto> batchDtos : batchDtoLists) {
                    this.diffallocDeal(level, args, batchDtos, msgHander, ++i, false);
                }
            }
        } else {
            this.diffallocDeal(level, args, curCalMats, msgHander, 1, false);
        }
    }

    private List<List<MaterialCodeDto>> getBatchList(List<List<Long>> lists, Map<Long, List<MaterialCodeDto>> materialDtoMap) {
        ArrayList<List<MaterialCodeDto>> dtoLists = new ArrayList<List<MaterialCodeDto>>(lists.size());
        for (List<Long> list : lists) {
            ArrayList<MaterialCodeDto> batchDtos = new ArrayList<MaterialCodeDto>(list.size());
            for (Long matId : list) {
                List<MaterialCodeDto> matDtos = materialDtoMap.get(matId);
                if (matDtos == null) continue;
                batchDtos.addAll(matDtos);
            }
            dtoLists.add(batchDtos);
        }
        return dtoLists;
    }

    private void createCalcResult(DiffCalcDataArgs args, List<MaterialCodeDto> curCalMats, int level) {
        Set<Long> curCalMatIds = DiffCalcHelper.getDimMatIdMapFromLvl(curCalMats);
        DataSet dimMatDs = null;
        if (this.getContext().isContainsMaterialOtherDim()) {
            dimMatDs = DiffCalcHelper.getDimMatDsFromLvl(curCalMats);
        }
        DataSet curMatAllocDs = DiffCalcDataInputFactory.getCurMatAllocDataId(args, curCalMatIds);
        if (this.getContext().isContainsMaterialOtherDim() && dimMatDs != null) {
            curMatAllocDs = DiffCalcHelper.joinDimMatDsToFilterDs(curMatAllocDs, dimMatDs, this.getContext().getDiffMatLvlDim());
        }
        DataSet curPurAllocDs = DiffCalcDataInputFactory.getEndPurchDiffAllocDsId(args, curCalMatIds);
        if (this.getContext().isContainsMaterialOtherDim() && dimMatDs != null) {
            curPurAllocDs = DiffCalcHelper.joinDimMatDsToFilterDs(curPurAllocDs, dimMatDs, this.getContext().getDiffMatLvlDim());
        }
        DataSet curVouPurAllocDs = DiffCalcDataInputFactory.getCurPurchDiffAllocDsId(args, curCalMatIds);
        if (this.getContext().isContainsMaterialOtherDim() && dimMatDs != null) {
            curVouPurAllocDs = DiffCalcHelper.joinDimMatDsToFilterDs(curVouPurAllocDs, dimMatDs, this.getContext().getDiffMatLvlDim());
        }
        Set<Long> costobjectIds = this.getCostobjectIds(curMatAllocDs, curPurAllocDs, curVouPurAllocDs);
        long start = System.currentTimeMillis();
        int size = DiffCalcHelper.generateCostobjectDiffCalcResult(args, this.getContext().getCostobjectDiffCalcResultIdMap(), costobjectIds, null);
        logger.info("\u5dee\u5f02\u5206\u644a-\u7b2c{}\u5c42\u7269\u6599\u751f\u6210\u8ba1\u7b97\u7ed3\u679c\u5355\u6570\u4e3a{}\uff0c\u8017\u65f6\u4e3a{}", new Object[]{level + 1, size, System.currentTimeMillis() - start});
    }

    private Set<Long> getCostobjectIds(DataSet curMatAllocDs, DataSet curPurAllocDs, DataSet curVouPurAllocDs) {
        DataSet curMatAllocCopyDs = curMatAllocDs.groupBy(new String[]{"costobject"}).finish();
        Set<Long> costobjectIds = ScaCalcHelper.getLongIdSetFromDs(curMatAllocCopyDs, "costobject", false);
        DataSet curPurAllocCopyDs = curPurAllocDs.groupBy(new String[]{"costobject"}).finish();
        costobjectIds.addAll(ScaCalcHelper.getLongIdListFromDs(curPurAllocCopyDs, "costobject", false));
        DataSet curVouPurAllocCopyDs = curVouPurAllocDs.groupBy(new String[]{"costobject"}).finish();
        costobjectIds.addAll(ScaCalcHelper.getLongIdListFromDs(curVouPurAllocCopyDs, "costobject", false));
        return costobjectIds;
    }

    protected abstract void diffallocDeal(int var1, DiffCalcDataArgs var2, List<MaterialCodeDto> var3, DebugInfoMsgHandler var4, int var5, boolean var6);

    private void nonProdDiffColl(DiffCalcDataArgs args, Collection<MaterialCodeDto> allmats, Long taskEntryId) {
        if (CadEmptyUtils.isEmpty((Long)taskEntryId)) {
            Tuple2<Integer, Long> recorderTuple = this.getResultManager().getTaskRecorder().saveTaskRecordEntryRtEntryId(DiffReportItemEnum.getName(DiffReportItemEnum.NONDIFFCOLL.getValue()), 0L, "2", null);
            taskEntryId = (Long)recorderTuple.t2;
        } else {
            this.getResultManager().getTaskRecorder().upateTaskRecordDetail(taskEntryId, "2");
        }
        this.saveDiffCalcReport();
        long time = System.currentTimeMillis();
        List<Map<String, Object>> matListMap = DiffCalcHelper.getDimMapParamFromLvl(allmats, this.getContext().getDiffMatLvlDim(), this.getContext().getMatAuxptysMap());
        logger.info("AllProdMaterial:{}", (Object)matListMap.size());
        int isLogAllProdMaterial = CadBgParamUtils.getCadParamForInt((String)"isLogAllProdMaterial", (int)1);
        if (isLogAllProdMaterial == 1) {
            int index = 0;
            for (Map<String, Object> map : matListMap) {
                logger.info("prodMaterial {}:{}", (Object)index, map);
                ++index;
            }
        }
        CalServiceHelper.putAllMatAllocToCalV2(args, matListMap, true);
        logger.info("\u975e\u751f\u4ea7\u9886\u6599\u7269\u6599\u5f52\u96c6\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - time - 1L));
        this.getResultManager().getTaskRecorder().upateTaskRecordDetail(taskEntryId, "4", -1, null);
        this.updateTaskRecordProcess(5, "2");
    }

    private String getLevelStr(int level) {
        if (level == 1) {
            return String.format(this.speLvlShowMsg, level + 1);
        }
        return String.format(this.lvlShowMsg, level + 1);
    }

    private void diffColl(int level, DiffCalcDataArgs args, List<MaterialCodeDto> curCalMats, String curCalMatNumbers, List<List<String>> curNestMatGroups, int progess, Long taskEntryId, String suffix) {
        String curItem = this.getLevelStr(level) + DiffReportItemEnum.getName(DiffReportItemEnum.DIFFCOLL.getValue());
        String infoMsg = String.format(ResManager.loadKDString((String)"\u672c\u5c42\u8ba1\u7b97\u7269\u6599\u7f16\u7801\u8303\u56f4\uff1a%s", (String)"DiffCalcBaseAction_2", (String)"macc-sca-algox", (Object[])new Object[0]), curCalMatNumbers);
        StringBuilder sbInfo = new StringBuilder();
        sbInfo.append(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\uff1a", (String)"DiffCalcBaseAction_6", (String)"macc-sca-algox", (Object[])new Object[0])).append(TimeUtils.formatDate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss")).append("\n");
        if (!curNestMatGroups.isEmpty()) {
            List<MaterialCodeDto> nestMats = DiffCalcHelper.getLvlNestGroupMaterialList(curNestMatGroups, this.getMaterialCodeMap());
            Map<String, String> matDimNames = DiffCalcDataInputFactory.getMaterialInfoMap(nestMats, this.getContext().getDiffMatLvlDim());
            sbInfo.append(ResManager.loadKDString((String)"\u5d4c\u5957\u7ec4\uff1a\n", (String)"DiffCalcBaseAction_7", (String)"macc-sca-algox", (Object[])new Object[0]));
            for (List<String> matGroup : curNestMatGroups) {
                int i = 0;
                sbInfo.append("[");
                for (String mat : matGroup) {
                    if (i != 0) {
                        sbInfo.append(",");
                    }
                    sbInfo.append(matDimNames.get(mat) == null ? mat : matDimNames.get(mat));
                    ++i;
                }
                sbInfo.append("]\n");
            }
        }
        sbInfo.append(infoMsg);
        infoMsg = sbInfo.toString();
        if (CadEmptyUtils.isEmpty((Long)taskEntryId)) {
            Tuple2<Integer, Long> tuple = this.getResultManager().getTaskRecorder().saveTaskRecordEntryRtEntryId(curItem, 0L, "2", infoMsg);
            taskEntryId = (Long)tuple.t2;
        } else {
            this.getResultManager().getTaskRecorder().upateTaskRecordDetailPara(taskEntryId, "2", null, null, infoMsg);
        }
        this.saveDiffCalcReport();
        long time = System.currentTimeMillis();
        boolean calNestRatio = CadBgParamUtils.getCadParamForInt((String)"calNestRatio", (int)0) == 1;
        List reworkAndNestMatFactMap = null;
        String nestMatUseQtyDsCache = null;
        String nestPreDiffDsCache = null;
        if ((level > 0 || args.isSpecifyMatCalc()) && !curNestMatGroups.isEmpty()) {
            DebugInfoMsgHandler msgHander = new DebugInfoMsgHandler(this.getContext().getInputArgs().getTaskRecordId(), taskEntryId);
            Map<String, Object> map = this.getReworkAndNestMatParam(args, curNestMatGroups, msgHander, calNestRatio);
            reworkAndNestMatFactMap = (List)map.get("oldParamList");
            nestMatUseQtyDsCache = (String)map.get("nestMatUseQtyDsCache");
            nestPreDiffDsCache = (String)map.get("nestPreDiffDsCache");
            if (StringUtils.isNotEmpty((String)args.getDebugColValue())) {
                msgHander.dealInfoMsg("\r\nReworkAndNestMatFactMap-" + reworkAndNestMatFactMap);
                msgHander.dealInfoMsg("\r\nnestMatUseCalList-" + reworkAndNestMatFactMap);
                msgHander.dealInfoMsg("\r\nnestMatUsePreDiffList-" + reworkAndNestMatFactMap);
            }
        }
        List<MaterialCodeDto> newCalMats = curCalMats;
        if (!curNestMatGroups.isEmpty()) {
            newCalMats = new ArrayList<MaterialCodeDto>(curCalMats.size());
            HashSet nestMats = Sets.newHashSetWithExpectedSize((int)10);
            for (List<String> list : curNestMatGroups) {
                nestMats.addAll(list);
            }
            for (MaterialCodeDto dto : curCalMats) {
                if (nestMats.contains(dto.getMaterialKey())) continue;
                newCalMats.add(dto);
            }
        }
        List<Map<String, Object>> matListMap = DiffCalcHelper.getDimMapParamFromLvl(newCalMats, this.getContext().getDiffMatLvlDim(), this.getContext().getMatAuxptysMap());
        List<List<Map<String, Object>>> nestMatGroups = DiffCalcHelper.getLvlNestGroupMapDimList(curNestMatGroups, this.getMaterialCodeMap(), this.getContext().getDiffMatLvlDim(), this.getContext().getMatAuxptysMap());
        LogUtils.logInfoIdColl("matGroupDimPrint", logger, curItem, nestMatGroups);
        LogUtils.logInfoIdColl("matDimPrint", logger, curItem, matListMap);
        if (level != 0 || this.scaDiffColExecute()) {
            CalServiceHelper.putCurrMatAllocToCalV2(args, matListMap, nestMatGroups, level == 0, reworkAndNestMatFactMap, nestMatUseQtyDsCache, nestPreDiffDsCache, false);
        }
        logger.info(curItem + "\u5dee\u5f02\u5f52\u96c6\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - time));
        this.getResultManager().getTaskRecorder().upateTaskRecordDetail(taskEntryId, "4", -1, suffix);
        this.updateTaskRecordProcess(progess, "2");
    }

    private Map<String, Object> getReworkAndNestMatParam(DiffCalcDataArgs args, List<List<String>> curNestMatGroups, DebugInfoMsgHandler msgHander, boolean calNestRatio) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        List<MaterialCodeDto> nestMats = DiffCalcHelper.getLvlNestGroupMaterialList(curNestMatGroups, this.getMaterialCodeMap());
        Set<Long> nestMatIds = DiffCalcHelper.getDimMatIdMapFromLvl(nestMats);
        DataSet curMatAllocDs = DiffCalcDataInputFactory.getCurMatAllocDataNotSub(args, nestMatIds);
        if (calNestRatio) {
            DataSet preDiffAlloc = DiffCalcDataInputFactory.getEndPurchDiffAllocDsForNest(args, nestMatIds);
            curMatAllocDs = curMatAllocDs.union(preDiffAlloc).groupBy(new String[]{"manuorg", "costobject", "material", "auxpty", "configuredcode", "tracknumber", "project", "lot", "submaterial", "subauxpty", "subconfiguredcode", "subtracknumber", "subproject", "sublot"}).sum("qty").finish();
        }
        HashSet<Long> costobjectIds = new HashSet<Long>(10);
        HashMap circleParam = Maps.newHashMapWithExpectedSize((int)16);
        HashSet materialsSet = Sets.newHashSetWithExpectedSize((int)16);
        List<List<String>> preNestMatDimGroups = DiffCalcHelper.getLvlNestGroupDimList(curNestMatGroups, this.getMaterialCodeMap(), this.getContext().getDiffMatLvlDim());
        for (Row row : curMatAllocDs) {
            boolean isCollect = false;
            String productDim = DiffCalcHelper.getDimStrFromRow(row, this.getContext().getDiffMatLvlDim(), "");
            String materialDim = DiffCalcHelper.getDimStrFromRow(row, this.getContext().getDiffMatLvlDim(), "sub");
            for (List<String> nestMatGroup : preNestMatDimGroups) {
                if (!nestMatGroup.contains(productDim) || !nestMatGroup.contains(materialDim)) continue;
                isCollect = true;
                break;
            }
            if (!isCollect) continue;
            costobjectIds.add(row.getLong("costobject"));
            materialsSet.add(row.getLong("submaterial"));
            BigDecimal qty = row.getBigDecimal("qty");
            logger.info("\u5d4c\u5957\u7ec4step1 \u4ea7\u54c1\uff1a{}\uff0c\u6750\u6599\uff1a{}", (Object)productDim, (Object)materialDim);
            HashMap map = Maps.newHashMapWithExpectedSize((int)32);
            Map<String, Object> map2 = DiffCalcHelper.getDimParamFromRowForCal(row, this.getContext().getDiffMatLvlDim(), "");
            map.put("product", map2);
            Map<String, Object> matMap = DiffCalcHelper.getDimParamFromRowForCal(row, this.getContext().getDiffMatLvlDim(), "sub");
            map.put("material", matMap);
            map.put("manuorg", row.getLong("manuorg"));
            map.put("qty", qty);
            map.put("costobjectId", row.getLong("costobject"));
            logger.info("\u5d4c\u5957\u7ec4step2  \u4ea7\u54c1\uff1a{}\uff0c\u6750\u6599\uff1a{}\uff0c\u6570\u91cf\uff1a{}", new Object[]{productDim, materialDim, qty});
            String uniqueKey = productDim + "$" + materialDim;
            List tmplist = circleParam.computeIfAbsent(uniqueKey, p -> Lists.newArrayList());
            tmplist.add(map);
        }
        if (costobjectIds.isEmpty()) {
            return result;
        }
        if (calNestRatio) {
            Map<String, Object> map = this.nestRatioForCal(args, msgHander, costobjectIds, circleParam, materialsSet);
            result.put("nestMatUseQtyDsCache", map.get("nestMatUseQtyDsCache"));
            result.put("nestPreDiffDsCache", map.get("nestPreDiffDsCache"));
        }
        DataSet factDs = DiffCalcDataInputFactory.getCostobjectFact(args, costobjectIds);
        Set<Long> sourcebillentryIds = ScaCalcHelper.getLongIdSetFromDs(factDs, "sourcebillentry", true);
        String diffAllocDims = CalServiceHelper.getDiffAllocDimConfig(args.getOrgId());
        String[] diffAllocDimArr = diffAllocDims.split(",");
        String selectField = CalServiceHelper.getDiffAllocDimsAlias("cal_costrecord_subentity", diffAllocDimArr, "");
        DataSet costrecordDs = DiffCalcDataInputFactory.getCalCostRecordInfoByBizEntryId(args, sourcebillentryIds, selectField);
        HashSet<String> pamFields = new HashSet<String>(10);
        pamFields.add("material");
        for (String dim : diffAllocDimArr) {
            if (StringUtils.isBlank((String)dim)) continue;
            pamFields.add(dim);
        }
        ArrayList<String> arrayList = new ArrayList<String>(pamFields);
        arrayList.add("sourcebillentry");
        arrayList.add("qty");
        DataSet costfactDs = factDs.join(costrecordDs).on("sourcebillentry", "srcbillentryid").select(arrayList.toArray(new String[0])).finish().distinct();
        DataSet paramDs = costfactDs.groupBy(pamFields.toArray(new String[0])).sum("qty").finish();
        pamFields.add("qty");
        ArrayList paramList = new ArrayList(10);
        for (Row row : paramDs) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            for (String field : pamFields) {
                paramMap.put(field, row.get(field));
            }
            paramList.add(paramMap);
        }
        result.put("oldParamList", paramList);
        return result;
    }

    private Map<String, Object> nestRatioForCal(DiffCalcDataArgs args, DebugInfoMsgHandler msgHander, Set<Long> costobjectIds, Map<String, List<Map<String, Object>>> circleParam, Set<Long> materialsSet) {
        Map<Long, Map<Long, CalcResultObjectInfo>> mainJoinSideCostObjectInfoMap;
        HashMap result;
        block12: {
            result = Maps.newHashMapWithExpectedSize((int)16);
            mainJoinSideCostObjectInfoMap = ScaCalcHelper.getMainJoinSideCalcResultInfo(args.getOrgId(), args.getCostaccountId(), args.getPeriodId(), args.getPrePeriodId(), costobjectIds, args.getStartDate(), args.getEndDate());
            if (StringUtils.isNotEmpty((String)args.getDebugColValue()) && "costobject".equals(args.getDebugColName())) {
                try {
                    Long costobjectId = Long.valueOf(args.getDebugColValue());
                    Map<Long, CalcResultObjectInfo> detailsMap = mainJoinSideCostObjectInfoMap.get(costobjectId);
                    if (detailsMap != null && msgHander != null) {
                        msgHander.dealInfoMsg("\r\ngetReworkAndNestMatParam-CalcResultObjectInfo-" + detailsMap);
                    }
                }
                catch (Exception ex) {
                    if (!logger.isDebugEnabled()) break block12;
                    logger.debug("\u5d4c\u5957\u4f20\u53c2,\u5dee\u5f02\u5206\u644a\u8ba1\u7b97-long\u7c7b\u578b\u8f6c\u6362\u95ee\u9898\uff0c\u4e0d\u9700\u8981\u5173\u6ce8 ->{}", (Object)ex.getMessage());
                }
            }
        }
        Map diffProAllocStdMap = ProAllocStdHelper.getDiffProAllocStdMap((Long)args.getOrgId(), (Long)args.getCostaccountId());
        Map<String, BigDecimal> equivalentMap = ScaCalcHelper.getEquivalentMap(args.getOrgId(), args.getCostaccountId(), null, new ArrayList<Object>(costobjectIds), true);
        HashMap costobjectRatioMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry<String, List<Map<String, Object>>> entry : circleParam.entrySet()) {
            for (Map<String, Object> map : entry.getValue()) {
                Long costobjectId = (Long)map.get("costobjectId");
                BigDecimal ratio = this.getCostobjectRatio(args, costobjectId, mainJoinSideCostObjectInfoMap, diffProAllocStdMap, equivalentMap);
                costobjectRatioMap.put(costobjectId, ratio);
                BigDecimal qty = (BigDecimal)map.get("qty");
                logger.info("\u5d4c\u5957\u7ec4step3  costobjectId\uff1a{}\uff0cratio\uff1a{}\uff0cqty\uff1a{}", new Object[]{costobjectId, ratio, qty});
                map.put("qty", qty.multiply(ratio).setScale(10, RoundingMode.HALF_UP));
            }
        }
        Set<String> tmpKeySet = circleParam.keySet();
        DataSet preDiffAllocDs = DiffCalcDataInputFactory.getPreDiffAllocDsForDimFormat(args, materialsSet, costobjectIds);
        Algo algo = Algo.create((String)"kd.macc.sca.algox.restore.action.DiffCalcBaseAction");
        DataSetBuilder builder = algo.createDataSetBuilder(this.getNestMatUsePreDiffRowMeta());
        for (Row row : preDiffAllocDs) {
            String productDim = DiffCalcHelper.getDimStrFromRow(row, this.getContext().getDiffMatLvlDim(), "");
            String materialDim = DiffCalcHelper.getDimStrFromRow(row, this.getContext().getDiffMatLvlDim(), "sub");
            String uniqueKey = productDim + "$" + materialDim;
            if (!tmpKeySet.contains(uniqueKey)) continue;
            Long manuOrg = row.getLong("manuorg");
            Map<String, Object> map = DiffCalcHelper.getDimParamFromRowForCal(row, this.getContext().getDiffMatLvlDim(), "");
            int size = this.getNestMatUsePreDiffRowMeta().getFieldCount();
            Object[] values = new Object[size];
            int index = 0;
            Long costobjectId = row.getLong("costobject");
            BigDecimal ratio = BigDecimal.ZERO;
            if (costobjectRatioMap.get(costobjectId) != null) {
                ratio = (BigDecimal)costobjectRatioMap.get(costobjectId);
            }
            values[index++] = manuOrg;
            values[index++] = map.get("material");
            values[index++] = map.get("assit") == null ? Long.valueOf(0L) : map.get("assit");
            values[index++] = map.get("configuredcode") == null ? Long.valueOf(0L) : map.get("configuredcode");
            values[index++] = map.get("tracknumber") == null ? Long.valueOf(0L) : map.get("tracknumber");
            values[index++] = map.get("project") == null ? Long.valueOf(0L) : map.get("project");
            values[index++] = map.get("lot") == null ? "" : map.get("lot");
            values[index++] = row.getLong("costelement");
            values[index++] = row.getLong("costsubelement");
            values[index++] = row.getBigDecimal("startorddiff").multiply(ratio).setScale(10, RoundingMode.HALF_UP);
            values[index++] = row.getBigDecimal("startinvoicediff").multiply(ratio).setScale(10, RoundingMode.HALF_UP);
            values[index++] = row.getBigDecimal("startdiffqty").multiply(ratio).setScale(10, RoundingMode.HALF_UP);
            values[index++] = row.getBigDecimal("startfeediff").multiply(ratio).setScale(10, RoundingMode.HALF_UP);
            values[index++] = row.getBigDecimal("startmadediff").multiply(ratio).setScale(10, RoundingMode.HALF_UP);
            values[index++] = row.getBigDecimal("startunjoindiffamt").multiply(ratio).setScale(10, RoundingMode.HALF_UP);
            values[index++] = row.getBigDecimal("startstdcostupamt").multiply(ratio).setScale(10, RoundingMode.HALF_UP);
            values[index++] = row.getBigDecimal("startmadeupamt").multiply(ratio).setScale(10, RoundingMode.HALF_UP);
            values[index++] = row.getBigDecimal("startotherdiff").multiply(ratio).setScale(10, RoundingMode.HALF_UP);
            values[index++] = row.getBigDecimal("startfalldiff").multiply(ratio).setScale(10, RoundingMode.HALF_UP);
            values[index++] = row.getBigDecimal("startreservediffx").multiply(ratio).setScale(10, RoundingMode.HALF_UP);
            values[index++] = row.getBigDecimal("startreservediffw").multiply(ratio).setScale(10, RoundingMode.HALF_UP);
            values[index++] = row.getBigDecimal("startreservediffy").multiply(ratio).setScale(10, RoundingMode.HALF_UP);
            logger.info("\u5d4c\u5957\u7ec4step4-1  nestMatUsePreDiffDs-value\uff1a{}", (Object)JSON.toJSONString((Object)values));
            builder.append(RowFactory.createRow((RowMeta)this.getNestMatUsePreDiffRowMeta(), (Object[])values));
        }
        DataSet nestMatUsePreDiffDs = builder.build();
        nestMatUsePreDiffDs = nestMatUsePreDiffDs.groupBy(new String[]{"storageorgunit", "material", "assit", "configuredcode", "tracknumber", "project", "lot", "costelement", "costsubelement"}).sum("ddiff_g").sum("ddiff_h").sum("ddiff_p").sum("ddiff_k").sum("ddiff_q").sum("ddiff_r").sum("ddiff_m").sum("ddiff_s").sum("ddiff_t").sum("ddiff_c").sum("ddiff_x").sum("ddiff_w").sum("ddiff_y").finish();
        if (StringUtils.isNotEmpty((String)args.getDebugColValue()) && "costobject".equals(args.getDebugColName())) {
            DataSetXLogUtil.logDataSet(nestMatUsePreDiffDs.copy(), "nestMatUsePreDiffDs", msgHander);
        }
        CacheHint cacheHint = new CacheHint();
        cacheHint.setTimeout((long)CadBgParamUtils.getCadParamForInt((String)"nestPreDiffDs_cacheTimeOut", (int)3600), TimeUnit.SECONDS);
        CachedDataSet cache = nestMatUsePreDiffDs.cache(cacheHint);
        String nestMatUsePreDiffDsCacheId = cache.getCacheId();
        result.put("nestPreDiffDsCache", nestMatUsePreDiffDsCacheId);
        logger.info("\u5d4c\u5957\u7ec4step6  nestMatUsePreDiffDsCacheId {}", (Object)nestMatUsePreDiffDsCacheId);
        DataSetBuilder matUseQtyBuilder = algo.createDataSetBuilder(this.getNestMatUseQtyRowMeta());
        for (Map.Entry entry : circleParam.entrySet()) {
            for (Map map : (List)entry.getValue()) {
                int size = this.getNestMatUseQtyRowMeta().getFieldCount();
                Object[] values = new Object[size];
                int index = 0;
                Map product = (Map)map.get("product");
                Map subMaterial = (Map)map.get("material");
                values[index++] = map.get("manuorg");
                values[index++] = product.get("material");
                values[index++] = product.get("assit") == null ? Long.valueOf(0L) : product.get("assit");
                values[index++] = product.get("configuredcode") == null ? Long.valueOf(0L) : product.get("configuredcode");
                values[index++] = product.get("tracknumber") == null ? Long.valueOf(0L) : product.get("tracknumber");
                values[index++] = product.get("project") == null ? Long.valueOf(0L) : product.get("project");
                values[index++] = product.get("lot") == null ? "" : product.get("lot");
                values[index++] = map.get("manuorg");
                values[index++] = subMaterial.get("material");
                values[index++] = subMaterial.get("assit") == null ? Long.valueOf(0L) : subMaterial.get("assit");
                values[index++] = subMaterial.get("configuredcode") == null ? Long.valueOf(0L) : subMaterial.get("configuredcode");
                values[index++] = subMaterial.get("tracknumber") == null ? Long.valueOf(0L) : subMaterial.get("tracknumber");
                values[index++] = subMaterial.get("project") == null ? Long.valueOf(0L) : subMaterial.get("project");
                values[index++] = subMaterial.get("lot") == null ? "" : subMaterial.get("lot");
                values[index++] = map.get("qty");
                logger.info("\u5d4c\u5957\u7ec4step4-2 nestMatUseQtyDsCacheDs-value\uff1a{}", (Object)JSON.toJSONString((Object)values));
                matUseQtyBuilder.append(RowFactory.createRow((RowMeta)this.getNestMatUseQtyRowMeta(), (Object[])values));
            }
        }
        DataSet nestMatUseQtyDsCache = matUseQtyBuilder.build();
        nestMatUseQtyDsCache = nestMatUseQtyDsCache.groupBy(new String[]{"instorageorgunit", "outstorageorgunit", "inmaterial", "inassit", "inconfiguredcode", "intracknumber", "inproject", "inlot", "outmaterial", "outassit", "outconfiguredcode", "outtracknumber", "outproject", "outlot"}).sum("baseqty").finish();
        if (StringUtils.isNotEmpty((String)args.getDebugColValue()) && "costobject".equals(args.getDebugColName())) {
            DataSetXLogUtil.logDataSet(nestMatUseQtyDsCache.copy(), "nestMatUseQtyDsCache", msgHander);
        }
        CacheHint cacheHint2 = new CacheHint();
        cacheHint2.setTimeout((long)CadBgParamUtils.getCadParamForInt((String)"nestMatUseQtyDs_cacheTimeOut", (int)3600), TimeUnit.SECONDS);
        CachedDataSet nestMatUseQtyCache = nestMatUseQtyDsCache.cache(cacheHint2);
        String nestMatUseQtyDsCacheId = nestMatUseQtyCache.getCacheId();
        result.put("nestMatUseQtyDsCache", nestMatUseQtyDsCacheId);
        return result;
    }

    private RowMeta getNestMatUsePreDiffRowMeta() {
        if (nestMatUsePreDiffRowMeta == null) {
            Field[] fields = new Field[]{new Field("storageorgunit", (DataType)DataType.LongType), new Field("material", (DataType)DataType.LongType), new Field("assit", (DataType)DataType.LongType), new Field("configuredcode", (DataType)DataType.LongType), new Field("tracknumber", (DataType)DataType.LongType), new Field("project", (DataType)DataType.LongType), new Field("lot", (DataType)DataType.StringType), new Field("costelement", (DataType)DataType.LongType), new Field("costsubelement", (DataType)DataType.LongType), new Field("ddiff_g", (DataType)DataType.BigDecimalType), new Field("ddiff_h", (DataType)DataType.BigDecimalType), new Field("ddiff_p", (DataType)DataType.BigDecimalType), new Field("ddiff_k", (DataType)DataType.BigDecimalType), new Field("ddiff_q", (DataType)DataType.BigDecimalType), new Field("ddiff_r", (DataType)DataType.BigDecimalType), new Field("ddiff_m", (DataType)DataType.BigDecimalType), new Field("ddiff_s", (DataType)DataType.BigDecimalType), new Field("ddiff_t", (DataType)DataType.BigDecimalType), new Field("ddiff_c", (DataType)DataType.BigDecimalType), new Field("ddiff_x", (DataType)DataType.BigDecimalType), new Field("ddiff_w", (DataType)DataType.BigDecimalType), new Field("ddiff_y", (DataType)DataType.BigDecimalType)};
            nestMatUsePreDiffRowMeta = new RowMeta(fields);
        }
        return nestMatUsePreDiffRowMeta;
    }

    private RowMeta getNestMatUseQtyRowMeta() {
        if (nestMatUseQtyRowMeta == null) {
            Field[] fields = new Field[]{new Field("instorageorgunit", (DataType)DataType.LongType), new Field("inmaterial", (DataType)DataType.LongType), new Field("inassit", (DataType)DataType.LongType), new Field("inconfiguredcode", (DataType)DataType.LongType), new Field("intracknumber", (DataType)DataType.LongType), new Field("inproject", (DataType)DataType.LongType), new Field("inlot", (DataType)DataType.StringType), new Field("outstorageorgunit", (DataType)DataType.LongType), new Field("outmaterial", (DataType)DataType.LongType), new Field("outassit", (DataType)DataType.LongType), new Field("outconfiguredcode", (DataType)DataType.LongType), new Field("outtracknumber", (DataType)DataType.LongType), new Field("outproject", (DataType)DataType.LongType), new Field("outlot", (DataType)DataType.StringType), new Field("baseqty", (DataType)DataType.BigDecimalType)};
            nestMatUseQtyRowMeta = new RowMeta(fields);
        }
        return nestMatUseQtyRowMeta;
    }

    private BigDecimal getCostobjectRatio(DiffCalcDataArgs args, Long costobjectId, Map<Long, Map<Long, CalcResultObjectInfo>> mainJoinSideCostObjectInfoMap, Map<String, String> diffProAllocStdMap, Map<String, BigDecimal> equivalentMap) {
        BigDecimal result = BigDecimal.ZERO;
        Map<Long, CalcResultObjectInfo> mainCostobjectMap = mainJoinSideCostObjectInfoMap.get(costobjectId);
        if (mainCostobjectMap == null) {
            logger.info("\u5d4c\u5957\u4f20\u53c2 ,mainCostobjectMap error {}", (Object)costobjectId);
            return result;
        }
        CalcResultObjectInfo croi = mainCostobjectMap.get(costobjectId);
        if (croi == null) {
            logger.info("\u5d4c\u5957\u4f20\u53c2,CalcResultObjectInfo error{}", (Object)costobjectId);
            return result;
        }
        Long costcenterId = croi.getCostCenterId();
        String allocStd = ProAllocStdHelper.getProAllocStd(diffProAllocStdMap, (long)args.getCostaccountId(), (long)costcenterId, (long)0L);
        BigDecimal multiplier = BigDecimal.ZERO;
        if (!ScaCalcHelper.isHasMainJoinFacted(mainCostobjectMap)) {
            return BigDecimal.ZERO;
        }
        if ("B".equals(croi.getBizStatus())) {
            return BigDecimal.ONE;
        }
        if ("0".equals(allocStd)) {
            multiplier = BigDecimal.ONE;
        } else if ("5".equals(allocStd)) {
            multiplier = BigDecimal.ZERO;
        } else if ("2".equals(allocStd) || "1".equals(allocStd)) {
            BigDecimal tmpA;
            BigDecimal equivalent = BigDecimal.ONE;
            if ("2".equals(allocStd) && (equivalent = ScaCalcHelper.getCostobjectEquivalent(equivalentMap, args.getCostaccountId(), 0L, costcenterId, costobjectId, 0L)) == null) {
                logger.info("\u5d4c\u5957\u4f20\u53c2,\u7ea6\u5f53\u7cfb\u6570\u4e3a0\uff0c{}", (Object)costobjectId);
                return result;
            }
            BigDecimal proFinQty = ScaCalcHelper.getMainAndJoinProFinQty(mainCostobjectMap);
            BigDecimal proIntrQty = ScaCalcHelper.getMainAndJoinProEndQty(mainCostobjectMap);
            if (ScaCalcHelper.isContainsJoinProduct(mainCostobjectMap)) {
                proFinQty = BigDecimal.ZERO;
                proIntrQty = BigDecimal.ZERO;
                for (Map.Entry<Long, CalcResultObjectInfo> entry : mainCostobjectMap.entrySet()) {
                    if ("B".equals(entry.getValue().getProductType())) continue;
                    CalcResultObjectInfo costobjectInfo = entry.getValue();
                    proFinQty = proFinQty.add(costobjectInfo.getFinishQty().multiply(costobjectInfo.getWeight()));
                    proIntrQty = proIntrQty.add(costobjectInfo.getEndQty().multiply(costobjectInfo.getWeight()));
                }
            }
            if ((tmpA = proIntrQty.multiply(equivalent).add(proFinQty)).compareTo(BigDecimal.ZERO) == 0) {
                logger.info("\u5d4c\u5957\u4f20\u53c2 ,\u671f\u672b\u5728\u4ea7\u54c1\u6570\u91cf*\u7ea6\u5f53\u7cfb\u6570+\u5b8c\u5de5\u5165\u5e93\u6570\u91cf=0\u3002{}", (Object)costobjectId);
            }
            multiplier = proFinQty.divide(tmpA, 10, 4);
        }
        logger.info("\u5d4c\u5957\u4f20\u53c2 ,\u6210\u672c\u5bf9\u8c61{},\u5728\u4ea7\u5206\u644a\u6bd4\u4f8b{}", (Object)costobjectId, (Object)multiplier);
        return multiplier;
    }
}

