/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore.action;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.algo.output.IgnoreOutput;
import kd.bos.algo.util.Tuple2;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.macc.cad.common.dto.MaterialCodeDto;
import kd.macc.sca.algox.costrec.DebugInfoMsgHandler;
import kd.macc.sca.algox.enums.CalcReportEntryEnum;
import kd.macc.sca.algox.restore.CalServiceHelper;
import kd.macc.sca.algox.restore.DiffCalcDataInputFactory;
import kd.macc.sca.algox.restore.DiffReportItemEnum;
import kd.macc.sca.algox.restore.action.AbstractDiffCalcAction;
import kd.macc.sca.algox.restore.action.task.DiffCalcResultParam;
import kd.macc.sca.algox.restore.action.task.DiffCalcResultTaskAction;
import kd.macc.sca.algox.restore.common.DiffCalcDataArgs;
import kd.macc.sca.algox.restore.common.DiffCalcHelper;
import kd.macc.sca.algox.restore.function.DiffCalcResultCalcFunction;
import kd.macc.sca.algox.restore.function.DiffCalcResultCompDealFunction;
import kd.macc.sca.algox.restore.function.DiffCalcResultKeycolDealFunction;
import kd.macc.sca.algox.restore.function.DiffCalcResultSaveFunction;
import kd.macc.sca.algox.restore.function.DiffTransOutTransDiffTypeFunction;
import kd.macc.sca.algox.utils.DataSetXHelper;
import kd.macc.sca.algox.utils.RestoreCalcReportHelper;
import kd.macc.sca.algox.utils.ScaCalcHelper;

public class DiffCalcResultAction
extends AbstractDiffCalcAction {
    private static final Log logger = LogFactory.getLog(DiffCalcResultAction.class);

    @Override
    protected void doExecute() {
        if (this.getContext().isDiffCheck()) {
            return;
        }
        if (!this.getContext().isCalc()) {
            return;
        }
        RestoreCalcReportHelper.changeEntryStatusById(CalcReportEntryEnum.handleResult.id);
        DiffCalcDataArgs args = this.getContext().getInputArgs();
        Collection<MaterialCodeDto> allmats = this.getMaterialCodeMap().values();
        this.calResult(args, allmats);
    }

    private void calResult(DiffCalcDataArgs args, Collection<MaterialCodeDto> allmats) {
        String curItem = DiffReportItemEnum.getName(DiffReportItemEnum.DEALCALCRESULT.getValue());
        Tuple2<Integer, Long> recorderTuple = this.getResultManager().getTaskRecorder().saveTaskRecordEntryRtEntryId(curItem, DiffReportItemEnum.DEALCALCRESULT.getValue(), "2", null);
        DebugInfoMsgHandler msgHander = null;
        if (StringUtils.isNotEmpty((String)this.getContext().getInputArgs().getDebugColValue())) {
            msgHander = new DebugInfoMsgHandler(this.getContext().getInputArgs().getTaskRecordId(), (Long)recorderTuple.t2);
        }
        args.setTaskEntryId((Long)recorderTuple.t2);
        this.calResultBatchDeal(args, allmats, msgHander);
        Set<Long> allmatIds = DiffCalcHelper.getDimMatIdMapFromLvl(this.getMaterialCodeMap().values());
        CalServiceHelper.recalCalcBalance(args, allmatIds);
        RestoreCalcReportHelper.clearReportEntryById(CalcReportEntryEnum.handleResult.id);
        this.getResultManager().getTaskRecorder().upateTaskRecordDetail(DiffReportItemEnum.DEALCALCRESULT.getValue(), "4", (Integer)recorderTuple.t1, null);
        this.updateTaskRecordProcess(8, "2");
    }

    protected void calResultBatchDeal(DiffCalcDataArgs args, Collection<MaterialCodeDto> allmats, DebugInfoMsgHandler msgHander) {
        Set<Long> costobjectRangeIds = null;
        if (!args.isSpecifyMatCalc()) {
            DataSet calcResultCostObjectDs = DiffCalcDataInputFactory.getCalcResultCostobjectDs(args);
            costobjectRangeIds = ScaCalcHelper.getLongIdSetFromDs(calcResultCostObjectDs, "costobject", false);
            DiffCalcHelper.generateCostobjectDiffCalcResult(args, this.getContext().getCostobjectDiffCalcResultIdMap(), costobjectRangeIds, null);
            costobjectRangeIds.addAll(this.getContext().getCostobjectDiffCalcResultIdMap().keySet());
        } else {
            costobjectRangeIds = new HashSet<Long>(this.getContext().getCostobjectDiffCalcResultIdMap().keySet());
        }
        this.updateUnAllocDiffToCalcresult(args.getUnAllocDiffCostobjectIds());
        Set<Long> curCalMatIds = DiffCalcHelper.getDimMatIdMapFromLvl(allmats);
        int batchSize = this.getContext().getDiffCalcResultBatchSize();
        if (costobjectRangeIds.size() > batchSize) {
            batchSize = this.getBatchAvgSize(batchSize, costobjectRangeIds.size());
            ArrayList<Long> costobjectIds = new ArrayList<Long>(costobjectRangeIds);
            Collections.shuffle(costobjectIds);
            List splitLists = Lists.partition(costobjectIds, (int)batchSize);
            logger.info("\u5dee\u5f02\u5206\u644a\u751f\u6210\u8ba1\u7b97\u7ed3\u679c\u5355\u5f00\u59cb\uff0c\u5171{}\u4e2a\u6210\u672c\u5bf9\u8c61\u6570\u91cf\uff0c\u6bcf\u6279{}\u4e2a\uff0c\u5171{}\u6279,", new Object[]{costobjectRangeIds.size(), batchSize, splitLists.size()});
            if (args.getParallel() && !args.isSpecifyMatCalc()) {
                int batchIndex = 0;
                ArrayList<Long> paramIds = new ArrayList<Long>(10);
                ArrayList<DynamicObject> paramDyns = new ArrayList<DynamicObject>(10);
                for (List list : splitLists) {
                    ++batchIndex;
                    DiffCalcResultParam params = new DiffCalcResultParam();
                    params.setArgs(args);
                    params.setBatchExecuteSize(this.getContext().getBatchExecuteSize());
                    params.setCostobjectIds(list);
                    params.setMsgHander(msgHander);
                    params.setCurCalMatIds(curCalMatIds);
                    params.setCostobjectDiffCalcResultIdMap(this.getContext().getCostobjectDiffCalcResultIdMap());
                    params.setBatchIndex(batchIndex);
                    paramIds.add(this.genParParamDynId("diffcalcresult", params, paramDyns));
                }
                SaveServiceHelper.save((DynamicObject[])paramDyns.toArray(new DynamicObject[0]));
                String taskName = ResManager.loadKDString((String)"\u5dee\u5f02\u5206\u644a-\u751f\u6210\u8ba1\u7b97\u7ed3\u679c\u5355", (String)"DiffCalcResultAction_9", (String)"macc-sca-algox", (Object[])new Object[0]);
                HashSet<String> taskIds = new HashSet<String>(16);
                batchIndex = 0;
                for (Long paramId : paramIds) {
                    int n = ++batchIndex;
                    ++batchIndex;
                    taskIds.add(this.sendTask(taskName, paramId, splitLists.size(), n, DiffCalcResultTaskAction.class.getName()));
                }
                this.waitTaskExecute(taskName, taskIds, paramIds);
            } else {
                int batchIndex = 0;
                for (List list : splitLists) {
                    this.calResultDeal(args, curCalMatIds, new ArrayList<Long>(list), msgHander, ++batchIndex);
                }
            }
        } else {
            this.calResultDeal(args, curCalMatIds, costobjectRangeIds, msgHander, 1);
        }
    }

    private void updateUnAllocDiffToCalcresult(Set<Long> costobjectIds) {
        Map<Long, Long> diffCalcResultIds = this.getContext().getCostobjectDiffCalcResultIdMap();
        ArrayList calcResultIds = Lists.newArrayListWithExpectedSize((int)costobjectIds.size());
        for (Long id : costobjectIds) {
            Long resultId = diffCalcResultIds.get(id);
            if (resultId == null) continue;
            calcResultIds.add(resultId);
        }
        logger.info("\u66f4\u65b0\u672a\u5206\u644a\u5dee\u5f02\u6807\u8bc6\u7684\u8ba1\u7b97\u7ed3\u679c\u5355\u6570\u91cf\uff1a{}", (Object)calcResultIds.size());
        if (!calcResultIds.isEmpty()) {
            List splitLists = Lists.partition((List)calcResultIds, (int)this.getContext().getBatchExecuteSize());
            for (List spids : splitLists) {
                String sql = String.format("update t_sca_diffcalcresult set fisunallocdiff = '1' where fid in (%s)", this.getUpdateInSql(spids));
                ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_sca_diffcalcresult", (HintCondition[])new HintCondition[]{new HintCondition("fperiodid", "=", (Object)this.getContext().getInputArgs().getPeriodId()), new HintCondition("forgid", "=", (Object)this.getContext().getInputArgs().getOrgId())});
                Throwable throwable = null;
                try {
                    this.executeBatch(sql);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ctx == null) continue;
                    if (throwable != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ctx.close();
                }
            }
        }
    }

    private String getUpdateInSql(List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return "0";
        }
        StringBuilder sb = new StringBuilder();
        for (Long costcenter : ids) {
            sb.append(",").append(costcenter);
        }
        return sb.substring(1);
    }

    public void calResultDeal(DiffCalcDataArgs args, Set<Long> allmatIds, Collection<Long> costobjectRangeIds, DebugInfoMsgHandler msgHander, int batchIndex) {
        long start = System.currentTimeMillis();
        OrmInput calcResultCompDs = DiffCalcDataInputFactory.getCalcResultCompDs(args, "1", costobjectRangeIds);
        OrmInput calcResultKeycolCompDs = DiffCalcDataInputFactory.getCalcResultCompKeycolDs(args, "1", costobjectRangeIds);
        OrmInput calcResultSumDs = DiffCalcDataInputFactory.getCalcResultSumDs(args, costobjectRangeIds);
        OrmInput calcResultUnabsoubDs = DiffCalcDataInputFactory.getCalcResultUnabsoubDs(args, costobjectRangeIds);
        OrmInput preDiffCalcResultCompDs = DiffCalcDataInputFactory.getPreDiffCalcResultCompDs(args, costobjectRangeIds);
        OrmInput diffCalcResultSubDs = DiffCalcDataInputFactory.getDiffCalcResultSubDs(args, costobjectRangeIds);
        OrmInput materialBUnitDs = DiffCalcDataInputFactory.getMaterialDs(allmatIds);
        logger.info("\u5dee\u5f02\u5206\u644a-\u8ba1\u7b97\u7ed3\u679c\u751f\u6210-\u7b2c{}\u5c42\u51c6\u5907\u6570\u636e\u8017\u65f6\uff1a{}", (Object)batchIndex, (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        JobSession session = AlgoX.createSession((String)"DiffCalcAction-calcResult");
        DataSetX calcResultCompDsX = session.fromInput((Input)calcResultCompDs);
        DataSetX calcResultKeycolCompDsX = session.fromInput((Input)calcResultKeycolCompDs);
        DataSetX diffCalcResultSubDsX = session.fromInput((Input)diffCalcResultSubDs);
        DataSetX calcResultUnabsoubDsX = session.fromInput((Input)calcResultUnabsoubDs);
        DataSetX preDiffCalcResultCompDsX = session.fromInput((Input)preDiffCalcResultCompDs);
        DataSetX calcResultSumDsX = session.fromInput((Input)calcResultSumDs);
        DataSetX materialBUnitDsX = session.fromInput((Input)materialBUnitDs);
        calcResultCompDsX = this.logDataSetX(calcResultCompDsX, ResManager.loadKDString((String)"\u8ba1\u7b97\u7ed3\u679c\u5355-\u6807\u51c6\u6210\u672c\u5dee\u5f02:", (String)"DiffCalcResultAction_0", (String)"macc-sca-algox", (Object[])new Object[0]), msgHander);
        calcResultSumDsX = this.logDataSetX(calcResultSumDsX, ResManager.loadKDString((String)"\u8ba1\u7b97\u7ed3\u679c\u5355-\u6c47\u603b\u884c\u6570\u636e:", (String)"DiffCalcResultAction_1", (String)"macc-sca-algox", (Object[])new Object[0]), msgHander);
        calcResultUnabsoubDsX = this.logDataSetX(calcResultUnabsoubDsX, ResManager.loadKDString((String)"\u8ba1\u7b97\u7ed3\u679c\u5355-\u672a\u5438\u6536\u5dee\u5f02\u6570\u636e:", (String)"DiffCalcResultAction_2", (String)"macc-sca-algox", (Object[])new Object[0]), msgHander);
        preDiffCalcResultCompDsX = this.logDataSetX(preDiffCalcResultCompDsX, ResManager.loadKDString((String)"\u4e0a\u4e00\u671f\u7684\u5dee\u5f02\u7ed3\u679c\u5355\u6570\u636e\uff08\u83b7\u53d6\u7d2f\u8ba1\u6570\u636e\uff0c\u548c\u4e0a\u671f\u671f\u672b\uff09:", (String)"DiffCalcResultAction_3", (String)"macc-sca-algox", (Object[])new Object[0]), msgHander);
        diffCalcResultSubDsX = this.logDataSetX(diffCalcResultSubDsX, ResManager.loadKDString((String)"\u672c\u671f\u5dee\u5f02\u7ed3\u679c\u5355\u7684\u4e0b\u9636\u5dee\u5f02:", (String)"DiffCalcResultAction_4", (String)"macc-sca-algox", (Object[])new Object[0]), msgHander);
        calcResultCompDsX = calcResultCompDsX.map((MapFunction)new DiffTransOutTransDiffTypeFunction());
        diffCalcResultSubDsX = DataSetXHelper.groupBySum(diffCalcResultSubDsX, new String[]{"costobject", "relacostobject", "material", "auxpty", "mversion", "keycol", "keycolid", "element", "subelement"}, DiffCalcHelper.stringArrUnion(DiffCalcHelper.fieldsAddPre(DiffCalcHelper.DIFF_FIELD_ARR, "start"), DiffCalcHelper.fieldsAddPre(DiffCalcHelper.DIFF_FIELD_ARR, "curr"), DiffCalcHelper.fieldsAddPre(DiffCalcHelper.DIFF_FIELD_ARR, "comp"), DiffCalcHelper.fieldsAddPre(DiffCalcHelper.DIFF_FIELD_ARR, "end")));
        diffCalcResultSubDsX = this.logDataSetX(diffCalcResultSubDsX, ResManager.loadKDString((String)"\u4e0b\u9636\u5dee\u5f02\u6309\u9ed8\u8ba4\u5b50\u8981\u7d20\u6c42\u548c:", (String)"DiffCalcResultAction_5", (String)"macc-sca-algox", (Object[])new Object[0]), msgHander);
        calcResultCompDsX = DataSetXHelper.addBigDecimalFields(calcResultCompDsX, new String[]{"startdiffqty", "startmadediff", "startmadeupamt", "compdiffqty", "compmadediff", "compmadeupamt", "enddiffqty", "endmadediff", "endmadeupamt"});
        calcResultCompDsX = calcResultCompDsX.groupBy(new String[]{"costobject", "relacostobject", "element", "subelement", "material", "mversion", "auxpty", "keycol", "keycolid"}).reduceGroup((GroupReduceFunction)new DiffCalcResultCompDealFunction());
        calcResultCompDsX = this.logDataSetX(calcResultCompDsX, ResManager.loadKDString((String)"\u5904\u7406\u8ba1\u7b97\u7ed3\u679c\u5355\u7684\u7efc\u5408\u5dee\u5f02\u6570\u636e:", (String)"DiffCalcResultAction_6", (String)"macc-sca-algox", (Object[])new Object[0]), msgHander);
        DataSetX resultDsX = calcResultCompDsX.select(new String[]{"costobject", "relacostobject", "element", "subelement", "material", "mversion", "auxpty", "keycol", "keycolid", "startqty", "startamt", "currqty", "curramt", "compqty", "compamt", "endqty", "endamt", "totalqty", "totalamt", "startdiffqty", "startmadediff", "startmadeupamt", "compdiffqty", "compmadediff", "compmadeupamt", "enddiffqty", "endmadediff", "endmadeupamt"});
        resultDsX = DataSetXHelper.addBigDecimalFields(resultDsX, new String[]{"endunjoindiffamt", "compunjoindiffamt", "currunjoindiffamt", "startunjoindiffamt"});
        calcResultUnabsoubDsX = calcResultUnabsoubDsX.map(new MapFunction(){
            private static final long serialVersionUID = 1L;

            public RowMeta getResultRowMeta() {
                return this.sourceRowMeta;
            }

            public RowX map(RowX row) {
                String elementType = row.getString(this.sourceRowMeta.getFieldIndex("elementType"));
                if (!"005".equals(elementType)) {
                    row.set(this.sourceRowMeta.getFieldIndex("material"), (Object)0L);
                }
                return row;
            }
        });
        resultDsX = DataSetXHelper.unionIfRowDiffStrDefaultEmpty(resultDsX, calcResultUnabsoubDsX);
        resultDsX = DataSetXHelper.addBigDecimalFields(resultDsX, new String[]{"startstdcostupamt", "startorddiff", "startinvoicediff", "startfeediff", "startotherdiff", "startfalldiff", "startreservediffx", "startreservediffw", "startreservediffy", "totaldiffqty", "totalmadediff", "totalmadeupamt", "totalunjoindiffamt", "totalstdcostupamt", "totalorddiff", "totalinvoicediff", "totalfeediff", "totalotherdiff", "totalfalldiff", "totalreservediffx", "totalreservediffw", "totalreservediffy", "currdiffqty", "currmadediff", "currmadeupamt", "currstdcostupamt", "currorddiff", "currinvoicediff", "currfeediff", "currotherdiff", "currfalldiff", "currreservediffx", "currreservediffw", "currreservediffy", "compstdcostupamt", "comporddiff", "compinvoicediff", "compfeediff", "compotherdiff", "compfalldiff", "compreservediffx", "compreservediffw", "compreservediffy", "endstdcostupamt", "endorddiff", "endinvoicediff", "endfeediff", "endotherdiff", "endfalldiff", "endreservediffx", "endreservediffw", "endreservediffy", "startactcostupamt", "curractcostupamt", "compactcostupamt", "endactcostupamt", "totalactcostupamt"});
        resultDsX = DataSetXHelper.unionIfRowDiffStrDefaultEmpty(resultDsX, diffCalcResultSubDsX);
        resultDsX = DataSetXHelper.unionIfRowDiffStrDefaultEmpty(resultDsX, preDiffCalcResultCompDsX);
        resultDsX = DataSetXHelper.groupBySum(resultDsX, new String[]{"costobject", "relacostobject", "element", "subelement", "material", "mversion", "auxpty", "keycol", "keycolid"}, DiffCalcHelper.stringArrUnion({"startqty", "startamt", "currqty", "curramt", "compqty", "compamt", "endqty", "endamt", "totalqty", "totalamt", "startactcostupamt", "curractcostupamt", "compactcostupamt", "endactcostupamt", "totalactcostupamt"}, DiffCalcHelper.fieldsAddPre(DiffCalcHelper.DIFF_FIELD_ARR, "start"), DiffCalcHelper.fieldsAddPre(DiffCalcHelper.DIFF_FIELD_ARR, "curr"), DiffCalcHelper.fieldsAddPre(DiffCalcHelper.DIFF_FIELD_ARR, "comp"), DiffCalcHelper.fieldsAddPre(DiffCalcHelper.DIFF_FIELD_ARR, "end"), DiffCalcHelper.fieldsAddPre(DiffCalcHelper.DIFF_FIELD_ARR, "total")));
        resultDsX = this.logDataSetX(resultDsX, ResManager.loadKDString((String)"\u6c47\u603b\u5dee\u5f02\u6570\u636e:", (String)"DiffCalcResultAction_7", (String)"macc-sca-algox", (Object[])new Object[0]), msgHander);
        DataSetX matKeycolCompDsX = calcResultKeycolCompDsX.groupBy(new String[]{"costobject", "relacostobject", "subelement", "material", "mversion", "auxpty", "keycolid"}).reduceGroup((GroupReduceFunction)new DiffCalcResultKeycolDealFunction());
        resultDsX = resultDsX.addFields(new Field[]{new Field("type", (DataType)DataType.StringType)}, new Object[]{"1"});
        resultDsX = DataSetXHelper.unionIfRowDiffStrDefaultEmpty(resultDsX, calcResultSumDsX);
        resultDsX = resultDsX.leftJoin(materialBUnitDsX).on("material", "id").select(resultDsX.getRowMeta().getFieldNames(), new String[]{"baseunit"});
        resultDsX = resultDsX.addFields(new Field[]{new Field("batchgroupId", (DataType)DataType.IntegerType)}, new Object[]{0});
        int batchSize = costobjectRangeIds.size() / 50;
        if (batchSize < 16) {
            batchSize = 16;
        }
        resultDsX = resultDsX.groupBy(new String[]{"costobject"}).reduceGroup((GroupReduceFunction)new DiffCalcResultCalcFunction(batchSize));
        resultDsX = this.logDataSetX(resultDsX, ResManager.loadKDString((String)"\u8ba1\u7b97\u5b9e\u9645\u6210\u672c\u548c\u7efc\u5408\u884c\u5dee\u5f02\u6570\u636e:", (String)"DiffCalcResultAction_8", (String)"macc-sca-algox", (Object[])new Object[0]), msgHander);
        resultDsX = resultDsX.leftJoin(matKeycolCompDsX).on("costobject", "costobject").on("relacostobject", "relacostobject").on("subelement", "subelement").on("material", "material").on("mversion", "mversion").on("auxpty", "auxpty").on("keycolid", "keycolid").select(resultDsX.getRowMeta().getFieldNames(), new String[]{"keycolStr"});
        resultDsX = resultDsX.groupBy(new String[]{"batchgroupId"}).reduceGroup((GroupReduceFunction)new DiffCalcResultSaveFunction(this.getContext().getCostobjectDiffCalcResultIdMap(), args.getPeriodId(), args.getOrgId(), this.getContext().getBatchExecuteSize(), args.getAmtPrecision()));
        resultDsX.output((Output)new IgnoreOutput());
        try {
            session.commit(2, TimeUnit.HOURS);
            logger.info("\u5dee\u5f02\u5206\u644a-\u8ba1\u7b97\u7ed3\u679c\u751f\u6210-\u7b2c{}\u5c42algox\u5904\u7406\u8017\u65f6\uff1a{}", (Object)batchIndex, (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            logger.error("\u5dee\u5f02\u5206\u644a-\u751f\u6210\u8ba1\u7b97\u7ed3\u679c\u5355\u51fa\u9519\uff1a", (Throwable)e);
            throw e;
        }
    }
}

