/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore.action;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.algox.restore.DiffCalcTaskType;
import kd.macc.sca.algox.restore.action.AbstractDiffCalcAction;
import kd.macc.sca.algox.restore.common.DiffCalcDataArgs;
import kd.macc.sca.algox.utils.CurrencyHelper;
import kd.macc.sca.algox.utils.PeriodHelper;
import kd.macc.sca.algox.utils.ScaDebugHelper;
import org.apache.commons.lang3.StringUtils;

public class DiffInitializeAction
extends AbstractDiffCalcAction {
    private static final int DEFAULT_BATCH_SIZE = 2000;
    private static final int BATCH_BATCH_MIN_SIZE = 5;
    private static final String DBPARAM_SCA_DIFF_BATCHSIZE = "scaDiffBatchSize";
    private static final String DBPARAM_SCA_DIFF_DIFFALLOCBATCHSIZE = "scaDiffAllocBSize";
    private static final String DBPARAM_SCA_DIFF_DIFFCHECKNOAUD = "scaDiffCheckNoAud";
    private static final String DBPARAM_SCA_DIFF_DIFFCHECK = "scaDiffDataCheck";
    private static final int DEFAULT_CB_BATCH_SIZE = 10000;
    private static final String DBPARAM_SCA_DIFF_COSTOBJSIZE = "sca_diffcostobjsize";
    private DiffCalcDataArgs args;
    private DynamicObject costAcctObj;

    @Override
    protected void doExecute() {
        this.args = this.getContext().getInputArgs();
        if (this.args.getCostaccountId() == null || Long.compare(0L, this.args.getCostaccountId()) == 0) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u6267\u884c\u6210\u672c\u8ba1\u7b97\u65f6\uff0c\u8bf7\u4f20\u5165\u6210\u672c\u8d26\u7c3f\u53c2\u6570\u503c\u3002", (String)"DiffInitializeAction_0", (String)"macc-sca-algox", (Object[])new Object[0]));
        }
        ArrayList<String> selectFields = new ArrayList<String>(4);
        selectFields.add("calorg");
        selectFields.add("costtype");
        selectFields.add("calpolicy");
        MainEntityType subCostAcctType = (MainEntityType)EntityMetadataCache.getSubDataEntityType((String)"cal_bd_costaccount", selectFields);
        this.costAcctObj = BusinessDataServiceHelper.loadSingleFromCache((Object)this.args.getCostaccountId(), (DynamicObjectType)subCostAcctType);
        this.checkAndInitOrg();
        this.checkAndInitPeriod();
        this.checkAndInitCurrency();
        this.initCheckWay();
        this.initEnableFactory();
        if (this.getContext().getTaskType() == DiffCalcTaskType.DiffCalc) {
            this.initDefaultElementInfo();
            this.initEnableFactory();
            this.initDebugInfo();
            this.initBatchSize();
        }
    }

    private void initBatchSize() {
        int batchSize = CadBgParamUtils.getCadParamForInt((String)DBPARAM_SCA_DIFF_BATCHSIZE, (int)2000);
        int diffAllocSize = CadBgParamUtils.getCadParamForInt((String)DBPARAM_SCA_DIFF_DIFFALLOCBATCHSIZE, (int)10000);
        int diffCalcResultSize = CadBgParamUtils.getCadParamForInt((String)DBPARAM_SCA_DIFF_COSTOBJSIZE, (int)10000);
        String checkNotAudit = CadBgParamUtils.getCadBgParamForString((String)DBPARAM_SCA_DIFF_DIFFCHECKNOAUD, (String)"true");
        String diffCheck = CadBgParamUtils.getCadBgParamForString((String)DBPARAM_SCA_DIFF_DIFFCHECK, (String)"false");
        int diffAllocMatSize = CadBgParamUtils.getCadParamForInt((String)"diffAllocMatQuSize", (int)300);
        String diffcostadjbatch = CadBgParamUtils.getCadBgParamForString((String)"diffCostadjBatch", (String)"false");
        this.getContext().setDiffAllocSaveCadjId("1".equals(CadBgParamUtils.getScmParamForString((String)"diffAllocSaveCadjId", (String)"0")));
        this.getContext().setDiffAllocDealUAlloc("1".equals(CadBgParamUtils.getScmParamForString((String)"diffAllocDealUAlloc", (String)"0")));
        this.getContext().setDiffAllocMatQuSize(diffAllocMatSize);
        if ("false".equals(checkNotAudit)) {
            this.getContext().setDiffCheckNotAudit(true);
        }
        if ("true".equals(diffcostadjbatch)) {
            this.getContext().setDiffCostadjBatch(true);
        }
        if (batchSize < 5) {
            batchSize = 5;
        }
        this.getContext().setBatchExecuteSize(batchSize);
        if (diffAllocSize < 5) {
            diffAllocSize = 5;
        }
        this.getContext().setDiffallocBatchSize(diffAllocSize);
        if (diffCalcResultSize < 5) {
            diffCalcResultSize = 5;
        }
        if ("true".equals(diffCheck)) {
            this.getContext().setDiffCheck(true);
        }
        this.getContext().setDiffCalcResultBatchSize(diffCalcResultSize);
    }

    private void initEnableFactory() {
        this.args.setEnableFactory(CostAccountHelper.isEnableMulFactory((Long)this.args.getCostaccountId()));
        HashMap manuorgToCosttypeMap = Maps.newHashMapWithExpectedSize((int)10);
        if (this.args.isEnableFactory()) {
            List manuOrgs = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"04", (Long)this.args.getOrgId(), (boolean)true);
            for (Long manuOrg : manuOrgs) {
                Long costtypeId = CostTypeHelper.getCostTypeIdByManuOrgIdFromCal((Long)this.args.getCostaccountId(), (Long)this.args.getOrgId(), (Long)manuOrg);
                if (CadEmptyUtils.isEmpty((Long)costtypeId)) continue;
                manuorgToCosttypeMap.put(manuOrg, costtypeId);
            }
        } else {
            Long costtypeId = CostTypeHelper.getCostTypeIdByManuOrgIdFromCal((Long)this.args.getCostaccountId(), (Long)this.args.getOrgId(), (Long)0L);
            if (!CadEmptyUtils.isEmpty((Long)costtypeId)) {
                manuorgToCosttypeMap.put(0L, costtypeId);
            }
        }
        this.args.setManuorgToCosttypeMap(manuorgToCosttypeMap);
    }

    private void initDefaultElementInfo() {
        QFilter eleFilter = new QFilter("type", "=", (Object)"001");
        eleFilter.and("defaultvalue", "=", (Object)Boolean.TRUE);
        DynamicObject[] dyo = BusinessDataServiceHelper.load((String)"cad_subelement", (String)"id", (QFilter[])eleFilter.toArray());
        if (dyo.length > 0) {
            this.args.setDefSubElementId(dyo[0].getLong("id"));
            eleFilter = new QFilter("subelement.id", "=", (Object)this.args.getDefSubElementId());
            dyo = BusinessDataServiceHelper.load((String)"cad_elementdetail", (String)"element.id", (QFilter[])eleFilter.toArray());
            if (dyo.length > 0) {
                this.args.setDefElementId(dyo[0].getLong("element.id"));
            }
        }
    }

    private void initDebugInfo() {
        String[] ss;
        String debugString;
        if (this.getContext().getTaskType() == DiffCalcTaskType.DiffCalc && StringUtils.isNotEmpty((CharSequence)(debugString = ScaDebugHelper.getDebugKeyword("sca_differencecalcwizards"))) && (ss = debugString.split("=")).length > 1) {
            this.args.setDebugColName(ss[0]);
            this.args.setDebugColValue(ss[1]);
        }
    }

    private void checkAndInitOrg() {
        Long calOrgId = this.costAcctObj == null ? 0L : this.costAcctObj.getLong("calorg.id");
        if (CadEmptyUtils.isEmpty((Long)calOrgId)) {
            if (this.args.getOrgId() == null || Long.compare(0L, this.args.getOrgId()) == 0) {
                throw new IllegalArgumentException(ResManager.loadKDString((String)"\u6267\u884c\u6210\u672c\u8ba1\u7b97\u65f6\uff0c\u8bf7\u4f20\u5165\u6838\u7b97\u7ec4\u7ec7\u53c2\u6570\u503c\u3002", (String)"DiffInitializeAction_1", (String)"macc-sca-algox", (Object[])new Object[0]));
            }
            return;
        }
        if (CadEmptyUtils.isEmpty((Long)this.args.getOrgId())) {
            this.args.setOrgId(calOrgId);
        } else if (Long.compare(this.args.getOrgId(), calOrgId) != 0) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u6210\u672c\u8ba1\u7b97\u65f6\uff0c\u4f20\u5165\u7684\u6838\u7b97\u7ec4\u7ec7\u53c2\u6570\u503c%1$s\uff0c\u548c\u8d26\u7c3f\u7684\u6838\u7b97\u7ec4\u7ec7%2$s\u4e0d\u4e00\u81f4\u3002", (String)"DiffInitializeAction_2", (String)"macc-sca-algox", (Object[])new Object[0]), this.args.getOrgId(), calOrgId));
        }
    }

    private void checkAndInitPeriod() {
        QFilter qfOrg = new QFilter("org", "=", (Object)this.args.getOrgId());
        QFilter qfCostAccount = new QFilter("entry.costaccount", "=", (Object)this.args.getCostaccountId());
        DynamicObject sysCtrlEntity = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"id,entry.currentperiod currentperiod", (QFilter[])new QFilter[]{qfOrg, qfCostAccount});
        long currentPeriod = 0L;
        if (sysCtrlEntity != null) {
            currentPeriod = sysCtrlEntity.getLong("currentperiod");
        }
        if (CadEmptyUtils.isEmpty((Long)this.args.getPeriodId())) {
            this.args.setPeriodId(currentPeriod);
        } else if (currentPeriod != this.args.getPeriodId()) {
            this.args.setPeriodId(currentPeriod);
            this.args.setStartDate(null);
        }
        if (this.args.getStartDate() == null) {
            DynamicObject period = PeriodHelper.getPeriod(this.args.getPeriodId());
            this.args.setStartDate(period.getDate("begindate"));
            this.args.setEndDate(period.getDate("enddate"));
        }
        this.args.setPrePeriodId(PeriodHelper.getPrePeriodId(this.args.getPeriodId()));
    }

    private void checkAndInitCurrency() {
        if (CadEmptyUtils.isEmpty((Long)this.args.getCurrencyId())) {
            Long calpolicy = this.costAcctObj.getLong("calpolicy.id");
            if (calpolicy == null || Long.compare(0L, calpolicy) == 0) {
                return;
            }
            DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calpolicy)});
            this.args.setCurrencyId(result.getLong("currency"));
        }
        if (this.args.getCurrencyId() != null) {
            DynamicObject dyo = CurrencyHelper.getCurrency(this.args.getCurrencyId());
            this.args.setAmtPrecision(dyo.getInt("amtprecision"));
            this.args.setPricePrecision(dyo.getInt("priceprecision"));
        }
    }

    private void initCheckWay() {
        if (this.getContext().getTaskType() == DiffCalcTaskType.DiffCalcCheck) {
            this.args.setCheckWay(0);
        } else {
            this.args.setCheckWay(1);
        }
    }
}

