/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore.check;

import com.google.common.collect.Sets;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class ColleAuditCheck
extends AbstractSingleCalcCheckAction {
    public void doCheck() {
        CalcCheckContext context = this.getContext();
        QFilter qfOrg = new QFilter("calorg", "=", (Object)context.getOrgId());
        QFilter qfCostAccount = new QFilter("costaccount", "=", (Object)context.getCostAccountId());
        QFilter qfStartDate = new QFilter("bookdate", ">=", (Object)context.getPeriodStartDate());
        QFilter qfEndDate = new QFilter("bookdate", "<=", (Object)context.getPeriodEndDate());
        QFilter qfBillStatus = new QFilter("billstatus", "!=", (Object)"C");
        QFilter qfCreateType = new QFilter("createtype", "not in", (Object)Sets.newHashSet((Object[])new String[]{"W", "Y", "Z"}));
        qfCreateType.or(new QFilter("ischargeoff", "=", (Object)true));
        qfCreateType.or(new QFilter("ischargeoffed", "=", (Object)true));
        DataSet data = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("doCheck"), (String)"cal_stdcostdiffbill", (String)"billno,0L as costcenter", (QFilter[])new QFilter[]{qfOrg, qfCostAccount, qfStartDate, qfEndDate, qfBillStatus, qfCreateType}, (String)"billno");
        String checkDesc = ResManager.loadKDString((String)"%s\u5f20\u5355\u636e\u6ca1\u6709\u5ba1\u6838\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ColleAuditCheck_0", (String)"macc-sca-algox", (Object[])new Object[0]);
        String detailDesc = ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u6ca1\u6709\u5ba1\u6838\u3002", (String)"ColleAuditCheck_1", (String)"macc-sca-algox", (Object[])new Object[0]);
        while (data.hasNext()) {
            Row row = data.next();
            String billno = row.getString("billno");
            CalcCheckDetailResultInfo info = new CalcCheckDetailResultInfo();
            info.setCostCenter(row.getLong("costcenter"));
            info.setCheckDetailResult(String.format(detailDesc, billno));
            this.getSingleCheckContext().getCheckDetailResult().add(info);
        }
        if (CadEmptyUtils.isEmpty((List)this.getSingleCheckContext().getCheckDetailResult())) {
            return;
        }
        this.getSingleCheckContext().setCheckResult(String.format(checkDesc, this.getSingleCheckContext().getCheckDetailResult().size()));
        this.getSingleCheckContext().setPass(false);
    }
}

