/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JoinDataSetX;
import kd.bos.algox.RowX;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.dto.MaterialCodeDto;
import kd.macc.sca.algox.restore.CalServiceHelper;
import kd.macc.sca.algox.restore.common.DiffCalcDataArgs;
import kd.macc.sca.algox.utils.CommonUtils;
import kd.macc.sca.algox.utils.ScaCalcHelper;
import kd.macc.sca.common.costcalc.CalcResultObjectInfo;
import org.apache.commons.lang3.StringUtils;

public class DiffCalcHelper {
    private static final String INSERT_CHECKDETAIL_ENTRY_SQL = "INSERT INTO t_sca_ckreportdetailentry (FId,FEntryId,fcostcenterid,fcheckdetail) VALUES (?,?,?,?)";
    private static final Log logger = LogFactory.getLog(DiffCalcHelper.class);
    public static final String PRE_START = "start";
    public static final String PRE_CUR = "curr";
    public static final String PRE_END = "end";
    public static final String PRE_COM = "comp";
    public static final String PRE_TOTAL = "total";
    public static final String[] DIFF_FIELD_ARR = new String[]{"diffqty", "madediff", "madeupamt", "unjoindiffamt", "stdcostupamt", "orddiff", "invoicediff", "feediff", "otherdiff", "falldiff", "reservediffx", "reservediffw", "reservediffy"};
    public static final String[] STD_FIELD_ARR = new String[]{"qty", "amt", "actcostupamt"};
    public static final String[] STD_AMT_FIELD_ARR = new String[]{"qty", "stdcost", "amt", "actcostupamt"};
    public static final String DIM_MATERIAL = "material";
    public static final String DIM_AUXPTY = "auxpty";
    public static final String DIM_CONFIGUREDCODE = "configuredcode";
    public static final String DIM_TRACKNUMBER = "tracknumber";
    public static final String DIM_PROJECT = "project";
    public static final String DIM_LOT = "lot";
    public static final String[] COSTOBJECT_DIM_FIELD = new String[]{"material", "auxpty", "configuredcode", "tracknumber", "projectnumber", "lot"};
    public static final RowMeta DIM_ROWMETA = new RowMeta(new Field[]{new Field("material", (DataType)DataType.LongType), new Field("auxpty", (DataType)DataType.LongType), new Field("configuredcode", (DataType)DataType.LongType), new Field("tracknumber", (DataType)DataType.LongType), new Field("project", (DataType)DataType.LongType), new Field("lot", (DataType)DataType.StringType)});

    public static void insertCalcErrorInfo(Long taskConfigDetailId, Long costcenter, String errorInfo) {
        if (errorInfo == null) {
            errorInfo = "";
        }
        if (errorInfo.length() > 255) {
            errorInfo = errorInfo.substring(0, 254);
        }
        ArrayList<Object[]> entrys = new ArrayList<Object[]>();
        Object[] entry = new Object[]{taskConfigDetailId, ID.genLongId(), costcenter, errorInfo};
        entrys.add(entry);
        DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)INSERT_CHECKDETAIL_ENTRY_SQL, entrys);
    }

    public static boolean isCostobjectDebug(DiffCalcDataArgs args, Long costobjectId) {
        return "costobject".equals(args.getDebugColName()) && StringUtils.equals((CharSequence)args.getDebugColValue(), (CharSequence)String.valueOf(costobjectId));
    }

    public static String getRowDimString(Row row, Set<String> diffMatLvlDim, String keyPre) {
        StringBuilder key = new StringBuilder();
        for (int i = 0; i < CalServiceHelper.DIFFMATERIAL_COLS.length; ++i) {
            String dim = CalServiceHelper.DIFFMATERIAL_COLS[i];
            if (diffMatLvlDim.contains(dim)) {
                Object val;
                if (DIM_LOT.equals(dim)) {
                    val = row.getString(keyPre + dim) == null ? "" : row.getString(keyPre + dim);
                    key.append((String)val);
                } else {
                    val = row.getLong(keyPre + dim) == null ? Long.valueOf(0L) : row.getLong(keyPre + dim);
                    key.append(val);
                }
            } else if (DIM_LOT.equals(dim)) {
                key.append("");
            } else {
                key.append("0");
            }
            if (i == CalServiceHelper.DIFFMATERIAL_COLS.length - 1) continue;
            key.append("@");
        }
        return key.toString();
    }

    public static String getRowDimString(Row row) {
        StringBuilder key = new StringBuilder();
        for (int i = 0; i < CalServiceHelper.DIFFMATERIAL_COLS.length; ++i) {
            Object val;
            String dim = CalServiceHelper.DIFFMATERIAL_COLS[i];
            if (DIM_LOT.equals(dim)) {
                val = row.getString(dim) == null ? "" : row.getString(dim);
                key.append((String)val);
            } else {
                val = row.getLong(dim) == null ? Long.valueOf(0L) : row.getLong(dim);
                key.append(val);
            }
            if (i == CalServiceHelper.DIFFMATERIAL_COLS.length - 1) continue;
            key.append("@");
        }
        return key.toString();
    }

    public static MaterialCodeDto getDiffMaterialDtoFromString(String materialData) {
        MaterialCodeDto dto = new MaterialCodeDto();
        String[] keyArr = materialData.split("@");
        dto.setMaterial(Long.parseLong(keyArr[0]));
        dto.setMatversion(Long.parseLong(keyArr[1]));
        dto.setAuxpty(Long.parseLong(keyArr[2]));
        dto.setConfiguredcode(Long.parseLong(keyArr[3]));
        dto.setTracknumber(Long.parseLong(keyArr[4]));
        dto.setProject(Long.parseLong(keyArr[5]));
        if (keyArr.length >= 7) {
            dto.setLot(keyArr[6]);
        }
        return dto;
    }

    public static Set<Long> getDimMatIdMapFromLvl(Collection<MaterialCodeDto> matCodes) {
        HashSet<Long> materialIds = new HashSet<Long>(16);
        for (MaterialCodeDto mat : matCodes) {
            materialIds.add(mat.getMaterial());
        }
        return materialIds;
    }

    public static DataSet getDimMatDsFromLvl(Collection<MaterialCodeDto> matCodes) {
        ArrayList<Object[]> array = new ArrayList<Object[]>(10);
        for (MaterialCodeDto mat : matCodes) {
            array.add(new Object[]{mat.getMaterial(), mat.getAuxpty(), mat.getConfiguredcode(), mat.getTracknumber(), mat.getProject(), mat.getLot()});
        }
        return Algo.create((String)"dataset").createDataSet(array.iterator(), DIM_ROWMETA);
    }

    public static DataSet getDimMatAndDealAuxptyDsFromLvl(Collection<MaterialCodeDto> matCodes, Map<Long, Set<Long>> matAuxptysMap) {
        ArrayList<Object[]> array = new ArrayList<Object[]>(10);
        for (MaterialCodeDto mat : matCodes) {
            if (matAuxptysMap.containsKey(mat.getMaterial())) {
                for (Long auxptyId : matAuxptysMap.get(mat.getMaterial())) {
                    array.add(new Object[]{mat.getMaterial(), auxptyId, mat.getConfiguredcode(), mat.getTracknumber(), mat.getProject(), mat.getLot()});
                }
                continue;
            }
            array.add(new Object[]{mat.getMaterial(), mat.getAuxpty(), mat.getConfiguredcode(), mat.getTracknumber(), mat.getProject(), mat.getLot()});
        }
        return Algo.create((String)"dataset").createDataSet(array.iterator(), DIM_ROWMETA);
    }

    public static DataSet joinDimMatDsToFilterDs(DataSet srcDs, DataSet dimDs, Set<String> diffMatLvlDim) {
        JoinDataSet joinDs = srcDs.join(dimDs);
        for (String dim : diffMatLvlDim) {
            joinDs.on(dim, dim);
        }
        HashSet<String> srcFieldNames = new HashSet<String>(Arrays.asList(srcDs.getRowMeta().getFieldNames()));
        srcFieldNames.removeAll(Arrays.asList(CalServiceHelper.DIFFMATERIAL_DIM_COLS));
        return joinDs.select(srcFieldNames.toArray(new String[0]), dimDs.getRowMeta().getFieldNames()).finish();
    }

    public static DataSetX joinDimMatDsXToFilterDs(DataSetX srcDs, DataSetX dimDs, Set<String> diffMatLvlDim) {
        return DiffCalcHelper.joinDimMatDsXToFilterDs(srcDs, dimDs, diffMatLvlDim, null);
    }

    public static DataSetX joinDimMatDsXToFilterDs(DataSetX srcDs, DataSetX dimDs, Set<String> diffMatLvlDim, String[] selectFields) {
        JoinDataSetX joinDs = srcDs.join(dimDs);
        for (String dim : diffMatLvlDim) {
            joinDs.on(dim, dim);
        }
        HashSet<String> srcFieldNames = new HashSet<String>(Arrays.asList(srcDs.getRowMeta().getFieldNames()));
        srcFieldNames.removeAll(Arrays.asList(CalServiceHelper.DIFFMATERIAL_DIM_COLS));
        if (selectFields == null) {
            return joinDs.select(srcFieldNames.toArray(new String[0]), dimDs.getRowMeta().getFieldNames());
        }
        return joinDs.select(selectFields);
    }

    public static Map<String, Set<Object>> getDimMatMapFromLvl(Collection<MaterialCodeDto> matCodes, Set<String> diffMatLvlDim) {
        HashMap dimMatMap = Maps.newHashMapWithExpectedSize((int)128);
        for (MaterialCodeDto mat : matCodes) {
            if (diffMatLvlDim.contains(DIM_MATERIAL)) {
                dimMatMap.computeIfAbsent(DIM_MATERIAL, t -> new HashSet(16)).add(mat.getMaterial());
            }
            if (diffMatLvlDim.contains(DIM_AUXPTY)) {
                dimMatMap.computeIfAbsent(DIM_AUXPTY, t -> new HashSet(16)).add(mat.getAuxpty());
            }
            if (diffMatLvlDim.contains(DIM_CONFIGUREDCODE)) {
                dimMatMap.computeIfAbsent(DIM_CONFIGUREDCODE, t -> new HashSet(16)).add(mat.getConfiguredcode());
            }
            if (diffMatLvlDim.contains(DIM_TRACKNUMBER)) {
                dimMatMap.computeIfAbsent(DIM_TRACKNUMBER, t -> new HashSet(16)).add(mat.getTracknumber());
            }
            if (diffMatLvlDim.contains(DIM_PROJECT)) {
                dimMatMap.computeIfAbsent(DIM_PROJECT, t -> new HashSet(16)).add(mat.getProject());
            }
            if (!diffMatLvlDim.contains(DIM_LOT)) continue;
            dimMatMap.computeIfAbsent(DIM_LOT, t -> new HashSet(16)).add(mat.getLot());
        }
        return dimMatMap;
    }

    public static List<Map<String, Object>> getDimMapParamFromLvl(Collection<MaterialCodeDto> matCodes, Set<String> diffMatLvlDim, Map<Long, Set<Long>> matAuxptysMap) {
        ArrayList<Map<String, Object>> matParamList = new ArrayList<Map<String, Object>>(matCodes.size());
        for (MaterialCodeDto mat : matCodes) {
            if (diffMatLvlDim.contains(DIM_AUXPTY) && matAuxptysMap.containsKey(mat.getMaterial())) {
                for (Long auxptyId : matAuxptysMap.get(mat.getMaterial())) {
                    HashMap matParamMap = Maps.newHashMapWithExpectedSize((int)2);
                    if (diffMatLvlDim.contains(DIM_MATERIAL)) {
                        matParamMap.put(DIM_MATERIAL, mat.getMaterial());
                    }
                    if (diffMatLvlDim.contains(DIM_AUXPTY)) {
                        matParamMap.put("assist", auxptyId);
                    }
                    if (diffMatLvlDim.contains(DIM_CONFIGUREDCODE)) {
                        matParamMap.put(DIM_CONFIGUREDCODE, mat.getConfiguredcode());
                    }
                    if (diffMatLvlDim.contains(DIM_TRACKNUMBER)) {
                        matParamMap.put(DIM_TRACKNUMBER, mat.getTracknumber());
                    }
                    if (diffMatLvlDim.contains(DIM_PROJECT)) {
                        matParamMap.put(DIM_PROJECT, mat.getProject());
                    }
                    if (diffMatLvlDim.contains(DIM_LOT)) {
                        matParamMap.put(DIM_LOT, mat.getLot());
                    }
                    matParamList.add(matParamMap);
                }
                continue;
            }
            HashMap matParamMap = Maps.newHashMapWithExpectedSize((int)2);
            if (diffMatLvlDim.contains(DIM_MATERIAL)) {
                matParamMap.put(DIM_MATERIAL, mat.getMaterial());
            }
            if (diffMatLvlDim.contains(DIM_AUXPTY)) {
                matParamMap.put("assist", mat.getAuxpty());
            }
            if (diffMatLvlDim.contains(DIM_CONFIGUREDCODE)) {
                matParamMap.put(DIM_CONFIGUREDCODE, mat.getConfiguredcode());
            }
            if (diffMatLvlDim.contains(DIM_TRACKNUMBER)) {
                matParamMap.put(DIM_TRACKNUMBER, mat.getTracknumber());
            }
            if (diffMatLvlDim.contains(DIM_PROJECT)) {
                matParamMap.put(DIM_PROJECT, mat.getProject());
            }
            if (diffMatLvlDim.contains(DIM_LOT)) {
                matParamMap.put(DIM_LOT, mat.getLot());
            }
            matParamList.add(matParamMap);
        }
        return matParamList;
    }

    public static Set<String> getDimStrFromLvl(Collection<MaterialCodeDto> matCodes, Set<String> diffMatLvlDim) {
        HashSet<String> matParamList = new HashSet<String>(matCodes.size());
        for (MaterialCodeDto mat : matCodes) {
            matParamList.add(DiffCalcHelper.getDimStrFromLvl(mat, diffMatLvlDim));
        }
        return matParamList;
    }

    public static String getDimStrFromRow(RowX row, RowMeta sourceMeta, Set<String> diffMatLvlDim, String prefx) {
        StringBuilder sb = new StringBuilder();
        int i = diffMatLvlDim.size();
        for (String dim : diffMatLvlDim) {
            Object val = null;
            if (DIM_LOT.equals(dim)) {
                val = row.getString(sourceMeta.getFieldIndex(prefx + dim));
                if (val == null) {
                    val = "";
                }
            } else {
                val = row.getLong(sourceMeta.getFieldIndex(prefx + dim));
                if (val == null) {
                    val = 0L;
                }
            }
            sb.append(val);
            if (--i == 0) continue;
            sb.append("@");
        }
        return sb.toString();
    }

    public static Map<String, Object> getDimParamFromRowForCal(Row row, Set<String> diffMatLvlDim, String prefx) {
        HashMap result = Maps.newHashMap();
        for (String dim : diffMatLvlDim) {
            Object val = null;
            if (DIM_LOT.equals(dim)) {
                val = row.getString(prefx + dim);
                if (val == null) {
                    val = "";
                }
            } else {
                val = row.getLong(prefx + dim);
                if (val == null) {
                    val = 0L;
                }
            }
            if (dim.equals(DIM_AUXPTY)) {
                result.put("assit", val);
                continue;
            }
            result.put(dim, val);
        }
        return result;
    }

    public static String getDimStrFromRow(Row row, Set<String> diffMatLvlDim, String prefx) {
        StringBuilder sb = new StringBuilder();
        int i = diffMatLvlDim.size();
        for (String dim : diffMatLvlDim) {
            Object val = null;
            if (DIM_LOT.equals(dim)) {
                val = row.getString(prefx + dim);
                if (val == null) {
                    val = "";
                }
            } else {
                val = row.getLong(prefx + dim);
                if (val == null) {
                    val = 0L;
                }
            }
            sb.append(val);
            if (--i == 0) continue;
            sb.append("@");
        }
        return sb.toString();
    }

    public static String getDimStrFromLvl(MaterialCodeDto mat, Set<String> diffMatLvlDim) {
        StringBuilder sb = new StringBuilder();
        int i = diffMatLvlDim.size();
        for (String dim : diffMatLvlDim) {
            Object val = null;
            if (DIM_MATERIAL.equals(dim)) {
                val = mat.getMaterial();
            } else if (DIM_AUXPTY.equals(dim)) {
                val = mat.getAuxpty();
            } else if (DIM_CONFIGUREDCODE.equals(dim)) {
                val = mat.getConfiguredcode();
            } else if (DIM_TRACKNUMBER.equals(dim)) {
                val = mat.getTracknumber();
            } else if (DIM_PROJECT.equals(dim)) {
                val = mat.getProject();
            } else if (DIM_LOT.equals(dim)) {
                val = mat.getLot();
            }
            sb.append(val);
            if (--i == 0) continue;
            sb.append("@");
        }
        return sb.toString();
    }

    public static Map<String, String> getDynDimFieldMappingMap(String dynNum) {
        HashMap dynDimFieldMappingMap = Maps.newHashMapWithExpectedSize((int)10);
        if ("costobject".equals(dynNum)) {
            for (int i = 0; i < CalServiceHelper.DIFFMATERIAL_DIM_COLS.length; ++i) {
                dynDimFieldMappingMap.put(CalServiceHelper.DIFFMATERIAL_DIM_COLS[i], COSTOBJECT_DIM_FIELD[i]);
            }
        } else {
            for (int i = 0; i < CalServiceHelper.DIFFMATERIAL_DIM_COLS.length; ++i) {
                dynDimFieldMappingMap.put(CalServiceHelper.DIFFMATERIAL_DIM_COLS[i], CalServiceHelper.DIFFMATERIAL_DIM_COLS[i]);
            }
        }
        return dynDimFieldMappingMap;
    }

    public static Map<Long, String> getAuxValueNameMap(Set auxptyIds) {
        HashMap<Long, String> auxValueNameMap = new HashMap<Long, String>(16);
        DynamicObjectCollection auxPropObj = QueryServiceHelper.query((String)"bd_flexauxprop", (String)"id,value", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)auxptyIds)});
        HashSet auxptyTypes = new HashSet(16);
        HashSet<Long> auxptyValue = new HashSet<Long>(16);
        HashMap<Long, String> auxptyMap = new HashMap<Long, String>(16);
        for (DynamicObject aux : auxPropObj) {
            if (StringUtils.isEmpty((CharSequence)aux.getString("value"))) continue;
            JSONObject value = (JSONObject)JSON.parse((String)aux.getString("value"));
            for (Map.Entry val : value.entrySet()) {
                auxptyTypes.add(val.getKey());
                try {
                    auxptyValue.add(Long.parseLong(val.getValue().toString()));
                }
                catch (Exception exception) {
                    logger.error("getAuxValueNameMap error -> {}", (Object)exception.getMessage());
                }
                auxptyMap.put(aux.getLong("id"), aux.getString("value"));
            }
        }
        DynamicObjectCollection auxProptys = QueryServiceHelper.query((String)"bd_auxproperty", (String)"flexfield,name,valuesource", (QFilter[])new QFilter[]{new QFilter("flexfield", "in", auxptyTypes)});
        HashMap<String, String> typeNameMap = new HashMap<String, String>(16);
        HashSet<String> valuesourceSet = new HashSet<String>(16);
        for (DynamicObject aux : auxProptys) {
            typeNameMap.put(aux.getString("flexfield"), aux.getString("name"));
            String string = aux.getString("valuesource");
            if (StringUtils.isBlank((CharSequence)string)) continue;
            valuesourceSet.add(string);
        }
        HashMap<Long, String> auxpValueMap = new HashMap<Long, String>(16);
        for (String string : valuesourceSet) {
            DynamicObjectCollection auxProptyValues = QueryServiceHelper.query((String)string, (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", auxptyValue)});
            for (DynamicObject aux : auxProptyValues) {
                auxpValueMap.put(aux.getLong("id"), aux.getString("name"));
            }
        }
        for (Map.Entry entry : auxptyMap.entrySet()) {
            JSONObject value = (JSONObject)JSON.parse((String)((String)entry.getValue()));
            if (value == null) continue;
            StringBuilder auxStr = new StringBuilder();
            for (Map.Entry val : value.entrySet()) {
                try {
                    auxStr.append((String)typeNameMap.get(val.getKey())).append(':').append((String)auxpValueMap.get(Long.parseLong(val.getValue().toString()))).append(';');
                }
                catch (Exception e) {
                    auxStr.append(val.getValue());
                    auxStr.append(";");
                    logger.error("getAuxValueNameMap error -> {}", (Object)e.getMessage());
                }
            }
            auxValueNameMap.put((Long)entry.getKey(), auxStr.toString());
        }
        return auxValueNameMap;
    }

    public static DataSet clearDiffDimValue(DataSet allocDataSet, Set<String> diffMatLvlDim, boolean isContainsSub) {
        if (diffMatLvlDim.size() < 6) {
            ArrayList<String> fieldNames = new ArrayList<String>(Arrays.asList(allocDataSet.getRowMeta().getFieldNames()));
            for (String dim : CalServiceHelper.DIFFMATERIAL_COLS) {
                if (diffMatLvlDim.contains(dim)) continue;
                fieldNames.remove(dim);
                if (isContainsSub) {
                    fieldNames.remove("sub" + dim);
                }
                if (DIM_LOT.equals(dim)) {
                    fieldNames.add("'' as lot");
                    if (!isContainsSub) continue;
                    fieldNames.add("'' as sublot");
                    continue;
                }
                fieldNames.add("0L as " + dim);
                if (!isContainsSub) continue;
                fieldNames.add("0L as sub" + dim);
            }
            allocDataSet = allocDataSet.select(fieldNames.toArray(new String[0]));
        }
        return allocDataSet;
    }

    public static DataSet clearDiffDimValue(DataSet allocDataSet, Set<String> diffMatLvlDim) {
        return DiffCalcHelper.clearDiffDimValue(allocDataSet, diffMatLvlDim, true);
    }

    public static void isHasCheckDetail(DiffCalcDataArgs inputArgs, long itemId, String curItem) {
        if (DiffCalcHelper.isExistsCheckDetail(itemId)) {
            DiffCalcHelper.createCheckDetailDyn(inputArgs, itemId, curItem);
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u7b97\u8fc7\u7a0b\u4e2d\u5b58\u5728\u4e0d\u901a\u8fc7\u9879\uff0c\u8bf7\u70b9\u51fb\u67e5\u770b\u3002", (String)"DiffCalcHelper_0", (String)"macc-sca-algox", (Object[])new Object[0]));
        }
    }

    public static void createCheckDetailDyn(DiffCalcDataArgs inputArgs, long itemId, String curItem) {
        DynamicObject checkDetail = BusinessDataServiceHelper.newDynamicObject((String)"sca_checkreportdetail");
        checkDetail.set("id", (Object)itemId);
        checkDetail.set("org", (Object)inputArgs.getOrgId());
        checkDetail.set("costaccount", (Object)inputArgs.getCostaccountId());
        checkDetail.set("period", (Object)inputArgs.getPeriodId());
        checkDetail.set("currency", (Object)inputArgs.getCurrencyId());
        checkDetail.set("item", (Object)String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5b58\u5728\u8ba1\u7b97\u4e0d\u901a\u8fc7\u9879\u3002", (String)"DiffCalcHelper_1", (String)"macc-sca-algox", (Object[])new Object[0]), curItem));
        checkDetail.set("calcdate", (Object)TimeServiceHelper.now());
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"sca_checkreportdetail");
        SaveServiceHelper.save((IDataEntityType)mainEntityType, (Object[])new DynamicObject[]{checkDetail});
    }

    public static boolean isExistsCheckDetail(long taskDetailId) {
        int size = 0;
        try (TXHandle handle = TX.requiresNew();){
            String strSql = "SELECT count(1) value FROM t_sca_ckreportdetailentry WHERE FId = " + taskDetailId;
            try (DataSet batSizeData = DB.queryDataSet((String)"TaskRecordGetEntrySize", (DBRoute)CommonUtils.getCalDBRouteKey(), (String)strSql);){
                if (batSizeData.hasNext()) {
                    Row row = batSizeData.next();
                    size = Integer.parseInt(row.get("value").toString());
                }
            }
        }
        return size > 0;
    }

    public static List<MaterialCodeDto> getLvlMaterialList(Set<String> calMatIds, Map<String, MaterialCodeDto> materialCodeMap) {
        ArrayList<MaterialCodeDto> curCalMats = new ArrayList<MaterialCodeDto>(10);
        for (String matkey : calMatIds) {
            MaterialCodeDto mat = materialCodeMap.get(matkey);
            if (mat == null) continue;
            curCalMats.add(mat);
        }
        return curCalMats;
    }

    public static List<MaterialCodeDto> getLvlNestGroupMaterialList(List<List<String>> preNestMatGroups, Map<String, MaterialCodeDto> materialCodeMap) {
        ArrayList<MaterialCodeDto> curCalMats = new ArrayList<MaterialCodeDto>(10);
        for (List<String> group : preNestMatGroups) {
            for (String matkey : group) {
                MaterialCodeDto mat = materialCodeMap.get(matkey);
                if (mat == null) continue;
                curCalMats.add(mat);
            }
        }
        return curCalMats;
    }

    public static List<List<String>> getLvlNestGroupDimList(List<List<String>> preNestMatGroups, Map<String, MaterialCodeDto> materialCodeMap, Set<String> diffMatLvlDim) {
        ArrayList<List<String>> preNestMatDimGroups = new ArrayList<List<String>>(10);
        for (List<String> group : preNestMatGroups) {
            ArrayList<String> dimGroup = new ArrayList<String>(10);
            preNestMatDimGroups.add(dimGroup);
            for (String matkey : group) {
                MaterialCodeDto mat = materialCodeMap.get(matkey);
                if (mat == null) continue;
                dimGroup.add(DiffCalcHelper.getDimStrFromLvl(mat, diffMatLvlDim));
            }
        }
        return preNestMatDimGroups;
    }

    public static List<List<Map<String, Object>>> getLvlNestGroupMapDimList(List<List<String>> preNestMatGroups, Map<String, MaterialCodeDto> materialCodeMap, Set<String> diffMatLvlDim, Map<Long, Set<Long>> matAuxptysMap) {
        ArrayList preNestMatDimGroups = new ArrayList(preNestMatGroups.size());
        for (List<String> group : preNestMatGroups) {
            ArrayList<MaterialCodeDto> arrayList = new ArrayList<MaterialCodeDto>(group.size());
            preNestMatDimGroups.add(arrayList);
            for (String matkey : group) {
                MaterialCodeDto mat = materialCodeMap.get(matkey);
                if (mat == null) continue;
                arrayList.add(mat);
            }
        }
        ArrayList<List<Map<String, Object>>> nestMatGroups = new ArrayList<List<Map<String, Object>>>(preNestMatDimGroups.size());
        for (List list : preNestMatDimGroups) {
            nestMatGroups.add(DiffCalcHelper.getDimMapParamFromLvl(list, diffMatLvlDim, matAuxptysMap));
        }
        return nestMatGroups;
    }

    public static Set<String> getCurrMaterialIds(List<MaterialCodeDto> curCalcMat, List<List<String>> nestMatGroups, List<List<String>> curNestMatGroups) {
        HashSet lvlmats = Sets.newHashSetWithExpectedSize((int)10);
        for (MaterialCodeDto materialCodeDto : curCalcMat) {
            lvlmats.add(materialCodeDto.getMaterialKey());
        }
        for (List list : nestMatGroups) {
            boolean isNeedAdd = false;
            for (String matId : list) {
                if (!lvlmats.contains(matId)) continue;
                isNeedAdd = true;
                break;
            }
            if (!isNeedAdd) continue;
            lvlmats.addAll(list);
            curNestMatGroups.add(list);
        }
        return lvlmats;
    }

    public static int generateCostobjectDiffCalcResult(DiffCalcDataArgs args, Map<Long, Long> costobjectDiffCalcResultIdMap, Set<Long> costobjectIds, Map<Long, Map<Long, CalcResultObjectInfo>> mainJoinSideCostObjectInfoMap) {
        HashSet cbIds = Sets.newHashSetWithExpectedSize((int)10);
        cbIds.addAll(costobjectIds);
        cbIds.removeAll(costobjectDiffCalcResultIdMap.keySet());
        Date curDate = new Date();
        if (cbIds.isEmpty()) {
            return 0;
        }
        if (mainJoinSideCostObjectInfoMap == null) {
            mainJoinSideCostObjectInfoMap = ScaCalcHelper.getMainJoinSideCalcResultInfo(args.getOrgId(), args.getCostaccountId(), args.getPeriodId(), args.getPrePeriodId(), cbIds, args.getStartDate(), args.getEndDate());
        }
        ArrayList<DynamicObject> diffCalcResultDyns = new ArrayList<DynamicObject>(10);
        for (Long costobjectId : cbIds) {
            if (!mainJoinSideCostObjectInfoMap.containsKey(costobjectId) || !mainJoinSideCostObjectInfoMap.get(costobjectId).containsKey(costobjectId)) continue;
            CalcResultObjectInfo resultObjectInfo = mainJoinSideCostObjectInfoMap.get(costobjectId).get(costobjectId);
            Long dynId = ID.genLongId();
            costobjectDiffCalcResultIdMap.put(costobjectId, dynId);
            DynamicObject dyo = BusinessDataServiceHelper.newDynamicObject((String)"sca_diffcalcresult");
            diffCalcResultDyns.add(dyo);
            dyo.set("id", (Object)dynId);
            dyo.set("billno", (Object)ID.genStringId());
            dyo.set("org", (Object)args.getOrgId());
            dyo.set("costobject", (Object)costobjectId);
            dyo.set("currency", (Object)args.getCurrencyId());
            dyo.set("bizdate", (Object)curDate);
            dyo.set("period", (Object)args.getPeriodId());
            dyo.set("costaccount", (Object)args.getCostaccountId());
            dyo.set("costcenter", (Object)resultObjectInfo.getCostCenterId());
            dyo.set("bizstatus", (Object)resultObjectInfo.getBizStatus());
            dyo.set("calcreport", (Object)args.getCalcReportId());
            dyo.set("billstatus", (Object)"C");
            dyo.set("createtime", (Object)curDate);
            dyo.set("creator_id", (Object)RequestContext.get().getCurrUserId());
            dyo.set("entryproduct", (Object)resultObjectInfo.getMaterialId());
            dyo.set("startqtys", (Object)resultObjectInfo.getStartQty());
            dyo.set("currqtys", (Object)resultObjectInfo.getPlanQty());
            dyo.set("compqtys", (Object)resultObjectInfo.getFinishQty());
            dyo.set("endqtys", (Object)resultObjectInfo.getEndQty());
            dyo.set("totalqtys", (Object)resultObjectInfo.getTotalQty().add(resultObjectInfo.getFinishQty()));
        }
        if (!diffCalcResultDyns.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])diffCalcResultDyns.toArray(new DynamicObject[0]));
            return diffCalcResultDyns.size();
        }
        return 0;
    }

    public static String[] fieldsAddPre(String[] fields, String keyPre) {
        String[] keyFields = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            keyFields[i] = keyPre + fields[i];
        }
        return keyFields;
    }

    public static List<String> fieldsAddPreToList(String[] fields, String keyPre) {
        ArrayList<String> list = new ArrayList<String>(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            list.add(keyPre + fields[i]);
        }
        return list;
    }

    public static String[] stringArrUnion(String[] ... arrs) {
        HashSet fields = Sets.newHashSetWithExpectedSize((int)10);
        for (String[] arr : arrs) {
            fields.addAll(Arrays.asList(arr));
        }
        return fields.toArray(new String[0]);
    }

    public static String getDiffTypeField(String difffield, String diffPre) {
        String field = null;
        if (!StringUtils.isEmpty((CharSequence)diffPre)) {
            difffield = difffield.replace(diffPre, "");
        }
        switch (difffield) {
            case "orddiff": {
                field = "ddiff_g";
                break;
            }
            case "invoicediff": {
                field = "ddiff_h";
                break;
            }
            case "feediff": {
                field = "ddiff_k";
                break;
            }
            case "stdcostupamt": {
                field = "ddiff_m";
                break;
            }
            case "diffqty": {
                field = "ddiff_p";
                break;
            }
            case "madediff": {
                field = "ddiff_q";
                break;
            }
            case "unjoindiffamt": {
                field = "ddiff_r";
                break;
            }
            case "madeupamt": {
                field = "ddiff_s";
                break;
            }
            case "otherdiff": {
                field = "ddiff_t";
                break;
            }
            case "falldiff": {
                field = "ddiff_c";
                break;
            }
            case "reservediffx": {
                field = "ddiff_x";
                break;
            }
            case "reservediffw": {
                field = "ddiff_w";
                break;
            }
            case "reservediffy": {
                field = "ddiff_y";
                break;
            }
        }
        return field;
    }

    public static Object getAlgoRowVal(Row sourceRow, RowMeta rowmeta, String fieldName, boolean isSetDefaultVal) {
        int index = rowmeta.getFieldIndex(fieldName, false);
        if (index >= 0) {
            Object val = sourceRow.get(rowmeta.getFieldIndex(fieldName));
            if (val != null) {
                return val;
            }
            if (isSetDefaultVal) {
                DataType dt = rowmeta.getDataType(index);
                if (dt.equals((Object)DataType.BigDecimalType)) {
                    return BigDecimal.ZERO;
                }
                if (dt.equals((Object)DataType.BooleanType)) {
                    return Boolean.FALSE;
                }
                if (dt.equals((Object)DataType.DoubleType)) {
                    return 0.0;
                }
                if (dt.equals((Object)DataType.IntegerType)) {
                    return 0;
                }
                if (dt.equals((Object)DataType.LongType)) {
                    return 0L;
                }
                if (dt.equals((Object)DataType.StringType)) {
                    return " ";
                }
                if (dt.equals((Object)DataType.TimestampType)) {
                    return new Date();
                }
            }
        } else {
            throw new KDBizException("set field error:" + fieldName);
        }
        return null;
    }

    public static Object getAlgoXRowVal(RowX sourceRow, RowMeta rowmeta, String fieldName, boolean isSetDefaultVal) {
        int index = rowmeta.getFieldIndex(fieldName, false);
        if (index >= 0) {
            Object val = sourceRow.get(rowmeta.getFieldIndex(fieldName));
            if (val != null) {
                return val;
            }
            if (isSetDefaultVal) {
                DataType dt = rowmeta.getDataType(index);
                if (dt.equals((Object)DataType.BigDecimalType)) {
                    return BigDecimal.ZERO;
                }
                if (dt.equals((Object)DataType.BooleanType)) {
                    return Boolean.FALSE;
                }
                if (dt.equals((Object)DataType.DoubleType)) {
                    return 0.0;
                }
                if (dt.equals((Object)DataType.IntegerType)) {
                    return 0;
                }
                if (dt.equals((Object)DataType.LongType)) {
                    return 0L;
                }
                if (dt.equals((Object)DataType.StringType)) {
                    return " ";
                }
                if (dt.equals((Object)DataType.TimestampType)) {
                    return new Date();
                }
            }
        } else {
            throw new KDBizException("set field error:" + fieldName);
        }
        return null;
    }
}

