/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore.function;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.SecureRandom;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.macc.sca.algox.restore.common.DiffCalcDataArgs;
import kd.macc.sca.algox.restore.common.DiffCalcHelper;
import kd.macc.sca.algox.utils.BigDecimalUtils;

public class DiffAllocActAmtCalcSumFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private DiffCalcDataArgs args = null;
    private int batchSize = 8;

    public DiffAllocActAmtCalcSumFunction(DiffCalcDataArgs args, int batchSize) {
        this.args = args;
        this.batchSize = batchSize;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        int batchGroupId = new SecureRandom().nextInt(this.batchSize);
        for (RowX row : iterable) {
            this.calcActAmt(row, "start", "actcostupamt", DiffCalcHelper.DIFF_FIELD_ARR, "amt");
            this.calcActAmt(row, "curr", "actcostupamt", DiffCalcHelper.DIFF_FIELD_ARR, "amt");
            this.calcActAmt(row, "comp", "actcostupamt", DiffCalcHelper.DIFF_FIELD_ARR, "amt");
            this.calcActAmt(row, "end", "actcostupamt", DiffCalcHelper.DIFF_FIELD_ARR, "amt");
            this.calcActAmt(row, "total", "actcostupamt", DiffCalcHelper.DIFF_FIELD_ARR, "amt");
            this.calcStdCost(row, "start");
            this.calcStdCost(row, "curr");
            this.calcStdCost(row, "comp");
            this.calcStdCost(row, "end");
            this.calcStdCost(row, "total");
            row.set(this.sourceRowMeta.getFieldIndex("batchgroupId"), (Object)batchGroupId);
            collector.collect(row);
        }
    }

    private BigDecimal getBigDecimalVal(RowX rowx, String field) {
        return BigDecimalUtils.getBigDecimalOrZero(rowx.getBigDecimal(this.sourceRowMeta.getFieldIndex(field)));
    }

    private void calcStdCost(RowX row, String pre) {
        BigDecimal amt = this.getBigDecimalVal(row, pre + "amt");
        BigDecimal qty = this.getBigDecimalVal(row, pre + "qty");
        if (qty.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        row.set(this.sourceRowMeta.getFieldIndex(pre + "stdcost"), (Object)amt.divide(qty, this.args.getPricePrecision(), RoundingMode.HALF_UP));
    }

    private void calcActAmt(RowX row, String pre, String targetfield, String[] diffFieldArr, String stAmtField) {
        BigDecimal stAmt = this.getBigDecimalVal(row, pre + stAmtField);
        for (String field : diffFieldArr) {
            stAmt = stAmt.add(this.getBigDecimalVal(row, pre + field));
        }
        row.set(this.sourceRowMeta.getFieldIndex(pre + targetfield), (Object)stAmt);
    }
}

