/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore.function;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.id.ID;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.sca.algox.restore.common.DiffCalcDataArgs;
import kd.macc.sca.algox.restore.common.DiffCalcHelper;
import kd.macc.sca.algox.utils.BigDecimalUtils;
import kd.macc.sca.algox.utils.DataSetXHelper;
import kd.macc.sca.common.costcalc.CalcResultObjectInfo;

public class DiffAllocBillSaveFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private DiffCalcDataArgs calcDataArgs;
    private Map<Long, Map<Long, CalcResultObjectInfo>> mainJoinSideCostObjectInfoMap;

    public DiffAllocBillSaveFunction(DiffCalcDataArgs args, Map<Long, Map<Long, CalcResultObjectInfo>> mainJoinSideCostObjectInfoMap) {
        this.calcDataArgs = args;
        this.mainJoinSideCostObjectInfoMap = mainJoinSideCostObjectInfoMap;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        HashMap billMap = Maps.newHashMapWithExpectedSize((int)10);
        DataSet ds = DataSetXHelper.getDsFromAlgoxRows(iterable, new String[]{"elementnum asc", "subelementnum asc"}, this.sourceRowMeta);
        while (ds.hasNext()) {
            boolean isEndZero;
            boolean isCompZero;
            Row curRow = ds.next();
            Long material = curRow.getLong(this.sourceRowMeta.getFieldIndex("material"));
            Long mversion = curRow.getLong(this.sourceRowMeta.getFieldIndex("mversion"));
            Long auxpty = curRow.getLong(this.sourceRowMeta.getFieldIndex("auxpty"));
            Long configuredcode = curRow.getLong(this.sourceRowMeta.getFieldIndex("configuredcode"));
            Long tracknumber = curRow.getLong(this.sourceRowMeta.getFieldIndex("tracknumber"));
            Long project = curRow.getLong(this.sourceRowMeta.getFieldIndex("project"));
            String lot = curRow.getString(this.sourceRowMeta.getFieldIndex("lot"));
            String keycol = curRow.getString(this.sourceRowMeta.getFieldIndex("keycol"));
            Long keycolid = curRow.getLong(this.sourceRowMeta.getFieldIndex("keycolid"));
            if (keycolid == null) {
                keycolid = 0L;
            }
            Long costobject = curRow.getLong(this.sourceRowMeta.getFieldIndex("costobject"));
            Long relacostobject = curRow.getLong(this.sourceRowMeta.getFieldIndex("relacostobject"));
            Map<Long, CalcResultObjectInfo> costobjectInfoMap = this.mainJoinSideCostObjectInfoMap.get(costobject);
            if (costobjectInfoMap == null || !costobjectInfoMap.containsKey(relacostobject)) continue;
            Long costcenterId = 0L;
            String bizStatus = "";
            if (costobjectInfoMap.containsKey(relacostobject)) {
                costcenterId = costobjectInfoMap.get(relacostobject).getCostCenterId();
                bizStatus = costobjectInfoMap.get(relacostobject).getBizStatus();
            } else if (costobjectInfoMap.containsKey(costobject)) {
                costcenterId = costobjectInfoMap.get(costobject).getCostCenterId();
                bizStatus = costobjectInfoMap.get(costobject).getBizStatus();
            }
            Long costelement = curRow.getLong(this.sourceRowMeta.getFieldIndex("costelement"));
            Long costsubelement = curRow.getLong(this.sourceRowMeta.getFieldIndex("costsubelement"));
            String costadjustids = "";
            int costadjustidIndex = this.sourceRowMeta.getFieldIndex("costadjustids", false);
            if (costadjustidIndex >= 0) {
                costadjustids = curRow.getString(costadjustidIndex);
            }
            if (!(isCompZero = this.isDiffAmtZero(curRow, "comp"))) {
                String key = String.format("%s@%s@%s@%s@%s@%s@%s@%s@%s@%s", material, mversion, auxpty, configuredcode, tracknumber, project, lot, keycol, relacostobject, "00");
                DynamicObject dyn = (DynamicObject)billMap.get(key);
                if (dyn == null) {
                    dyn = this.createBill("00", costadjustids);
                    this.setBizInfo(dyn, material, mversion, auxpty, configuredcode, tracknumber, project, lot, keycol, keycolid, relacostobject, costobject, costcenterId, bizStatus);
                    billMap.put(key, dyn);
                }
                this.saveEntryDiffAmtVal(dyn, curRow, costelement, costsubelement, "comp");
            }
            if (isEndZero = this.isDiffAmtZero(curRow, "end")) continue;
            String key = String.format("%s@%s@%s@%s@%s@%s@%s@%s@%s@%s", material, mversion, auxpty, configuredcode, tracknumber, project, lot, keycol, relacostobject, "01");
            DynamicObject dyn = (DynamicObject)billMap.get(key);
            if (dyn == null) {
                dyn = this.createBill("01", costadjustids);
                this.setBizInfo(dyn, material, mversion, auxpty, configuredcode, tracknumber, project, lot, keycol, keycolid, relacostobject, costobject, costcenterId, bizStatus);
                billMap.put(key, dyn);
            }
            this.saveEntryDiffAmtVal(dyn, curRow, costelement, costsubelement, "end");
        }
        int size = billMap.size();
        if (size > 0) {
            String[] batchNumber = CodeRuleServiceHelper.getBatchNumber((String)"sca_purchdiffalloc", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"sca_purchdiffalloc"), (String)String.valueOf(this.calcDataArgs.getOrgId()), (int)size);
            int index = 0;
            for (DynamicObject dyn : billMap.values()) {
                if (batchNumber.length > index) {
                    dyn.set("billno", (Object)batchNumber[index]);
                }
                ++index;
            }
        }
        SaveServiceHelper.save((DynamicObject[])billMap.values().toArray(new DynamicObject[0]));
    }

    private boolean isDiffAmtZero(Row curRow, String keyPre) {
        for (String field : DiffCalcHelper.DIFF_FIELD_ARR) {
            BigDecimal val = curRow.getBigDecimal(this.sourceRowMeta.getFieldIndex(keyPre + field));
            if (val == null || val.compareTo(BigDecimal.ZERO) == 0) continue;
            return false;
        }
        return true;
    }

    private void saveEntryDiffAmtVal(DynamicObject dyn, Row curRow, Long costelement, Long costsubelement, String keyPre) {
        DynamicObjectCollection entryentity = dyn.getDynamicObjectCollection("entryentity");
        DynamicObject entryrow = entryentity.addNew();
        entryrow.set("element", (Object)costelement);
        entryrow.set("subelement", (Object)costsubelement);
        BigDecimal sumVal = BigDecimal.ZERO;
        for (String field : DiffCalcHelper.DIFF_FIELD_ARR) {
            BigDecimal val = BigDecimalUtils.getBigDecimalOrZero(curRow.getBigDecimal(this.sourceRowMeta.getFieldIndex(keyPre + field)));
            sumVal = sumVal.add(val);
            entryrow.set(field, (Object)val);
        }
        entryrow.set("amount", (Object)sumVal);
        dyn.set("difftotal", (Object)dyn.getBigDecimal("difftotal").add(sumVal));
    }

    private void setBizInfo(DynamicObject dyn, Long material, Long mversion, Long auxpty, Long configuredcode, Long tracknumber, Long project, String lot, String keycol, Long keycolid, Long relacostobject, Long costobject, Long costcenterId, String bizStatus) {
        dyn.set("material", (Object)material);
        dyn.set("version", (Object)mversion);
        dyn.set("auxpty", (Object)auxpty);
        dyn.set("configuredcode", (Object)configuredcode);
        dyn.set("tracknumber", (Object)tracknumber);
        dyn.set("project", (Object)project);
        dyn.set("lot", (Object)lot);
        dyn.set("keycol", (Object)keycol);
        dyn.set("keycolid", (Object)keycolid);
        dyn.set("becostobject", (Object)relacostobject);
        dyn.set("maincostobject", (Object)costobject);
        dyn.set("costcenter", (Object)costcenterId);
        dyn.set("costobjbizstatus", (Object)bizStatus);
    }

    private DynamicObject createBill(String biztype, String costadjustids) {
        DynamicObject dyn = BusinessDataServiceHelper.newDynamicObject((String)"sca_purchdiffalloc");
        dyn.set("id", (Object)ID.genLongId());
        dyn.set("billno", (Object)ID.genStringId());
        dyn.set("org", (Object)this.calcDataArgs.getOrgId());
        dyn.set("costaccount", (Object)this.calcDataArgs.getCostaccountId());
        dyn.set("period", (Object)this.calcDataArgs.getPeriodId());
        dyn.set("currency", (Object)this.calcDataArgs.getCurrencyId());
        dyn.set("difftotal", (Object)BigDecimal.ZERO);
        dyn.set("biztype", (Object)biztype);
        if (!StringUtils.isEmpty((String)costadjustids)) {
            String[] arr = costadjustids.split(",");
            DynamicObjectCollection srcbillEntry = dyn.getDynamicObjectCollection("srcbillentry");
            for (String str : arr) {
                if (StringUtils.isEmpty((String)str)) continue;
                DynamicObject entry = srcbillEntry.addNew();
                entry.set("srcbill", (Object)Long.valueOf(str));
                entry.set("sourcetype", (Object)"00");
            }
        }
        Date date = TimeServiceHelper.now();
        Long userId = RequestContext.get().getCurrUserId();
        dyn.set("billstatus", (Object)"C");
        dyn.set("createtime", (Object)date);
        dyn.set("auditdate", (Object)date);
        dyn.set("modifytime", (Object)date);
        dyn.set("creator_id", (Object)userId);
        dyn.set("modifier_id", (Object)userId);
        dyn.set("auditor_id", (Object)userId);
        return dyn;
    }
}

