/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore.function;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.algox.costrec.DebugInfoMsgHandler;

public class DiffAllocCostAdustIdCollectFunction
extends GroupReduceFunction {
    protected static final Log logger = LogFactory.getLog(DiffAllocCostAdustIdCollectFunction.class);
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta = null;
    private DebugInfoMsgHandler msgHander = null;

    public RowMeta getResultRowMeta() {
        if (this.rowMeta != null) {
            return this.rowMeta;
        }
        this.rowMeta = new RowMeta(new Field[]{new Field("material", (DataType)DataType.LongType), new Field("mversion", (DataType)DataType.LongType), new Field("auxpty", (DataType)DataType.LongType), new Field("configuredcode", (DataType)DataType.LongType), new Field("tracknumber", (DataType)DataType.LongType), new Field("project", (DataType)DataType.LongType), new Field("lot", (DataType)DataType.StringType), new Field("keycol", (DataType)DataType.StringType), new Field("keycolid", (DataType)DataType.LongType), new Field("costobject", (DataType)DataType.LongType), new Field("costadjustids", (DataType)DataType.StringType)});
        return this.rowMeta;
    }

    public DiffAllocCostAdustIdCollectFunction(DebugInfoMsgHandler msgHander) {
        this.msgHander = msgHander;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        RowX colRow = new RowX(this.getResultRowMeta().getFieldCount());
        RowX baseRow = null;
        Iterator<RowX> iterator = iterable.iterator();
        int i = 0;
        HashSet adjustIds = Sets.newHashSetWithExpectedSize((int)10);
        while (iterator.hasNext()) {
            RowX curRow = iterator.next();
            Long costadjustid = curRow.getLong(this.sourceRowMeta.getFieldIndex("costadjustid"));
            if (!CadEmptyUtils.isEmpty((Long)costadjustid)) {
                adjustIds.add(costadjustid);
            }
            if (i == 0) {
                baseRow = curRow;
            }
            ++i;
        }
        if (baseRow == null) {
            return;
        }
        colRow.set(this.getResultRowMeta().getFieldIndex("material"), (Object)this.getLongValue(baseRow, "material"));
        colRow.set(this.getResultRowMeta().getFieldIndex("mversion"), (Object)this.getLongValue(baseRow, "mversion"));
        colRow.set(this.getResultRowMeta().getFieldIndex("auxpty"), (Object)this.getLongValue(baseRow, "auxpty"));
        colRow.set(this.getResultRowMeta().getFieldIndex("configuredcode"), (Object)this.getLongValue(baseRow, "configuredcode"));
        colRow.set(this.getResultRowMeta().getFieldIndex("tracknumber"), (Object)this.getLongValue(baseRow, "tracknumber"));
        colRow.set(this.getResultRowMeta().getFieldIndex("project"), (Object)this.getLongValue(baseRow, "project"));
        colRow.set(this.getResultRowMeta().getFieldIndex("lot"), (Object)this.getStringValue(baseRow, "lot"));
        colRow.set(this.getResultRowMeta().getFieldIndex("keycol"), (Object)this.getStringValue(baseRow, "keycol"));
        colRow.set(this.getResultRowMeta().getFieldIndex("keycolid"), (Object)this.getLongValue(baseRow, "keycolid"));
        colRow.set(this.getResultRowMeta().getFieldIndex("costobject"), (Object)this.getLongValue(baseRow, "costobject"));
        colRow.set(this.getResultRowMeta().getFieldIndex("costadjustids"), (Object)this.getCostadjustIdsStr(adjustIds));
        try {
            collector.collect(colRow);
        }
        catch (Exception ex) {
            logger.error("\u6536\u96c6\u6570\u636e\u5931\u8d25", (Throwable)ex);
            this.msgHander.dealInfoMsg("ErrorString:" + JSON.toJSONString((Object)colRow.values()));
        }
    }

    private String getCostadjustIdsStr(Set<Long> adjustIds) {
        StringBuilder sb = new StringBuilder();
        for (Long id : adjustIds) {
            sb.append(id).append(",");
        }
        return sb.toString();
    }

    private Long getLongValue(RowX row, String key) {
        Long val = row.getLong(this.sourceRowMeta.getFieldIndex(key));
        if (val == null) {
            return 0L;
        }
        return val;
    }

    private String getStringValue(RowX row, String key) {
        String val = row.getString(this.sourceRowMeta.getFieldIndex(key));
        if (val == null) {
            return "";
        }
        return val;
    }
}

