/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore.function;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.macc.sca.algox.restore.common.DiffCalcDataArgs;
import kd.macc.sca.algox.utils.BigDecimalUtils;

public class DiffAllocMatBillStdCalcFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private DiffCalcDataArgs calcDataArgs;

    public DiffAllocMatBillStdCalcFunction(DiffCalcDataArgs calcDataArgs) {
        this.calcDataArgs = calcDataArgs;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector col) {
        ArrayList listRows = Lists.newArrayList();
        for (RowX row : iterable) {
            listRows.add(row);
        }
        this.dataDeal(listRows);
        for (RowX row : listRows) {
            col.collect(row);
        }
    }

    private void dataDeal(List<RowX> listRows) {
        BigDecimal standardamt = BigDecimalUtils.getBigDecimalOrZero(listRows.get(0).getBigDecimal(this.sourceRowMeta.getFieldIndex("standardamt")));
        BigDecimal qty = BigDecimalUtils.getBigDecimalOrZero(listRows.get(0).getBigDecimal(this.sourceRowMeta.getFieldIndex("qty")));
        RowX maxRow = null;
        BigDecimal maxAmt = BigDecimal.ZERO;
        for (RowX row : listRows) {
            BigDecimal substandardcost = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("substandardcost")));
            if (maxRow == null || maxAmt.compareTo(substandardcost) < 0) {
                maxRow = row;
                maxAmt = substandardcost;
            }
            BigDecimal substandardamt = qty.multiply(substandardcost).setScale(this.calcDataArgs.getAmtPrecision(), 4);
            standardamt = standardamt.subtract(substandardamt);
            row.set(this.sourceRowMeta.getFieldIndex("substandardamt"), (Object)substandardamt);
        }
        if (maxRow != null && standardamt.compareTo(BigDecimal.ZERO) != 0) {
            maxRow.set(this.sourceRowMeta.getFieldIndex("substandardamt"), (Object)standardamt.add(maxRow.getBigDecimal(this.sourceRowMeta.getFieldIndex("substandardamt"))));
        }
    }
}

