/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore.function;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.macc.sca.algox.restore.common.DiffCalcHelper;
import kd.macc.sca.algox.utils.BigDecimalUtils;

public class DiffAllocResultDealFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        ArrayList rows = Lists.newArrayList();
        BigDecimal startqty = BigDecimal.ZERO;
        BigDecimal currqty = BigDecimal.ZERO;
        BigDecimal compqty = BigDecimal.ZERO;
        BigDecimal endqty = BigDecimal.ZERO;
        Long elementId = 0L;
        Long subelementId = 0L;
        int i = 0;
        for (RowX row : iterable) {
            if (i == 0) {
                startqty = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("startqty")));
                currqty = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("currqty")));
                compqty = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("compqty")));
                endqty = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("endqty")));
                elementId = row.getLong(this.sourceRowMeta.getFieldIndex("element"));
                subelementId = row.getLong(this.sourceRowMeta.getFieldIndex("subelement"));
            }
            rows.add(row);
            ++i;
        }
        RowX compRow = null;
        if (!rows.isEmpty()) {
            compRow = ((RowX)rows.get(0)).copy();
            compRow.set(this.sourceRowMeta.getFieldIndex("type"), (Object)"5");
            compRow.set(this.sourceRowMeta.getFieldIndex("startqty"), (Object)startqty);
            compRow.set(this.sourceRowMeta.getFieldIndex("currqty"), (Object)currqty);
            compRow.set(this.sourceRowMeta.getFieldIndex("compqty"), (Object)compqty);
            compRow.set(this.sourceRowMeta.getFieldIndex("endqty"), (Object)endqty);
            compRow.set(this.sourceRowMeta.getFieldIndex("totalqty"), (Object)compqty);
            compRow.set(this.sourceRowMeta.getFieldIndex("costelement"), (Object)elementId);
            compRow.set(this.sourceRowMeta.getFieldIndex("costsubelement"), (Object)subelementId);
        }
        for (RowX row : rows) {
            for (String field : DiffCalcHelper.DIFF_FIELD_ARR) {
                row.set(this.sourceRowMeta.getFieldIndex("total" + field), (Object)row.getBigDecimal(this.sourceRowMeta.getFieldIndex("comp" + field)));
            }
            row.set(this.sourceRowMeta.getFieldIndex("totalamt"), (Object)row.getBigDecimal(this.sourceRowMeta.getFieldIndex("compamt")));
            row.set(this.sourceRowMeta.getFieldIndex("startqty"), (Object)BigDecimal.ZERO);
            row.set(this.sourceRowMeta.getFieldIndex("currqty"), (Object)BigDecimal.ZERO);
            row.set(this.sourceRowMeta.getFieldIndex("compqty"), (Object)BigDecimal.ZERO);
            row.set(this.sourceRowMeta.getFieldIndex("endqty"), (Object)BigDecimal.ZERO);
            row.set(this.sourceRowMeta.getFieldIndex("totalqty"), (Object)BigDecimal.ZERO);
        }
        for (RowX row : rows) {
            collector.collect(row);
        }
        if (compRow != null) {
            collector.collect(compRow);
        }
    }
}

