/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore.function;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.algox.restore.common.DiffCalcHelper;
import kd.macc.sca.algox.utils.BigDecimalUtils;

public class DiffAllocResultSumDealFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        ArrayList rows = Lists.newArrayList();
        Long elementId = 0L;
        Long subelementId = 0L;
        int i = 0;
        RowX compRow = null;
        for (RowX row : iterable) {
            Long costelement;
            if (i == 0) {
                elementId = row.getLong(this.sourceRowMeta.getFieldIndex("element"));
                subelementId = row.getLong(this.sourceRowMeta.getFieldIndex("subelement"));
            }
            if (CadEmptyUtils.isEmpty((Long)(costelement = row.getLong(this.sourceRowMeta.getFieldIndex("costelement"))))) {
                compRow = row;
                BigDecimal bigDecimal = BigDecimalUtils.getBigDecimalOrZero(compRow.getBigDecimal(this.sourceRowMeta.getFieldIndex("compamt")));
                BigDecimal totalAmt = BigDecimalUtils.getBigDecimalOrZero(compRow.getBigDecimal(this.sourceRowMeta.getFieldIndex("totalamt")));
                compRow.set(this.sourceRowMeta.getFieldIndex("totalamt"), (Object)bigDecimal.add(totalAmt));
            } else {
                rows.add(row);
            }
            ++i;
        }
        if (!rows.isEmpty() && compRow == null) {
            compRow = ((RowX)rows.get(0)).copy();
            compRow.set(this.sourceRowMeta.getFieldIndex("type"), (Object)"5");
            compRow.set(this.sourceRowMeta.getFieldIndex("startqty"), (Object)BigDecimal.ZERO);
            compRow.set(this.sourceRowMeta.getFieldIndex("currqty"), (Object)BigDecimal.ZERO);
            compRow.set(this.sourceRowMeta.getFieldIndex("compqty"), (Object)BigDecimal.ZERO);
            compRow.set(this.sourceRowMeta.getFieldIndex("endqty"), (Object)BigDecimal.ZERO);
            compRow.set(this.sourceRowMeta.getFieldIndex("totalqty"), (Object)BigDecimal.ZERO);
            compRow.set(this.sourceRowMeta.getFieldIndex("startamt"), (Object)BigDecimal.ZERO);
            compRow.set(this.sourceRowMeta.getFieldIndex("curramt"), (Object)BigDecimal.ZERO);
            compRow.set(this.sourceRowMeta.getFieldIndex("compamt"), (Object)BigDecimal.ZERO);
            compRow.set(this.sourceRowMeta.getFieldIndex("endamt"), (Object)BigDecimal.ZERO);
            compRow.set(this.sourceRowMeta.getFieldIndex("totalamt"), (Object)BigDecimal.ZERO);
            for (Iterator<Object> iterator : DiffCalcHelper.DIFF_FIELD_ARR) {
                compRow.set(this.sourceRowMeta.getFieldIndex("start" + iterator), (Object)BigDecimal.ZERO);
                compRow.set(this.sourceRowMeta.getFieldIndex("curr" + iterator), (Object)BigDecimal.ZERO);
                compRow.set(this.sourceRowMeta.getFieldIndex("comp" + iterator), (Object)BigDecimal.ZERO);
                compRow.set(this.sourceRowMeta.getFieldIndex("end" + iterator), (Object)BigDecimal.ZERO);
                compRow.set(this.sourceRowMeta.getFieldIndex("total" + iterator), (Object)BigDecimal.ZERO);
            }
        }
        for (RowX row : rows) {
            for (String field : DiffCalcHelper.DIFF_FIELD_ARR) {
                row.set(this.sourceRowMeta.getFieldIndex("total" + field), (Object)row.getBigDecimal(this.sourceRowMeta.getFieldIndex("comp" + field)));
            }
            this.addRow(row, compRow, "start");
            this.addRow(row, compRow, "curr");
            this.addRow(row, compRow, "comp");
            this.addRow(row, compRow, "end");
            this.addRow(row, compRow, "total");
        }
        if (compRow != null) {
            compRow.set(this.sourceRowMeta.getFieldIndex("costelement"), (Object)elementId);
            compRow.set(this.sourceRowMeta.getFieldIndex("costsubelement"), (Object)subelementId);
            collector.collect(compRow);
        }
    }

    private void addRow(RowX row, RowX compRow, String pre) {
        for (String field : DiffCalcHelper.DIFF_FIELD_ARR) {
            int index = this.sourceRowMeta.getFieldIndex(pre + field);
            BigDecimal comAmt = BigDecimalUtils.getBigDecimalOrZero(compRow.getBigDecimal(index));
            BigDecimal detailAmt = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(index));
            compRow.set(index, (Object)comAmt.add(detailAmt));
        }
    }
}

