/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore.function;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.macc.sca.algox.utils.BigDecimalUtils;

public class DiffAllocStandcostDealFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta rowMeta = new RowMeta(new Field[]{new Field("manuorg", (DataType)DataType.LongType), new Field("material", (DataType)DataType.LongType), new Field("mversion", (DataType)DataType.LongType), new Field("auxpty", (DataType)DataType.LongType), new Field("configuredcode", (DataType)DataType.LongType), new Field("tracknumber", (DataType)DataType.LongType), new Field("project", (DataType)DataType.LongType), new Field("lot", (DataType)DataType.StringType), new Field("keycol", (DataType)DataType.StringType), new Field("keycolid", (DataType)DataType.LongType), new Field("costcenter", (DataType)DataType.LongType), new Field("costobject", (DataType)DataType.LongType), new Field("relacostobject", (DataType)DataType.LongType), new Field("costelement", (DataType)DataType.LongType), new Field("costsubelement", (DataType)DataType.LongType), new Field("currqty", (DataType)DataType.BigDecimalType), new Field("curramt", (DataType)DataType.BigDecimalType)});

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        Iterator<RowX> iterator = iterable.iterator();
        RowX baseRow = new RowX(this.rowMeta.getFieldCount());
        HashSet hasSumMatAllocEntryIds = Sets.newHashSetWithExpectedSize((int)10);
        HashMap subelementStdRow = Maps.newHashMapWithExpectedSize((int)10);
        int i = 0;
        BigDecimal sumQty = BigDecimal.ZERO;
        while (iterator.hasNext()) {
            Long matallocentryid;
            RowX curRow = iterator.next();
            if (i == 0) {
                baseRow.set(this.rowMeta.getFieldIndex("material"), (Object)curRow.getLong(this.sourceRowMeta.getFieldIndex("material")));
                baseRow.set(this.rowMeta.getFieldIndex("manuorg"), (Object)curRow.getLong(this.sourceRowMeta.getFieldIndex("manuorg")));
                baseRow.set(this.rowMeta.getFieldIndex("mversion"), (Object)curRow.getLong(this.sourceRowMeta.getFieldIndex("mversion")));
                baseRow.set(this.rowMeta.getFieldIndex("auxpty"), (Object)curRow.getLong(this.sourceRowMeta.getFieldIndex("auxpty")));
                baseRow.set(this.rowMeta.getFieldIndex("configuredcode"), (Object)curRow.getLong(this.sourceRowMeta.getFieldIndex("configuredcode")));
                baseRow.set(this.rowMeta.getFieldIndex("tracknumber"), (Object)curRow.getLong(this.sourceRowMeta.getFieldIndex("tracknumber")));
                baseRow.set(this.rowMeta.getFieldIndex("project"), (Object)curRow.getLong(this.sourceRowMeta.getFieldIndex("project")));
                baseRow.set(this.rowMeta.getFieldIndex("lot"), (Object)curRow.getString(this.sourceRowMeta.getFieldIndex("lot")));
                baseRow.set(this.rowMeta.getFieldIndex("keycol"), (Object)curRow.getString(this.sourceRowMeta.getFieldIndex("keycol")));
                Long keycolid = curRow.getLong(this.sourceRowMeta.getFieldIndex("keycolid"));
                if (keycolid == null) {
                    keycolid = 0L;
                }
                baseRow.set(this.rowMeta.getFieldIndex("keycolid"), (Object)keycolid);
                baseRow.set(this.rowMeta.getFieldIndex("costcenter"), (Object)curRow.getLong(this.sourceRowMeta.getFieldIndex("costcenter")));
                baseRow.set(this.rowMeta.getFieldIndex("costobject"), (Object)curRow.getLong(this.sourceRowMeta.getFieldIndex("costobject")));
                baseRow.set(this.rowMeta.getFieldIndex("relacostobject"), (Object)curRow.getLong(this.sourceRowMeta.getFieldIndex("costobject")));
                baseRow.set(this.rowMeta.getFieldIndex("curramt"), (Object)BigDecimal.ZERO);
                baseRow.set(this.rowMeta.getFieldIndex("currqty"), (Object)BigDecimal.ZERO);
            }
            if (hasSumMatAllocEntryIds.add(matallocentryid = curRow.getLong(this.sourceRowMeta.getFieldIndex("matallocentryid")))) {
                sumQty = sumQty.add(BigDecimalUtils.getBigDecimalOrZero(curRow.getBigDecimal(this.sourceRowMeta.getFieldIndex("qty"))));
            }
            Long costelement = curRow.getLong(this.sourceRowMeta.getFieldIndex("costelement"));
            Long costsubelement = curRow.getLong(this.sourceRowMeta.getFieldIndex("costsubelement"));
            RowX rowx = (RowX)subelementStdRow.get(costsubelement);
            BigDecimal standardamt = BigDecimalUtils.getBigDecimalOrZero(curRow.getBigDecimal(this.sourceRowMeta.getFieldIndex("substandardamt")));
            if (rowx == null) {
                rowx = baseRow.copy();
                subelementStdRow.put(costsubelement, rowx);
                rowx.set(this.rowMeta.getFieldIndex("costelement"), (Object)costelement);
                rowx.set(this.rowMeta.getFieldIndex("costsubelement"), (Object)costsubelement);
            }
            rowx.set(this.rowMeta.getFieldIndex("curramt"), (Object)rowx.getBigDecimal(this.rowMeta.getFieldIndex("curramt")).add(standardamt));
            ++i;
        }
        for (RowX row : subelementStdRow.values()) {
            row.set(this.rowMeta.getFieldIndex("currqty"), (Object)sumQty);
            collector.collect(row);
        }
    }
}

