/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore.function;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.macc.sca.algox.restore.common.DiffCalcDataArgs;
import kd.macc.sca.algox.restore.common.DiffCalcHelper;
import kd.macc.sca.algox.utils.BigDecimalUtils;
import kd.macc.sca.algox.utils.ScaCalcHelper;
import kd.macc.sca.common.costcalc.CalcResultObjectInfo;

public class DiffAllocStdMainJoinAllocFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private Map<Long, Map<Long, CalcResultObjectInfo>> mainJoinSideCostObjectInfoMap = null;
    private DiffCalcDataArgs calcDataArgs;

    public DiffAllocStdMainJoinAllocFunction(DiffCalcDataArgs args, Map<Long, Map<Long, CalcResultObjectInfo>> mainJoinSideCostObjectInfoMap) {
        this.mainJoinSideCostObjectInfoMap = mainJoinSideCostObjectInfoMap;
        this.calcDataArgs = args;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        ArrayList mainRows = Lists.newArrayList();
        for (RowX rowX : iterable) {
            mainRows.add(rowX);
        }
        if (mainRows.isEmpty()) {
            return;
        }
        Long costObjectId = ((RowX)mainRows.get(0)).getLong(this.sourceRowMeta.getFieldIndex("costobject"));
        if (!this.mainJoinSideCostObjectInfoMap.containsKey(costObjectId)) {
            return;
        }
        for (Object rowx : mainRows) {
            rowx.set(this.sourceRowMeta.getFieldIndex("relacostobject"), (Object)costObjectId);
        }
        Map<Long, CalcResultObjectInfo> map = this.mainJoinSideCostObjectInfoMap.get(costObjectId);
        if (map.size() == 1 || !ScaCalcHelper.isHasMainJoinFacted(map)) {
            this.setCompRows(mainRows);
            for (RowX row : mainRows) {
                collector.collect(row);
            }
            return;
        }
        List<RowX> joinRows = this.calcMainJoinProductCost(mainRows, map);
        this.setCompRows(mainRows);
        this.setCompRows(joinRows);
        for (RowX row : mainRows) {
            collector.collect(row);
        }
        for (RowX row : joinRows) {
            collector.collect(row);
        }
    }

    private void setCompRows(List<RowX> rows) {
        RowX compRow = null;
        BigDecimal sumCompAmt = BigDecimal.ZERO;
        BigDecimal sumEndAmt = BigDecimal.ZERO;
        for (RowX rowX : rows) {
            if ("5".equals(rowX.getString(this.sourceRowMeta.getFieldIndex("type")))) {
                compRow = rowX;
                continue;
            }
            sumCompAmt = sumCompAmt.add(this.getBigDecimalVal(rowX, "compamt"));
            sumEndAmt = sumEndAmt.add(this.getBigDecimalVal(rowX, "endamt"));
            this.totalAddCompAmt(rowX);
        }
        if (compRow != null) {
            compRow.set(this.sourceRowMeta.getFieldIndex("compamt"), (Object)sumCompAmt);
            compRow.set(this.sourceRowMeta.getFieldIndex("endamt"), (Object)sumEndAmt);
            this.totalAddCompAmt(compRow);
        }
    }

    private void totalAddCompAmt(RowX rowX) {
        BigDecimal compAmt = this.getBigDecimalVal(rowX, "compamt");
        BigDecimal totalQty = this.getBigDecimalVal(rowX, "totalqty");
        BigDecimal compQty = this.getBigDecimalVal(rowX, "compqty");
        BigDecimal totalAmt = this.getBigDecimalVal(rowX, "totalamt");
        rowX.set(this.sourceRowMeta.getFieldIndex("totalqty"), (Object)totalQty.add(compQty));
        rowX.set(this.sourceRowMeta.getFieldIndex("totalAmt"), (Object)totalAmt.add(compAmt));
    }

    private List<RowX> calcMainJoinProductCost(List<RowX> mainRows, Map<Long, CalcResultObjectInfo> resultVoMaps) {
        ArrayList joinRows = Lists.newArrayList();
        if (!ScaCalcHelper.isContainsProductFacted(resultVoMaps, "A")) {
            return joinRows;
        }
        int compqtyIndex = this.sourceRowMeta.getFieldIndex("compqty");
        int compamtIndex = this.sourceRowMeta.getFieldIndex("compamt");
        int precision = 10;
        for (RowX mainRow : mainRows) {
            BigDecimal compamt = BigDecimalUtils.getBigDecimalOrZero(mainRow.getBigDecimal(compamtIndex));
            BigDecimal compqty = BigDecimalUtils.getBigDecimalOrZero(mainRow.getBigDecimal(compqtyIndex));
            if (BigDecimal.ZERO.compareTo(compamt) == 0 && BigDecimal.ZERO.compareTo(compqty) == 0) continue;
            precision = mainRow.getInteger(this.sourceRowMeta.getFieldIndex("precision"));
            BigDecimal totalMuilt = BigDecimal.ZERO;
            BigDecimal maxMuilt = null;
            for (Map.Entry<Long, CalcResultObjectInfo> entry : resultVoMaps.entrySet()) {
                BigDecimal qty;
                if ("B".equals(entry.getValue().getProductType()) || (qty = entry.getValue().getFinishQty()).compareTo(BigDecimal.ZERO) == 0) continue;
                BigDecimal weight = entry.getValue().getWeight();
                BigDecimal multi = qty.multiply(weight);
                totalMuilt = totalMuilt.add(multi);
                if (maxMuilt != null && maxMuilt.compareTo(multi.abs()) >= 0) continue;
                maxMuilt = multi.abs();
            }
            if (totalMuilt.compareTo(BigDecimal.ZERO) == 0 && maxMuilt != null) {
                totalMuilt = maxMuilt;
            }
            if (totalMuilt.compareTo(BigDecimal.ZERO) == 0) {
                String errStr = ResManager.loadKDString((String)"\u4e3b\u8054\u4ea7\u54c1\u5b8c\u5de5\u6bd4\u4f8b\u5206\u914d\u5931\u8d25\uff0c\u3010\u2211\u4e3b\u4ea7\u54c1\u5b8c\u5de5\u5165\u5e93\u6570\u91cf*\u6743\u91cd+\u2211\u8054\u4ea7\u54c1\u5b8c\u5de5\u5165\u5e93\u6570\u91cf*\u6743\u91cd=0\u3011\uff0c\u5de5\u5355\u7f16\u53f7\u3010\u3011\uff0c\u6210\u672c\u5bf9\u8c61\u3010\u3011\uff0c\u5b50\u8981\u7d20\u3010\u3011\u3002", (String)"DiffAllocStdMainJoinAllocFunction_0", (String)"macc-sca-algox", (Object[])new Object[0]);
                throw new KDBizException(errStr);
            }
            BigDecimal mainJoinCompQty = BigDecimalUtils.getBigDecimalOrZero(mainRow.getBigDecimal(compqtyIndex));
            BigDecimal mainJoinCompAmt = BigDecimalUtils.getBigDecimalOrZero(mainRow.getBigDecimal(compamtIndex));
            BigDecimal diffFinQty = mainJoinCompQty;
            BigDecimal diffFinAmt = mainJoinCompAmt;
            RowX allocMaxRow = null;
            boolean isContainMainFact = false;
            boolean isContainJoinFact = false;
            for (Map.Entry<Long, CalcResultObjectInfo> entry : resultVoMaps.entrySet()) {
                CalcResultObjectInfo costobjectInfo;
                if ("B".equals(entry.getValue().getProductType()) || BigDecimal.ZERO.compareTo((costobjectInfo = entry.getValue()).getFinishQty()) == 0) continue;
                BigDecimal qty = costobjectInfo.getFinishQty();
                BigDecimal weight = costobjectInfo.getWeight();
                BigDecimal multi = qty.multiply(weight);
                BigDecimal radio = BigDecimal.ZERO;
                if (totalMuilt.compareTo(BigDecimal.ZERO) != 0) {
                    radio = multi.divide(totalMuilt, 10, RoundingMode.HALF_UP);
                }
                BigDecimal allocAmt = radio.multiply(mainJoinCompAmt).setScale(this.calcDataArgs.getAmtPrecision(), RoundingMode.HALF_UP);
                BigDecimal allocQty = radio.multiply(mainJoinCompQty).setScale(precision, RoundingMode.HALF_UP);
                diffFinAmt = diffFinAmt.subtract(allocAmt);
                diffFinQty = diffFinQty.subtract(allocQty);
                if ("C".equals(entry.getValue().getProductType())) {
                    mainRow.set(compqtyIndex, (Object)allocQty);
                    mainRow.set(compamtIndex, (Object)allocAmt);
                    if (allocMaxRow == null || allocMaxRow.getBigDecimal(compamtIndex).compareTo(allocAmt) < 0) {
                        allocMaxRow = mainRow;
                    }
                    isContainMainFact = true;
                    continue;
                }
                RowX joinRow = this.getProductRow(mainRow, costobjectInfo.getCostObjectId());
                joinRow.set(compqtyIndex, (Object)allocQty);
                joinRow.set(compamtIndex, (Object)allocAmt);
                if (allocMaxRow == null || allocMaxRow.getBigDecimal(compamtIndex).compareTo(allocAmt) < 0) {
                    allocMaxRow = joinRow;
                }
                joinRows.add(joinRow);
                isContainJoinFact = true;
            }
            if (diffFinAmt.compareTo(BigDecimal.ZERO) != 0 && allocMaxRow != null) {
                allocMaxRow.set(compamtIndex, (Object)allocMaxRow.getBigDecimal(compamtIndex).add(diffFinAmt));
            }
            if (diffFinQty.compareTo(BigDecimal.ZERO) != 0 && allocMaxRow != null) {
                allocMaxRow.set(compqtyIndex, (Object)allocMaxRow.getBigDecimal(compqtyIndex).add(diffFinQty));
            }
            if (isContainMainFact || !isContainJoinFact) continue;
            mainRow.set(compqtyIndex, (Object)BigDecimal.ZERO);
            mainRow.set(compamtIndex, (Object)BigDecimal.ZERO);
        }
        return joinRows;
    }

    private BigDecimal getBigDecimalVal(RowX rowx, String field) {
        return BigDecimalUtils.getBigDecimalOrZero(rowx.getBigDecimal(this.sourceRowMeta.getFieldIndex(field)));
    }

    private RowX getProductRow(RowX baseRow, Long costobjectId) {
        RowX newRow = baseRow.copy();
        newRow.set(this.sourceRowMeta.getFieldIndex("startqty"), (Object)BigDecimal.ZERO);
        newRow.set(this.sourceRowMeta.getFieldIndex("startamt"), (Object)BigDecimal.ZERO);
        newRow.set(this.sourceRowMeta.getFieldIndex("currqty"), (Object)BigDecimal.ZERO);
        newRow.set(this.sourceRowMeta.getFieldIndex("curramt"), (Object)BigDecimal.ZERO);
        newRow.set(this.sourceRowMeta.getFieldIndex("compqty"), (Object)BigDecimal.ZERO);
        newRow.set(this.sourceRowMeta.getFieldIndex("compamt"), (Object)BigDecimal.ZERO);
        newRow.set(this.sourceRowMeta.getFieldIndex("endqty"), (Object)BigDecimal.ZERO);
        newRow.set(this.sourceRowMeta.getFieldIndex("endamt"), (Object)BigDecimal.ZERO);
        newRow.set(this.sourceRowMeta.getFieldIndex("totalqty"), (Object)BigDecimal.ZERO);
        newRow.set(this.sourceRowMeta.getFieldIndex("totalamt"), (Object)BigDecimal.ZERO);
        for (String field : DiffCalcHelper.DIFF_FIELD_ARR) {
            newRow.set(this.sourceRowMeta.getFieldIndex("total" + field), (Object)BigDecimal.ZERO);
        }
        newRow.set(this.sourceRowMeta.getFieldIndex("relacostobject"), (Object)costobjectId);
        return newRow;
    }
}

