/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore.function;

import java.math.BigDecimal;
import java.util.Iterator;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.util.StringUtils;
import kd.macc.sca.algox.utils.BigDecimalUtils;

public class DiffCalcResultCompDealFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        Iterator<RowX> iterator = iterable.iterator();
        RowX baseRow = null;
        int i = 0;
        while (iterator.hasNext()) {
            RowX curRow = iterator.next();
            if (baseRow == null) {
                baseRow = curRow;
            }
            if (i != 0) {
                this.addBigDecimal(baseRow, curRow, "startqty");
                this.addBigDecimal(baseRow, curRow, "startamt");
                this.addBigDecimal(baseRow, curRow, "currqty");
                this.addBigDecimal(baseRow, curRow, "curramt");
                this.addBigDecimal(baseRow, curRow, "compqty");
                this.addBigDecimal(baseRow, curRow, "compamt");
                this.addBigDecimal(baseRow, curRow, "endqty");
                this.addBigDecimal(baseRow, curRow, "endamt");
                this.addBigDecimal(baseRow, curRow, "totalqty");
                this.addBigDecimal(baseRow, curRow, "totalamt");
            }
            String difftype = curRow.getString(this.sourceRowMeta.getFieldIndex("difftype"));
            BigDecimal startAmt = BigDecimalUtils.getBigDecimalOrZero(curRow.getBigDecimal(this.sourceRowMeta.getFieldIndex("startamt")));
            BigDecimal endAmt = BigDecimalUtils.getBigDecimalOrZero(curRow.getBigDecimal(this.sourceRowMeta.getFieldIndex("endamt")));
            BigDecimal comAmt = BigDecimalUtils.getBigDecimalOrZero(curRow.getBigDecimal(this.sourceRowMeta.getFieldIndex("diff")));
            this.setAmt(baseRow, difftype, startAmt, endAmt, comAmt);
            ++i;
        }
        if (baseRow != null) {
            collector.collect(baseRow);
        }
    }

    private void setAmt(RowX rowx, String difftype, BigDecimal startAmt, BigDecimal endAmt, BigDecimal comAmt) {
        String field = null;
        switch (difftype) {
            case "P": {
                field = "diffqty";
                break;
            }
            case "Q": {
                field = "madediff";
                break;
            }
            case "S": {
                field = "madeupamt";
                break;
            }
        }
        if (!StringUtils.isEmpty((String)field)) {
            BigDecimal startPreAmt = BigDecimalUtils.getBigDecimalOrZero(rowx.getBigDecimal(this.sourceRowMeta.getFieldIndex("start" + field)));
            rowx.set(this.sourceRowMeta.getFieldIndex("start" + field), (Object)startAmt.add(startPreAmt));
            BigDecimal comPreAmt = BigDecimalUtils.getBigDecimalOrZero(rowx.getBigDecimal(this.sourceRowMeta.getFieldIndex("comp" + field)));
            rowx.set(this.sourceRowMeta.getFieldIndex("comp" + field), (Object)comAmt.add(comPreAmt));
            BigDecimal endPreAmt = BigDecimalUtils.getBigDecimalOrZero(rowx.getBigDecimal(this.sourceRowMeta.getFieldIndex("end" + field)));
            rowx.set(this.sourceRowMeta.getFieldIndex("end" + field), (Object)endAmt.add(endPreAmt));
        }
    }

    private void addBigDecimal(RowX baseRow, RowX curRow, String field) {
        BigDecimal val = BigDecimalUtils.getBigDecimalOrZero(baseRow.getBigDecimal(this.sourceRowMeta.getFieldIndex(field)));
        BigDecimal curVal = BigDecimalUtils.getBigDecimalOrZero(curRow.getBigDecimal(this.sourceRowMeta.getFieldIndex(field)));
        baseRow.set(this.sourceRowMeta.getFieldIndex(field), (Object)val.add(curVal));
    }
}

