/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore.function;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.id.ID;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.macc.sca.algox.restore.common.DiffCalcHelper;
import org.apache.commons.lang3.StringUtils;

public class DiffCalcResultSaveFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private static final String INSERT_SQL1 = "insert into t_sca_comdiffresultentry(fentryid,fid,ftype1,frelacostobjectid1,felementid1,fsubelementid1,fmaterialid1,fauxptyid1,fmatversionid1,fkeycol1,fkeycol1id,fbaseunitid1,fstartqty1,fstartamt1,fstartactcostupamt1,fstartdiffqty1,fstartmadediff1,fstartmadeupamt1,fstartunjoindiffamt1,fstartstdcostupamt1,fstartorddiff1,fstartinvoicediff1,fstartfeediff1,fstartotherdiff1,fstartreservediffx1,fstartreservediffw1,fstartreservediffy1,fcurrqty1,fcurramt1,fcurractcostupamt1,fcurrdiffqty1,fcurrmadediff1,fcurrmadeupamt1,fcurrunjoindiffamt1,fcurrstdcostupamt1,fcurrorddiff1,fcurrinvoicediff1,fcurrfeediff1,fcurrotherdiff1,fcurrreservediffx1,fcurrreservediffw1,fcurrreservediffy1) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String INSERT_SQL2 = "insert into t_sca_comdiffresultentry_v(fentryid,fid,fstartfalldiff1,fcurrfalldiff1,fcompqty1,fcompamt1,fcompactcostupamt1,fcompdiffqty1,fcompmadediff1,fcompmadeupamt1,fcompunjoindiffamt1,fcompstdcostupamt1,fcomporddiff1,fcompinvoicediff1,fcompfeediff1,fcompotherdiff1,fcompfalldiff1,fcompreservediffx1,fcompreservediffw1,fcompreservediffy1,fendqty1,fendamt1,fendactcostupamt1,fenddiffqty1,fendmadediff1,fendmadeupamt1,fendunjoindiffamt1,fendstdcostupamt1,fendorddiff1,fendinvoicediff1,fendfeediff1,fendotherdiff1,fendfalldiff1,fendreservediffx1,fendreservediffw1,fendreservediffy1,ftotalqty1,ftotalamt1,ftotalactcostupamt1,ftotaldiffqty1,ftotalmadediff1,ftotalmadeupamt1,ftotalunjoindiffamt1,ftotalstdcostupamt1,ftotalorddiff1,ftotalinvoicediff1,ftotalfeediff1,ftotalotherdiff1,ftotalfalldiff1,ftotalreservediffx1,ftotalreservediffw1,ftotalreservediffy1) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String SUBENTRY_SQL = "insert into t_sca_comdiffressubentry(fentryid,fdetailid,fseq,fcalckeycol1id,fsubcurrqty1) values(?,?,?,?,?)";
    private Map<Long, Long> costobjectDiffCalcResultIdMap = null;
    private long batchSize = 5000L;
    private long periodId = 0L;
    private long orgId = 0L;
    private int amtPrecision = 0;
    private String[] qtyFiled = new String[]{"startqty", "currqty", "compqty", "endqty", "totalqty"};

    public DiffCalcResultSaveFunction(Map<Long, Long> costobjectDiffCalcResultIdMap, long periodId, long orgId, long batchSize, int amtPrecision) {
        this.costobjectDiffCalcResultIdMap = costobjectDiffCalcResultIdMap;
        this.batchSize = batchSize;
        this.periodId = periodId;
        this.orgId = orgId;
        this.amtPrecision = amtPrecision;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        ArrayList paramObj1Lists = Lists.newArrayList();
        ArrayList paramObj2Lists = Lists.newArrayList();
        ArrayList paramObj3Lists = Lists.newArrayList();
        for (RowX row : iterable) {
            Long costobjectId = row.getLong(this.sourceRowMeta.getFieldIndex("costobject"));
            if (!this.costobjectDiffCalcResultIdMap.containsKey(costobjectId)) continue;
            Long entryId = ID.genLongId();
            Long fid = this.costobjectDiffCalcResultIdMap.get(costobjectId);
            ArrayList paramObjects1 = Lists.newArrayList();
            paramObjects1.add(entryId);
            paramObjects1.add(fid);
            this.setParamVal(new String[]{"type", "relacostobject", "element", "subelement", "material", "auxpty", "mversion", "keycol", "keycolid", "baseunit"}, row, this.sourceRowMeta, paramObjects1, true);
            this.setParamVal(DiffCalcHelper.fieldsAddPre(DiffCalcHelper.STD_FIELD_ARR, "start"), row, this.sourceRowMeta, paramObjects1, true);
            this.setParamVal(DiffCalcHelper.fieldsAddPre(DiffCalcHelper.DIFF_FIELD_ARR, "start"), row, this.sourceRowMeta, paramObjects1, false);
            this.setParamVal(DiffCalcHelper.fieldsAddPre(DiffCalcHelper.STD_FIELD_ARR, "curr"), row, this.sourceRowMeta, paramObjects1, true);
            this.setParamVal(DiffCalcHelper.fieldsAddPre(DiffCalcHelper.DIFF_FIELD_ARR, "curr"), row, this.sourceRowMeta, paramObjects1, false);
            ArrayList paramObjects2 = Lists.newArrayList();
            paramObjects2.add(entryId);
            paramObjects2.add(fid);
            this.setParamVal(new String[]{"startfalldiff", "currfalldiff"}, row, this.sourceRowMeta, paramObjects2, true);
            this.setParamVal(DiffCalcHelper.fieldsAddPre(DiffCalcHelper.STD_FIELD_ARR, "comp"), row, this.sourceRowMeta, paramObjects2, true);
            this.setParamVal(DiffCalcHelper.fieldsAddPre(DiffCalcHelper.DIFF_FIELD_ARR, "comp"), row, this.sourceRowMeta, paramObjects2, true);
            this.setParamVal(DiffCalcHelper.fieldsAddPre(DiffCalcHelper.STD_FIELD_ARR, "end"), row, this.sourceRowMeta, paramObjects2, true);
            this.setParamVal(DiffCalcHelper.fieldsAddPre(DiffCalcHelper.DIFF_FIELD_ARR, "end"), row, this.sourceRowMeta, paramObjects2, true);
            this.setParamVal(DiffCalcHelper.fieldsAddPre(DiffCalcHelper.STD_FIELD_ARR, "total"), row, this.sourceRowMeta, paramObjects2, true);
            this.setParamVal(DiffCalcHelper.fieldsAddPre(DiffCalcHelper.DIFF_FIELD_ARR, "total"), row, this.sourceRowMeta, paramObjects2, true);
            paramObj1Lists.add(paramObjects1.toArray());
            paramObj2Lists.add(paramObjects2.toArray());
            String calckeyStr = row.getString(this.getSourceRowMeta().getFieldIndex("keycolStr"));
            if (!StringUtils.isEmpty((CharSequence)calckeyStr)) {
                this.addSubEntryParamObj(paramObj3Lists, entryId, calckeyStr);
            }
            if ((long)paramObj1Lists.size() <= this.batchSize) continue;
            this.executeBatch(INSERT_SQL1, paramObj1Lists);
            this.executeBatch(INSERT_SQL2, paramObj2Lists);
            if (!paramObj3Lists.isEmpty()) {
                this.executeBatch(SUBENTRY_SQL, paramObj3Lists);
            }
            paramObj1Lists.clear();
            paramObj2Lists.clear();
            paramObj3Lists.clear();
        }
        if (!paramObj1Lists.isEmpty()) {
            this.executeBatch(INSERT_SQL1, paramObj1Lists);
            this.executeBatch(INSERT_SQL2, paramObj2Lists);
            if (!paramObj3Lists.isEmpty()) {
                this.executeBatch(SUBENTRY_SQL, paramObj3Lists);
            }
        }
    }

    private void addSubEntryParamObj(List<Object[]> paramObj3Lists, Long entryId, String keycolStr) {
        Map json = (Map)JSONObject.parse((String)keycolStr);
        int i = 0;
        for (Map.Entry entry : json.entrySet()) {
            paramObj3Lists.add(new Object[]{entryId, ID.genLongId(), i++, Long.parseLong(entry.getKey().toString()), new BigDecimal(entry.getValue().toString())});
        }
    }

    protected void executeBatch(String sql, List<Object[]> entrys) {
        try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_sca_diffcalcresult", (HintCondition[])new HintCondition[]{new HintCondition("fperiodid", "=", (Object)this.periodId), new HintCondition("forgid", "=", (Object)this.orgId)});
             TXHandle handle = TX.requiresNew();){
            DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)sql, entrys);
        }
    }

    private void setParamVal(String[] fieldKeys, RowX row, RowMeta rowmeta, List<Object> paramObj, boolean isDealFallDiff) {
        for (String field : fieldKeys) {
            if (!isDealFallDiff && field.contains("falldiff")) continue;
            Object val = DiffCalcHelper.getAlgoXRowVal(row, rowmeta, field, true);
            if (val instanceof BigDecimal && this.isSetAmtPricision(field)) {
                val = ((BigDecimal)val).setScale(this.amtPrecision, RoundingMode.HALF_UP);
            }
            paramObj.add(val);
        }
    }

    private boolean isSetAmtPricision(String field) {
        for (String qty : this.qtyFiled) {
            if (!field.equals(qty)) continue;
            return false;
        }
        return true;
    }
}

