/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore.function;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.util.StringUtils;
import kd.macc.sca.algox.restore.common.DiffCalcHelper;

public class DiffCheckDifftypeTranFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private String amtField = "amount";
    private boolean isDealNoUpdateCalField = false;

    public DiffCheckDifftypeTranFunction(String amtField) {
        this.amtField = amtField;
    }

    public DiffCheckDifftypeTranFunction(String amtField, boolean isDealNoUpdateCalField) {
        this.amtField = amtField;
        this.isDealNoUpdateCalField = isDealNoUpdateCalField;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        ArrayList<RowX> rows = new ArrayList<RowX>(10);
        for (RowX row : iterable) {
            if (this.isDealNoUpdateCalField) {
                this.dealNonUpdateCalFields(row);
            }
            for (String field : DiffCalcHelper.DIFF_FIELD_ARR) {
                BigDecimal val = row.getBigDecimal(this.sourceRowMeta.getFieldIndex(field));
                String type = this.getDiffTypeField(field);
                if (val == null || BigDecimal.ZERO.compareTo(val) == 0 || type == null) continue;
                RowX newRow = row.copy();
                newRow.set(this.sourceRowMeta.getFieldIndex("difftype"), (Object)type);
                newRow.set(this.sourceRowMeta.getFieldIndex(this.amtField), (Object)val);
                rows.add(newRow);
            }
        }
        for (RowX row : rows) {
            collector.collect(row);
        }
    }

    private void dealNonUpdateCalFields(RowX row) {
        String noupdatecalfields = row.getString(this.sourceRowMeta.getFieldIndex("noupdatecalfields"));
        if (StringUtils.isEmpty((String)noupdatecalfields)) {
            return;
        }
        JSONObject jsonObj = JSON.parseObject((String)noupdatecalfields);
        JSONArray arr = jsonObj.getJSONArray("setnull");
        if (arr == null || arr.isEmpty()) {
            return;
        }
        HashSet nullFields = Sets.newHashSetWithExpectedSize((int)10);
        for (int i = 0; i < arr.size(); ++i) {
            nullFields.add(arr.getString(i));
        }
        for (String nullField : nullFields) {
            if ("tracknumber".equals(nullField)) {
                row.set(this.sourceRowMeta.getFieldIndex("tracknumber"), (Object)0L);
            }
            if (!"configuredcode".equals(nullField)) continue;
            row.set(this.sourceRowMeta.getFieldIndex("configuredcode"), (Object)0L);
        }
    }

    private String getDiffTypeField(String diffField) {
        String type = null;
        switch (diffField) {
            case "orddiff": {
                type = "G";
                break;
            }
            case "invoicediff": {
                type = "H";
                break;
            }
            case "feediff": {
                type = "K";
                break;
            }
            case "stdcostupamt": {
                type = "M";
                break;
            }
            case "diffqty": {
                type = "P";
                break;
            }
            case "madediff": {
                type = "Q";
                break;
            }
            case "unjoindiffamt": {
                type = "R";
                break;
            }
            case "madeupamt": {
                type = "S";
                break;
            }
            case "otherdiff": {
                type = "T";
                break;
            }
            case "falldiff": {
                type = "C";
                break;
            }
        }
        return type;
    }
}

