/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore.function;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.macc.sca.algox.restore.common.DiffCalcDataArgs;
import kd.macc.sca.algox.restore.common.DiffCalcHelper;
import kd.macc.sca.algox.utils.BigDecimalUtils;

public class DiffTransOutCalcRadioFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private DiffCalcDataArgs args = null;

    public DiffTransOutCalcRadioFunction(DiffCalcDataArgs args) {
        this.args = args;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> iteraRows, Collector cols) {
        ArrayList listRows = Lists.newArrayList();
        for (RowX row : iteraRows) {
            listRows.add(row);
        }
        if (listRows.size() == 1) {
            for (String field : DiffCalcHelper.DIFF_FIELD_ARR) {
                ((RowX)listRows.get(0)).set(this.sourceRowMeta.getFieldIndex("comp" + field), (Object)((RowX)listRows.get(0)).getBigDecimal(this.sourceRowMeta.getFieldIndex(field)));
            }
        } else {
            int returnCode = this.factAmtCalc(listRows);
            if (returnCode == 0) {
                RowX row;
                row = (RowX)listRows.get(0);
                row.set(this.sourceRowMeta.getFieldIndex("sourcebill"), (Object)0L);
                row.set(this.sourceRowMeta.getFieldIndex("sourcebillentry"), (Object)0L);
                for (String field : DiffCalcHelper.DIFF_FIELD_ARR) {
                    row.set(this.sourceRowMeta.getFieldIndex("comp" + field), (Object)row.getBigDecimal(this.sourceRowMeta.getFieldIndex(field)));
                }
                listRows = Lists.newArrayList();
                listRows.add(row);
            }
        }
        for (RowX lRow : listRows) {
            cols.collect(lRow);
        }
    }

    private int factAmtCalc(List<RowX> listRows) {
        BigDecimal totalQty = BigDecimal.ZERO;
        BigDecimal tmpQty = BigDecimal.ZERO;
        RowX fillDiffRow = null;
        for (RowX row : listRows) {
            BigDecimal proFinQty = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("qty")));
            if (proFinQty.abs().compareTo(tmpQty.abs()) > 0) {
                tmpQty = proFinQty;
                fillDiffRow = row;
            }
            totalQty = totalQty.add(proFinQty);
        }
        if (BigDecimal.ZERO.compareTo(totalQty) == 0) {
            return 0;
        }
        for (String field : DiffCalcHelper.DIFF_FIELD_ARR) {
            BigDecimal amount = BigDecimalUtils.getBigDecimalOrZero(listRows.get(0).getBigDecimal(this.sourceRowMeta.getFieldIndex(field)));
            if (amount.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal unitCost = amount.divide(totalQty, this.args.getPricePrecision(), RoundingMode.HALF_UP);
            BigDecimal diffAmt = amount;
            for (RowX row : listRows) {
                BigDecimal proFinQty = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("qty")));
                BigDecimal cost = proFinQty.multiply(unitCost).setScale(this.args.getAmtPrecision(), RoundingMode.HALF_UP);
                row.set(this.sourceRowMeta.getFieldIndex("comp" + field), (Object)cost);
                diffAmt = diffAmt.subtract(cost);
            }
            if (fillDiffRow == null || diffAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal cost = fillDiffRow.getBigDecimal(this.sourceRowMeta.getFieldIndex("comp" + field));
            cost = cost.add(diffAmt);
            fillDiffRow.set(this.sourceRowMeta.getFieldIndex("comp" + field), (Object)cost);
        }
        return 1;
    }
}

