/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore.function;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.algox.restore.common.DiffCalcHelper;

public class DiffTransOutDealVouDataFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        ArrayList listRows = Lists.newArrayList();
        Long entryid = null;
        RowX baseRow = null;
        ArrayList wDealRows = Lists.newArrayList();
        for (RowX rowX : iterable) {
            Long tempEntryId = rowX.getLong(this.sourceRowMeta.getFieldIndex("product"));
            if (!CadEmptyUtils.isEmpty((Long)tempEntryId)) {
                entryid = tempEntryId;
                baseRow = rowX;
            } else {
                wDealRows.add(rowX);
            }
            listRows.add(rowX);
        }
        if (listRows.isEmpty()) {
            return;
        }
        if (entryid == null) {
            return;
        }
        if (!wDealRows.isEmpty()) {
            Set<String> notFillFields = this.getNotFillField();
            for (RowX row : wDealRows) {
                for (String field : this.sourceRowMeta.getFieldNames()) {
                    if (notFillFields.contains(field)) continue;
                    int index = this.sourceRowMeta.getFieldIndex(field);
                    if (baseRow == null) continue;
                    row.set(index, baseRow.get(index));
                }
                row.set(this.sourceRowMeta.getFieldIndex("element"), row.get(this.sourceRowMeta.getFieldIndex("relement")));
                row.set(this.sourceRowMeta.getFieldIndex("subelement"), row.get(this.sourceRowMeta.getFieldIndex("rsubelement")));
            }
        }
        for (RowX rowX : listRows) {
            collector.collect(rowX);
        }
    }

    private Set<String> getNotFillField() {
        HashSet fields = Sets.newHashSetWithExpectedSize((int)10);
        for (String field : DiffCalcHelper.DIFF_FIELD_ARR) {
            fields.add(field);
            fields.add("comp" + field);
            fields.add("excomp" + field);
        }
        fields.add("relement");
        fields.add("rsubelement");
        return fields;
    }
}

