/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.restore.report;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.algox.restore.function.DiffCheckDifftypeTranFunction;
import kd.macc.sca.algox.restore.function.DiffTransOutTransDiffTypeFunction;
import kd.macc.sca.algox.restore.report.DiffCheckReportArgs;
import kd.macc.sca.algox.utils.BigDecimalUtils;
import kd.macc.sca.algox.utils.DataSetXHelper;
import kd.macc.sca.algox.utils.PeriodHelper;

public class DiffCheckQueryHelper {
    private static final String ALGO_KEYPRE = "DiffCheckQuery_";
    public static final Log logger = LogFactory.getLog(DiffCheckQueryHelper.class);
    private static final String[] GROUP_MAT = new String[]{"org", "costaccount", "period", "material", "difftype"};
    private static final String[] GROUP_MAT_CONFIG = new String[]{"org", "costaccount", "period", "material", "configuredcode", "difftype"};
    private static final String[] GROUP_MAT_CONFIG_TRACK = new String[]{"org", "costaccount", "period", "material", "configuredcode", "tracknumber", "difftype"};

    public static DataSet queryDiff(DiffCheckReportArgs args) {
        String dyfftypeInSql = DiffCheckQueryHelper.getArrayStrInSql(args.getDiffTypes());
        String diffTypeSql = "difftype in (" + dyfftypeInSql + ")";
        return DiffCheckQueryHelper.getResultDs(args, diffTypeSql);
    }

    private static DataSet getResultDs(final DiffCheckReportArgs args, String diffTypeSql) {
        OrmInput diffAllocDs = DiffCheckQueryHelper.getDiffAllocDs(args);
        OrmInput finishDs = DiffCheckQueryHelper.getDiffFinishDs(args);
        OrmInput unAbsoubDs = DiffCheckQueryHelper.getDiffUnAbsoubDs(args);
        OrmInput diffadjustDs = DiffCheckQueryHelper.getDiffAdjustDs(args);
        OrmInput costobjectDs = null;
        if (!args.isDisplayunallocdiff()) {
            costobjectDs = DiffCheckQueryHelper.getCostObjectNotUnallocDs(args);
        }
        JobSession session = AlgoX.createSession((String)"DiffCheckQuery-check");
        DataSetX diffAllocDsX = session.fromInput((Input)diffAllocDs);
        DataSetX finishDsX = session.fromInput((Input)finishDs);
        DataSetX unAbsoubDsX = session.fromInput((Input)unAbsoubDs);
        DataSetX diffadjustDsX = session.fromInput((Input)diffadjustDs);
        diffadjustDsX = diffadjustDsX.map(new MapFunction(){

            public RowMeta getResultRowMeta() {
                return this.sourceRowMeta;
            }

            public RowX map(RowX row) {
                Long period = row.getLong(this.sourceRowMeta.getFieldIndex("period"));
                if (CadEmptyUtils.isEmpty((Long)period)) {
                    row.set(this.sourceRowMeta.getFieldIndex("period"), (Object)args.getPeriod());
                }
                return row;
            }
        });
        DataSetX costobjectDsX = null;
        if (costobjectDs != null) {
            costobjectDsX = session.fromInput((Input)costobjectDs);
            costobjectDsX = costobjectDsX.distinct(new String[]{"rcostobject"});
            diffAllocDsX = diffAllocDsX.join(costobjectDsX).on("costobject", "rcostobject").select(diffAllocDsX.getRowMeta().getFieldNames(), new String[]{"rcostobject"});
            finishDsX = finishDsX.join(costobjectDsX).on("costobject", "rcostobject").select(finishDsX.getRowMeta().getFieldNames(), new String[]{"rcostobject"});
            unAbsoubDsX = unAbsoubDsX.join(costobjectDsX).on("costobject", "rcostobject").select(unAbsoubDsX.getRowMeta().getFieldNames(), new String[]{"rcostobject"});
        }
        unAbsoubDsX = unAbsoubDsX.map((MapFunction)new DiffTransOutTransDiffTypeFunction());
        finishDsX = finishDsX.map((MapFunction)new DiffTransOutTransDiffTypeFunction());
        String[] groupArr = GROUP_MAT;
        if ("2".equals(args.getDisplaymodel())) {
            groupArr = GROUP_MAT_CONFIG;
        } else if ("3".equals(args.getDisplaymodel())) {
            groupArr = GROUP_MAT_CONFIG_TRACK;
        }
        diffAllocDsX = diffAllocDsX.addFields(new Field[]{new Field("difftype", (DataType)DataType.StringType)}, new Object[]{""});
        diffAllocDsX = DataSetXHelper.addBigDecimalFields(diffAllocDsX, new String[]{"allocamt"});
        diffAllocDsX = diffAllocDsX.groupBy(new String[]{"entryid"}).reduceGroup((GroupReduceFunction)new DiffCheckDifftypeTranFunction("allocamt"));
        diffAllocDsX = diffAllocDsX.groupBy(groupArr).sum("allocamt");
        diffadjustDsX = diffadjustDsX.addFields(new Field[]{new Field("difftype", (DataType)DataType.StringType)}, new Object[]{""});
        diffadjustDsX = DataSetXHelper.addBigDecimalFields(diffadjustDsX, new String[]{"adjustamt"});
        diffadjustDsX = diffadjustDsX.groupBy(new String[]{"entryid"}).reduceGroup((GroupReduceFunction)new DiffCheckDifftypeTranFunction("adjustamt", true));
        diffAllocDsX = DataSetXHelper.addBigDecimalFields(diffAllocDsX, new String[]{"finishamt", "adjustamt", "unabsamt"});
        DataSetX resultDsx = DataSetXHelper.unionIfRowDiff(diffAllocDsX, finishDsX);
        resultDsx = DataSetXHelper.unionIfRowDiff(resultDsx, unAbsoubDsX);
        resultDsx = DataSetXHelper.unionIfRowDiff(resultDsx, diffadjustDsX);
        resultDsx = resultDsx.groupBy(groupArr).sum("allocamt").sum("finishamt").sum("unabsamt").sum("adjustamt");
        resultDsx = DataSetXHelper.addBigDecimalFields(resultDsx, new String[]{"diffamount"});
        resultDsx = resultDsx.map(new MapFunction(){

            public RowMeta getResultRowMeta() {
                return this.sourceRowMeta;
            }

            public RowX map(RowX row) {
                BigDecimal finishamt = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("finishamt")));
                BigDecimal allocamt = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("allocamt")));
                BigDecimal unabsamt = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("unabsamt")));
                BigDecimal adjustamt = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("adjustamt")));
                BigDecimal diffamount = finishamt.add(allocamt).add(unabsamt).subtract(adjustamt);
                row.set(this.sourceRowMeta.getFieldIndex("diffamount"), (Object)diffamount);
                return row;
            }
        });
        if (args.isShowdiffonly()) {
            resultDsx = resultDsx.filter("diffamount!=0");
        }
        DataSetX sumbDsx = resultDsx.map(new MapFunction(){

            public RowMeta getResultRowMeta() {
                return this.sourceRowMeta;
            }

            public RowX map(RowX row) {
                row.set(this.sourceRowMeta.getFieldIndex("difftype"), (Object)"0");
                return row;
            }
        });
        sumbDsx = sumbDsx.groupBy(groupArr).sum("allocamt").sum("finishamt").sum("unabsamt").sum("adjustamt").sum("diffamount");
        DataSetX countAllDsx = sumbDsx.map(new MapFunction(){

            public RowMeta getResultRowMeta() {
                return this.sourceRowMeta;
            }

            public RowX map(RowX row) {
                if (this.sourceRowMeta.getFieldIndex("configuredcode", false) >= 0) {
                    row.set(this.sourceRowMeta.getFieldIndex("configuredcode"), (Object)0L);
                }
                if (this.sourceRowMeta.getFieldIndex("tracknumber", false) >= 0) {
                    row.set(this.sourceRowMeta.getFieldIndex("tracknumber"), (Object)0L);
                }
                row.set(this.sourceRowMeta.getFieldIndex("difftype"), (Object)"1");
                row.set(this.sourceRowMeta.getFieldIndex("org"), (Object)0L);
                row.set(this.sourceRowMeta.getFieldIndex("costaccount"), (Object)0L);
                row.set(this.sourceRowMeta.getFieldIndex("period"), (Object)0L);
                row.set(this.sourceRowMeta.getFieldIndex("material"), (Object)0L);
                return row;
            }
        });
        countAllDsx = countAllDsx.groupBy(groupArr).sum("allocamt").sum("finishamt").sum("unabsamt").sum("adjustamt").sum("diffamount");
        if (args.isShowdiffdetail()) {
            resultDsx = resultDsx.filter(diffTypeSql);
            resultDsx = resultDsx.union(sumbDsx);
        } else {
            resultDsx = sumbDsx;
        }
        resultDsx = resultDsx.union(countAllDsx);
        resultDsx = resultDsx.orderBy(new String[]{"material asc", "difftype desc"});
        DataSetOutput resultSet = new DataSetOutput(resultDsx.getRowMeta());
        resultDsx.output((Output)resultSet);
        try {
            long start = System.currentTimeMillis();
            session.commit(20, TimeUnit.MINUTES);
            logger.info("\u5dee\u5f02\u5bf9\u6570\u62a5\u8868\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            logger.error("\u5dee\u5f02\u5bf9\u6570\u62a5\u8868\u51fa\u9519\uff1a", (Throwable)e);
            throw e;
        }
        return session.readDataSet(resultSet.getId());
    }

    private static OrmInput getCostObjectNotUnallocDs(DiffCheckReportArgs args) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("costaccount", "=", (Object)args.getCostaccountId());
        filter.and("period", "=", (Object)args.getPeriod());
        if (!CadEmptyUtils.isEmpty(args.getCostcenters())) {
            filter.and("costcenter", "in", args.getCostcenters());
        }
        filter.and("isunallocdiff", "=", (Object)Boolean.FALSE);
        filter.and("entryentity1.type1", "=", (Object)"5");
        if (!CadEmptyUtils.isEmpty(args.getProducts())) {
            filter.and(new QFilter("becostobject.material.masterid", "in", args.getProducts()));
        }
        return new OrmInput("DiffCheckQuery_result", "sca_diffcalcresult", "entryentity1.relacostobject1 rcostobject", filter.toArray());
    }

    private static OrmInput getDiffAllocDs(DiffCheckReportArgs args) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("costaccount", "=", (Object)args.getCostaccountId());
        filter.and("period", "=", (Object)args.getPeriod());
        if (!CadEmptyUtils.isEmpty(args.getCostcenters())) {
            filter.and("costcenter", "in", args.getCostcenters());
        }
        filter.and("biztype", "=", (Object)"00");
        if (!CadEmptyUtils.isEmpty(args.getProducts())) {
            filter.and(new QFilter("becostobject.material.masterid", "in", args.getProducts()));
        }
        String allocSelectFields = "entryentity.id entryid,org,costaccount,period,becostobject costobject,becostobject.material.masterid material,becostobject.calckeycol.configuredcode configuredcode,becostobject.calckeycol.tracknumber tracknumber,entryentity.orddiff as orddiff,entryentity.invoicediff as invoicediff,entryentity.feediff as feediff,entryentity.diffqty as diffqty,entryentity.madediff as madediff,entryentity.unjoindiffamt as unjoindiffamt,entryentity.stdcostupamt as stdcostupamt,entryentity.madeupamt as madeupamt,entryentity.otherdiff as otherdiff,entryentity.falldiff as falldiff,entryentity.reservediffx as reservediffx,entryentity.reservediffw as reservediffw,entryentity.reservediffy as reservediffy";
        return new OrmInput("DiffCheckQuery_diffalloc", "sca_purchdiffalloc", allocSelectFields, filter.toArray());
    }

    private static OrmInput getDiffFinishDs(DiffCheckReportArgs args) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("costaccount", "=", (Object)args.getCostaccountId());
        filter.and("period", "=", (Object)args.getPeriod());
        if (!CadEmptyUtils.isEmpty(args.getCostcenters())) {
            filter.and("costcenter", "in", args.getCostcenters());
        }
        if (!CadEmptyUtils.isEmpty(args.getProducts())) {
            filter.and(new QFilter("costobject.material.masterid", "in", args.getProducts()));
        }
        String finsihSelectFields = "org,costaccount,period,costobject,costobject.material.masterid material,costobject.calckeycol.configuredcode configuredcode,costobject.calckeycol.tracknumber tracknumber,entryentity.difftype difftype,entryentity.amount finishamt";
        return new OrmInput("DiffCheckQuery_finish", "sca_finishdiffbill", finsihSelectFields, filter.toArray());
    }

    private static OrmInput getDiffUnAbsoubDs(DiffCheckReportArgs args) {
        QFilter filter = new QFilter("org", "=", (Object)args.getOrgId());
        filter.and("costaccount", "=", (Object)args.getCostaccountId());
        filter.and("period", "=", (Object)args.getPeriod());
        if (!CadEmptyUtils.isEmpty(args.getCostcenters())) {
            filter.and("costcenter", "in", args.getCostcenters());
        }
        if (!CadEmptyUtils.isEmpty(args.getProducts())) {
            filter.and(new QFilter("costobject.material.masterid", "in", args.getProducts()));
        }
        String unabsorbSelectFields = "org,costaccount,period,costobject,costobject.material.masterid material,costobject.calckeycol.configuredcode configuredcode,costobject.calckeycol.tracknumber tracknumber,difftype,entryentity.amount unabsamt";
        return new OrmInput("DiffCheckQuery_unabsorb", "sca_unabsorbdiff", unabsorbSelectFields, filter.toArray());
    }

    private static OrmInput getDiffAdjustDs(DiffCheckReportArgs args) {
        QFilter filter = new QFilter("calorg", "=", (Object)args.getOrgId());
        filter.and("costaccount", "=", (Object)args.getCostaccountId());
        Date[] date = PeriodHelper.getPeriodStartAndEndTime(args.getPeriod());
        filter.and("bookdate", ">=", (Object)date[0]);
        filter.and("bookdate", "<=", (Object)date[1]);
        filter.and("biztype", "=", (Object)"A");
        filter.and("srcsys", "=", (Object)"B");
        filter.and("createtype", "in", (Object)Sets.newHashSet((Object[])new String[]{"W", "Y", "Z"}));
        if (!args.isDisplayunallocdiff()) {
            filter.and("isupdatecost", "=", (Object)"1");
        }
        if (!CadEmptyUtils.isEmpty(args.getProducts())) {
            filter.and("entryentity.material.masterid", "in", args.getProducts());
        }
        logger.info("getDiffAdjustDs-{}", (Object)filter);
        String adjustSelectFields = "entryentity.id entryid,calorg org,costaccount,period,entryentity.material.masterid material,entryentity.configuredcode configuredcode,entryentity.tracknumber tracknumber,entryentity.noupdatecalfields noupdatecalfields,entryentity.diff_g AS orddiff,entryentity.diff_h AS invoicediff,entryentity.diff_k AS feediff,entryentity.diff_p AS diffqty,entryentity.diff_q AS madediff,entryentity.diff_r AS unjoindiffamt,entryentity.diff_m AS stdcostupamt,entryentity.diff_s AS madeupamt,entryentity.diff_t AS otherdiff,entryentity.diff_c AS falldiff,entryentity.diff_x AS reservediffx,entryentity.diff_w AS reservediffw,entryentity.diff_y AS reservediffy";
        return new OrmInput("DiffCheckQuery_adjuest", "cal_stdcostdiffbill", adjustSelectFields, filter.toArray());
    }

    private static String getArrayStrInSql(String[] difftypes) {
        if (difftypes == null || difftypes.length == 0) {
            return "'0'";
        }
        StringBuilder sb = new StringBuilder();
        for (String type : difftypes) {
            sb.append("'").append(type).append("',");
        }
        return sb.toString().substring(0, sb.length() - 1);
    }

    private static QFilter getBillTypeFilter() {
        QFilter billformidQF = new QFilter("billformid", "in", (Object)new String[]{"im_productinbill", "im_mdc_mftreturnbill", "im_mdc_mftmanuinbill", "im_mdc_omcmplinbill", "om_mftorder", "pom_mftorder"});
        DynamicObjectCollection billtypes = QueryServiceHelper.query((String)"bos_billtype", (String)"id", (QFilter[])new QFilter[]{billformidQF});
        ArrayList<Long> billTypeList = new ArrayList<Long>(10);
        for (DynamicObject billtype : billtypes) {
            billTypeList.add(billtype.getLong("id"));
        }
        return new QFilter("billtype", "in", billTypeList);
    }
}

