/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.task;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.macc.sca.algox.calc.input.CalcDataArgs;
import kd.macc.sca.algox.calc.input.CalcMaterial;
import kd.macc.sca.algox.calc.input.CompleteProduct;
import kd.macc.sca.algox.calc.input.CostObject;
import kd.macc.sca.algox.calc.input.SubElement;
import kd.macc.sca.algox.calc.output.InventoryAccountCostResult;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.CommonUtils;
import kd.macc.sca.algox.utils.DiffAllocHelper;

public class ServiceHelper {
    private static final Log logger = LogFactory.getLog(ServiceHelper.class);
    public static final int RUN_TASK_NUM = 15;
    public static final int BATCH_SIZE = 200;
    private static final Set<String> completedTaskStatus = new HashSet<String>(16){
        private static final long serialVersionUID = 1L;
        {
            this.add("COMPLETED");
            this.add("FAILED");
            this.add("TIMEOUT");
            this.add("ABORTED");
            this.add("SKIP");
        }
    };

    public static void putCurrMatAllocToCal(CalcDataArgs args) {
        Set<CalcMaterial> curCalcMats = args.getCurCalcMat();
        HashMap<String, Object> commonParam = new HashMap<String, Object>();
        commonParam.put("allocmodel", "A");
        commonParam.put("carryrule", "A");
        commonParam.put("iswriterpt", true);
        commonParam.put("iswriteerrrpt", false);
        commonParam.put("matconditiontype", "A");
        commonParam.put("runjob", false);
        commonParam.put("isFirstStep", false);
        if (args.getParallel().booleanValue()) {
            commonParam.put("isParallel", true);
        } else {
            commonParam.put("isParallel", false);
        }
        commonParam.put("isLastLevel", args.isIslastLevel());
        logger.info("++++++++++++ServiceHelper\u4f20\u9012\u7684isLastLevel\uff1a" + args.isIslastLevel());
        ArrayList bizParamList = new ArrayList();
        HashMap<String, Serializable> bizParam = new HashMap<String, Serializable>();
        bizParam.put("costaccount", args.getCostAccount());
        HashSet<Long> materialids = new HashSet<Long>(16);
        for (CalcMaterial curCalcMat : curCalcMats) {
            materialids.add(curCalcMat.getMaterialId());
        }
        bizParam.put("materials", materialids);
        bizParamList.add(bizParam);
        try {
            if (!CadEmptyUtils.isEmpty(materialids)) {
                DispatchServiceHelper.invokeBizService((String)"fi", (String)"calx", (String)"DiffAllocService", (String)"diffAlloc", (Object[])new Object[]{commonParam, bizParamList});
            }
        }
        catch (Exception var8) {
            logger.error("\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u5fae\u670d\u52a1DiffAllocService\u7684diffAlloc\u65b9\u6cd5\u5931\u8d25\u3002", (Throwable)var8);
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u5fae\u670d\u52a1DiffAllocService\u7684diffAlloc\u65b9\u6cd5\u5931\u8d25\u3002", (String)"ServiceHelper_1", (String)"macc-sca-algox", (Object[])new Object[0]));
        }
    }

    public static void putAllMatAllocToCal(CalcDataArgs args, Set<CalcMaterial> allCalcMats) {
        if (allCalcMats != null) {
            HashMap<String, Object> commonParam = new HashMap<String, Object>();
            commonParam.put("allocmodel", "A");
            commonParam.put("carryrule", "A");
            commonParam.put("iswriterpt", true);
            commonParam.put("iswriteerrrpt", false);
            commonParam.put("matconditiontype", "B");
            commonParam.put("runjob", false);
            commonParam.put("isFirstStep", true);
            if (args.getParallel().booleanValue()) {
                commonParam.put("isParallel", true);
            } else {
                commonParam.put("isParallel", false);
            }
            commonParam.put("isLastLevel", args.isIslastLevel());
            ArrayList bizParamList = new ArrayList(16);
            HashMap<String, Serializable> bizParam = new HashMap<String, Serializable>();
            bizParam.put("costaccount", args.getCostAccount());
            double size = (double)allCalcMats.size() / 0.75 + 1.0;
            HashSet<Long> materialids = new HashSet<Long>((int)size);
            for (CalcMaterial allCalcMat : allCalcMats) {
                materialids.add(allCalcMat.getMaterialId());
            }
            bizParam.put("materials", materialids);
            bizParamList.add(bizParam);
            try {
                if (!CadEmptyUtils.isEmpty(materialids)) {
                    DispatchServiceHelper.invokeBizService((String)"fi", (String)"calx", (String)"DiffAllocService", (String)"diffAlloc", (Object[])new Object[]{commonParam, bizParamList});
                    logger.info("\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u5fae\u670d\u52a1DiffAllocService\u7684diffAlloc\u65b9\u6cd5\u6210\u529f\u3002" + ((Object)commonParam).toString());
                }
            }
            catch (Exception var8) {
                logger.error("\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u5fae\u670d\u52a1DiffAllocService\u7684diffAlloc\u65b9\u6cd5\u5931\u8d25\u3002", (Throwable)var8);
                throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u5fae\u670d\u52a1DiffAllocService\u7684diffAlloc\u65b9\u6cd5\u5931\u8d25\u3002", (String)"ServiceHelper_1", (String)"macc-sca-algox", (Object[])new Object[0]));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void putCostInfoToCalSystem(Set<CalcMaterial> mats, CalcDataArgs args, Map<Long, List<InventoryAccountCostResult>> inventoryAccountCostResultMap) {
        List<CompleteProduct> completeProducts;
        Map<Long, List<CompleteProduct>> resultMap = ServiceHelper.aggregateByBillId(mats);
        Map<Long, List<CompleteProduct>> costObjIdAndCompleteProductMap = ServiceHelper.aggregateByCostObjId(resultMap);
        HashMap<Long, void> costObjIdAndTotalQtyMap = new HashMap<Long, void>(16);
        for (Map.Entry<Long, List<CompleteProduct>> entry : costObjIdAndCompleteProductMap.entrySet()) {
            void var8_11;
            BigDecimal bigDecimal = BigDecimal.ZERO;
            completeProducts = entry.getValue();
            for (CompleteProduct completeProduct : completeProducts) {
                BigDecimal bigDecimal2 = var8_11.add(completeProduct.getQty());
            }
            costObjIdAndTotalQtyMap.put(entry.getKey(), var8_11);
        }
        ArrayList resultCostInfoList = new ArrayList(10);
        for (Map.Entry<Long, List<CompleteProduct>> entry : resultMap.entrySet()) {
            completeProducts = entry.getValue();
            if (completeProducts.size() <= 0) continue;
            for (CompleteProduct completeProduct : completeProducts) {
                HashMap<String, Serializable> resultCostInfoMap = new HashMap<String, Serializable>(16);
                Long sourceBillEntryId = completeProduct.getSourceBillEntryId();
                resultCostInfoMap.put("bizbillentryid", sourceBillEntryId);
                resultCostInfoMap.put("costaccount", args.getCostAccount());
                BigDecimal qty = completeProduct.getQty();
                BigDecimal totalQty = (BigDecimal)costObjIdAndTotalQtyMap.get(completeProduct.getCostObjectId());
                BigDecimal scale = qty.divide(totalQty, 10, 4);
                ArrayList costInfoList = new ArrayList(10);
                for (SubElement subElement : completeProduct.getSubElements()) {
                    HashMap<String, Number> costInfoMap = new HashMap<String, Number>(16);
                    Long subElementId = subElement.getId();
                    costInfoMap.put("costsubelement", subElementId);
                    BigDecimal finishedProductAmount = subElement.getFinishedProductAmount();
                    finishedProductAmount = finishedProductAmount.multiply(scale);
                    BigDecimal finishedQty = subElement.getFinishedProductQty();
                    finishedQty = finishedQty.multiply(scale);
                    costInfoMap.put("cost", finishedProductAmount);
                    costInfoList.add(costInfoMap);
                    Long costObjectId = completeProduct.getCostObjectId();
                    List<InventoryAccountCostResult> inventoryAccountCostResults = inventoryAccountCostResultMap.get(costObjectId);
                    if (inventoryAccountCostResults == null) {
                        inventoryAccountCostResults = new ArrayList<InventoryAccountCostResult>(10);
                        inventoryAccountCostResultMap.put(costObjectId, inventoryAccountCostResults);
                    }
                    InventoryAccountCostResult inventoryAccountCostResult = new InventoryAccountCostResult();
                    inventoryAccountCostResult.setAssociatedSourceBillId(completeProduct.getSourceBillId());
                    inventoryAccountCostResult.setAssociatedSourceBillEntryId(sourceBillEntryId);
                    inventoryAccountCostResult.setAmount(finishedProductAmount);
                    inventoryAccountCostResult.setQty(finishedQty);
                    inventoryAccountCostResult.setSubElementId(subElementId);
                    inventoryAccountCostResults.add(inventoryAccountCostResult);
                }
                resultCostInfoMap.put("costinfo", costInfoList);
                resultCostInfoList.add(resultCostInfoMap);
            }
        }
        try {
            HashMap hashMap;
            if (!CadEmptyUtils.isEmpty(resultCostInfoList) && (hashMap = (HashMap)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CostRecordCostUpdateService", (String)"updateCostByCostSubElement", (Object[])new Object[]{resultCostInfoList})) != null && hashMap.size() > 0) {
                logger.error("\u5b58\u8d27\u6838\u7b97\u5fae\u670d\u52a1\u8fd4\u56de\u5931\u8d25\u7ed3\u679c\u3002", (Throwable)new KDBizException(((Object)hashMap).toString()));
            }
        }
        catch (Exception exception) {
            logger.error("\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u5fae\u670d\u52a1updateCostByCostSubElement\u5931\u8d25\u3002", (Throwable)exception);
        }
    }

    private static Map<Long, List<CompleteProduct>> aggregateByCostObjId(Map<Long, List<CompleteProduct>> resultMap) {
        HashMap<Long, List<CompleteProduct>> costObjIdAndCompleteProductMap = new HashMap<Long, List<CompleteProduct>>(16);
        for (Map.Entry<Long, List<CompleteProduct>> entry : resultMap.entrySet()) {
            List<CompleteProduct> completeProducts = entry.getValue();
            for (CompleteProduct completeProduct : completeProducts) {
                Long costObjectId = completeProduct.getCostObjectId();
                ArrayList<CompleteProduct> completeProductList = (ArrayList<CompleteProduct>)costObjIdAndCompleteProductMap.get(costObjectId);
                if (completeProductList == null) {
                    completeProductList = new ArrayList<CompleteProduct>(10);
                    completeProductList.add(completeProduct);
                    costObjIdAndCompleteProductMap.put(costObjectId, completeProductList);
                    continue;
                }
                completeProductList.add(completeProduct);
            }
        }
        return costObjIdAndCompleteProductMap;
    }

    private static Map<Long, List<CompleteProduct>> aggregateByBillId(Set<CalcMaterial> mats) {
        HashMap<Long, List<CompleteProduct>> resultMap = new HashMap<Long, List<CompleteProduct>>(16);
        for (CalcMaterial mat : mats) {
            CostObject costObjForCalculate = mat.getCostObjForCalculate();
            if (costObjForCalculate == null) continue;
            List<CompleteProduct> completeProducts = costObjForCalculate.getCompleteProducts();
            for (CompleteProduct completeProduct : completeProducts) {
                Long completeBillId = completeProduct.getCompleteBillId();
                ArrayList<CompleteProduct> completeProductList = (ArrayList<CompleteProduct>)resultMap.get(completeBillId);
                if (completeProductList == null) {
                    completeProductList = new ArrayList<CompleteProduct>(10);
                    completeProductList.add(completeProduct);
                    resultMap.put(completeBillId, completeProductList);
                    continue;
                }
                completeProductList.add(completeProduct);
            }
        }
        return resultMap;
    }

    public static void transOutCostDiffInfoToCalSystem(CalcDataArgs args, Set<Map<String, Object>> stdCostDiffBillSet) {
        if (args.getParallel().booleanValue()) {
            ServiceHelper.transOutBillByTask(stdCostDiffBillSet);
        } else {
            ServiceHelper.transOutBill(stdCostDiffBillSet);
        }
    }

    public static void deleteCalDiffBills(CalcDataArgs args, Set<CalcMaterial> allCalcMat) {
        Long periodId = args.getPeriod();
        Long costAccountId = args.getCostAccount();
        HashSet<Long> materialids = new HashSet<Long>(16);
        materialids.add(0L);
        for (CalcMaterial mat : allCalcMat) {
            materialids.add(mat.getMaterialId());
        }
        QFilter filter = new QFilter("period.id", "=", (Object)periodId);
        filter.and("costaccount.id", "=", (Object)costAccountId);
        filter.and("billsrctype", "=", (Object)"D");
        filter.and("isvoucher", "=", (Object)"0");
        DataSet bills = QueryServiceHelper.queryDataSet((String)"", (String)"cal_costadjustbill", (String)"id,entryentity.material.id as materialid,entryentity.accounttype as accounttype", (QFilter[])new QFilter[]{filter}, null);
        ArrayList<Long> billids = new ArrayList<Long>(16);
        ArrayList<Long> actCostBillIds = new ArrayList<Long>(16);
        for (Row bill : bills) {
            if ("D".equals(bill.getString("accounttype"))) {
                billids.add(bill.getLong("id"));
                materialids.add(bill.getLong("materialid"));
                continue;
            }
            actCostBillIds.add(bill.getLong("id"));
        }
        ServiceHelper.deleteActAdjustBill(actCostBillIds);
        boolean isNewPeriodBal = (Boolean)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBalanceService", (String)"isNewPeriodBal", null);
        if (isNewPeriodBal) {
            ServiceHelper.deleteNewBalaActAdjustBill(billids);
        } else {
            ServiceHelper.deleteAdjBillBySql(billids);
            DiffAllocHelper.recalPurDiffBatch(costAccountId, periodId, materialids);
            DiffAllocHelper.recalCalcBalanceBatch(costAccountId, periodId, materialids, args.getParallel());
        }
    }

    public static void recalCalcBalance(CalcDataArgs args) {
        Long periodId = args.getPeriod();
        Long costAccountId = args.getCostAccount();
        QFilter filter = new QFilter("period.id", "=", (Object)periodId);
        filter.and("costaccount.id", "=", (Object)costAccountId);
        filter.and("billsrctype", "=", (Object)"D");
        DataSet bills = QueryServiceHelper.queryDataSet((String)"kd.macc.sca.algox.task.ServiceHelper", (String)"cal_costadjustbill", (String)"id,entryentity.material.id as materialid", (QFilter[])new QFilter[]{filter}, null);
        HashSet<Long> materialids = new HashSet<Long>(16);
        materialids.add(0L);
        for (Row bill : bills) {
            materialids.add(bill.getLong("materialid"));
        }
        DiffAllocHelper.recalCalcBalanceBatch(costAccountId, periodId, materialids, args.getParallel());
        DiffAllocHelper.recalPurDiffBatch(costAccountId, periodId, materialids);
    }

    public static void deleteAdjBillBySql(List<Long> adjBillIds) {
        logger.info("--------------ServiceHelper.deleteAdjBillBySql >delete all adjBillsList size:" + adjBillIds.size());
        StringBuilder billIds = new StringBuilder();
        Lists.partition(adjBillIds, (int)5000).forEach(list -> {
            long beginTime = System.currentTimeMillis();
            billIds.setLength(0);
            for (Long billId : list) {
                billIds.append(",").append(billId);
            }
            String deleBillDetailSql = "delete from t_cal_costadjust_detail where fentryid in ( select fentryid from t_cal_costadjustbillentry where fid in ( " + billIds.substring(1) + "))";
            String deleBillEntrySql = " delete from t_cal_costadjustbillentry where fid in (" + billIds.substring(1) + ")";
            String deleBillSql = "delete from t_cal_costadjustbill where fid in (" + billIds.substring(1) + ")";
            DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (String)deleBillDetailSql);
            DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (String)deleBillEntrySql);
            DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (String)deleBillSql);
            long endTime = System.currentTimeMillis();
            logger.info("--------------ServiceHelper.deleteAdjBillBySql ->delete lot adjBillList size:" + list.size());
            logger.info("--------------ServiceHelper.deleteAdjBillBySql ->delete lot adjBillList time:" + (endTime - beginTime));
        });
    }

    private static void deleteActAdjustBill(List<Long> auditBillIds) {
        QFilter filter = new QFilter("id", "in", auditBillIds);
        filter.and("billstatus", "=", (Object)"C");
        DataSet bills = QueryServiceHelper.queryDataSet((String)"", (String)"cal_costadjustbill", (String)"id", (QFilter[])new QFilter[]{filter}, null);
        ArrayList<Long> auditBills = new ArrayList<Long>(16);
        for (Row bill : bills) {
            auditBills.add(bill.getLong("id"));
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("diffAlloc", "true");
        option.setVariableValue("ignoreValidation", "true");
        Lists.partition(auditBills, (int)2000).forEach(list -> {
            long beginTime = System.currentTimeMillis();
            OperationResult operResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"cal_costadjust_subentity", (Object[])list.toArray(), (OperateOption)option);
            List idList = operResult.getSuccessPkIds();
            if (operResult.isSuccess()) {
                QFilter deleFilter = new QFilter("id", "in", (Object)idList);
                DeleteServiceHelper.delete((String)"cal_costadjust_subentity", (QFilter[])deleFilter.toArray());
            } else if (operResult.getAllErrorOrValidateInfo() != null && operResult.getAllErrorOrValidateInfo().size() > 0) {
                ArrayList<String> errors = new ArrayList<String>(operResult.getAllErrorOrValidateInfo().size());
                for (IOperateInfo operatorInfo : operResult.getAllErrorOrValidateInfo()) {
                    errors.add(operatorInfo.getMessage());
                }
                logger.error("----------ServiceHelper.deleteActAdjustBill->delete fail:" + ((Object)errors).toString());
            }
            long endTime = System.currentTimeMillis();
            logger.info("--------------ServiceHelper.deleteActAdjustBill->delete lot adjBillList size:" + list.size());
            logger.info("--------------ServiceHelper.deleteActAdjustBill->delete lot adjBillList time:" + (endTime - beginTime));
        });
        QFilter filter1 = new QFilter("id", "in", auditBillIds);
        filter1.and("billstatus", "!=", (Object)"C");
        DataSet deleteBills = QueryServiceHelper.queryDataSet((String)"", (String)"cal_costadjustbill", (String)"id", (QFilter[])new QFilter[]{filter1}, null);
        ArrayList<Long> deleteBillIds = new ArrayList<Long>(16);
        for (Row deletebill : deleteBills) {
            deleteBillIds.add(deletebill.getLong("id"));
        }
        QFilter deleFilter = new QFilter("id", "in", deleteBillIds);
        DeleteServiceHelper.delete((String)"cal_costadjust_subentity", (QFilter[])deleFilter.toArray());
    }

    private static void deleteNewBalaActAdjustBill(List<Long> billids) {
        QFilter filter = new QFilter("id", "in", billids);
        filter.and("billstatus", "=", (Object)"C");
        DataSet bills = QueryServiceHelper.queryDataSet((String)"", (String)"cal_costadjustbill", (String)"id", (QFilter[])new QFilter[]{filter}, null);
        ArrayList<Long> auditBills = new ArrayList<Long>(16);
        for (Row bill : bills) {
            auditBills.add(bill.getLong("id"));
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("diffAlloc", "true");
        option.setVariableValue("ignoreValidation", "true");
        Lists.partition(auditBills, (int)2000).forEach(list -> {
            OperationResult operResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"cal_costadjust_subentity", (Object[])list.toArray(), (OperateOption)option);
            List idList = operResult.getSuccessPkIds();
            if (!operResult.isSuccess() && operResult.getAllErrorOrValidateInfo() != null && operResult.getAllErrorOrValidateInfo().size() > 0) {
                ArrayList<String> errors = new ArrayList<String>(operResult.getAllErrorOrValidateInfo().size());
                for (IOperateInfo operatorInfo : operResult.getAllErrorOrValidateInfo()) {
                    errors.add(operatorInfo.getMessage());
                }
                logger.error("----------ServiceHelper.deleteActAdjustBill->delete fail:" + ((Object)errors).toString());
            }
        });
        QFilter filter1 = new QFilter("id", "in", billids);
        filter1.and("billstatus", "!=", (Object)"C");
        DataSet deleteBills = QueryServiceHelper.queryDataSet((String)"", (String)"cal_costadjustbill", (String)"id", (QFilter[])new QFilter[]{filter1}, null);
        ArrayList<Long> deleteBillIds = new ArrayList<Long>(16);
        for (Row deletebill : deleteBills) {
            deleteBillIds.add(deletebill.getLong("id"));
        }
        QFilter deleFilter = new QFilter("id", "in", deleteBillIds);
        DeleteServiceHelper.delete((String)"cal_costadjust_subentity", (QFilter[])deleFilter.toArray());
    }

    private static void transOutBill(Set<Map<String, Object>> stdCostDiffBillSet) {
        try {
            if (!stdCostDiffBillSet.isEmpty()) {
                DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalStandardCostDiffBillService", (String)"buildDiffBill", (Object[])new Object[]{stdCostDiffBillSet});
            }
            logger.info("\u5dee\u5f02\u8f6c\u51fa\u8c03\u7528\u5b58\u8d27\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355\u751f\u6210\u63a5\u53e3\u6210\u529f");
        }
        catch (Exception var2) {
            logger.error("\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u5fae\u670d\u52a1\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355\u751f\u6210\u63a5\u53e3CalStandardCostDiffBillService.buildDiffBill\u5931\u8d25\u3002", (Throwable)var2);
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u5fae\u670d\u52a1\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355\u751f\u6210\u63a5\u53e3CalStandardCostDiffBillService.buildDiffBill\u5931\u8d25\u3002", (String)"ServiceHelper_6", (String)"macc-sca-algox", (Object[])new Object[0]));
        }
    }

    private static void transOutBillByTask(Set<Map<String, Object>> stdCostDiffBillSet) {
        if (stdCostDiffBillSet == null || stdCostDiffBillSet.isEmpty()) {
            return;
        }
        List<Set<Map<String, Object>>> batchList = ServiceHelper.spritBatch(stdCostDiffBillSet);
        logger.info("ServiceHelper_transOutBillByTask_batchList.size:" + batchList.size());
        int batchIndex = 1;
        HashSet<String> taskIds = new HashSet<String>(16);
        taskIds.add("12321412");
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, calendar.get(11) - 1);
        QFilter taskFilter = new QFilter("id", "in", taskIds);
        taskFilter.and("status", "=", (Object)"BEGIN");
        taskFilter.and("runtime", ">=", (Object)calendar.getTime());
        for (Set<Map<String, Object>> currBatchDm : batchList) {
            DynamicObjectCollection runningTasks = QueryServiceHelper.query((String)"sch_task", (String)"id", (QFilter[])taskFilter.toArray());
            taskIds.add(ServiceHelper.sendTask(currBatchDm, batchList.size(), batchIndex++));
        }
        logger.info("ServiceHelper_transOutBillByTask_taskIds.size:" + taskIds.size());
        while (true) {
            QFilter completedFilter = new QFilter("id", "in", taskIds);
            completedFilter.and("status", "in", completedTaskStatus);
            DynamicObjectCollection runningTasks = QueryServiceHelper.query((String)"sch_task", (String)"id", (QFilter[])completedFilter.toArray());
            if (runningTasks.size() == batchList.size()) {
                QFilter failTtaskFilter = new QFilter("id", "in", taskIds);
                failTtaskFilter.and("status", "=", (Object)"FAILED");
                DynamicObjectCollection failTasks = QueryServiceHelper.query((String)"sch_task", (String)"id", (QFilter[])failTtaskFilter.toArray());
                if (failTasks != null && failTasks.size() > 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u901a\u8fc7\u540e\u53f0\u4efb\u52a1\u8c03\u7528\u5b58\u8d27\u6838\u7b97\u5fae\u670d\u52a1\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355\u751f\u6210\u63a5\u53e3ServiceHelper.transOutBillByTask\u5931\u8d25\u3002", (String)"ServiceHelper_7", (String)"macc-sca-algox", (Object[])new Object[0]));
                }
                return;
            }
            try {
                Thread.sleep(5000L);
                continue;
            }
            catch (InterruptedException e) {
                logger.error((Throwable)e);
                continue;
            }
            break;
        }
    }

    private static List<Set<Map<String, Object>>> spritBatch(Set<Map<String, Object>> partialDms) {
        ArrayList<Set<Map<String, Object>>> batchList = new ArrayList<Set<Map<String, Object>>>(16);
        if (partialDms == null) {
            return batchList;
        }
        HashMap<Long, Set<Map<String, Object>>> matparams = new HashMap<Long, Set<Map<String, Object>>>(16);
        for (Map<String, Object> partialDm : partialDms) {
            Set<Map<String, Object>> currSet;
            Long matId = Long.valueOf(partialDm.get("material").toString());
            if (matparams.containsKey(matId)) {
                currSet = (Set)matparams.get(matId);
                currSet.add(partialDm);
                continue;
            }
            currSet = new HashSet();
            matparams.put(matId, currSet);
            currSet.add(partialDm);
        }
        int batch_size = matparams.size() / 10 + 1;
        HashSet currBatchDms = null;
        for (Map.Entry partialDm : matparams.entrySet()) {
            if (currBatchDms == null || currBatchDms.size() >= batch_size) {
                currBatchDms = new HashSet(16);
                batchList.add(currBatchDms);
            }
            currBatchDms.addAll((Collection)partialDm.getValue());
        }
        return batchList;
    }

    private static String sendTask(Set<Map<String, Object>> currBatchDms, int totalBatch, int currbatch) {
        HashMap<String, String> jobParams = new HashMap<String, String>();
        jobParams.put("currBatchDms", SerializationUtils.toJsonString(currBatchDms));
        jobParams.put("batchInfo", currbatch + "/" + totalBatch);
        String appId = "sca";
        String taskClass = "kd.macc.sca.algox.task.CalStandardCostDiffBillTask";
        long timestamp = System.currentTimeMillis();
        JobInfo job = new JobInfo();
        job.setRunByLang(Lang.get());
        String OpName = ResManager.loadKDString((String)"\u751f\u6210\u8f6c\u51fa\u5355\u3010{0}\u3011\uff0c\u7b2c\u3010{1}\u3011\u6279\uff0c\u5f00\u59cb\u6267\u884c\u64cd\u4f5c\u4eba:{2}", (String)"ServiceHelper_8", (String)"macc-sca-algox", (Object[])new Object[0]);
        OpName = MessageFormat.format(OpName, "TraceId:" + RequestContext.get().getTraceId() + "/timestamp:" + timestamp, currbatch + "/" + totalBatch, RequestContext.get().getUserName());
        job.setName(OpName);
        job.setJobType(JobType.BIZ);
        job.setParams(jobParams);
        job.setAppId(appId);
        job.setTaskClassname(taskClass);
        job.setRunByUserId(RequestContext.get().getCurrUserId());
        return JobClient.dispatch((JobInfo)job);
    }
}

