/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.utils;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.FinishCalcHelper;
import kd.macc.sca.algox.utils.PeriodHelper;
import kd.macc.sca.algox.wip.input.CalcDataArgs;

public class CostConfirmBillHelper {
    public static void genBillData(CalcDataArgs args) {
        QFilter filter = FinishCalcHelper.getCommonFilter(args);
        filter.and(new QFilter("entryentity.caltype", "=", (Object)"5"));
        DynamicObjectCollection calcResultColl = QueryServiceHelper.query((String)"sca_calcresult", (String)"id,org.id org,costaccount.id costaccount,costcenter.id costcenter,period.id period,costobject.id costobject,costobject.material.masterid material,costobject.bomversion bomversion,costobject.auxpty auxpty,entryentity.totalamount totalamount,entryentity.stdamount totalstdamount", (QFilter[])new QFilter[]{filter});
        if (CadEmptyUtils.isEmpty(calcResultColl)) {
            return;
        }
        Set<Long> changeRecordCostObjects = CostConfirmBillHelper.getChangeRecordMap(calcResultColl);
        long costaccount = ((DynamicObject)calcResultColl.get(0)).getLong("costaccount");
        Set<Long> finishCostObjects = CostConfirmBillHelper.getCostObjectAccounts(changeRecordCostObjects, costaccount);
        HashSet confirmIds = new HashSet();
        DynamicObject calcReport = BusinessDataServiceHelper.loadSingle((Object)args.getCalcReportId(), (String)"sca_calcreport");
        DynamicObjectCollection calcReportEntrys = calcReport.getDynamicObjectCollection("dtentryentity");
        Set<Object> costObjects = args.getCostObjects();
        if (costObjects != null && !costObjects.isEmpty()) {
            for (Object temp : costObjects) {
                if (!(temp instanceof Long)) continue;
                finishCostObjects.add((Long)temp);
            }
            calcReport.set("type", (Object)"4");
        }
        HashMap costConFirmMap = new HashMap(16);
        ArrayList<QFilter> qfList = new ArrayList<QFilter>(10);
        args.warpQFilter4Period(qfList, "org", true);
        args.wrapQFilter4CostObjects(qfList, "costobject");
        List costConfirmIds = QueryServiceHelper.queryPrimaryKeys((String)"sca_costconfirm", (QFilter[])qfList.toArray(new QFilter[0]), null, (int)-1);
        Lists.partition((List)costConfirmIds, (int)20000).forEach(list -> {
            ArrayList<DynamicObject> costConfirBills = new ArrayList<DynamicObject>();
            DynamicObject costConfirBill = null;
            DynamicObject[] costConfirmLoads = BusinessDataServiceHelper.load((Object[])list.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"sca_costconfirm"));
            for (DynamicObject costConfirmLoad : costConfirmLoads) {
                StringBuilder key = new StringBuilder();
                key.append(costConfirmLoad.getString("costobject.id")).append("@").append(costConfirmLoad.getString("costaccount.id")).append("@").append(costConfirmLoad.getString("period.id"));
                costConFirmMap.put(key.toString(), costConfirmLoad);
            }
            for (DynamicObject calcResult : calcResultColl) {
                StringBuilder key = new StringBuilder();
                key.append(calcResult.getString("costobject")).append("@").append(calcResult.getString("costaccount")).append("@").append(calcResult.getString("period"));
                boolean exists = costConFirmMap.containsKey(key.toString());
                costConfirBill = exists ? (DynamicObject)costConFirmMap.get(key.toString()) : BusinessDataServiceHelper.newDynamicObject((String)"sca_costconfirm");
                List<String> groupKeys = Arrays.asList("org", "costaccount", "costcenter", "period", "costobject", "material", "bomversion", "auxpty");
                for (int i = 0; i < groupKeys.size(); ++i) {
                    String field = groupKeys.get(i);
                    costConfirBill.set(field, calcResult.get(field));
                }
                costConfirBill.set("currency", args.getCurrencyId());
                BigDecimal diffRate = BigDecimal.ZERO;
                BigDecimal totalamount = calcResult.getBigDecimal("totalamount");
                BigDecimal totalstdamount = calcResult.getBigDecimal("totalstdamount");
                BigDecimal diffAmount = totalamount.subtract(totalstdamount);
                if (diffAmount != null && totalstdamount != null && BigDecimal.ZERO.compareTo(totalstdamount) != 0) {
                    diffRate = diffAmount.divide(totalstdamount, 4, 4);
                }
                if (!exists) {
                    costConfirBill.set("id", (Object)DBServiceHelper.genGlobalLongId());
                }
                costConfirBill.set("absorbamount", (Object)calcResult.getBigDecimal("totalamount"));
                costConfirBill.set("stdamount", (Object)totalstdamount);
                costConfirBill.set("diff", (Object)diffAmount);
                costConfirBill.set("diffrate", (Object)diffRate);
                costConfirBill.set("bizstatus", (Object)"A");
                costConfirBill.set("srcbill", calcResult.get("id"));
                costConfirBills.add(costConfirBill);
                if (diffRate.compareTo(args.getMinDiffRate()) < 0 || diffRate.compareTo(args.getMaxDiffRate()) > 0) {
                    DynamicObject calcReportEntry = calcReportEntrys.addNew();
                    calcReportEntry.set("costobject", calcResult.get("costobject"));
                    calcReportEntry.set("actualcost", (Object)calcResult.getBigDecimal("totalamount"));
                    calcReportEntry.set("standardcost", (Object)totalstdamount);
                    calcReportEntry.set("dtmoney", (Object)diffAmount);
                    calcReportEntry.set("dtratio", (Object)diffRate);
                }
                if (finishCostObjects.isEmpty() || !finishCostObjects.contains(calcResult.getLong("costobject"))) continue;
                confirmIds.add(costConfirBill.getLong("id"));
            }
            SaveServiceHelper.save((DynamicObject[])costConfirBills.toArray(new DynamicObject[0]));
        });
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{calcReport});
        if (!confirmIds.isEmpty()) {
            OperationServiceHelper.executeOperate((String)"confirm", (String)"sca_costconfirm", (Object[])confirmIds.toArray(), (OperateOption)OperateOption.create());
        }
    }

    private static Set<Long> getCostObjectAccounts(Set<Long> changeRecordCostObjects, long costaccount) {
        QFilter commonQF = new QFilter("costobject", "in", changeRecordCostObjects);
        commonQF.and("costaccount", "=", (Object)costaccount);
        commonQF.and("bizstatus", "=", (Object)"B");
        DynamicObjectCollection costObjectAccounts = QueryServiceHelper.query((String)"cad_costobjectaccount", (String)"id, costobject", (QFilter[])new QFilter[]{commonQF});
        HashSet<Long> costObjectIds = new HashSet<Long>(costObjectAccounts.size());
        costObjectAccounts.forEach(e -> costObjectIds.add(e.getLong("costobject")));
        return costObjectIds;
    }

    private static Set<Long> getChangeRecordMap(DynamicObjectCollection calcResultColl) {
        long costaccount = ((DynamicObject)calcResultColl.get(0)).getLong("costaccount");
        long org = ((DynamicObject)calcResultColl.get(0)).getLong("org");
        long costcenter = ((DynamicObject)calcResultColl.get(0)).getLong("costcenter");
        HashSet costObjectIds = new HashSet();
        HashSet<Long> periodIds = new HashSet<Long>();
        calcResultColl.forEach(e -> {
            costObjectIds.add(e.getLong("costobject"));
            periodIds.add(e.getLong("period"));
        });
        Map<String, Date> date = PeriodHelper.getDateByPeriod(periodIds);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(new QFilter("org", "=", (Object)org));
        filters.add(new QFilter("costaccount", "=", (Object)costaccount));
        filters.add(new QFilter("costcenter", "=", (Object)costcenter));
        filters.add(new QFilter("costobject", "in", costObjectIds));
        filters.add(new QFilter("bizstatus", "!=", (Object)"B"));
        filters.add(new QFilter("sourcebiztime", ">=", (Object)date.get("begindate")));
        filters.add(new QFilter("sourcebiztime", "<=", (Object)date.get("enddate")));
        DynamicObjectCollection changeRecords = QueryServiceHelper.query((String)"sca_costchangerecord", (String)"id, costobject", (QFilter[])filters.toArray(new QFilter[0]));
        HashSet<Long> changeRecordCostObjects = new HashSet<Long>();
        changeRecords.forEach(e -> changeRecordCostObjects.add(e.getLong("costobject")));
        return changeRecordCostObjects;
    }

    public static void deleteBillData(CalcDataArgs args) {
        QFilter filter = FinishCalcHelper.getCommonFilter(args, true, false, true);
        filter.and(FinishCalcHelper.getCostCenterFilter(args));
        filter.and(new QFilter("costobject", "in", args.getCostObjects()));
        DeleteServiceHelper.delete((String)"sca_costconfirm", (QFilter[])new QFilter[]{filter});
    }

    public static void deleteUnconfirmBillData(CalcDataArgs args) {
        if (CadEmptyUtils.isEmpty(args.getCostObjects())) {
            return;
        }
        QFilter filter = FinishCalcHelper.getCommonFilter(args, true, false, true);
        filter.and(FinishCalcHelper.getCostCenterFilter(args));
        filter.and(new QFilter("bizstatus", "=", (Object)"A"));
        DeleteServiceHelper.delete((String)"sca_costconfirm", (QFilter[])new QFilter[]{filter});
    }
}

