/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.sca.algox.calc.input.CalcDataArgs;
import kd.macc.sca.algox.calc.input.CostObjectForCalc;
import kd.macc.sca.algox.calc.input.ProductCostObject;
import kd.macc.sca.algox.utils.PeriodHelper;

public class DiffCalcResultHelper {
    private static final Log logger = LogFactory.getLog(DiffCalcResultHelper.class);
    private static final String madefeeDiff = "Q";
    private static final String costUpdatefeeDiff = "S";
    private static final String materialDiff = "P";
    private static final String srcAllocBill = "A";
    private static final String dataTypeItem = "2";

    public static void updateCalcResult(CalcDataArgs args, List<ProductCostObject> calcresults) {
        Long calOrgId = args.getOrgId();
        Long costAccountId = args.getCostAccount();
        Long periodId = args.getPeriod();
        Long prePeriodId = PeriodHelper.getPrePeriodId(periodId);
        HashSet<Object> costobjects = new HashSet<Object>(16);
        HashSet<Object> finishcos = new HashSet<Object>(16);
        ArrayList<DynamicObject> dyos = new ArrayList<DynamicObject>(10);
        HashSet<String> coelegroup1 = new HashSet<String>(16);
        HashMap<Object, DynamicObject> cacheDyoMap = new HashMap<Object, DynamicObject>(16);
        HashMap<String, DynamicObject> entry1cachemap = new HashMap<String, DynamicObject>(16);
        DataSet purchDiffDs_Comp = DiffCalcResultHelper.getPurchDiffAllocInfo_Comp_V2(calOrgId, costAccountId, periodId);
        DataSet currUnAbsorbDiffDs = DiffCalcResultHelper.getCurrLevelUnAbsorbDiffInfo(calOrgId, costAccountId, periodId);
        DataSet compGroupDiffTypeDs = purchDiffDs_Comp.union(currUnAbsorbDiffDs);
        DataSet compAllDiffTypeDs = compGroupDiffTypeDs.executeSql("select billtype,org, costcenter, costaccount, period,costobject,material,bizstatus,difftype,element,subelement,submaterial,submatversion,submatauxpty,sum(curramount) curramount,sum(finishamount) finishamount   group by billtype,org, costcenter, costaccount, period,costobject,material,bizstatus,difftype,element,subelement,submaterial,submatversion,submatauxpty");
        DataSet calcResultInfo_Comp = DiffCalcResultHelper.getAllWipCalcResultInfo(calOrgId, costAccountId, periodId, "1");
        DiffCalcResultHelper.collFinishCostObjectSet(calcresults, finishcos);
        try {
            DataSet newAllDiffTypeDs = compAllDiffTypeDs.copy();
            DataSet costobjectds = newAllDiffTypeDs.select(new String[]{"costobject", "costcenter", "bizstatus", "material"}).groupBy(new String[]{"costobject", "costcenter", "bizstatus", "material"}).finish();
            Map<Object, Map<String, BigDecimal>> costObjectInfoDs = DiffCalcResultHelper.getWipCalcCostObjectInfo(calOrgId, costAccountId, periodId, costobjects);
            for (Row row : costobjectds) {
                Object costobject = row.get("costobject");
                costobjects.add(costobject);
                DynamicObject dyo = BusinessDataServiceHelper.newDynamicObject((String)"sca_diffcalcresult");
                dyos.add(dyo);
                dyo.set("billno", (Object)System.nanoTime());
                dyo.set("org", (Object)calOrgId);
                dyo.set("costobject", costobject);
                dyo.set("currency", (Object)args.getCurrency());
                dyo.set("bizdate", (Object)new Date());
                dyo.set("period", (Object)args.getPeriod());
                dyo.set("costaccount", (Object)args.getCostAccount());
                dyo.set("costcenter", row.get("costcenter"));
                dyo.set("bizstatus", row.get("bizstatus"));
                dyo.set("calcreport", (Object)args.getCalcReportId());
                dyo.set("billstatus", (Object)"C");
                dyo.set("createtime", (Object)new Date());
                dyo.set("entryproduct", row.get("material"));
                DiffCalcResultHelper.setCostObjectQty(dyo, costobject, costObjectInfoDs);
                cacheDyoMap.put(costobject, dyo);
            }
            DataSet prePeriodCalDiffDs = DiffCalcResultHelper.getPrePeriodCalDiffResult(calOrgId, costAccountId, prePeriodId, costobjects);
            DataSet calcDs_Comp = DiffCalcResultHelper.getFilterWipResult(calcResultInfo_Comp);
            String decimalFields = DiffCalcResultHelper.getWipQueryDecimalFields();
            String selectFields = "billtype,org, costaccount, period,costcenter, costobject,difftype,  element,subelement,submaterial,submatversion,submatauxpty,curramount,finishamount," + decimalFields;
            JoinDataSet joinDataSet1 = compAllDiffTypeDs.leftJoin(calcDs_Comp);
            joinDataSet1.on("costobject", "wipcostobject");
            joinDataSet1.on("element", "wipelement");
            joinDataSet1.on("subelement", "wipsubelement");
            joinDataSet1.on("submaterial", "wipsubmaterial");
            joinDataSet1.on("submatversion", "wipsubmatversion");
            joinDataSet1.on("submatauxpty", "wipsubmatauxpty");
            DataSet compCostcalcRs = joinDataSet1.select(selectFields.split(",")).finish();
            DataSet filterPreDs = prePeriodCalDiffDs.copy();
            Map<Object, Object[]> materialdyos = DiffCalcResultHelper.getMaterialBaseunitInfo();
            DataSet filterPreDs1 = prePeriodCalDiffDs.copy();
            DiffCalcResultHelper.createCompCalcResultBillEntry(finishcos, compCostcalcRs, filterPreDs1, cacheDyoMap, coelegroup1, entry1cachemap, materialdyos);
            logger.info("\u6210\u672c\u5206\u644a\u8ba1\u7b97\u7ed3\u679c\u8868\u5206\u5f55-\u7efc\u5408\u4fe1\u606f\u521b\u5efa\u5b8c\u6210");
            DiffCalcResultHelper.dealNoMatchElementData_Comp(calcResultInfo_Comp, prePeriodCalDiffDs, coelegroup1, cacheDyoMap, entry1cachemap, dyos, args, materialdyos, costObjectInfoDs);
            logger.info("\u6210\u672c\u5206\u644a\u8ba1\u7b97\u7ed3\u679c\u8868\u5bf9\u8c61\u4fe1\u606f\u6784\u5efa\u5b8c\u6210");
            DiffCalcResultHelper.closeDataSet(prePeriodCalDiffDs, newAllDiffTypeDs);
            if (!dyos.isEmpty()) {
                logger.info("\u5f00\u59cb\u4fdd\u5b58\u6210\u672c\u5206\u644a\u8ba1\u7b97\u7ed3\u679c\u8868\u5bf9\u8c61\u4fe1\u606f\u5230\u6570\u636e\u5e93");
                List<List<DynamicObject>> spdyos = DiffCalcResultHelper.splitList(dyos, 1000);
                for (List<DynamicObject> list : spdyos) {
                    SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
                }
            }
            cacheDyoMap = null;
            coelegroup1 = null;
        }
        catch (Exception e) {
            try {
                logger.info("\u751f\u6210\u8ba1\u7b97\u7ed3\u679c\u5355\u5931\u8d25\uff1a" + e.getLocalizedMessage());
                logger.error("\u751f\u6210\u8ba1\u7b97\u7ed3\u679c\u5355\u5931\u8d25\uff1a", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                DiffCalcResultHelper.closeDataSet(purchDiffDs_Comp, compAllDiffTypeDs);
                throw throwable;
            }
        }
        DiffCalcResultHelper.closeDataSet(purchDiffDs_Comp, compAllDiffTypeDs);
    }

    private static String getWipQueryDecimalFields() {
        String decimalFields = "pdstartqty,pdstartamount,pdcurrqty,pdcurramount,pdcompqty,pdcompanount,pdendqty,pdendamount,diff,totalqty,totalamount,stdqty,stdamount";
        return decimalFields;
    }

    private static DataSet getFilterWipResult(DataSet calcResultInfo) {
        String[] wipSelectFields = DiffCalcResultHelper.getCalcWipFields();
        DataSet wipcalcgrs = calcResultInfo.copy().select((wipSelectFields[0] + wipSelectFields[1]).split(","));
        GroupbyDataSet groupDataSet = wipcalcgrs.groupBy(new String[]{"wiporg", "wipcostcenter", "wipcostaccount", "wipperiod", "wipcostobject", "wipelement", "wipsubelement", "wipsubmaterial", "wipsubmatversion", "wipsubmatauxpty"});
        groupDataSet.sum("pdstartqty");
        groupDataSet.sum("pdstartamount");
        groupDataSet.sum("pdcurrqty");
        groupDataSet.sum("pdcurramount");
        groupDataSet.sum("pdcompqty");
        groupDataSet.sum("pdcompanount");
        groupDataSet.sum("pdendqty");
        groupDataSet.sum("pdendamount");
        groupDataSet.sum("totalqty");
        groupDataSet.sum("totalamount");
        groupDataSet.sum("stdqty");
        groupDataSet.sum("stdamount");
        groupDataSet.sum("diff");
        DataSet calcDs = groupDataSet.finish();
        return calcDs;
    }

    private static String[] getCalcWipFields() {
        String decimalFields = DiffCalcResultHelper.getWipQueryDecimalFields();
        String selectFields = "org  wiporg, costaccount  wipcostaccount, period  wipperiod,costcenter  wipcostcenter, costobject  wipcostobject, element wipelement,subelement wipsubelement,submaterial wipsubmaterial,submatversion wipsubmatversion,submatauxpty wipsubmatauxpty,";
        return new String[]{selectFields, decimalFields};
    }

    private static Map<Object, Object[]> getMaterialBaseunitInfo() {
        String algokey = DiffCalcResultHelper.getAlgokey("getMaterialBaseunitInfo");
        DataSet mdyos = QueryServiceHelper.queryDataSet((String)algokey, (String)"bd_material", (String)"id,baseunit.id AS baseunitId,baseunit.precision AS precision,isenablematerialversion,isuseauxpty", (QFilter[])new QFilter[0], null);
        HashMap<Object, Object[]> materialdyos = new HashMap<Object, Object[]>();
        for (Row row : mdyos) {
            materialdyos.put(row.get("id"), new Object[]{row.get("baseunitId"), row.get("precision"), row.getBoolean("isenablematerialversion"), row.getBoolean("isuseauxpty")});
        }
        return materialdyos;
    }

    private static void dealNoMatchElementData(DataSet calcresultInfo, DataSet prePeriodCalDiffDs, Set<String> coelegroup, Map<Object, DynamicObject> cacheDyoMap, Map<String, DynamicObject> entrycachemap, List<DynamicObject> dyos, CalcDataArgs args, Map<Object, Object[]> materialdyos, Map<Object, Map<String, BigDecimal>> costObjectInfoDs) {
        JoinDataSet rsds = calcresultInfo.leftJoin(prePeriodCalDiffDs);
        rsds.on("costobject", "r_costobject");
        rsds.on("subelement", "r_subelement");
        rsds.on("element", "r_element");
        rsds.on("submaterial", "material");
        rsds.on("submatversion", "matversion");
        rsds.on("submatauxpty", "auxpty");
        Object[] filterDiffDsFields = calcresultInfo.getRowMeta().getFieldNames();
        Object[] preCalResultDsFields = DiffCalcResultHelper.getPreCalResultDsFields();
        String[] totalfieldNames = (String[])ArrayUtils.addAll((Object[])filterDiffDsFields, (Object[])preCalResultDsFields);
        DataSet rsdata = rsds.select(totalfieldNames).finish();
        for (Row row : rsdata) {
            DynamicObject entrydyo;
            Object wipcostobject = row.get("costobject");
            Object costcenter = row.get("costcenter");
            Object bizstatus = row.get("bizstatus");
            Object material = row.get("material");
            Object wipelement = row.get("element");
            Object wipsubelement = row.get("subelement");
            Long wipsubmaterial = row.getLong("submaterial");
            Long wipsubmatversion = row.getLong("submatversion");
            Long wipsubmatauxpty = row.getLong("submatauxpty");
            String difftype = row.getString("difftype");
            BigDecimal compamt = row.getBigDecimal("diff");
            BigDecimal costupamt = row.getBigDecimal("costupamt");
            if (wipcostobject == null) continue;
            Integer qtypre = null;
            String key = wipcostobject + "&" + wipelement + "&" + wipsubelement + "&" + wipsubmaterial + "&" + wipsubmatversion + "&" + wipsubmatauxpty;
            DynamicObject dyo = cacheDyoMap.get(wipcostobject);
            if (dyo == null) {
                dyo = BusinessDataServiceHelper.newDynamicObject((String)"sca_diffcalcresult");
                dyos.add(dyo);
                dyo.set("billno", (Object)System.currentTimeMillis());
                dyo.set("org", (Object)args.getOrgId());
                dyo.set("costobject", wipcostobject);
                dyo.set("currency", (Object)args.getCurrency());
                dyo.set("bizdate", (Object)new Date());
                dyo.set("period", (Object)args.getPeriod());
                dyo.set("costaccount", (Object)args.getCostAccount());
                dyo.set("costcenter", costcenter);
                dyo.set("bizstatus", bizstatus);
                dyo.set("calcreport", (Object)args.getCalcReportId());
                dyo.set("billstatus", (Object)"C");
                dyo.set("createtime", (Object)new Date());
                dyo.set("entryproduct", material);
                DiffCalcResultHelper.setCostObjectQty(dyo, wipcostobject, costObjectInfoDs);
                cacheDyoMap.put(wipcostobject, dyo);
            }
            if ((entrydyo = entrycachemap.get(key)) == null) {
                DynamicObjectCollection entryentity = dyo.getDynamicObjectCollection("entryentity");
                entrydyo = entryentity.addNew();
                entrydyo.set("element", wipelement);
                entrydyo.set("subElement", wipsubelement);
                entrydyo.set("material", (Object)wipsubmaterial);
                if (wipsubmaterial != null && wipsubmaterial != 0L) {
                    Object[] baseinfo = materialdyos.get(wipsubmaterial);
                    if (baseinfo != null) {
                        if (baseinfo[1] != null) {
                            qtypre = (Integer)baseinfo[1];
                        }
                        entrydyo.set("baseunit", baseinfo[0]);
                    }
                    if (wipsubmatauxpty != null && wipsubmatauxpty != 0L && baseinfo != null && ((Boolean)baseinfo[3]).booleanValue()) {
                        entrydyo.set("auxpty", (Object)wipsubmatauxpty);
                    }
                    if (wipsubmatversion != null && wipsubmatversion != 0L && baseinfo != null && ((Boolean)baseinfo[2]).booleanValue()) {
                        entrydyo.set("matversion", (Object)wipsubmatversion);
                    }
                }
                entrycachemap.put(key, entrydyo);
                DiffCalcResultHelper.updateQtyAndCost(entrydyo, row, qtypre);
            }
            if (materialDiff.equals(difftype) || madefeeDiff.equals(difftype)) {
                DiffCalcResultHelper.setDiffAllocSumCurrFinishInfo(difftype, compamt, entrydyo);
            } else if (costUpdatefeeDiff.equals(difftype)) {
                DiffCalcResultHelper.setDiffAllocSumCurrFinishInfo(difftype, costupamt, entrydyo);
            }
            DiffCalcResultHelper.setDiffAllocWipInfo(entrydyo);
            DiffCalcResultHelper.setTotalPeriodDiffInfo(entrydyo, row);
            DiffCalcResultHelper.updateActualCost(entrydyo, row, qtypre);
        }
    }

    private static void dealNoMatchElementData_Comp(DataSet calcresultInfo, DataSet prePeriodCalDiffDs, Set<String> coelegroup, Map<Object, DynamicObject> cacheDyoMap, Map<String, DynamicObject> entry1cachemap, List<DynamicObject> dyos, CalcDataArgs args, Map<Object, Object[]> materialdyos, Map<Object, Map<String, BigDecimal>> costObjectInfoDs) {
        JoinDataSet rsds = calcresultInfo.leftJoin(prePeriodCalDiffDs);
        rsds.on("costobject", "r_costobject");
        rsds.on("subelement", "r_subelement1");
        rsds.on("element", "r_element1");
        rsds.on("submaterial", "material1");
        rsds.on("submatversion", "matversion1");
        rsds.on("submatauxpty", "auxpty1");
        Object[] filterDiffDsFields = calcresultInfo.getRowMeta().getFieldNames();
        Object[] preCalResultDsFields = DiffCalcResultHelper.getCompPreCalResultDsFields();
        String[] totalfieldNames = (String[])ArrayUtils.addAll((Object[])filterDiffDsFields, (Object[])preCalResultDsFields);
        DataSet rsdata = rsds.select(totalfieldNames).finish();
        for (Row row : rsdata) {
            DynamicObject entrydyo;
            Object wipcostobject = row.get("costobject");
            Object costcenter = row.get("costcenter");
            Object bizstatus = row.get("bizstatus");
            Object material = row.get("material");
            Object wipelement = row.get("element");
            Object wipsubelement = row.get("subelement");
            Long wipsubmaterial = row.getLong("submaterial");
            Long wipsubmatversion = row.getLong("submatversion");
            Long wipsubmatauxpty = row.getLong("submatauxpty");
            String difftype = row.getString("difftype");
            BigDecimal compamt = row.getBigDecimal("diff");
            BigDecimal costupamt = row.getBigDecimal("costupamt");
            Integer qtypre = null;
            String key = wipcostobject + "&" + wipelement + "&" + wipsubelement + "&" + wipsubmaterial + "&" + wipsubmatversion + "&" + wipsubmatauxpty;
            DynamicObject dyo = cacheDyoMap.get(wipcostobject);
            if (dyo == null) {
                dyo = BusinessDataServiceHelper.newDynamicObject((String)"sca_diffcalcresult");
                dyos.add(dyo);
                dyo.set("billno", (Object)System.currentTimeMillis());
                dyo.set("org", (Object)args.getOrgId());
                dyo.set("costobject", wipcostobject);
                dyo.set("currency", (Object)args.getCurrency());
                dyo.set("bizdate", (Object)new Date());
                dyo.set("period", (Object)args.getPeriod());
                dyo.set("costaccount", (Object)args.getCostAccount());
                dyo.set("costcenter", costcenter);
                dyo.set("bizstatus", bizstatus);
                dyo.set("calcreport", (Object)args.getCalcReportId());
                dyo.set("billstatus", (Object)"C");
                dyo.set("createtime", (Object)new Date());
                dyo.set("entryproduct", material);
                DiffCalcResultHelper.setCostObjectQty(dyo, wipcostobject, costObjectInfoDs);
                cacheDyoMap.put(wipcostobject, dyo);
            }
            if ((entrydyo = entry1cachemap.get(key)) == null) {
                DynamicObjectCollection entryentity = dyo.getDynamicObjectCollection("entryentity1");
                entrydyo = entryentity.addNew();
                entrydyo.set("element1", wipelement);
                entrydyo.set("subElement1", wipsubelement);
                entrydyo.set("material1", (Object)wipsubmaterial);
                if (wipsubmaterial != null && wipsubmaterial != 0L) {
                    Object[] baseinfo = materialdyos.get(wipsubmaterial);
                    if (baseinfo != null) {
                        if (baseinfo[1] != null) {
                            qtypre = (Integer)baseinfo[1];
                        }
                        entrydyo.set("baseunit1", baseinfo[0]);
                    }
                    if (wipsubmatauxpty != null && wipsubmatauxpty != 0L && baseinfo != null && ((Boolean)baseinfo[3]).booleanValue()) {
                        entrydyo.set("auxpty1", (Object)wipsubmatauxpty);
                    }
                    if (wipsubmatversion != null && wipsubmatversion != 0L && baseinfo != null && ((Boolean)baseinfo[2]).booleanValue()) {
                        entrydyo.set("matversion1", (Object)wipsubmatversion);
                    }
                }
                entry1cachemap.put(key, entrydyo);
                DiffCalcResultHelper.updateQtyAndCost_Comp(entrydyo, row, qtypre);
            }
            if (materialDiff.equals(difftype) || madefeeDiff.equals(difftype)) {
                DiffCalcResultHelper.setDiffAllocSumCurrFinishInfo_Comp(difftype, compamt, entrydyo);
            } else if (costUpdatefeeDiff.equals(difftype)) {
                DiffCalcResultHelper.setDiffAllocSumCurrFinishInfo_Comp(difftype, costupamt, entrydyo);
            }
            DiffCalcResultHelper.setDiffAllocWipInfo_Comp(entrydyo);
            DiffCalcResultHelper.setTotalPeriodDiffInfo_Comp(entrydyo, row);
            DiffCalcResultHelper.updateActualCost_Comp(entrydyo, row, qtypre);
        }
    }

    private static Map<Object, Map<String, BigDecimal>> getWipCalcCostObjectInfo(Object calOrgId, Object costAccountId, Object periodId, Set<Object> costobjects) {
        HashMap<Object, Map<String, BigDecimal>> coinfomap = new HashMap<Object, Map<String, BigDecimal>>(16);
        String algoKey = DiffCalcResultHelper.getAlgokey("getWipCalcCostObjectInfo");
        QFilter orgIdFilter = new QFilter("org", "=", calOrgId);
        QFilter costAccountIdFilter = new QFilter("costaccount", "=", costAccountId);
        QFilter periodIdFilter = new QFilter("period", "=", periodId);
        QFilter datatypeFilter = new QFilter("entryentity.datatype", "in", (Object)new String[]{"98", "99"});
        String decimalFields = "entryentity.pdstartqty pdstartqty,entryentity.pdstartamount pdstartamount, entryentity.pdcurrqty pdcurrqty,entryentity.pdcurramount pdcurramount, entryentity.pdcompqty pdcompqty,entryentity.pdcompanount pdcompanount, entryentity.pdendqty pdendqty,entryentity.pdendamount pdendamount, entryentity.diff diff,entryentity.totalqty totalqty,entryentity.totalamount totalamount, entryentity.stdqty stdqty,entryentity.stdamount stdamount";
        String selectFields = "org.id  wiporg, costaccount.id  wipcostaccount, period.id  wipperiod,costcenter.id  wipcostcenter, costobject.id  wipcostobject, entryentity.element.id wipelement,entryentity.subelement.id wipsubelement,entryentity.material.id wipsubmaterial,entryentity.matversion.id wipsubmatversion,entryentity.auxpty.id wipsubmatauxpty," + decimalFields;
        QFilter[] filters = new QFilter[]{orgIdFilter, costAccountIdFilter, periodIdFilter, datatypeFilter};
        DataSet ds = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_calcresult", (String)selectFields, (QFilter[])filters, null);
        GroupbyDataSet groupDataSet = ds.groupBy(new String[]{"wiporg", "wipcostcenter", "wipcostaccount", "wipperiod", "wipcostobject", "wipelement", "wipsubelement", "wipsubmaterial", "wipsubmatversion", "wipsubmatauxpty"});
        groupDataSet.max("pdstartqty");
        groupDataSet.max("pdstartamount");
        groupDataSet.max("pdcurrqty");
        groupDataSet.max("pdcurramount");
        groupDataSet.max("pdcompqty");
        groupDataSet.max("pdcompanount");
        groupDataSet.max("pdendqty");
        groupDataSet.max("pdendamount");
        groupDataSet.max("totalqty");
        groupDataSet.max("totalamount");
        groupDataSet.max("stdqty");
        groupDataSet.max("stdamount");
        groupDataSet.max("diff");
        DataSet gds = groupDataSet.finish();
        for (Row row : gds) {
            Object costobject = row.get("wipcostobject");
            HashMap<String, BigDecimal> decimalmap = new HashMap<String, BigDecimal>();
            decimalmap.put("pdstartqty", row.getBigDecimal("pdstartqty"));
            decimalmap.put("pdcurrqty", row.getBigDecimal("pdcurrqty"));
            decimalmap.put("pdcompqty", row.getBigDecimal("pdcompqty"));
            decimalmap.put("pdendqty", row.getBigDecimal("pdendqty"));
            decimalmap.put("totalqty", row.getBigDecimal("totalqty"));
            coinfomap.put(costobject, decimalmap);
        }
        return coinfomap;
    }

    private static void createCalcResultBillEntry(Set<Object> finishcos, DataSet filterDiffDs, DataSet filterPreDs, Map<Object, DynamicObject> cacheHeadDyo, Set<String> coelegroup, Map<String, DynamicObject> entrycachemap, Map<Object, Object[]> materialdyos) {
        JoinDataSet rsds = filterDiffDs.leftJoin(filterPreDs);
        rsds.on("subelement", "r_subelement");
        rsds.on("element", "r_element");
        rsds.on("submaterial", "material");
        rsds.on("submatversion", "matversion");
        rsds.on("submatauxpty", "auxpty");
        rsds.on("costobject", "r_costobject");
        Object[] filterDiffDsFields = filterDiffDs.getRowMeta().getFieldNames();
        Object[] preCalResultDsFields = DiffCalcResultHelper.getPreCalResultDsFields();
        String[] totalfieldNames = (String[])ArrayUtils.addAll((Object[])filterDiffDsFields, (Object[])preCalResultDsFields);
        DataSet rsdata = rsds.select(totalfieldNames).finish();
        for (Row frow : rsdata) {
            String entrygroupkey;
            DynamicObject entrydyo;
            DynamicObject dyo;
            Long subelement = frow.getLong("subelement");
            Long element = frow.getLong("element");
            Long submaterial = frow.getLong("submaterial");
            Long submatversion = frow.getLong("submatversion");
            Long submatauxpty = frow.getLong("submatauxpty");
            Object difftype = frow.get("difftype");
            Object baseunit = frow.get("baseunit");
            Object billtype = frow.get("billtype");
            Object costobject = frow.get("costobject");
            if (costobject == null || (dyo = cacheHeadDyo.get(costobject)) == null) continue;
            DynamicObjectCollection entryentity = dyo.getDynamicObjectCollection("entryentity");
            Integer qtypre = null;
            String key = costobject + "&" + element + "&" + subelement + "&" + submaterial + "&" + submatversion + "&" + submatauxpty + "&" + difftype;
            coelegroup.add(key);
            BigDecimal currsubadjamt = frow.getBigDecimal("curramount") == null ? new BigDecimal("0.0000000000") : frow.getBigDecimal("curramount");
            BigDecimal finishadjamt = BigDecimal.ZERO;
            boolean isFinishPro = finishcos.contains(costobject);
            if (isFinishPro) {
                BigDecimal bigDecimal = finishadjamt = frow.getBigDecimal("finishamount") == null ? new BigDecimal("0.0000000000") : frow.getBigDecimal("finishamount");
            }
            if ((entrydyo = entrycachemap.get(entrygroupkey = costobject + "&" + element + "&" + subelement + "&" + submaterial + "&" + submatversion + "&" + submatauxpty)) == null) {
                entrydyo = entryentity.addNew();
                entrydyo.set("element", (Object)element);
                entrydyo.set("subElement", (Object)subelement);
                entrydyo.set("material", (Object)submaterial);
                if (submaterial != null && submaterial != 0L) {
                    Object[] baseunitinfos = materialdyos.get(submaterial);
                    Object object = baseunit = baseunit == null ? baseunitinfos[0] : baseunit;
                    if (baseunitinfos[1] != null) {
                        qtypre = (Integer)baseunitinfos[1];
                    }
                    entrydyo.set("baseunit", baseunit);
                    if (submatauxpty != null && submatauxpty != 0L && ((Boolean)baseunitinfos[3]).booleanValue()) {
                        entrydyo.set("auxpty", (Object)submatauxpty);
                    }
                    if (submatversion != null && submatversion != 0L && ((Boolean)baseunitinfos[2]).booleanValue()) {
                        entrydyo.set("matversion", (Object)submatversion);
                    }
                }
                entrycachemap.put(entrygroupkey, entrydyo);
            } else {
                BigDecimal sumcurrdiffamt = DiffCalcResultHelper.getDiffAllocCurrProductInfo(difftype, entrydyo);
                currsubadjamt = currsubadjamt.add(sumcurrdiffamt);
                if (isFinishPro) {
                    BigDecimal sumfinishdiffamt = DiffCalcResultHelper.getDiffAllocCurrFinishInfo(difftype, entrydyo);
                    finishadjamt = finishadjamt.add(sumfinishdiffamt);
                }
            }
            DiffCalcResultHelper.setDiffAllocStartInfo(entrydyo, frow);
            if (srcAllocBill.equals(billtype)) {
                DiffCalcResultHelper.setDiffAllocCurrProductInfo(difftype, currsubadjamt, entrydyo);
            }
            DiffCalcResultHelper.setDiffAllocCurrFinishInfo(difftype, finishadjamt, entrydyo);
            DiffCalcResultHelper.setDiffAllocWipInfo(entrydyo);
            DiffCalcResultHelper.setTotalPeriodDiffInfo(entrydyo, frow);
            DiffCalcResultHelper.updateQtyAndCost(entrydyo, frow, qtypre);
        }
    }

    private static void createCompCalcResultBillEntry(Set<Object> finishcos, DataSet filterDiffDs, DataSet filterPreDs, Map<Object, DynamicObject> cacheHeadDyo, Set<String> coelegroup, Map<String, DynamicObject> entry1cachemap, Map<Object, Object[]> materialdyos) {
        JoinDataSet rsds = filterDiffDs.leftJoin(filterPreDs);
        rsds.on("subelement", "r_subelement1");
        rsds.on("element", "r_element1");
        rsds.on("submaterial", "material1");
        rsds.on("submatversion", "matversion1");
        rsds.on("submatauxpty", "auxpty1");
        rsds.on("costobject", "r_costobject");
        Object[] filterDiffDsFields = filterDiffDs.getRowMeta().getFieldNames();
        Object[] preCalResultDsFields = DiffCalcResultHelper.getCompPreCalResultDsFields();
        String[] totalfieldNames = (String[])ArrayUtils.addAll((Object[])filterDiffDsFields, (Object[])preCalResultDsFields);
        DataSet rsdata = rsds.select(totalfieldNames).finish();
        for (Row frow : rsdata) {
            String entrygroupkey;
            DynamicObject entrydyo;
            Long subelement = frow.getLong("subelement");
            Long element = frow.getLong("element");
            Long submaterial = frow.getLong("submaterial");
            Long submatversion = frow.getLong("submatversion");
            Long submatauxpty = frow.getLong("submatauxpty");
            Object difftype = frow.get("difftype");
            Object baseunit = frow.get("baseunit1");
            Object billtype = frow.get("billtype");
            Object costobject = frow.get("costobject");
            DynamicObject dyo = cacheHeadDyo.get(costobject);
            if (dyo == null) continue;
            DynamicObjectCollection entryentity = dyo.getDynamicObjectCollection("entryentity1");
            Integer qtypre = null;
            String key = costobject + "&" + element + "&" + subelement + "&" + submaterial + "&" + submatversion + "&" + submatauxpty + "&" + difftype;
            coelegroup.add(key);
            BigDecimal currsubadjamt = frow.getBigDecimal("curramount") == null ? new BigDecimal("0.0000000000") : frow.getBigDecimal("curramount");
            BigDecimal finishadjamt = BigDecimal.ZERO;
            boolean isFinishPro = finishcos.contains(costobject);
            if (isFinishPro) {
                BigDecimal bigDecimal = finishadjamt = frow.getBigDecimal("finishamount") == null ? new BigDecimal("0.0000000000") : frow.getBigDecimal("finishamount");
            }
            if ((entrydyo = entry1cachemap.get(entrygroupkey = costobject + "&" + element + "&" + subelement + "&" + submaterial + "&" + submatversion + "&" + submatauxpty)) == null) {
                entrydyo = entryentity.addNew();
                entrydyo.set("element1", (Object)element);
                entrydyo.set("subElement1", (Object)subelement);
                entrydyo.set("material1", (Object)submaterial);
                if (submaterial != null && submaterial != 0L) {
                    Object[] baseinfos = materialdyos.get(submaterial);
                    Object object = baseunit = baseunit == null ? baseinfos[0] : baseunit;
                    if (baseinfos[1] != null) {
                        qtypre = (Integer)baseinfos[1];
                    }
                    entrydyo.set("baseunit1", baseunit);
                    if (submatauxpty != null && submatauxpty != 0L && ((Boolean)baseinfos[3]).booleanValue()) {
                        entrydyo.set("auxpty1", (Object)submatauxpty);
                    }
                    if (submatversion != null && submatversion != 0L && ((Boolean)baseinfos[2]).booleanValue()) {
                        entrydyo.set("matversion1", (Object)submatversion);
                    }
                }
                entry1cachemap.put(entrygroupkey, entrydyo);
                DiffCalcResultHelper.updateQtyAndCost_Comp(entrydyo, frow, qtypre);
            } else {
                BigDecimal sumcurrdiffamt = DiffCalcResultHelper.getDiffAllocCurrProductInfo_Comp(difftype, entrydyo);
                currsubadjamt = currsubadjamt.add(sumcurrdiffamt);
                if (isFinishPro) {
                    BigDecimal sumfinishdiffamt = DiffCalcResultHelper.getDiffAllocCurrFinishInfo_Comp(difftype, entrydyo);
                    finishadjamt = finishadjamt.add(sumfinishdiffamt);
                }
            }
            DiffCalcResultHelper.setDiffAllocStartInfo_Comp(entrydyo, frow);
            if (srcAllocBill.equals(billtype)) {
                DiffCalcResultHelper.setDiffAllocCurrProductInfo_Comp(difftype, currsubadjamt, entrydyo);
            }
            DiffCalcResultHelper.setDiffAllocCurrFinishInfo_Comp(difftype, finishadjamt, entrydyo);
            DiffCalcResultHelper.setDiffAllocWipInfo_Comp(entrydyo);
            DiffCalcResultHelper.setTotalPeriodDiffInfo_Comp(entrydyo, frow);
            DiffCalcResultHelper.updateQtyAndCost_Comp(entrydyo, frow, qtypre);
        }
    }

    public static void updateQtyAndCost(DynamicObject entrydyo, Row frow, Integer qtyprecision) {
        entrydyo.set("startqty", (Object)DiffCalcResultHelper.getQtyWithPrecision(frow, "pdstartqty", qtyprecision));
        entrydyo.set("startamt", (Object)frow.getBigDecimal("pdstartamount"));
        entrydyo.set("startactcostupamt", (Object)DiffCalcResultHelper.calcActcostupAmt(entrydyo, frow, "start"));
        entrydyo.set("currqty", (Object)DiffCalcResultHelper.getQtyWithPrecision(frow, "pdcurrqty", qtyprecision));
        entrydyo.set("curramt", (Object)frow.getBigDecimal("pdcurramount"));
        entrydyo.set("curractcostupamt", (Object)DiffCalcResultHelper.calcActcostupAmt(entrydyo, frow, "curr"));
        entrydyo.set("compqty", (Object)DiffCalcResultHelper.getQtyWithPrecision(frow, "pdcompqty", qtyprecision));
        entrydyo.set("compamt", (Object)frow.getBigDecimal("pdcompanount"));
        entrydyo.set("compactcostupamt", (Object)DiffCalcResultHelper.calcActcostupAmt(entrydyo, frow, "comp"));
        entrydyo.set("endqty", (Object)DiffCalcResultHelper.getQtyWithPrecision(frow, "pdendqty", qtyprecision));
        entrydyo.set("endamt", (Object)frow.getBigDecimal("pdendamount"));
        entrydyo.set("endactcostupamt", (Object)DiffCalcResultHelper.calcActcostupAmt(entrydyo, frow, "end"));
        entrydyo.set("totalqty", (Object)DiffCalcResultHelper.getQtyWithPrecision(frow, "stdqty", qtyprecision));
        entrydyo.set("totalamt", (Object)frow.getBigDecimal("stdamount"));
        entrydyo.set("totalactcostupamt", (Object)DiffCalcResultHelper.calcActcostupAmt(entrydyo, frow, "total"));
    }

    public static void updateActualCost(DynamicObject entrydyo, Row frow, Integer qtyprecision) {
        entrydyo.set("startactcostupamt", (Object)DiffCalcResultHelper.calcActcostupAmt(entrydyo, frow, "start"));
        entrydyo.set("curractcostupamt", (Object)DiffCalcResultHelper.calcActcostupAmt(entrydyo, frow, "curr"));
        entrydyo.set("compactcostupamt", (Object)DiffCalcResultHelper.calcActcostupAmt(entrydyo, frow, "comp"));
        entrydyo.set("endactcostupamt", (Object)DiffCalcResultHelper.calcActcostupAmt(entrydyo, frow, "end"));
        entrydyo.set("totalactcostupamt", (Object)DiffCalcResultHelper.calcActcostupAmt(entrydyo, frow, "total"));
    }

    public static void updateActualCost_Comp(DynamicObject entrydyo, Row frow, Integer qtyprecision) {
        entrydyo.set("startactcostupamt1", (Object)DiffCalcResultHelper.calcActcostupAmt_Comp(entrydyo, frow, "start"));
        entrydyo.set("curractcostupamt1", (Object)DiffCalcResultHelper.calcActcostupAmt_Comp(entrydyo, frow, "curr"));
        entrydyo.set("compactcostupamt1", (Object)DiffCalcResultHelper.calcActcostupAmt_Comp(entrydyo, frow, "comp"));
        entrydyo.set("endactcostupamt1", (Object)DiffCalcResultHelper.calcActcostupAmt_Comp(entrydyo, frow, "end"));
        entrydyo.set("totalactcostupamt1", (Object)DiffCalcResultHelper.calcActcostupAmt_Comp(entrydyo, frow, "total"));
    }

    private static void updateQtyAndCost_Comp(DynamicObject entrydyo, Row frow, Integer qtyprecision) {
        entrydyo.set("startqty1", (Object)DiffCalcResultHelper.getQtyWithPrecision(frow, "pdstartqty", qtyprecision));
        entrydyo.set("startamt1", (Object)frow.getBigDecimal("pdstartamount"));
        entrydyo.set("startactcostupamt1", (Object)DiffCalcResultHelper.calcActcostupAmt_Comp(entrydyo, frow, "start"));
        entrydyo.set("currqty1", (Object)DiffCalcResultHelper.getQtyWithPrecision(frow, "pdcurrqty", qtyprecision));
        entrydyo.set("curramt1", (Object)frow.getBigDecimal("pdcurramount"));
        entrydyo.set("curractcostupamt1", (Object)DiffCalcResultHelper.calcActcostupAmt_Comp(entrydyo, frow, "curr"));
        entrydyo.set("compqty1", (Object)DiffCalcResultHelper.getQtyWithPrecision(frow, "pdcompqty", qtyprecision));
        entrydyo.set("compamt1", (Object)frow.getBigDecimal("pdcompanount"));
        entrydyo.set("compactcostupamt1", (Object)DiffCalcResultHelper.calcActcostupAmt_Comp(entrydyo, frow, "comp"));
        entrydyo.set("endqty1", (Object)DiffCalcResultHelper.getQtyWithPrecision(frow, "pdendqty", qtyprecision));
        entrydyo.set("endamt1", (Object)frow.getBigDecimal("pdendamount"));
        entrydyo.set("endactcostupamt1", (Object)DiffCalcResultHelper.calcActcostupAmt_Comp(entrydyo, frow, "end"));
        entrydyo.set("totalqty1", (Object)DiffCalcResultHelper.getQtyWithPrecision(frow, "stdqty", qtyprecision));
        entrydyo.set("totalamt1", (Object)frow.getBigDecimal("stdamount"));
        entrydyo.set("totalactcostupamt1", (Object)DiffCalcResultHelper.calcActcostupAmt_Comp(entrydyo, frow, "total"));
    }

    public static BigDecimal sumValue(BigDecimal value1, BigDecimal value2, Integer scale) {
        value1 = value1 == null ? BigDecimal.ZERO : value1;
        value2 = value2 == null ? BigDecimal.ZERO : value2;
        return scale == null ? value1.add(value2) : value1.add(value2).setScale((int)scale, RoundingMode.HALF_UP);
    }

    private static BigDecimal getQtyWithPrecision(Row frow, String qtyfield, Integer qtyprecision) {
        Optional<BigDecimal> opqty = Optional.ofNullable(frow.getBigDecimal(qtyfield));
        if (opqty.isPresent()) {
            if (qtyprecision != null) {
                return opqty.get().setScale((int)qtyprecision, RoundingMode.HALF_UP);
            }
            return opqty.get();
        }
        return null;
    }

    public static BigDecimal calcActcostupAmt(DynamicObject entrydyo, Row frow, String flag) {
        String standardamt = String.format("%samt", flag);
        BigDecimal totaldiffamt = DiffCalcResultHelper.getTotalDiffAmt(entrydyo, flag);
        BigDecimal standardamtValue = entrydyo.getBigDecimal(standardamt) == null ? BigDecimal.ZERO : entrydyo.getBigDecimal(standardamt);
        return standardamtValue.add(totaldiffamt);
    }

    public static BigDecimal calcActcostupAmt_Comp(DynamicObject entrydyo, Row frow, String flag) {
        String standardamt = String.format("%samt1", flag);
        BigDecimal totaldiffamt = DiffCalcResultHelper.getTotalDiffAmt_Comp(entrydyo, flag);
        BigDecimal standardamtValue = entrydyo.getBigDecimal(standardamt) == null ? BigDecimal.ZERO : entrydyo.getBigDecimal(standardamt);
        return standardamtValue.add(totaldiffamt);
    }

    public static BigDecimal getTotalDiffAmt(DynamicObject entrydyo, String flag) {
        BigDecimal sorddiff = entrydyo.getBigDecimal(String.format("%sorddiff", flag));
        BigDecimal invoicediff = entrydyo.getBigDecimal(String.format("%sinvoicediff", flag));
        BigDecimal feediff = entrydyo.getBigDecimal(String.format("%sfeediff", flag));
        BigDecimal otherdiff = entrydyo.getBigDecimal(String.format("%sotherdiff", flag));
        BigDecimal diffqty = entrydyo.getBigDecimal(String.format("%sdiffqty", flag));
        BigDecimal madediff = entrydyo.getBigDecimal(String.format("%smadediff", flag));
        BigDecimal unjoindiffamt = entrydyo.getBigDecimal(String.format("%sunjoindiffamt", flag));
        BigDecimal madeupamt = entrydyo.getBigDecimal(String.format("%smadeupamt", flag));
        BigDecimal stdcostupam = entrydyo.getBigDecimal(String.format("%sstdcostupamt", flag));
        BigDecimal falldiff = entrydyo.getBigDecimal(String.format("%sfalldiff", flag));
        BigDecimal zero = BigDecimal.ZERO;
        sorddiff = sorddiff == null ? zero : sorddiff;
        invoicediff = invoicediff == null ? zero : invoicediff;
        feediff = feediff == null ? zero : feediff;
        otherdiff = otherdiff == null ? zero : otherdiff;
        diffqty = diffqty == null ? zero : diffqty;
        madediff = madediff == null ? zero : madediff;
        unjoindiffamt = unjoindiffamt == null ? zero : unjoindiffamt;
        madeupamt = madeupamt == null ? zero : madeupamt;
        stdcostupam = stdcostupam == null ? zero : stdcostupam;
        falldiff = falldiff == null ? zero : falldiff;
        BigDecimal totalDiffamt = sorddiff.add(invoicediff).add(feediff).add(otherdiff).add(diffqty).add(madediff).add(unjoindiffamt).add(madeupamt).add(stdcostupam).add(falldiff);
        return totalDiffamt;
    }

    public static BigDecimal getTotalDiffAmt_Comp(DynamicObject entrydyo, String flag) {
        BigDecimal sorddiff = entrydyo.getBigDecimal(String.format("%sorddiff1", flag));
        BigDecimal invoicediff = entrydyo.getBigDecimal(String.format("%sinvoicediff1", flag));
        BigDecimal feediff = entrydyo.getBigDecimal(String.format("%sfeediff1", flag));
        BigDecimal otherdiff = entrydyo.getBigDecimal(String.format("%sotherdiff1", flag));
        BigDecimal diffqty = entrydyo.getBigDecimal(String.format("%sdiffqty1", flag));
        BigDecimal madediff = entrydyo.getBigDecimal(String.format("%smadediff1", flag));
        BigDecimal unjoindiffamt = entrydyo.getBigDecimal(String.format("%sunjoindiffamt1", flag));
        BigDecimal madeupamt = entrydyo.getBigDecimal(String.format("%smadeupamt1", flag));
        BigDecimal stdcostupam = entrydyo.getBigDecimal(String.format("%sstdcostupamt1", flag));
        BigDecimal falldiff = entrydyo.getBigDecimal(String.format("%sfalldiff1", flag));
        BigDecimal zero = BigDecimal.ZERO;
        sorddiff = sorddiff == null ? zero : sorddiff;
        invoicediff = invoicediff == null ? zero : invoicediff;
        feediff = feediff == null ? zero : feediff;
        otherdiff = otherdiff == null ? zero : otherdiff;
        diffqty = diffqty == null ? zero : diffqty;
        madediff = madediff == null ? zero : madediff;
        unjoindiffamt = unjoindiffamt == null ? zero : unjoindiffamt;
        madeupamt = madeupamt == null ? zero : madeupamt;
        stdcostupam = stdcostupam == null ? zero : stdcostupam;
        falldiff = falldiff == null ? zero : falldiff;
        BigDecimal totalDiffamt = sorddiff.add(invoicediff).add(feediff).add(otherdiff).add(diffqty).add(madediff).add(unjoindiffamt).add(madeupamt).add(stdcostupam).add(falldiff);
        return totalDiffamt;
    }

    public static void setTotalPeriodDiffInfo(DynamicObject entrydyo, Row frow) {
        entrydyo.set("totalorddiff", (Object)DiffCalcResultHelper.calcTotalPeriodDiff(entrydyo, frow, "orddiff"));
        entrydyo.set("totalinvoicediff", (Object)DiffCalcResultHelper.calcTotalPeriodDiff(entrydyo, frow, "invoicediff"));
        entrydyo.set("totalfeediff", (Object)DiffCalcResultHelper.calcTotalPeriodDiff(entrydyo, frow, "feediff"));
        entrydyo.set("totalotherdiff", (Object)DiffCalcResultHelper.calcTotalPeriodDiff(entrydyo, frow, "otherdiff"));
        entrydyo.set("totalfalldiff", (Object)DiffCalcResultHelper.calcTotalPeriodDiff(entrydyo, frow, "falldiff"));
        entrydyo.set("totaldiffqty", (Object)DiffCalcResultHelper.calcTotalPeriodDiff(entrydyo, frow, "diffqty"));
        entrydyo.set("totalmadediff", (Object)DiffCalcResultHelper.calcTotalPeriodDiff(entrydyo, frow, "madediff"));
        entrydyo.set("totalunjoindiffamt", (Object)DiffCalcResultHelper.calcTotalPeriodDiff(entrydyo, frow, "unjoindiffamt"));
        entrydyo.set("totalmadeupamt", (Object)DiffCalcResultHelper.calcTotalPeriodDiff(entrydyo, frow, "madeupamt"));
        entrydyo.set("totalstdcostupamt", (Object)DiffCalcResultHelper.calcTotalPeriodDiff(entrydyo, frow, "stdcostupamt"));
        entrydyo.set("totalactcostupamt", (Object)DiffCalcResultHelper.calcTotalPeriodDiff(entrydyo, frow, "actcostupamt"));
    }

    public static void setTotalPeriodDiffInfo_Comp(DynamicObject entrydyo, Row frow) {
        entrydyo.set("totalorddiff1", (Object)DiffCalcResultHelper.calcTotalPeriodDiff_Comp(entrydyo, frow, "orddiff"));
        entrydyo.set("totalinvoicediff1", (Object)DiffCalcResultHelper.calcTotalPeriodDiff_Comp(entrydyo, frow, "invoicediff"));
        entrydyo.set("totalfeediff1", (Object)DiffCalcResultHelper.calcTotalPeriodDiff_Comp(entrydyo, frow, "feediff"));
        entrydyo.set("totalotherdiff1", (Object)DiffCalcResultHelper.calcTotalPeriodDiff_Comp(entrydyo, frow, "otherdiff"));
        entrydyo.set("totalfalldiff1", (Object)DiffCalcResultHelper.calcTotalPeriodDiff_Comp(entrydyo, frow, "falldiff"));
        entrydyo.set("totaldiffqty1", (Object)DiffCalcResultHelper.calcTotalPeriodDiff_Comp(entrydyo, frow, "diffqty"));
        entrydyo.set("totalmadediff1", (Object)DiffCalcResultHelper.calcTotalPeriodDiff_Comp(entrydyo, frow, "madediff"));
        entrydyo.set("totalunjoindiffamt1", (Object)DiffCalcResultHelper.calcTotalPeriodDiff_Comp(entrydyo, frow, "unjoindiffamt"));
        entrydyo.set("totalmadeupamt1", (Object)DiffCalcResultHelper.calcTotalPeriodDiff_Comp(entrydyo, frow, "madeupamt"));
        entrydyo.set("totalstdcostupamt1", (Object)DiffCalcResultHelper.calcTotalPeriodDiff_Comp(entrydyo, frow, "stdcostupamt"));
        entrydyo.set("totalactcostupamt1", (Object)DiffCalcResultHelper.calcTotalPeriodDiff_Comp(entrydyo, frow, "actcostupamt"));
    }

    public static void setDiffAllocWipInfo(DynamicObject entrydyo) {
        entrydyo.set("endorddiff", (Object)DiffCalcResultHelper.calcEndDiff(entrydyo, "orddiff"));
        entrydyo.set("endinvoicediff", (Object)DiffCalcResultHelper.calcEndDiff(entrydyo, "invoicediff"));
        entrydyo.set("endfeediff", (Object)DiffCalcResultHelper.calcEndDiff(entrydyo, "feediff"));
        entrydyo.set("endotherdiff", (Object)DiffCalcResultHelper.calcEndDiff(entrydyo, "otherdiff"));
        entrydyo.set("endfalldiff", (Object)DiffCalcResultHelper.calcEndDiff(entrydyo, "falldiff"));
        entrydyo.set("enddiffqty", (Object)DiffCalcResultHelper.calcEndDiff(entrydyo, "diffqty"));
        entrydyo.set("endmadediff", (Object)DiffCalcResultHelper.calcEndDiff(entrydyo, "madediff"));
        entrydyo.set("endunjoindiffamt", (Object)DiffCalcResultHelper.calcEndDiff(entrydyo, "unjoindiffamt"));
        entrydyo.set("endmadeupamt", (Object)DiffCalcResultHelper.calcEndDiff(entrydyo, "madeupamt"));
        entrydyo.set("endstdcostupamt", (Object)DiffCalcResultHelper.calcEndDiff(entrydyo, "stdcostupamt"));
        entrydyo.set("endactcostupamt", (Object)DiffCalcResultHelper.calcEndDiff(entrydyo, "actcostupamt"));
    }

    public static void setDiffAllocWipInfo_Comp(DynamicObject entrydyo) {
        entrydyo.set("endorddiff1", (Object)DiffCalcResultHelper.calcEndDiff_Comp(entrydyo, "orddiff"));
        entrydyo.set("endinvoicediff1", (Object)DiffCalcResultHelper.calcEndDiff_Comp(entrydyo, "invoicediff"));
        entrydyo.set("endfeediff1", (Object)DiffCalcResultHelper.calcEndDiff_Comp(entrydyo, "feediff"));
        entrydyo.set("endotherdiff1", (Object)DiffCalcResultHelper.calcEndDiff_Comp(entrydyo, "otherdiff"));
        entrydyo.set("endfalldiff1", (Object)DiffCalcResultHelper.calcEndDiff_Comp(entrydyo, "falldiff"));
        entrydyo.set("enddiffqty1", (Object)DiffCalcResultHelper.calcEndDiff_Comp(entrydyo, "diffqty"));
        entrydyo.set("endmadediff1", (Object)DiffCalcResultHelper.calcEndDiff_Comp(entrydyo, "madediff"));
        entrydyo.set("endunjoindiffamt1", (Object)DiffCalcResultHelper.calcEndDiff_Comp(entrydyo, "unjoindiffamt"));
        entrydyo.set("endmadeupamt1", (Object)DiffCalcResultHelper.calcEndDiff_Comp(entrydyo, "madeupamt"));
        entrydyo.set("endstdcostupamt1", (Object)DiffCalcResultHelper.calcEndDiff_Comp(entrydyo, "stdcostupamt"));
        entrydyo.set("endactcostupamt1", (Object)DiffCalcResultHelper.calcEndDiff_Comp(entrydyo, "actcostupamt"));
    }

    public static void setDiffAllocStartInfo(DynamicObject entrydyo, Row frow) {
        entrydyo.set("startorddiff", frow.get("endorddiff"));
        entrydyo.set("startinvoicediff", frow.get("endinvoicediff"));
        entrydyo.set("startfeediff", frow.get("endfeediff"));
        entrydyo.set("startotherdiff", frow.get("endotherdiff"));
        entrydyo.set("startfalldiff", frow.get("endfalldiff"));
        entrydyo.set("startdiffqty", frow.get("enddiffqty"));
        entrydyo.set("startmadediff", frow.get("endmadediff"));
        entrydyo.set("startunjoindiffamt", frow.get("endunjoindiffamt"));
        entrydyo.set("startmadeupamt", frow.get("endmadeupamt"));
        entrydyo.set("startstdcostupamt", frow.get("endstdcostupamt"));
        entrydyo.set("startactcostupamt", frow.get("endactcostupamt"));
    }

    public static void setDiffAllocStartInfo_Comp(DynamicObject entrydyo, Row frow) {
        entrydyo.set("startorddiff1", frow.get("endorddiff1"));
        entrydyo.set("startinvoicediff1", frow.get("endinvoicediff1"));
        entrydyo.set("startfeediff1", frow.get("endfeediff1"));
        entrydyo.set("startotherdiff1", frow.get("endotherdiff1"));
        entrydyo.set("startfalldiff1", frow.get("endfalldiff1"));
        entrydyo.set("startdiffqty1", frow.get("enddiffqty1"));
        entrydyo.set("startmadediff1", frow.get("endmadediff1"));
        entrydyo.set("startunjoindiffamt1", frow.get("endunjoindiffamt1"));
        entrydyo.set("startmadeupamt1", frow.get("endmadeupamt1"));
        entrydyo.set("startstdcostupamt1", frow.get("endstdcostupamt1"));
        entrydyo.set("startactcostupamt1", frow.get("endactcostupamt1"));
    }

    public static DataSet getPrePeriodCalDiffResult(Object calOrgId, Object costAccountId, Object periodId, Set<Object> costobjects) {
        String algoKey = DiffCalcResultHelper.getAlgokey("getPrePeriodCalDiffResult");
        QFilter orgIdFilter = new QFilter("org", "=", (Object)99999999L);
        QFilter costAccountIdFilter = new QFilter("costaccount", "=", costAccountId);
        QFilter periodIdFilter = new QFilter("period", "=", periodId);
        QFilter costObjectIdFilter = new QFilter("costobject.id", "in", costobjects);
        String selectFields = DiffCalcResultHelper.getQueryFields();
        QFilter[] filters = new QFilter[]{orgIdFilter, costAccountIdFilter, periodIdFilter, costObjectIdFilter};
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_diffcalcresult", (String)selectFields, (QFilter[])filters, null);
        return dataSet;
    }

    public static void setDiffAllocCurrProductInfo(Object difftype, Object subadjamt, DynamicObject resultentrydyo) {
        switch (difftype.toString()) {
            case "G": {
                resultentrydyo.set("currorddiff", subadjamt);
                break;
            }
            case "H": {
                resultentrydyo.set("currinvoicediff", subadjamt);
                break;
            }
            case "K": {
                resultentrydyo.set("currfeediff", subadjamt);
                break;
            }
            case "T": {
                resultentrydyo.set("currotherdiff", subadjamt);
                break;
            }
            case "P": {
                resultentrydyo.set("currdiffqty", subadjamt);
                break;
            }
            case "Q": {
                resultentrydyo.set("currmadediff", subadjamt);
                break;
            }
            case "R": {
                resultentrydyo.set("currunjoindiffamt", subadjamt);
                break;
            }
            case "S": {
                resultentrydyo.set("currmadeupamt", subadjamt);
                break;
            }
            case "M": {
                resultentrydyo.set("currstdcostupamt", subadjamt);
                break;
            }
            case "C": {
                resultentrydyo.set("currfalldiff", subadjamt);
                break;
            }
        }
    }

    public static void setDiffAllocCurrProductInfo_Comp(Object difftype, Object subadjamt, DynamicObject resultentrydyo) {
        switch (difftype.toString()) {
            case "G": {
                resultentrydyo.set("currorddiff1", subadjamt);
                break;
            }
            case "H": {
                resultentrydyo.set("currinvoicediff1", subadjamt);
                break;
            }
            case "K": {
                resultentrydyo.set("currfeediff1", subadjamt);
                break;
            }
            case "T": {
                resultentrydyo.set("currotherdiff1", subadjamt);
                break;
            }
            case "P": {
                resultentrydyo.set("currdiffqty1", subadjamt);
                break;
            }
            case "Q": {
                resultentrydyo.set("currmadediff1", subadjamt);
                break;
            }
            case "R": {
                resultentrydyo.set("currunjoindiffamt1", subadjamt);
                break;
            }
            case "S": {
                resultentrydyo.set("currmadeupamt1", subadjamt);
                break;
            }
            case "M": {
                resultentrydyo.set("currstdcostupamt1", subadjamt);
                break;
            }
            case "C": {
                resultentrydyo.set("currfalldiff1", subadjamt);
                break;
            }
        }
    }

    public static BigDecimal getDiffAllocCurrProductInfo(Object difftype, DynamicObject resultentrydyo) {
        switch (difftype.toString()) {
            case "G": {
                return resultentrydyo.getBigDecimal("currorddiff");
            }
            case "H": {
                return resultentrydyo.getBigDecimal("currinvoicediff");
            }
            case "K": {
                return resultentrydyo.getBigDecimal("currfeediff");
            }
            case "T": {
                return resultentrydyo.getBigDecimal("currotherdiff");
            }
            case "P": {
                return resultentrydyo.getBigDecimal("currdiffqty");
            }
            case "Q": {
                return resultentrydyo.getBigDecimal("currmadediff");
            }
            case "R": {
                return resultentrydyo.getBigDecimal("currunjoindiffamt");
            }
            case "S": {
                return resultentrydyo.getBigDecimal("currmadeupamt");
            }
            case "M": {
                return resultentrydyo.getBigDecimal("currstdcostupamt");
            }
            case "C": {
                return resultentrydyo.getBigDecimal("currfalldiff");
            }
        }
        return BigDecimal.ZERO;
    }

    private static BigDecimal getDiffAllocCurrProductInfo_Comp(Object difftype, DynamicObject resultentrydyo) {
        switch (difftype.toString()) {
            case "G": {
                return resultentrydyo.getBigDecimal("currorddiff1");
            }
            case "H": {
                return resultentrydyo.getBigDecimal("currinvoicediff1");
            }
            case "K": {
                return resultentrydyo.getBigDecimal("currfeediff1");
            }
            case "T": {
                return resultentrydyo.getBigDecimal("currotherdiff1");
            }
            case "P": {
                return resultentrydyo.getBigDecimal("currdiffqty1");
            }
            case "Q": {
                return resultentrydyo.getBigDecimal("currmadediff1");
            }
            case "R": {
                return resultentrydyo.getBigDecimal("currunjoindiffamt1");
            }
            case "S": {
                return resultentrydyo.getBigDecimal("currmadeupamt1");
            }
            case "M": {
                return resultentrydyo.getBigDecimal("currstdcostupamt1");
            }
            case "C": {
                return resultentrydyo.getBigDecimal("currfalldiff1") == null ? BigDecimal.ZERO : resultentrydyo.getBigDecimal("currfalldiff1");
            }
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal getDiffAllocCurrFinishInfo(Object difftype, DynamicObject resultentrydyo) {
        switch (difftype.toString()) {
            case "G": {
                return resultentrydyo.getBigDecimal("comporddiff");
            }
            case "H": {
                return resultentrydyo.getBigDecimal("compinvoicediff");
            }
            case "K": {
                return resultentrydyo.getBigDecimal("compfeediff");
            }
            case "T": {
                return resultentrydyo.getBigDecimal("compotherdiff");
            }
            case "P": {
                return resultentrydyo.getBigDecimal("compdiffqty");
            }
            case "Q": {
                return resultentrydyo.getBigDecimal("compmadediff");
            }
            case "R": {
                return resultentrydyo.getBigDecimal("compunjoindiffamt");
            }
            case "S": {
                return resultentrydyo.getBigDecimal("compmadeupamt");
            }
            case "M": {
                return resultentrydyo.getBigDecimal("compstdcostupamt");
            }
            case "C": {
                return resultentrydyo.getBigDecimal("compfalldiff");
            }
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal getDiffAllocCurrFinishInfo_Comp(Object difftype, DynamicObject resultentrydyo) {
        switch (difftype.toString()) {
            case "G": {
                return resultentrydyo.getBigDecimal("comporddiff1");
            }
            case "H": {
                return resultentrydyo.getBigDecimal("compinvoicediff1");
            }
            case "K": {
                return resultentrydyo.getBigDecimal("compfeediff1");
            }
            case "T": {
                return resultentrydyo.getBigDecimal("compotherdiff1");
            }
            case "P": {
                return resultentrydyo.getBigDecimal("compdiffqty1");
            }
            case "Q": {
                return resultentrydyo.getBigDecimal("compmadediff1");
            }
            case "R": {
                return resultentrydyo.getBigDecimal("compunjoindiffamt1");
            }
            case "S": {
                return resultentrydyo.getBigDecimal("compmadeupamt1");
            }
            case "M": {
                return resultentrydyo.getBigDecimal("compstdcostupamt1");
            }
            case "C": {
                return resultentrydyo.getBigDecimal("compfalldiff1");
            }
        }
        return BigDecimal.ZERO;
    }

    public static void setDiffAllocCurrFinishInfo(Object difftype, Object subadjamt, DynamicObject resultentrydyo) {
        switch (difftype.toString()) {
            case "G": {
                resultentrydyo.set("comporddiff", subadjamt);
                break;
            }
            case "H": {
                resultentrydyo.set("compinvoicediff", subadjamt);
                break;
            }
            case "K": {
                resultentrydyo.set("compfeediff", subadjamt);
                break;
            }
            case "T": {
                resultentrydyo.set("compotherdiff", subadjamt);
                break;
            }
            case "P": {
                resultentrydyo.set("compdiffqty", subadjamt);
                break;
            }
            case "Q": {
                resultentrydyo.set("compmadediff", subadjamt);
                break;
            }
            case "R": {
                resultentrydyo.set("compunjoindiffamt", subadjamt);
                break;
            }
            case "S": {
                resultentrydyo.set("compmadeupamt", subadjamt);
                break;
            }
            case "M": {
                resultentrydyo.set("compstdcostupamt", subadjamt);
                break;
            }
            case "C": {
                resultentrydyo.set("compfalldiff", subadjamt);
            }
        }
    }

    public static void setDiffAllocCurrFinishInfo_Comp(Object difftype, Object subadjamt, DynamicObject resultentrydyo) {
        switch (difftype.toString()) {
            case "G": {
                resultentrydyo.set("comporddiff1", subadjamt);
                break;
            }
            case "H": {
                resultentrydyo.set("compinvoicediff1", subadjamt);
                break;
            }
            case "K": {
                resultentrydyo.set("compfeediff1", subadjamt);
                break;
            }
            case "T": {
                resultentrydyo.set("compotherdiff1", subadjamt);
                break;
            }
            case "P": {
                resultentrydyo.set("compdiffqty1", subadjamt);
                break;
            }
            case "Q": {
                resultentrydyo.set("compmadediff1", subadjamt);
                break;
            }
            case "R": {
                resultentrydyo.set("compunjoindiffamt1", subadjamt);
                break;
            }
            case "S": {
                resultentrydyo.set("compmadeupamt1", subadjamt);
                break;
            }
            case "M": {
                resultentrydyo.set("compstdcostupamt1", subadjamt);
                break;
            }
            case "C": {
                resultentrydyo.set("compfalldiff1", subadjamt);
                break;
            }
        }
    }

    public static void setDiffAllocSumCurrFinishInfo(Object difftype, BigDecimal subadjamt, DynamicObject resultentrydyo) {
        switch (difftype.toString()) {
            case "G": {
                BigDecimal comporddiff = resultentrydyo.getBigDecimal("comporddiff") == null ? BigDecimal.ZERO : resultentrydyo.getBigDecimal("comporddiff");
                resultentrydyo.set("comporddiff", (Object)comporddiff.add(subadjamt));
                break;
            }
            case "H": {
                BigDecimal compinvoicediff = resultentrydyo.getBigDecimal("compinvoicediff") == null ? BigDecimal.ZERO : resultentrydyo.getBigDecimal("compinvoicediff");
                resultentrydyo.set("compinvoicediff", (Object)compinvoicediff.add(subadjamt));
                break;
            }
            case "K": {
                BigDecimal compfeediff = resultentrydyo.getBigDecimal("compfeediff") == null ? BigDecimal.ZERO : resultentrydyo.getBigDecimal("compfeediff");
                resultentrydyo.set("compfeediff", (Object)compfeediff.add(subadjamt));
                break;
            }
            case "T": {
                BigDecimal compotherdiff = resultentrydyo.getBigDecimal("compotherdiff") == null ? BigDecimal.ZERO : resultentrydyo.getBigDecimal("compotherdiff");
                resultentrydyo.set("compotherdiff", (Object)compotherdiff.add(subadjamt));
                break;
            }
            case "P": {
                BigDecimal compdiffqty = resultentrydyo.getBigDecimal("compdiffqty") == null ? BigDecimal.ZERO : resultentrydyo.getBigDecimal("compdiffqty");
                resultentrydyo.set("compdiffqty", (Object)compdiffqty.add(subadjamt));
                break;
            }
            case "Q": {
                BigDecimal compmadediff = resultentrydyo.getBigDecimal("compmadediff") == null ? BigDecimal.ZERO : resultentrydyo.getBigDecimal("compmadediff");
                resultentrydyo.set("compmadediff", (Object)compmadediff.add(subadjamt));
                break;
            }
            case "R": {
                BigDecimal compunjoindiffamt = resultentrydyo.getBigDecimal("compunjoindiffamt") == null ? BigDecimal.ZERO : resultentrydyo.getBigDecimal("compunjoindiffamt");
                resultentrydyo.set("compunjoindiffamt", (Object)compunjoindiffamt.add(subadjamt));
                break;
            }
            case "S": {
                BigDecimal compmadeupamt = resultentrydyo.getBigDecimal("compmadeupamt") == null ? BigDecimal.ZERO : resultentrydyo.getBigDecimal("compmadeupamt");
                resultentrydyo.set("compmadeupamt", (Object)compmadeupamt.add(subadjamt));
                break;
            }
            case "M": {
                BigDecimal compstdcostupamt = resultentrydyo.getBigDecimal("compstdcostupamt") == null ? BigDecimal.ZERO : resultentrydyo.getBigDecimal("compstdcostupamt");
                resultentrydyo.set("compstdcostupamt", (Object)compstdcostupamt.add(subadjamt));
                break;
            }
            case "C": {
                BigDecimal compfalldiff = resultentrydyo.getBigDecimal("compfalldiff") == null ? BigDecimal.ZERO : resultentrydyo.getBigDecimal("compfalldiff");
                resultentrydyo.set("compfalldiff", (Object)compfalldiff.add(subadjamt));
                break;
            }
        }
    }

    private static void setDiffAllocSumCurrFinishInfo_Comp(Object difftype, BigDecimal subadjamt, DynamicObject resultentrydyo) {
        switch (difftype.toString()) {
            case "G": {
                BigDecimal comporddiff = resultentrydyo.getBigDecimal("comporddiff1") == null ? BigDecimal.ZERO : resultentrydyo.getBigDecimal("comporddiff1");
                resultentrydyo.set("comporddiff1", (Object)comporddiff.add(subadjamt));
                break;
            }
            case "H": {
                BigDecimal compinvoicediff = resultentrydyo.getBigDecimal("compinvoicediff1") == null ? BigDecimal.ZERO : resultentrydyo.getBigDecimal("compinvoicediff1");
                resultentrydyo.set("compinvoicediff1", (Object)compinvoicediff.add(subadjamt));
                break;
            }
            case "K": {
                BigDecimal compfeediff = resultentrydyo.getBigDecimal("compfeediff1") == null ? BigDecimal.ZERO : resultentrydyo.getBigDecimal("compfeediff1");
                resultentrydyo.set("compfeediff1", (Object)compfeediff.add(subadjamt));
                break;
            }
            case "T": {
                BigDecimal compotherdiff = resultentrydyo.getBigDecimal("compotherdiff1") == null ? BigDecimal.ZERO : resultentrydyo.getBigDecimal("compotherdiff1");
                resultentrydyo.set("compotherdiff1", (Object)compotherdiff.add(subadjamt));
                break;
            }
            case "P": {
                BigDecimal compdiffqty = resultentrydyo.getBigDecimal("compdiffqty1") == null ? BigDecimal.ZERO : resultentrydyo.getBigDecimal("compdiffqty1");
                resultentrydyo.set("compdiffqty1", (Object)compdiffqty.add(subadjamt));
                break;
            }
            case "Q": {
                BigDecimal compmadediff = resultentrydyo.getBigDecimal("compmadediff1") == null ? BigDecimal.ZERO : resultentrydyo.getBigDecimal("compmadediff1");
                resultentrydyo.set("compmadediff1", (Object)compmadediff.add(subadjamt));
                break;
            }
            case "R": {
                BigDecimal compunjoindiffamt = resultentrydyo.getBigDecimal("compunjoindiffamt1") == null ? BigDecimal.ZERO : resultentrydyo.getBigDecimal("compunjoindiffamt1");
                resultentrydyo.set("compunjoindiffamt1", (Object)compunjoindiffamt.add(subadjamt));
                break;
            }
            case "S": {
                BigDecimal compmadeupamt = resultentrydyo.getBigDecimal("compmadeupamt1") == null ? BigDecimal.ZERO : resultentrydyo.getBigDecimal("compmadeupamt1");
                resultentrydyo.set("compmadeupamt1", (Object)compmadeupamt.add(subadjamt));
                break;
            }
            case "M": {
                BigDecimal compstdcostupamt = resultentrydyo.getBigDecimal("compstdcostupamt1") == null ? BigDecimal.ZERO : resultentrydyo.getBigDecimal("compstdcostupamt1");
                resultentrydyo.set("compstdcostupamt1", (Object)compstdcostupamt.add(subadjamt));
                break;
            }
            case "C": {
                BigDecimal compfalldiff = resultentrydyo.getBigDecimal("compfalldiff1") == null ? BigDecimal.ZERO : resultentrydyo.getBigDecimal("compfalldiff1");
                resultentrydyo.set("compfalldiff1", (Object)compfalldiff.add(subadjamt));
                break;
            }
        }
    }

    private static DataSet getPurchDiffAllocInfo(Object orgId, Object costAccountId, Object periodId) {
        String algoKey = DiffCalcResultHelper.getAlgokey("getPurchDiffAllocInfo");
        QFilter orgIdFilter = new QFilter("org", "=", orgId);
        QFilter costAccountIdFilter = new QFilter("costaccount", "=", costAccountId);
        QFilter periodIdFilter = new QFilter("period", "=", periodId);
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)"C");
        String selectFields = "'A' billtype,org, costcenter, costaccount, period, entryentity.costobject costobject,difftype,entryentity.costobject.material material,  entryentity.costobject.bizstatus bizstatus,entryentity.element element,entryentity.subelement subelement,isnull(entryentity.subentryentity.lastmaterial,0) submaterial,isnull(entryentity.subentryentity.lastversion,0) submatversion,isnull(entryentity.subentryentity.lastauxpty,0) submatauxpty,case when entryentity.subentryentity.lastmaterial is null then entryentity.amount else entryentity.subentryentity.adjamount end adjamount";
        QFilter[] filters = new QFilter[]{orgIdFilter, costAccountIdFilter, periodIdFilter, statusFilter};
        DataSet ds = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_purchdiffalloc", (String)selectFields, (QFilter[])filters, null);
        DataSet resultDs = ds.executeSql("select billtype,org, costcenter, costaccount, period,costobject,material,bizstatus,difftype,element,subelement,submaterial,submatversion,submatauxpty,sum(adjamount) curramount,sum(adjamount) finishamount   group by billtype,org, costcenter, costaccount, period,costobject,material,bizstatus,difftype,element,subelement,submaterial,submatversion,submatauxpty");
        return resultDs;
    }

    @Deprecated
    private static DataSet getPurchDiffAllocInfo_Comp(Object orgId, Object costAccountId, Object periodId) {
        String algoKey = DiffCalcResultHelper.getAlgokey("getPurchDiffAllocInfo");
        QFilter orgIdFilter = new QFilter("org", "=", orgId);
        QFilter costAccountIdFilter = new QFilter("costaccount", "=", costAccountId);
        QFilter periodIdFilter = new QFilter("period", "=", periodId);
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)"C");
        String selectFields = "'A' billtype,org, costcenter, costaccount, period, entryentity.costobject costobject,difftype,entryentity.costobject.material material,  entryentity.costobject.bizstatus bizstatus,entryentity.element element,entryentity.subelement subelement ,case when entryentity.element in (773173188837423104,773177371976173568,773173574319126528) then 0 else material end submaterial,version submatversion,auxpty submatauxpty,entryentity.amount adjamount";
        QFilter[] filters = new QFilter[]{orgIdFilter, costAccountIdFilter, periodIdFilter, statusFilter};
        DataSet ds = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_purchdiffalloc", (String)selectFields, (QFilter[])filters, null);
        DataSet resultDs = ds.executeSql("select billtype,org, costcenter, costaccount, period,costobject,material,bizstatus,difftype,element,subelement,submaterial,submatversion,submatauxpty,sum(adjamount) curramount,sum(adjamount) finishamount   group by billtype,org, costcenter, costaccount, period,costobject,material,bizstatus,difftype,element,subelement,submaterial,submatversion,submatauxpty");
        return resultDs;
    }

    private static DataSet getPurchDiffAllocInfo_Comp_V2(Object orgId, Object costAccountId, Object periodId) {
        String algoKey = DiffCalcResultHelper.getAlgokey("getPurchDiffAllocInfo");
        QFilter orgIdFilter = new QFilter("org", "=", orgId);
        QFilter costAccountIdFilter = new QFilter("costaccount", "=", costAccountId);
        QFilter periodIdFilter = new QFilter("period", "=", periodId);
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)"C");
        String selectFields = "'A' billtype,org, costcenter, costaccount, period, entryentity.costobject costobject,difftype,entryentity.costobject.material material,  entryentity.costobject.bizstatus bizstatus,entryentity.element element,entryentity.subelement subelement ,material submaterial,version submatversion,auxpty submatauxpty,entryentity.amount adjamount";
        QFilter[] filters = new QFilter[]{orgIdFilter, costAccountIdFilter, periodIdFilter, statusFilter};
        DataSet ds = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_purchdiffalloc", (String)selectFields, (QFilter[])filters, null);
        DataSet resultDs = ds.executeSql("select billtype,org, costcenter, costaccount, period,costobject,material,bizstatus,difftype,submaterial,submatversion,submatauxpty,sum(adjamount) curramount,sum(adjamount) finishamount   group by billtype,org, costcenter, costaccount, period,costobject,material,bizstatus,difftype,submaterial,submatversion,submatauxpty");
        resultDs = resultDs.select("billtype,org, costcenter, costaccount, period,costobject,material,bizstatus,difftype,773126985240072192 element,773175233367685120 subelement,submaterial,submatversion,submatauxpty,curramount,finishamount");
        return resultDs;
    }

    private static DataSet getAllWipCalcResultInfo(Object orgId, Object costAccountId, Object periodId, String dataType) {
        String algoKey = DiffCalcResultHelper.getAlgokey("getFinishProInfo");
        QFilter orgIdFilter = new QFilter("org", "=", orgId);
        QFilter costAccountIdFilter = new QFilter("costaccount", "=", costAccountId);
        QFilter periodIdFilter = new QFilter("period", "=", periodId);
        QFilter datatypeFilter = new QFilter("entryentity.datatype", "=", (Object)dataType);
        String decimalFields = "entryentity.pdstartqty pdstartqty,entryentity.pdstartamount pdstartamount, entryentity.pdcurrqty pdcurrqty,entryentity.pdcurramount pdcurramount, entryentity.pdcompqty pdcompqty,entryentity.pdcompanount pdcompanount, entryentity.pdendqty pdendqty,entryentity.pdendamount pdendamount, entryentity.diff diff,entryentity.costupdatediffamt costupamt, entryentity.totalqty totalqty,entryentity.totalamount totalamount, entryentity.stdqty stdqty,entryentity.stdamount stdamount";
        String selectFields = "org, costcenter, costaccount, period, costobject,entryentity.difftype difftype,costobject.bizstatus bizstatus,costobject.material material,entryentity.element element,entryentity.subelement subelement,entryentity.material submaterial,entryentity.matversion submatversion,entryentity.auxpty submatauxpty," + decimalFields;
        QFilter[] pfilters = new QFilter[]{orgIdFilter, costAccountIdFilter, periodIdFilter, datatypeFilter};
        DataSet ds = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_calcresult", (String)selectFields, (QFilter[])pfilters, null);
        GroupbyDataSet groupDataSet = ds.groupBy(new String[]{"org", "costcenter", "costaccount", "period", "costobject", "element", "subelement", "submaterial", "submatversion", "submatauxpty", "difftype", "bizstatus", "material"});
        groupDataSet.sum("pdstartqty");
        groupDataSet.sum("pdstartamount");
        groupDataSet.sum("pdcurrqty");
        groupDataSet.sum("pdcurramount");
        groupDataSet.sum("pdcompqty");
        groupDataSet.sum("pdcompanount");
        groupDataSet.sum("pdendqty");
        groupDataSet.sum("pdendamount");
        groupDataSet.sum("totalqty");
        groupDataSet.sum("totalamount");
        groupDataSet.sum("stdqty");
        groupDataSet.sum("stdamount");
        groupDataSet.sum("diff");
        groupDataSet.sum("costupamt");
        DataSet gds = groupDataSet.finish();
        DataSet resultDs = gds.executeSql("select org, costcenter, costaccount, period,costobject,material,bizstatus,case when difftype='1' then 'P' when difftype='2' then 'Q' \r\n when difftype='3' then 'S' when difftype='4' then 'R' else difftype end As difftype,element,subelement,submaterial,submatversion,submatauxpty,diff ,costupamt,stdamount,stdqty,totalamount, totalqty,pdendamount,pdendqty,pdcompanount,pdcompqty,pdcurramount,pdcurrqty,pdstartamount,pdstartqty");
        return resultDs;
    }

    private static DataSet getCurrLevelUnAbsorbDiffInfo(Object orgId, Object costAccountId, Object periodId) {
        String algoKey = DiffCalcResultHelper.getAlgokey("getUnAbsorbDiffInfo");
        QFilter orgIdFilter = new QFilter("org", "=", orgId);
        QFilter costAccountIdFilter = new QFilter("costaccount", "=", costAccountId);
        QFilter periodIdFilter = new QFilter("period", "=", periodId);
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)"C");
        String selectFields = "'T' billtype,org, costcenter, costaccount, period, costobject,costobject.bizstatus bizstatus, difftype,costobject.material material, entryentity.element element,entryentity.subelement subelement,0 submaterial,0 submatversion,0 submatauxpty,entryentity.amount adjamount";
        QFilter[] filters = new QFilter[]{orgIdFilter, costAccountIdFilter, periodIdFilter, statusFilter};
        DataSet ds = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_unabsorbdiff", (String)selectFields, (QFilter[])filters, null);
        DataSet resultDs = ds.executeSql("select billtype,org, costcenter, costaccount, period,costobject,material,bizstatus,case when difftype='1' then 'P' when difftype='2' then 'Q'   when difftype='3' then 'S' when difftype='4' then 'R' else difftype end As difftype,element,subelement,submaterial,submatversion,submatauxpty,0 curramount,sum(adjamount) finishamount  group by billtype,org, costcenter, costaccount, period,costobject,material,bizstatus,difftype,element,subelement,submaterial,submatversion,submatauxpty");
        return resultDs;
    }

    private static BigDecimal calcEndDiff(DynamicObject entrydyo, String difftype) {
        String bipdiff = String.format("start%s", difftype);
        String currPdiff = String.format("curr%s", difftype);
        String currFdiff = String.format("comp%s", difftype);
        BigDecimal bipdiffValue = entrydyo.getBigDecimal(bipdiff) == null ? BigDecimal.ZERO : entrydyo.getBigDecimal(bipdiff);
        BigDecimal currPdiffValue = entrydyo.getBigDecimal(currPdiff) == null ? BigDecimal.ZERO : entrydyo.getBigDecimal(currPdiff);
        BigDecimal currFdiffValue = entrydyo.getBigDecimal(currFdiff) == null ? BigDecimal.ZERO : entrydyo.getBigDecimal(currFdiff);
        return bipdiffValue.add(currPdiffValue).subtract(currFdiffValue);
    }

    private static BigDecimal calcEndDiff_Comp(DynamicObject entrydyo, String difftype) {
        String bipdiff = String.format("start%s1", difftype);
        String currPdiff = String.format("curr%s1", difftype);
        String currFdiff = String.format("comp%s1", difftype);
        BigDecimal bipdiffValue = entrydyo.getBigDecimal(bipdiff) == null ? BigDecimal.ZERO : entrydyo.getBigDecimal(bipdiff);
        BigDecimal currPdiffValue = entrydyo.getBigDecimal(currPdiff) == null ? BigDecimal.ZERO : entrydyo.getBigDecimal(currPdiff);
        BigDecimal currFdiffValue = entrydyo.getBigDecimal(currFdiff) == null ? BigDecimal.ZERO : entrydyo.getBigDecimal(currFdiff);
        return bipdiffValue.add(currPdiffValue).subtract(currFdiffValue);
    }

    private static BigDecimal calcTotalPeriodDiff(DynamicObject entrydyo, Row frow, String difftype) {
        String totaldiff = String.format("total%s", difftype);
        String compdiff = String.format("comp%s", difftype);
        BigDecimal compdiffValue = entrydyo.getBigDecimal(compdiff) == null ? BigDecimal.ZERO : entrydyo.getBigDecimal(compdiff);
        BigDecimal totaldiffValue = frow.getBigDecimal(totaldiff) == null ? BigDecimal.ZERO : frow.getBigDecimal(totaldiff);
        return compdiffValue.add(totaldiffValue);
    }

    private static BigDecimal calcTotalPeriodDiff_Comp(DynamicObject entrydyo, Row frow, String difftype) {
        String totaldiff = String.format("total%s1", difftype);
        String compdiff = String.format("comp%s1", difftype);
        BigDecimal compdiffValue = entrydyo.getBigDecimal(compdiff) == null ? BigDecimal.ZERO : entrydyo.getBigDecimal(compdiff);
        BigDecimal totaldiffValue = frow.getBigDecimal(totaldiff) == null ? BigDecimal.ZERO : frow.getBigDecimal(totaldiff);
        return compdiffValue.add(totaldiffValue);
    }

    private static void setCostObjectQty(DynamicObject dyo, Object costobject, Map<Object, Map<String, BigDecimal>> costObjectInfoDs) {
        Map<String, BigDecimal> comap = costObjectInfoDs.get(costobject);
        if (comap != null) {
            dyo.set("startqtys", (Object)comap.get("pdstartqty"));
            dyo.set("currqtys", (Object)comap.get("pdcurrqty"));
            dyo.set("compqtys", (Object)comap.get("pdcompqty"));
            dyo.set("endqtys", (Object)comap.get("pdendqty"));
            dyo.set("totalqtys", (Object)comap.get("totalqty"));
        }
    }

    private static void collFinishCostObjectSet(List<ProductCostObject> calcresults, Set<Object> finishcos) {
        calcresults.forEach(pc -> {
            Set<CostObjectForCalc> co = pc.getCostobjects();
            for (CostObjectForCalc costobject : co) {
                finishcos.add(costobject.getId());
            }
        });
    }

    private static String getQueryFields() {
        StringBuilder sb = new StringBuilder();
        sb.append("costobject AS r_costobject,");
        sb.append("bizstatus AS r_bizstatus,");
        sb.append("entryentity.element AS r_element,");
        sb.append("entryentity.subelement AS r_subelement,");
        sb.append("entryentity.material AS material,");
        sb.append("entryentity.auxpty AS auxpty,");
        sb.append("entryentity.matversion AS matversion,");
        sb.append("entryentity.baseunit AS baseunit,");
        sb.append("startqtys,currqtys,compqtys,endqtys,totalqtys,");
        sb.append("entryentity.startqty AS startqty,");
        sb.append("entryentity.startamt AS startamt,");
        sb.append("entryentity.startorddiff AS startorddiff,");
        sb.append("entryentity.startdiffqty AS startdiffqty,");
        sb.append("entryentity.startunjoindiffamt AS startunjoindiffamt,");
        sb.append("entryentity.startstdcostupamt AS startstdcostupamt,");
        sb.append("entryentity.startactcostupamt AS startactcostupamt,");
        sb.append("entryentity.currqty AS currqty,");
        sb.append("entryentity.curramt AS curramt,");
        sb.append("entryentity.currorddiff AS currorddiff,");
        sb.append("entryentity.currdiffqty AS currdiffqty,");
        sb.append("entryentity.currunjoindiffamt AS currunjoindiffamt,");
        sb.append("entryentity.currstdcostupamt AS currstdcostupamt,");
        sb.append("entryentity.curractcostupamt AS curractcostupamt,");
        sb.append("entryentity.compqty AS compqty,");
        sb.append("entryentity.compamt AS compamt,");
        sb.append("entryentity.comporddiff AS comporddiff,");
        sb.append("entryentity.compdiffqty AS compdiffqty,");
        sb.append("entryentity.compunjoindiffamt AS compunjoindiffamt,");
        sb.append("entryentity.compstdcostupamt AS compstdcostupamt,");
        sb.append("entryentity.compactcostupamt AS compactcostupamt,");
        sb.append("entryentity.totalqty AS totalqty,");
        sb.append("entryentity.totalamt AS totalamt,");
        sb.append("entryentity.totalorddiff AS totalorddiff,");
        sb.append("entryentity.totaldiffqty AS totaldiffqty,");
        sb.append("entryentity.totalunjoindiffamt AS totalunjoindiffamt,");
        sb.append("entryentity.totalstdcostupamt AS totalstdcostupamt,");
        sb.append("entryentity.totalactcostupamt AS totalactcostupamt,");
        sb.append("entryentity.endqty AS endqty,");
        sb.append("entryentity.endamt AS endamt,");
        sb.append("entryentity.endorddiff AS endorddiff,");
        sb.append("entryentity.enddiffqty AS enddiffqty,");
        sb.append("entryentity.endunjoindiffamt AS endunjoindiffamt,");
        sb.append("entryentity.endstdcostupamt AS endstdcostupamt,");
        sb.append("entryentity.endactcostupamt AS endactcostupamt,");
        sb.append("entryentity.startinvoicediff AS startinvoicediff,");
        sb.append("entryentity.startfeediff AS startfeediff,");
        sb.append("entryentity.startotherdiff AS startotherdiff,");
        sb.append("entryentity.startfalldiff AS startfalldiff,");
        sb.append("entryentity.startmadediff AS startmadediff,");
        sb.append("entryentity.startmadeupamt AS startmadeupamt,");
        sb.append("entryentity.totalinvoicediff AS totalinvoicediff,");
        sb.append("entryentity.totalfeediff AS totalfeediff,");
        sb.append("entryentity.totalotherdiff AS totalotherdiff,");
        sb.append("entryentity.totalfalldiff AS totalfalldiff,");
        sb.append("entryentity.totalmadediff AS totalmadediff,");
        sb.append("entryentity.totalmadeupamt AS totalmadeupamt,");
        sb.append("entryentity.endinvoicediff AS endinvoicediff,");
        sb.append("entryentity.endfeediff AS endfeediff,");
        sb.append("entryentity.endotherdiff AS endotherdiff,");
        sb.append("entryentity.endfalldiff AS endfalldiff,");
        sb.append("entryentity.endmadediff AS endmadediff,");
        sb.append("entryentity.endmadeupamt AS endmadeupamt,");
        sb.append("entryentity.compinvoicediff AS compinvoicediff,");
        sb.append("entryentity.compfeediff AS compfeediff,");
        sb.append("entryentity.compotherdiff AS compotherdiff,");
        sb.append("entryentity.compfalldiff AS compfalldiff,");
        sb.append("entryentity.compmadediff AS compmadediff,");
        sb.append("entryentity.compmadeupamt AS compmadeupamt,");
        sb.append("entryentity.currinvoicediff AS currinvoicediff,");
        sb.append("entryentity.currfeediff AS currfeediff,");
        sb.append("entryentity.currotherdiff AS currotherdiff,");
        sb.append("entryentity.currfalldiff AS currfalldiff,");
        sb.append("entryentity.currmadediff AS currmadediff,");
        sb.append("entryentity.currmadeupamt AS currmadeupamt,");
        sb.append("entryentity1.element1 AS r_element1,");
        sb.append("entryentity1.subelement1 AS r_subelement1,");
        sb.append("entryentity1.material1 AS material1,");
        sb.append("entryentity1.auxpty1 AS auxpty1,");
        sb.append("entryentity1.matversion1 AS matversion1,");
        sb.append("entryentity1.baseunit1 AS baseunit1,");
        sb.append("entryentity1.startqty1 AS startqty1,");
        sb.append("entryentity1.startamt1 AS startamt1,");
        sb.append("entryentity1.startorddiff1 AS startorddiff1,");
        sb.append("entryentity1.startdiffqty1 AS startdiffqty1,");
        sb.append("entryentity1.startunjoindiffamt1 AS startunjoindiffamt1,");
        sb.append("entryentity1.startstdcostupamt1 AS startstdcostupamt1,");
        sb.append("entryentity1.startactcostupamt1 AS startactcostupamt1,");
        sb.append("entryentity1.currqty1 AS currqty1,");
        sb.append("entryentity1.curramt1 AS curramt1,");
        sb.append("entryentity1.currorddiff1 AS currorddiff1,");
        sb.append("entryentity1.currdiffqty1 AS currdiffqty1,");
        sb.append("entryentity1.currunjoindiffamt1 AS currunjoindiffamt1,");
        sb.append("entryentity1.currstdcostupamt1 AS currstdcostupamt1,");
        sb.append("entryentity1.curractcostupamt1 AS curractcostupamt1,");
        sb.append("entryentity1.compqty1 AS compqty1,");
        sb.append("entryentity1.compamt1 AS compamt1,");
        sb.append("entryentity1.comporddiff1 AS comporddiff1,");
        sb.append("entryentity1.compdiffqty1 AS compdiffqty1,");
        sb.append("entryentity1.compunjoindiffamt1 AS compunjoindiffamt1,");
        sb.append("entryentity1.compstdcostupamt1 AS compstdcostupamt1,");
        sb.append("entryentity1.compactcostupamt1 AS compactcostupamt1,");
        sb.append("entryentity1.totalqty1 AS totalqty1,");
        sb.append("entryentity1.totalamt1 AS totalamt1,");
        sb.append("entryentity1.totalorddiff1 AS totalorddiff1,");
        sb.append("entryentity1.totaldiffqty1 AS totaldiffqty1,");
        sb.append("entryentity1.totalunjoindiffamt1 AS totalunjoindiffamt1,");
        sb.append("entryentity1.totalstdcostupamt1 AS totalstdcostupamt1,");
        sb.append("entryentity1.totalactcostupamt1 AS totalactcostupamt1,");
        sb.append("entryentity1.endqty1 AS endqty1,");
        sb.append("entryentity1.endamt1 AS endamt1,");
        sb.append("entryentity1.endorddiff1 AS endorddiff1,");
        sb.append("entryentity1.enddiffqty1 AS enddiffqty1,");
        sb.append("entryentity1.endunjoindiffamt1 AS endunjoindiffamt1,");
        sb.append("entryentity1.endstdcostupamt1 AS endstdcostupamt1,");
        sb.append("entryentity1.endactcostupamt1 AS endactcostupamt1,");
        sb.append("entryentity1.startinvoicediff1 AS startinvoicediff1,");
        sb.append("entryentity1.startfeediff1 AS startfeediff1,");
        sb.append("entryentity1.startotherdiff1 AS startotherdiff1,");
        sb.append("entryentity1.startfalldiff1 AS startfalldiff1,");
        sb.append("entryentity1.startmadediff1 AS startmadediff1,");
        sb.append("entryentity1.startmadeupamt1 AS startmadeupamt1,");
        sb.append("entryentity1.totalinvoicediff1 AS totalinvoicediff1,");
        sb.append("entryentity1.totalfeediff1 AS totalfeediff1,");
        sb.append("entryentity1.totalotherdiff1 AS totalotherdiff1,");
        sb.append("entryentity1.totalfalldiff1 AS totalfalldiff1,");
        sb.append("entryentity1.totalmadediff1 AS totalmadediff1,");
        sb.append("entryentity1.totalmadeupamt1 AS totalmadeupamt1,");
        sb.append("entryentity1.endinvoicediff1 AS endinvoicediff1,");
        sb.append("entryentity1.endfeediff1 AS endfeediff1,");
        sb.append("entryentity1.endotherdiff1 AS endotherdiff1,");
        sb.append("entryentity1.endfalldiff1 AS endfalldiff1,");
        sb.append("entryentity1.endmadediff1 AS endmadediff1,");
        sb.append("entryentity1.endmadeupamt1 AS endmadeupamt1,");
        sb.append("entryentity1.compinvoicediff1 AS compinvoicediff1,");
        sb.append("entryentity1.compfeediff1 AS compfeediff1,");
        sb.append("entryentity1.compotherdiff1 AS compotherdiff1,");
        sb.append("entryentity1.compfalldiff1 AS compfalldiff1,");
        sb.append("entryentity1.compmadediff1 AS compmadediff1,");
        sb.append("entryentity1.compmadeupamt1 AS compmadeupamt1,");
        sb.append("entryentity1.currinvoicediff1 AS currinvoicediff1,");
        sb.append("entryentity1.currfeediff1 AS currfeediff1,");
        sb.append("entryentity1.currotherdiff1 AS currotherdiff1,");
        sb.append("entryentity1.currfalldiff1 AS currfalldiff1,");
        sb.append("entryentity1.currmadediff1 AS currmadediff1,");
        sb.append("entryentity1.currmadeupamt1 AS currmadeupamt1");
        return sb.toString();
    }

    private static String[] getPreCalResultDsFields() {
        String fields = "baseunit,endorddiff,endinvoicediff,endfeediff,endotherdiff,endfalldiff,enddiffqty,endmadediff,endunjoindiffamt,endmadeupamt,endstdcostupamt,endactcostupamt,totalorddiff,totalinvoicediff,totalfeediff,totalotherdiff,totalfalldiff,totaldiffqty,totalmadediff,totalunjoindiffamt,totalmadeupamt,totalstdcostupamt,totalactcostupamt";
        return fields.split(",");
    }

    private static String[] getCompPreCalResultDsFields() {
        String fields = "baseunit1,endorddiff1,endinvoicediff1,endfeediff1,endotherdiff1,endfalldiff1,enddiffqty1,endmadediff1,endunjoindiffamt1,endmadeupamt1,endstdcostupamt1,endactcostupamt1,totalorddiff1,totalinvoicediff1,totalfeediff1,totalotherdiff1,totalfalldiff1,totaldiffqty1,totalmadediff1,totalunjoindiffamt1,totalmadeupamt1,totalstdcostupamt1,totalactcostupamt1";
        return fields.split(",");
    }

    public static String getAlgokey(String methodname) {
        return String.format("kd.macc.sca.algox.utils.DiffCalcResultHelper.%s", methodname);
    }

    public static void closeDataSet(DataSet ... ecostcalcRs) {
        for (DataSet dataSet : ecostcalcRs) {
            if (dataSet == null) continue;
            dataSet.close();
        }
    }

    public static OperationResult delete(String entityName, QFilter[] qFilters) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityName);
        String pkProperty = dt.getPrimaryKey().getName();
        DataSet ds = QueryServiceHelper.queryDataSet((String)(DiffCalcResultHelper.getAlgokey("delete") + entityName), (String)entityName, (String)pkProperty, (QFilter[])qFilters, (String)null);
        ArrayList<Object> pks = new ArrayList<Object>();
        for (Row row : ds) {
            pks.add(row.get(0));
        }
        if (!pks.isEmpty()) {
            OperationServiceHelper.executeOperate((String)"unaudit", (String)entityName, (Object[])pks.toArray(new Object[0]), (OperateOption)OperateOption.create());
            return OperationServiceHelper.executeOperate((String)"delete", (String)entityName, (Object[])pks.toArray(new Object[0]), (OperateOption)OperateOption.create());
        }
        return new OperationResult();
    }

    public static List<List<DynamicObject>> splitList(List<DynamicObject> dyos, int len) {
        if (dyos == null || dyos.size() == 0 || len < 1) {
            return null;
        }
        ArrayList<List<DynamicObject>> result = new ArrayList<List<DynamicObject>>(10);
        int size = dyos.size();
        int count = (size + len - 1) / len;
        for (int i = 0; i < count; ++i) {
            List<DynamicObject> subList = dyos.subList(i * len, (i + 1) * len > size ? size : len * (i + 1));
            result.add(subList);
        }
        return result;
    }
}

