/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.utils;

import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.sca.algox.alloc.input.CalcDataArgs;
import kd.macc.sca.algox.utils.CadEmptyUtils;

public class DiffMatCostHelper {
    private static final int MAP_INITIAL_CAPACITY = 16;

    public static DataSet getStdCost(CalcDataArgs args) {
        String alokey = "kd.macc.sca.algox.utils.MatCostHelper.getStdCost";
        QFilter commonFilter = new QFilter("org", "=", (Object)((Long)args.getOrgId()));
        if (!CadEmptyUtils.isEmpty(args.getCostCenterIds())) {
            commonFilter.and(new QFilter("costcenter", "in", args.getCostCenterIds()));
        }
        commonFilter.and(new QFilter("bookdate", "<=", (Object)args.getEndDate()));
        commonFilter.and(new QFilter("bookdate", ">=", (Object)args.getStartDate()));
        QFilter costObjectFilter = new QFilter("entryentity.costobject", "in", args.getCostObjects());
        QFilter billstatus = new QFilter("billstatus", "=", (Object)"C");
        DataSet finishInputQty = QueryServiceHelper.queryDataSet((String)alokey, (String)"cad_factnedoutputbill", (String)(Long.valueOf(args.getOrgId().toString()) + " orgid,costcenter.masterid costcenterid," + Long.valueOf(args.getCostAcctId().toString()) + " costaccountid," + Long.valueOf(args.getPeriodId().toString()) + " periodid,entryentity.costobject.id costobjectid,entryentity.costobject.material.masterid materialid,entryentity.costobject.bomversion.id matversionid,entryentity.costobject.auxpty.id auxptyid,entryentity.qty qty,bizdate"), (QFilter[])new QFilter[]{commonFilter, costObjectFilter, billstatus}, null);
        DynamicObject costaccountInfo = BusinessDataServiceHelper.loadSingle((Object)args.getCostAcctId(), (String)"cal_bd_costaccount");
        DynamicObject costTypeInfo = BusinessDataServiceHelper.loadSingle((Object)costaccountInfo.getLong("costtype.masterid"), (String)"cad_costtype");
        QFilter costtypeFilter = new QFilter("costtype", "=", (Object)costTypeInfo.getLong("masterid"));
        QFilter calcTypeFilter = new QFilter("entryentity.datatype", "in", (Object)new String[]{"2", "3", "4"});
        QFilter stdIsMainDataFilter = new QFilter("ismaindata", "=", (Object)1);
        DataSet calcDataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.cad.business.check.ProductStdCostCheckAction.getCalcCostObjectDataSet", (String)"cad_calceffectiveresult", (String)"material.masterid matid,matvers.id matverId,auxproperty.id auxptyId,entryentity.submaterial.id submatid,entryentity.submatvers.id submatverId,entryentity.subauxproperty.id subauxptyId,effectdate,expdate,entryentity.element.masterid elementid,entryentity.subelement.masterid subelementid,entryentity.subelement.type subelementtype,entryentity.qty subqty,entryentity.stdprice stdprice,entryentity.datatype calcdatatype", (QFilter[])new QFilter[]{costtypeFilter, calcTypeFilter, stdIsMainDataFilter}, null);
        JoinDataSet joinDataSet = finishInputQty.join(calcDataSet, JoinType.LEFT);
        joinDataSet.on("materialid", "matid");
        joinDataSet.on("matversionid", "matverId");
        joinDataSet.on("auxptyid", "auxptyId");
        DataSet calcAllDataSet = joinDataSet.select(new String[]{"orgid", "costaccountid", "periodid", "costcenterid", "costobjectid", "qty", "bizdate"}, new String[]{"matid", "matverId", "auxptyId", "submatid", "submatverId", "subauxptyId", "effectdate", "expdate", "elementid", "subelementid", "subelementtype", "subqty", "stdprice", "calcdatatype"}).finish();
        calcAllDataSet = calcAllDataSet.select("orgid,costaccountid,periodid,costcenterid,costobjectid,matid materialid,matverId matversionid, auxptyId auxptyid,bizdate,effectdate,expdate, submatid,submatverId,subauxptyId,elementid,subelementid,subelementtype,qty*subqty stdqty,qty*stdprice stdcost,calcdatatype").where(" expdate >= bizdate and effectdate <= bizdate");
        DataSet stdCostSubData = calcAllDataSet.select("orgid,costaccountid,periodid,costcenterid,costobjectid,submatid materialid,submatverId matversionid,subauxptyId auxptyid,elementid,subelementid,subelementtype,stdqty,stdcost,'3' caltype,case when subelementtype == '001' OR subelementtype == '002' then '1' else '2' end  difftype,'2' datatype,calcdatatype,                                       0 pdstartqty,0 pdstartamount,0 pdcurrqty,0 pdcurramount,0 pdcompqty,0 pdcompanount,0 pdendqty,0 pdendamount,0 diff,0 totalqty,0 totalamount,0 totalstdqty,0 totalstdamount").where(" calcdatatype = '2' or calcdatatype = '3' ");
        DataSet stdCostCompData = calcAllDataSet.select("orgid,costaccountid,periodid,costcenterid,costobjectid,submatid materialid,submatverId matversionid,subauxptyId auxptyid,elementid,subelementid,subelementtype,stdqty,stdcost,'3' caltype,case when subelementtype == '001' OR subelementtype == '002' then '1' else '2' end  difftype,'1' datatype,calcdatatype,                                       0 pdstartqty,0 pdstartamount,0 pdcurrqty,0 pdcurramount,0 pdcompqty,0 pdcompanount,0 pdendqty,0 pdendamount,0 diff,0 totalqty,0 totalamount,0 totalstdqty,0 totalstdamount").where(" calcdatatype = '2' or calcdatatype = '4'");
        DataSet stdCostAllDataSet = stdCostSubData.union(stdCostCompData);
        GroupbyDataSet groupDataSet = stdCostAllDataSet.groupBy(new String[]{"orgid", "costaccountid", "periodid", "costcenterid", "costobjectid", "materialid", "matversionid", "auxptyid", "elementid", "subelementid", "difftype", "caltype", "datatype"});
        groupDataSet.sum("pdstartqty");
        groupDataSet.sum("pdstartamount");
        groupDataSet.sum("pdcurrqty");
        groupDataSet.sum("pdcurramount");
        groupDataSet.sum("pdcompqty");
        groupDataSet.sum("pdcompanount");
        groupDataSet.sum("pdendqty");
        groupDataSet.sum("pdendamount");
        groupDataSet.sum("diff");
        groupDataSet.sum("totalqty");
        groupDataSet.sum("totalamount");
        groupDataSet.sum("totalstdqty");
        groupDataSet.sum("totalstdamount");
        groupDataSet.sum("stdqty");
        groupDataSet.sum("stdcost");
        String seleFields = "orgid, costaccountid, costobjectid, costcenterid, periodid, elementid, subelementid, materialid, auxptyid, matversionid, datatype, difftype, caltype, stdqty, stdcost, pdstartqty, pdstartamount, pdcurrqty, pdcurramount, pdcompqty, pdcompanount, pdendqty, pdendamount, diff, totalqty, totalamount, totalstdqty, totalstdamount,0 costupdatediffamt";
        return groupDataSet.finish().select(seleFields);
    }
}

