/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.utils;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.CostTypeHelper;

public class ElementHelper {
    public static Map<String, String> getElementInfos(Set<Long> costObjectIds, String subMatInfo, Date bizDate, Long costaccount, Long orgId, Long manuOrgId) {
        HashMap<String, String> elementInfos = new HashMap<String, String>();
        QFilter costObjectFilter = new QFilter("id", "in", costObjectIds);
        DataSet costObjectDataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.sca.algox.utils.ElementHelper.getElementInfos", (String)"cad_costobject", (String)"id, material, bomversion, auxpty", (QFilter[])new QFilter[]{costObjectFilter}, null);
        DynamicObject costaccountInfo = BusinessDataServiceHelper.loadSingle((Object)costaccount, (String)"cal_bd_costaccount");
        Long costTypeId = 0L;
        if (costaccountInfo != null) {
            costTypeId = CostTypeHelper.getCostTypeIdByManuOrgIdFromCal(costaccountInfo.getLong("id"), orgId, manuOrgId);
        }
        if (CadEmptyUtils.isEmpty(costTypeId)) {
            return elementInfos;
        }
        DynamicObject costTypeInfo = BusinessDataServiceHelper.loadSingle((Object)costTypeId, (String)"cad_costtype");
        String[] subMatInfos = subMatInfo.split("@");
        Long materialId = Long.parseLong(subMatInfos[0]);
        Long matvers = Long.parseLong(subMatInfos[1]);
        Long auxproperty = Long.parseLong(subMatInfos[2]);
        HashSet<Long> materialIds = new HashSet<Long>();
        materialIds.add(materialId);
        Long defaultSubelement = 0L;
        Long defaultElent = 0L;
        Map matIdToPairMap = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"SubElementAndMatService", (String)"getSubElementByOrg", (Object[])new Object[]{orgId, materialIds, new Date(), true});
        if (matIdToPairMap.containsKey(materialId)) {
            Long[] subelementId = (Long[])matIdToPairMap.get(materialId);
            defaultSubelement = subelementId[1];
            defaultElent = subelementId[0];
        }
        QFilter mainMatFilter = new QFilter("expdate", ">=", (Object)bizDate);
        mainMatFilter.and(new QFilter("effectdate", "<=", (Object)bizDate));
        mainMatFilter.and(new QFilter("costtype", "=", (Object)costTypeInfo.getLong("masterid")));
        QFilter subMatFilter = new QFilter("entryentity.submaterial", "=", (Object)materialId);
        subMatFilter.and(new QFilter("entryentity.submatvers", "=", (Object)matvers));
        subMatFilter.and(new QFilter("entryentity.subauxproperty", "=", (Object)auxproperty));
        DataSet calcInfoDataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.sca.algox.utils.ElementHelper.getElementInfos", (String)"cad_calceffectiveresult", (String)"material, matvers, auxproperty, entryentity.element element, entryentity.subelement subelement", (QFilter[])new QFilter[]{mainMatFilter, subMatFilter}, null);
        JoinDataSet joinDataSet = costObjectDataSet.join(calcInfoDataSet, JoinType.LEFT);
        joinDataSet.on("material", "material");
        joinDataSet.on("bomversion", "matvers");
        joinDataSet.on("auxpty", "auxproperty");
        DataSet costObjectElementDataSet = joinDataSet.select(new String[]{"id"}, new String[]{"element", "subelement"}).finish();
        for (Row row : costObjectElementDataSet) {
            if (CadEmptyUtils.isEmpty(row.getString("element")) || CadEmptyUtils.isEmpty(row.getString("subelement"))) {
                elementInfos.put(row.getString("id"), defaultElent + "@" + defaultSubelement);
                continue;
            }
            elementInfos.put(row.getString("id"), row.getString("element") + "@" + row.getString("subelement"));
        }
        return elementInfos;
    }

    public static Map<Long, Long[]> getDefSubEles(Long orgId, Set<Long> matIds) {
        HashMap<Long, Long[]> matToSubEleMap = new HashMap<Long, Long[]>(16);
        if (matIds == null || matIds.isEmpty()) {
            return matToSubEleMap;
        }
        return (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"SubElementAndMatService", (String)"getSubElementByOrg", (Object[])new Object[]{orgId, matIds, new Date(), true});
    }

    public static Long getElementBySubele(Long subelementId, Long elementtype) {
        QFilter subelementFilter = new QFilter("subelement", "=", (Object)subelementId);
        subelementFilter.and(new QFilter("elementtype", "=", (Object)elementtype));
        DynamicObject elementAndSubelement = BusinessDataServiceHelper.loadSingle((String)"cad_elementdetail", (String)"element", (QFilter[])new QFilter[]{subelementFilter});
        return elementAndSubelement == null ? 0L : elementAndSubelement.getLong("element.masterid");
    }

    public static boolean isMatSubElement(Long subelementId) {
        QFilter subelementFilter = new QFilter("id", "=", (Object)subelementId);
        subelementFilter.and(new QFilter("type", "in", Arrays.asList("001", "002")));
        return QueryServiceHelper.exists((String)"cad_subelement", (QFilter[])new QFilter[]{subelementFilter});
    }

    public static Long getMatDefSubEle() {
        QFilter typeFilter = new QFilter("type", "=", (Object)"001");
        QFilter isdefault = new QFilter("defaultvalue", "=", (Object)Character.valueOf('1'));
        DynamicObject subEle = QueryServiceHelper.queryOne((String)"cad_subelement", (String)"id", (QFilter[])new QFilter[]{typeFilter, isdefault});
        return subEle == null ? null : Long.valueOf(subEle.getLong("id"));
    }

    public static Set<Long> getMatSubEle() {
        HashSet<Long> matSubElement = new HashSet<Long>(16);
        QFilter matFilter = new QFilter("type", "in", Arrays.asList("001", "002"));
        DynamicObjectCollection subElements = QueryServiceHelper.query((String)"cad_subelement", (String)"id", (QFilter[])new QFilter[]{matFilter});
        for (DynamicObject subElement : subElements) {
            matSubElement.add(subElement.getLong("id"));
        }
        return matSubElement;
    }
}

