/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.utils;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.InFilterHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.PeriodHelper;
import kd.macc.sca.algox.utils.ScaCalcHelper;
import kd.macc.sca.algox.wip.input.CalcDataArgs;
import org.apache.commons.lang3.time.DateUtils;

public class FinishCalcHelper {
    private static final Log logger = LogFactory.getLog(FinishCalcHelper.class);

    public static QFilter getCommonFilter(CalcDataArgs args) {
        return FinishCalcHelper.getCommonFilter(args, true);
    }

    public static QFilter getCommonFilter(CalcDataArgs args, boolean isPeriod) {
        return FinishCalcHelper.getCommonFilter(args, isPeriod, true, true);
    }

    public static QFilter getCommonFilter(CalcDataArgs args, boolean isPeriod, boolean isCostoBject, boolean isCostAcct) {
        if (args.getOrgId() == null) {
            return null;
        }
        QFilter filter = new QFilter("org", "=", args.getOrgId());
        if (args.getCostAcctId() != null && isCostAcct) {
            filter.and(new QFilter("costaccount", "=", args.getCostAcctId()));
        }
        if (args.getPeriodId() != null && isPeriod) {
            filter.and(new QFilter("period", "=", args.getPeriodId()));
        }
        if (args.getCostObjects() != null && isCostoBject) {
            filter.and(InFilterHelper.getQFilterByBachSize((String)"costobject", new ArrayList<Object>(args.getCostObjects()), (String)"in", (int)200000));
        }
        return filter;
    }

    public static QFilter getOrgAndCostCenterFilter(CalcDataArgs args) {
        if (args.getOrgId() == null) {
            return null;
        }
        QFilter filter = new QFilter("org", "=", (Object)((Long)args.getOrgId()));
        if (!CadEmptyUtils.isEmpty(args.getCostCenterIds())) {
            filter.and(new QFilter("costcenter", "in", args.getCostCenterIds()));
        }
        return filter;
    }

    public static QFilter getCostCenterFilter(CalcDataArgs args) {
        QFilter filter = null;
        if (!CadEmptyUtils.isEmpty(args.getCostCenterIds())) {
            filter = new QFilter("costcenter", "in", args.getCostCenterIds());
        }
        return filter;
    }

    public static CalcDataArgs getCalcDataArgs(String calcParam) {
        calcParam = calcParam.replaceAll("org", "orgId");
        calcParam = calcParam.replaceAll("costaccount", "costAcctId");
        calcParam = calcParam.replaceAll("period", "periodId");
        calcParam = calcParam.replaceAll("costcenters", "costCenterIds");
        calcParam = calcParam.replaceAll("costobjects", "costObjects");
        calcParam = calcParam.replaceAll("costtypeid", "costTypeId");
        CalcDataArgs args = (CalcDataArgs)SerializationUtils.fromJsonString((String)calcParam, CalcDataArgs.class);
        return args;
    }

    public static Set<Long> getFinishedCostObject(CalcDataArgs args) {
        Set<Long> factCostobjectIds;
        DynamicObject period;
        String algoKey = "kd.macc.sca.algox.utils.FinishCalcHelper.getFinishedCostObject";
        QFilter costCenterFilter = null;
        if (!CadEmptyUtils.isEmpty(args.getCostCenterIds())) {
            costCenterFilter = new QFilter("costcenter", "in", args.getCostCenterIds());
        }
        QFilter plannedoutputFilter = new QFilter("billstatus", "=", (Object)"C");
        plannedoutputFilter.and(new QFilter("accountorg", "=", args.getOrgId()));
        plannedoutputFilter.and(new QFilter("costobject.producttype", "=", (Object)"C"));
        if (args.getPeriodId() instanceof Integer) {
            args.setPeriodId(Long.valueOf(args.getPeriodId().toString()));
        }
        if (CadEmptyUtils.isEmpty((DynamicObject)(period = BusinessDataServiceHelper.loadSingleFromCache((Object)args.getPeriodId(), (String)"bd_period")))) {
            return null;
        }
        Date endDate = FinishCalcHelper.trimDate(period.getDate("enddate"));
        endDate = DateUtils.addHours((Date)endDate, (int)24);
        plannedoutputFilter.and(new QFilter("closedatetime", "<", (Object)endDate));
        plannedoutputFilter.and(new QFilter("closedatetime", ">=", (Object)period.getDate("begindate")));
        if (!CadEmptyUtils.isEmpty(args.getManuOrgIds())) {
            plannedoutputFilter.and(new QFilter("manuorg", "in", args.getManuOrgIds()));
        }
        DataSet plannedoutputData = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_plannedoutputbill", (String)"costobject.id costobjectid,closestatu,billstatus,closedatetime", (QFilter[])new QFilter[]{plannedoutputFilter, costCenterFilter}, null);
        HashSet<Long> allcostObject = new HashSet<Long>();
        for (Row row : plannedoutputData) {
            if (!row.getBoolean("closestatu").booleanValue() && "C".equals(row.getString("billstatus")) || row.getBoolean("closestatu").booleanValue() && row.getDate("closedatetime").after(endDate)) continue;
            allcostObject.add(row.getLong("costobjectid"));
        }
        Set<Long> settleObjs = FinishCalcHelper.getHasSettleCostobjectIds(args, allcostObject);
        allcostObject.removeAll(settleObjs);
        Set<Long> costChangeObjs = FinishCalcHelper.getCostChangeObjs(args, period);
        if (!costChangeObjs.isEmpty()) {
            costChangeObjs = FinishCalcHelper.getHasSettleCostobjectIds(args, costChangeObjs);
            logger.info("\u5b8c\u5de5\u4ea7\u54c1\u7ed3\u7b97\u589e\u52a0\u6210\u672c\u53d8\u66f4\u8bb0\u5f55\u7684\u8303\u56f4\uff1a{}", (Object)JSON.toJSONString(costChangeObjs));
            allcostObject.addAll(costChangeObjs);
        }
        if (!CadEmptyUtils.isEmpty(factCostobjectIds = FinishCalcHelper.getFactNeedAddRange(args, period))) {
            logger.info("\u5b8c\u5de5\u4ea7\u54c1\u7ed3\u7b97\u589e\u52a0\u5b8c\u5de5\u5355\u7684\u8303\u56f4\uff1a{}", (Object)JSON.toJSONString(factCostobjectIds));
            allcostObject.addAll(factCostobjectIds);
        }
        return allcostObject;
    }

    private static Set<Long> getCostChangeObjs(CalcDataArgs args, DynamicObject period) {
        QFilter changeFilters = new QFilter("org", "=", args.getOrgId());
        if (!CadEmptyUtils.isEmpty(args.getCostCenterIds())) {
            changeFilters.and(new QFilter("costcenter", "in", args.getCostCenterIds()));
        }
        changeFilters.and(new QFilter("bizstatus", "!=", (Object)"B"));
        changeFilters.and(new QFilter("sourcebiztime", "<=", (Object)period.getDate("enddate")));
        changeFilters.and(new QFilter("sourcebiztime", ">=", (Object)period.getDate("begindate")));
        if (!CadEmptyUtils.isEmpty(args.getManuOrgIds())) {
            changeFilters.and(new QFilter("costobject.manuorg", "in", args.getManuOrgIds()));
        }
        DataSet changeRecord = QueryServiceHelper.queryDataSet((String)"changeRecord", (String)"sca_costchangerecord", (String)"costobject.id costobjectid", (QFilter[])new QFilter[]{changeFilters}, null);
        return ScaCalcHelper.getLongIdSetFromDs(changeRecord, "costobjectid", false);
    }

    private static Set<Long> getHasSettleCostobjectIds(CalcDataArgs args, Set<Long> allcostObject) {
        QFilter filter = new QFilter("bizstatus", "=", (Object)"B");
        filter.and("costaccount", "=", args.getCostAcctId());
        DataSet costObjectData = InFilterHelper.queryDataSetIn((String)"cad_costobjectaccount", (String)"costobject costobjectid", (QFilter)filter, (String)"costobject", new ArrayList<Long>(allcostObject));
        return ScaCalcHelper.getLongIdSetFromDs(costObjectData, "costobjectid", false);
    }

    private static Set<Long> getFactNeedAddRange(CalcDataArgs args, DynamicObject period) {
        DataSet factDs = FinishCalcHelper.getFactDs(args, period, true);
        Set<Long> costobjectIds = ScaCalcHelper.getLongIdSetFromDs(factDs, "costobject", true);
        QFilter factFilter = new QFilter("bizstatus", "=", (Object)"B");
        factFilter.and("costaccount", "=", args.getCostAcctId());
        DataSet costObjectData = InFilterHelper.queryDataSetIn((String)"cad_costobjectaccount", (String)"costobject costobjectid,createtime", (QFilter)factFilter, (String)"costobject", new ArrayList<Long>(costobjectIds));
        costObjectData = costObjectData.groupBy(new String[]{"costobjectid"}).max("createtime").finish();
        costObjectData = costObjectData.join(factDs).on("costobjectid", "costobject").select(new String[]{"costobjectid", "createtime"}, new String[]{"auditdate"}).finish().filter("createtime<auditdate");
        if (!costObjectData.isEmpty()) {
            return ScaCalcHelper.getLongIdSetFromDs(costObjectData, "costobjectid", false);
        }
        return null;
    }

    public static Set<Long> getWipCostObject(CalcDataArgs args) {
        DynamicObject period;
        long start = System.currentTimeMillis();
        HashSet costobjectIds = Sets.newHashSetWithExpectedSize((int)10);
        if (args.getPeriodId() instanceof Integer) {
            args.setPeriodId(Long.valueOf(args.getPeriodId().toString()));
        }
        if (CadEmptyUtils.isEmpty((DynamicObject)(period = BusinessDataServiceHelper.loadSingleFromCache((Object)args.getPeriodId(), (String)"bd_period")))) {
            return costobjectIds;
        }
        QFilter filter = new QFilter("accountorg", "=", args.getOrgId());
        if (!CadEmptyUtils.isEmpty(args.getCostCenterIds())) {
            filter.and("costobject.costcenter", "in", args.getCostCenterIds());
        }
        if (!CadEmptyUtils.isEmpty(args.getManuOrgIds())) {
            filter.and("manuorg", "in", args.getManuOrgIds());
        }
        filter.and("appnum", "=", (Object)"sca");
        filter.and("costobject.producttype", "=", (Object)"C");
        filter.and("bizdate", ">=", (Object)period.getDate("begindate"));
        filter.and("bizdate", "<=", (Object)period.getDate("enddate"));
        filter.and("billstatus", "=", (Object)"C");
        DataSet plannedDataSet = QueryServiceHelper.queryDataSet((String)"plannedoutputbill", (String)"cad_plannedoutputbill", (String)"costobject", (QFilter[])filter.toArray(), null);
        costobjectIds.addAll(ScaCalcHelper.getLongIdSetFromDs(plannedDataSet, "costobject", false));
        logger.info("\u671f\u672b\u8ba1\u7b97\u8303\u56f4-\u83b7\u53d6\u8ba1\u5212\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        costobjectIds.addAll(ScaCalcHelper.getLongIdSetFromDs(FinishCalcHelper.getFactDs(args, period, false), "costobject", false));
        logger.info("\u671f\u672b\u8ba1\u7b97\u8303\u56f4-\u83b7\u53d6\u5b8c\u5de5\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        QFilter lastfilter = new QFilter("org", "=", args.getOrgId());
        if (!CadEmptyUtils.isEmpty(args.getCostCenterIds())) {
            lastfilter.and("costobject.costcenter", "in", args.getCostCenterIds());
        }
        if (!CadEmptyUtils.isEmpty(args.getManuOrgIds())) {
            lastfilter.and("costobject.manuorg", "in", args.getManuOrgIds());
        }
        lastfilter.and("costaccount", "=", args.getCostAcctId());
        lastfilter.and("period", "=", (Object)PeriodHelper.getPrePeriodId(args.getPeriodId()));
        lastfilter.and("bizstatus", "=", (Object)"A");
        DataSet lastDataSet = QueryServiceHelper.queryDataSet((String)"CALCRESULT", (String)"sca_calcresult", (String)"costobject", (QFilter[])lastfilter.toArray(), null);
        costobjectIds.addAll(ScaCalcHelper.getLongIdSetFromDs(lastDataSet, "costobject", false));
        logger.info("\u671f\u672b\u8ba1\u7b97\u8303\u56f4-\u83b7\u53d6\u4e0a\u671f\u8ba1\u7b97\u7ed3\u679c\u5355\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        DataSet matAllocDs = FinishCalcHelper.getMatAllocDs(args);
        costobjectIds.addAll(ScaCalcHelper.getLongIdSetFromDs(matAllocDs, "costobject", false));
        logger.info("\u671f\u672b\u8ba1\u7b97\u8303\u56f4-\u83b7\u53d6\u6750\u6599\u5206\u914d\u5355\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        DataSet feeDs = FinishCalcHelper.getFeeDs(args);
        costobjectIds.addAll(ScaCalcHelper.getLongIdSetFromDs(feeDs, "costobject", false));
        logger.info("\u671f\u672b\u8ba1\u7b97\u8303\u56f4-\u672c\u671f\u5438\u6536\u6210\u672c\u5355\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        DataSet csInnerAllocDs = FinishCalcHelper.getCSInnerAllocDs(args);
        costobjectIds.addAll(ScaCalcHelper.getLongIdSetFromDs(csInnerAllocDs, "costobject", false));
        logger.info("\u671f\u672b\u8ba1\u7b97\u8303\u56f4-\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d\u5355\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        QFilter costAccountFilter = new QFilter("costaccount", "=", args.getCostAcctId());
        costAccountFilter.and("bizstatus", "=", (Object)"B");
        DataSet closeCostObjectDs = InFilterHelper.queryDataSetIn((String)"cad_costobjectaccount", (String)"costobject", (QFilter)costAccountFilter, (String)"costobject", new ArrayList(costobjectIds));
        Set<Long> settleCostobjectIds = ScaCalcHelper.getLongIdSetFromDs(closeCostObjectDs, "costobject", false);
        costobjectIds.removeAll(settleCostobjectIds);
        logger.info("\u671f\u672b\u8ba1\u7b97\u8303\u56f4-\u83b7\u53d6\u672a\u7ed3\u7b97\u7684\u6210\u672c\u5bf9\u8c61\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        return costobjectIds;
    }

    private static DataSet getMatAllocDs(CalcDataArgs args) {
        QFilter filter = new QFilter("org", "=", args.getOrgId());
        if (!CadEmptyUtils.isEmpty(args.getCostCenterIds())) {
            filter.and("entryentity.costobejctentry.costcenter", "in", args.getCostCenterIds());
        }
        if (!CadEmptyUtils.isEmpty(args.getManuOrgIds())) {
            filter.and("entryentity.costobejctentry.manuorg", "in", args.getManuOrgIds());
        }
        filter.and("costaccount", "=", args.getCostAcctId());
        filter.and("period", "=", args.getPeriodId());
        filter.and("allocstatus", "=", (Object)"2");
        return QueryServiceHelper.queryDataSet((String)"getMatAllocDs", (String)"sca_matalloc", (String)"entryentity.costobejctentry costobject", (QFilter[])filter.toArray(), null);
    }

    private static DataSet getFeeDs(CalcDataArgs args) {
        QFilter filter = new QFilter("org", "=", args.getOrgId());
        if (!CadEmptyUtils.isEmpty(args.getCostCenterIds())) {
            filter.and("costobject.costcenter", "in", args.getCostCenterIds());
        }
        if (!CadEmptyUtils.isEmpty(args.getManuOrgIds())) {
            filter.and("costobject.manuorg", "in", args.getManuOrgIds());
        }
        filter.and("costaccount", "=", args.getCostAcctId());
        filter.and("period", "=", args.getPeriodId());
        filter.and("billstatus", "=", (Object)"C");
        return QueryServiceHelper.queryDataSet((String)"getFeeDs", (String)"sca_resourceabsorb", (String)"costobject", (QFilter[])filter.toArray(), null);
    }

    private static DataSet getFactDs(CalcDataArgs args, DynamicObject period, boolean isMaxAuditdate) {
        QFilter filter = new QFilter("org", "=", args.getOrgId());
        if (!CadEmptyUtils.isEmpty(args.getCostCenterIds())) {
            filter.and("entryentity.costobject.costcenter", "in", args.getCostCenterIds());
        }
        if (!CadEmptyUtils.isEmpty(args.getManuOrgIds())) {
            filter.and("entryentity.costobject.manuorg", "in", args.getManuOrgIds());
        }
        filter.and("billstatus", "=", (Object)"C");
        filter.and("bookdate", ">=", (Object)period.getDate("begindate"));
        filter.and("bookdate", "<=", (Object)period.getDate("enddate"));
        filter.and("appnum", "=", (Object)"sca");
        DataSet ds = QueryServiceHelper.queryDataSet((String)"CAD_FACTNEDOUTPUTBILL", (String)"cad_factnedoutputbill", (String)"entryentity.costobject.mainproobj costobjectid,entryentity.costobject.id belongobj,auditdate", (QFilter[])filter.toArray(), null);
        ds = ds.select("case when costobjectid=0 or costobjectid is null then belongobj else costobjectid end costobject,auditdate");
        if (isMaxAuditdate) {
            return ds.groupBy(new String[]{"costobject"}).max("auditdate").finish();
        }
        return ds;
    }

    private static DataSet getCSInnerAllocDs(CalcDataArgs args) {
        QFilter filter = new QFilter("org", "=", args.getOrgId());
        if (!CadEmptyUtils.isEmpty(args.getCostCenterIds())) {
            filter.and("entryentity.costobject.costcenter", "in", args.getCostCenterIds());
        }
        if (!CadEmptyUtils.isEmpty(args.getManuOrgIds())) {
            filter.and("entryentity.costobject.manuorg", "in", args.getManuOrgIds());
        }
        filter.and("costaccount", "=", args.getCostAcctId());
        filter.and("period", "=", args.getPeriodId());
        filter.and("allocstatus", "=", (Object)"2");
        filter.and("entryentity.costobject.isactfeenocal", "=", (Object)"0");
        return QueryServiceHelper.queryDataSet((String)"getCSInnerAllocDs", (String)"cad_mfgfeeallocco", (String)"entryentity.costobject costobject", (QFilter[])filter.toArray(), null);
    }

    private static Date trimDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(11, 0);
        return calendar.getTime();
    }
}

