/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.utils;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.utils.DateUtils;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.algox.wip.input.CalcDataArgs;
import kd.macc.sca.common.costcalc.CostAdjustamt;

public class MfgUnAbsorbFeeHelper {
    private static String TOTAL_FIELDS = "org,costcenter,costobject";
    private static String DETAIL_FIELDS = TOTAL_FIELDS + ",warehouse,location,wareinorg,lot,sourcebill,sourcebillentry";
    protected static final String SPILTSIGN = "#";
    private static final Log logger = LogFactory.getLog(MfgUnAbsorbFeeHelper.class);
    private static final int DEFAULT_PRECISION = 10;
    private Map<Long, Integer> currencyAmtPrecision = new HashMap<Long, Integer>();

    public static Set<Long> getVoucherFromCal(CalcDataArgs args) {
        HashSet<Long> voucherFromCal = new HashSet<Long>(16);
        QFilter createTypeQf = new QFilter("createtype", "=", (Object)"R");
        QFilter voucherNumQf = new QFilter("vouchernum", "!=", (Object)" ");
        QFilter periodQF = new QFilter("id", "=", args.getPeriodId());
        DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)"begindate,enddate", (QFilter[])new QFilter[]{periodQF});
        QFilter bizDateQf = new QFilter("bizdate", "<=", (Object)(period == null ? TimeServiceHelper.now() : period.getDate("enddate")));
        bizDateQf.and(new QFilter("bizdate", ">=", (Object)(period == null ? TimeServiceHelper.now() : period.getDate("begindate"))));
        DynamicObjectCollection costAdjusts = QueryServiceHelper.query((String)"cal_stdcostdiffbill", (String)"entryentity.invbillid invbillid,entryentity.srcbillid srcbillid", (QFilter[])new QFilter[]{createTypeQf, voucherNumQf, bizDateQf});
        for (DynamicObject costAdjust : costAdjusts) {
            if (!CadEmptyUtils.isEmpty(costAdjust.getLong("srcbillid"))) {
                voucherFromCal.add(costAdjust.getLong("srcbillid"));
                continue;
            }
            voucherFromCal.add(costAdjust.getLong("invbillid"));
        }
        ArrayList<QFilter> qfList = new ArrayList<QFilter>(10);
        qfList.add(new QFilter("org", "=", args.getOrgId()));
        qfList.add(new QFilter("costaccount", "=", args.getCostAcctId()));
        qfList.add(new QFilter("period", "=", args.getPeriodId()));
        Set<Object> costObjectIds = MfgUnAbsorbFeeHelper.getCostObjectByCalcArgs(args);
        costObjectIds.addAll(args.getCostObjects());
        qfList.add(voucherNumQf);
        qfList.add(new QFilter("difftype", "=", (Object)"4"));
        if (!CadEmptyUtils.isEmpty(costObjectIds)) {
            qfList.add(new QFilter("costobject", "in", costObjectIds));
        }
        DynamicObjectCollection unAbsorbDiffs = QueryServiceHelper.query((String)"sca_unabsorbdiff", (String)"id", (QFilter[])qfList.toArray(new QFilter[0]));
        HashSet<Long> unAbsorbIds = new HashSet<Long>(16);
        for (DynamicObject unAbsorbDiff : unAbsorbDiffs) {
            unAbsorbIds.add(unAbsorbDiff.getLong("id"));
        }
        QFilter invbillidQf = new QFilter("entryentity.srcbillid", "in", unAbsorbIds);
        costAdjusts = QueryServiceHelper.query((String)"cal_stdcostdiffbill", (String)"id", (QFilter[])new QFilter[]{invbillidQf});
        unAbsorbIds.clear();
        for (DynamicObject costAj : costAdjusts) {
            unAbsorbIds.add(costAj.getLong("id"));
        }
        invbillidQf = new QFilter("id", "in", unAbsorbIds);
        costAdjusts = QueryServiceHelper.query((String)"cal_stdcostdiffbill", (String)"entryentity.invbillid invbillid,entryentity.srcbillid srcbillid", (QFilter[])new QFilter[]{invbillidQf});
        for (DynamicObject costAdjust : costAdjusts) {
            if (!CadEmptyUtils.isEmpty(costAdjust.getLong("srcbillid"))) {
                voucherFromCal.add(costAdjust.getLong("srcbillid"));
                continue;
            }
            voucherFromCal.add(costAdjust.getLong("invbillid"));
        }
        return voucherFromCal;
    }

    public static Set<Object> getCostObjectByCalcArgs(CalcDataArgs args) {
        QFilter orgFilter = new QFilter("org", "=", args.getOrgId());
        orgFilter.and(new QFilter("costaccount", "=", args.getCostAcctId()));
        orgFilter.and(new QFilter("period", "=", args.getPeriodId()));
        orgFilter.and(new QFilter("costobject.bizstatus", "=", (Object)"B"));
        if (!CollectionUtils.isEmpty(args.getCostCenterIds())) {
            orgFilter.and(new QFilter("costcenter", "in", args.getCostCenterIds()));
        }
        DynamicObjectCollection calcResults = QueryServiceHelper.query((String)"sca_calcresult", (String)"billno,costobject", (QFilter[])new QFilter[]{orgFilter});
        HashSet<Object> costObjectIds = new HashSet<Object>(16);
        calcResults.forEach(c -> costObjectIds.add(c.getLong("costobject")));
        return costObjectIds;
    }

    public static void unabsorbFeeToCal(CalcDataArgs args) {
        boolean isAdjectBill = MfgUnAbsorbFeeHelper.isAdjectBill(args);
        if (isAdjectBill) {
            logger.info("\u672a\u5438\u6536\u8d39\u7528\u5dee\u5f02\u5355\uff08\u6210\u672c\u6838\u7b97\u5bf9\u8c61\uff09");
            try {
                MfgUnAbsorbFeeHelper.unabsorbFeeToCals(args);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
    }

    public static void unabsorbFeeToCalNotCheck(CalcDataArgs args) {
        logger.info("\u672a\u5438\u6536\u8d39\u7528\u5dee\u5f02\u5355\uff08\u6210\u672c\u6838\u7b97\u5bf9\u8c61\uff09");
        try {
            MfgUnAbsorbFeeHelper.unabsorbFeeToCals(args);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    private static boolean isAdjectBill(CalcDataArgs args) {
        Long orgId = Long.valueOf(String.valueOf(args.getOrgId()));
        Long costAccountId = Long.valueOf(String.valueOf(args.getCostAcctId()));
        QFilter qfOrg = new QFilter("org", "=", (Object)orgId);
        QFilter qfCostAccount = new QFilter("costaccount", "=", (Object)costAccountId);
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)"sca");
        QFilter qfStrategy = new QFilter("reductstrategy", "=", (Object)"ITEMIZED_REDUCT");
        return !QueryServiceHelper.exists((String)"cad_sysparam", (QFilter[])new QFilter[]{qfOrg, qfCostAccount, qfAppNum, qfStrategy});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unabsorbFeeToCals(CalcDataArgs args) {
        DataSet unabsorbFee = null;
        DataSet factnedBill = null;
        HashSet<Map<String, Object>> params = new HashSet<Map<String, Object>>(16);
        try {
            unabsorbFee = MfgUnAbsorbFeeHelper.getUnabsorbFeeDiff(args);
            factnedBill = MfgUnAbsorbFeeHelper.getFactnedBill(args);
            HashMap<String, Map<String, Object>> invbillInfo = new HashMap<String, Map<String, Object>>(16);
            Map<String, BigDecimal> rate = MfgUnAbsorbFeeHelper.getRate(factnedBill, invbillInfo, args.getCostAcctId());
            int amtprecision = 4;
            QFilter cur = new QFilter("id", "=", args.getCurrencyId());
            DynamicObject currency_amt = QueryServiceHelper.queryOne((String)"bd_currency", (String)"amtprecision", (QFilter[])new QFilter[]{cur});
            if (currency_amt != null) {
                amtprecision = currency_amt.getInt("amtprecision");
            }
            MfgUnAbsorbFeeHelper.setParams(unabsorbFee, rate, params, amtprecision, invbillInfo);
        }
        finally {
            if (unabsorbFee != null) {
                unabsorbFee.close();
            }
            if (factnedBill != null) {
                factnedBill.close();
            }
        }
        if (params.size() > 0) {
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalStandardCostDiffBillService", (String)"buildDiffBill", (Object[])new Object[]{params});
        }
    }

    private static DataSet getUnabsorbFeeDiff(CalcDataArgs args) {
        Set<Object> costObjectIds;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(new QFilter("org", "=", args.getOrgId()));
        filters.add(new QFilter("costaccount", "=", args.getCostAcctId()));
        filters.add(new QFilter("period", "=", args.getPeriodId()));
        filters.add(new QFilter("vouchernum", "=", (Object)""));
        Set<Long> voucherFromCal = MfgUnAbsorbFeeHelper.getVoucherFromCal(args);
        if (!CadEmptyUtils.isEmpty(voucherFromCal)) {
            filters.add(new QFilter("id", "not in", voucherFromCal));
        }
        if (!CadEmptyUtils.isEmpty(args.getCostCenterIds())) {
            filters.add(new QFilter("costcenter", "in", args.getCostCenterIds()));
        }
        if ((costObjectIds = args.getUnAbCostObjects()).size() > 0) {
            filters.add(new QFilter("costobject", "in", costObjectIds));
        }
        String algoKey = "kd.macc.sca.algox.wip.PriceDiffDispatchCalcProcessor.getUnabsorbFeeDiff";
        String selectFields = "id,billno,org,costaccount,period,costcenter,costobject,costobject.material.masterid AS material,costobject.material.baseunit AS baseunit,costobject.bomversion AS bomversion,costobject.auxpty AS auxpty,costobject.configuredcode AS configuredcode,costobject.tracknumber AS tracknumber,currency,createtime,period.enddate enddate,entryentity.id AS entryid,entryentity.seq AS seq,entryentity.element AS element,entryentity.subelement AS subelement,entryentity.amount AS amount ";
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_unabsorbdiff", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), null);
    }

    private static DataSet getFactnedBill(CalcDataArgs args) {
        Set<Object> costObjectIds;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(3);
        filters.add(new QFilter("org", "=", args.getOrgId()));
        if (!CadEmptyUtils.isEmpty(args.getCostCenterIds())) {
            filters.add(new QFilter("costcenter", "in", args.getCostCenterIds()));
        }
        if ((costObjectIds = args.getUnAbCostObjects()).size() > 0) {
            filters.add(new QFilter("entryentity.costobject", "in", costObjectIds));
        }
        QFilter periodQF = new QFilter("id", "=", args.getPeriodId());
        DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)"begindate,enddate", (QFilter[])new QFilter[]{periodQF});
        filters.add(new QFilter("bookdate", "<=", (Object)(period == null ? TimeServiceHelper.now() : period.getDate("enddate"))));
        filters.add(new QFilter("bookdate", ">=", (Object)(period == null ? TimeServiceHelper.now() : period.getDate("begindate"))));
        filters.add(new QFilter("appnum", "=", (Object)"sca"));
        String algoKey = "kd.macc.sca.algox.wip.PriceDiffDispatchCalcProcessor.getFactnedBill";
        String selectFields = "org,costcenter,warehouse,location,wareinorg,batch as lot,sourcebill,sourcebillentry,entryentity.costobject AS costobject,entryentity.qty AS qty";
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_factnedoutputbill", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), null);
    }

    private static Map<String, BigDecimal> getRate(DataSet factnedBill, Map<String, Map<String, Object>> invbillInfo, Object costaccountId) {
        DataSet factnedBillCopy = factnedBill.copy();
        HashSet<Long> srcIdset = new HashSet<Long>(16);
        for (Row row : factnedBillCopy) {
            srcIdset.add(row.getLong("sourcebillentry"));
        }
        Map<Long, Object[]> costrecordMap = MfgUnAbsorbFeeHelper.getCalCostRecordInfoByBizEntryId(costaccountId, srcIdset);
        DataSet costTotal = factnedBill.executeSql("select " + TOTAL_FIELDS + ",sum(qty) AS qty group by " + TOTAL_FIELDS);
        DataSet wareHouse = factnedBill.executeSql("select " + DETAIL_FIELDS + ",sum(qty) AS qty group by " + DETAIL_FIELDS);
        HashMap<String, BigDecimal> totalMap = new HashMap<String, BigDecimal>(16);
        for (Row row : costTotal) {
            totalMap.put(MfgUnAbsorbFeeHelper.unionField2Key(TOTAL_FIELDS, row), row.getBigDecimal("qty"));
        }
        HashMap<String, Map> tailDiffMap = new HashMap<String, Map>(16);
        HashMap<String, String> maxKeyMap = new HashMap<String, String>(16);
        HashMap<String, BigDecimal> maxValueMap = new HashMap<String, BigDecimal>(16);
        HashMap<String, BigDecimal> needTailDiffMap = new HashMap<String, BigDecimal>(16);
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(16);
        for (Row row : wareHouse) {
            String totalKey = MfgUnAbsorbFeeHelper.unionField2Key(TOTAL_FIELDS, row);
            BigDecimal totalVal = (BigDecimal)totalMap.get(totalKey);
            if (totalVal == null || BigDecimal.ZERO.compareTo(totalVal) == 0) continue;
            String detailKey = MfgUnAbsorbFeeHelper.unionField2Key(DETAIL_FIELDS, row);
            BigDecimal detailVal = row.getBigDecimal("qty");
            BigDecimal ratio = detailVal.divide(totalVal, 8, 4);
            tailDiffMap.computeIfAbsent(totalKey, t -> new HashMap()).put(detailKey, ratio);
            if (!invbillInfo.containsKey(detailKey)) {
                Long sourcebillentry = row.getLong("sourcebillentry");
                if (costrecordMap.containsKey(sourcebillentry)) {
                    Object[] objArr = costrecordMap.get(sourcebillentry);
                    HashMap<String, Object> srcInfo = new HashMap<String, Object>(16);
                    srcInfo.put("invbillnum", objArr[0]);
                    srcInfo.put("inventryseq", objArr[1]);
                    srcInfo.put("invbillid", objArr[2]);
                    srcInfo.put("invbillentryid", objArr[3]);
                    srcInfo.put("ecostcenter", objArr[4]);
                    srcInfo.put("storageorgunit", objArr[5]);
                    srcInfo.put("noupdatecalfields", objArr[6]);
                    invbillInfo.put(detailKey, srcInfo);
                } else {
                    HashMap<String, Object> srcInfo = new HashMap<String, Object>(16);
                    srcInfo.put("invbillnum", "");
                    srcInfo.put("inventryseq", 0L);
                    srcInfo.put("invbillid", 0L);
                    srcInfo.put("invbillentryid", 0L);
                    srcInfo.put("ecostcenter", 0L);
                    srcInfo.put("storageorgunit", 0L);
                    invbillInfo.put(detailKey, srcInfo);
                }
            }
            BigDecimal old = needTailDiffMap.computeIfAbsent(totalKey, s -> new BigDecimal(0));
            needTailDiffMap.put(totalKey, old.add(ratio));
            BigDecimal max = maxValueMap.computeIfAbsent(totalKey, s -> new BigDecimal(0));
            if (max.compareTo(ratio) < 0) {
                maxKeyMap.put(totalKey, detailKey);
            }
            max = max.compareTo(ratio) >= 0 ? max : ratio;
            maxValueMap.put(totalKey, max);
            if (BigDecimal.ONE.compareTo(old.add(ratio)) != 0) continue;
            needTailDiffMap.remove(totalKey);
        }
        for (Map.Entry entry : tailDiffMap.entrySet()) {
            if (!needTailDiffMap.containsKey(entry.getKey())) continue;
            BigDecimal diff = (BigDecimal)needTailDiffMap.get(entry.getKey());
            diff = new BigDecimal(1).subtract(diff == null ? BigDecimal.ZERO : diff);
            BigDecimal ratio = (BigDecimal)((Map)entry.getValue()).get(maxKeyMap.get(entry.getKey()));
            ratio = diff.add(ratio == null ? BigDecimal.ZERO : ratio);
            ((Map)entry.getValue()).put(maxKeyMap.get(entry.getKey()), ratio);
        }
        for (Map.Entry entry : tailDiffMap.values()) {
            resultMap.putAll((Map<String, BigDecimal>)((Object)entry));
        }
        return resultMap;
    }

    public static Map<Long, Object[]> getCalCostRecordInfoByBizEntryId(Object costaccountId, Set<Long> costRecordSourceEntryIds) {
        QFilter filter = new QFilter("entry.bizbillentryid", "in", costRecordSourceEntryIds);
        filter.and("costaccount", "=", costaccountId);
        String selectField = "id,billnumber billno,entry.id as entryid,entry.seq seq,entry.bizbillentryid as srcbillentryid,entry.ecostcenter ecostcenter,storageorgunit,entry.noupdatecalfields noupdatecalfields";
        DataSet ds = QueryServiceHelper.queryDataSet((String)"getCalCostRecord", (String)"cal_costrecord_subentity", (String)selectField, (QFilter[])filter.toArray(), null);
        HashMap map = Maps.newHashMapWithExpectedSize((int)10);
        for (Row row : ds) {
            Long srcbillentryid = row.getLong("srcbillentryid");
            map.putIfAbsent(srcbillentryid, new Object[]{row.getString("billno"), row.getLong("seq"), row.getLong("id"), row.getLong("entryid"), row.getLong("ecostcenter"), row.getLong("storageorgunit"), row.getString("noupdatecalfields")});
        }
        return map;
    }

    private static Map<String, String> getSrcBillnoMap(DataSet factedOut) {
        HashMap<String, String> srcBillnoMap = new HashMap<String, String>(16);
        HashSet<Long> srcIdset = new HashSet<Long>(16);
        for (Row row : factedOut) {
            srcIdset.add(row.getLong("sourcebill"));
        }
        QFilter idQf = new QFilter("id", "in", srcIdset);
        DynamicObjectCollection mftManuins = QueryServiceHelper.query((String)"im_mdc_mftmanuinbill", (String)"id,billno", (QFilter[])new QFilter[]{idQf});
        for (DynamicObject mftManuin : mftManuins) {
            srcBillnoMap.put(mftManuin.getString("id"), mftManuin.getString("billno"));
        }
        return srcBillnoMap;
    }

    private static Map<String, Long> getSrcEntrySeqMap(DataSet factedOut) {
        HashMap<String, Long> srcEntrySeqMap = new HashMap<String, Long>(16);
        HashSet<Long> srcEntryIdset = new HashSet<Long>(16);
        for (Row row : factedOut) {
            srcEntryIdset.add(row.getLong("sourcebillentry"));
        }
        QFilter idQf = new QFilter("billentry.id", "in", srcEntryIdset);
        DynamicObjectCollection mftManuins = QueryServiceHelper.query((String)"im_mdc_mftmanuinbill", (String)"billentry.id id,billentry.seq seq", (QFilter[])new QFilter[]{idQf});
        for (DynamicObject mftManuin : mftManuins) {
            srcEntrySeqMap.put(mftManuin.getString("id"), mftManuin.getLong("seq"));
        }
        return srcEntrySeqMap;
    }

    private static void setParams(DataSet unabsorbFee, Map<String, BigDecimal> rate, Set<Map<String, Object>> params, int amtprecision, Map<String, Map<String, Object>> invbillInfo) {
        for (Row row : unabsorbFee) {
            String totalKey = MfgUnAbsorbFeeHelper.unionField2Key(TOTAL_FIELDS, row);
            int mapSign = 0;
            ArrayList<CostAdjustamt> subEntryRows = new ArrayList<CostAdjustamt>(10);
            for (Map.Entry<String, BigDecimal> detailRate : rate.entrySet()) {
                Map<String, Object> info;
                BigDecimal subRate;
                if (!detailRate.getKey().startsWith(totalKey) || (subRate = rate.get(detailRate.getKey())) == null || BigDecimal.ZERO.compareTo(subRate) == 0 || (info = MfgUnAbsorbFeeHelper.getDetailInfo(detailRate.getKey())).size() == 0) continue;
                HashMap<String, Object> param = new HashMap<String, Object>(16);
                MfgUnAbsorbFeeHelper.getParam(param, row, info, subRate, amtprecision, invbillInfo, detailRate.getKey(), subEntryRows);
            }
            if (subEntryRows.isEmpty()) {
                HashMap<String, Object> param = new HashMap<String, Object>(16);
                MfgUnAbsorbFeeHelper.getParam(param, row, amtprecision);
                param.put("isupdatecost", false);
                param.put("mapSign", ++mapSign);
                params.add(param);
                continue;
            }
            List<Map<String, Object>> passParams = MfgUnAbsorbFeeHelper.checkCostAdjustamt(subEntryRows, row.getBigDecimal("amount"));
            for (Map<String, Object> param : passParams) {
                param.put("mapSign", ++mapSign);
                params.add(param);
            }
        }
    }

    private static void getParam(Map<String, Object> param, Row row, int amtprecision) {
        param.put("calorg", row.getLong("org"));
        param.put("costaccount", row.getLong("costaccount"));
        param.put("billtype", 920040553033394176L);
        param.put("biztype", "A");
        param.put("cstype", "bd_supplier");
        param.put("createtype", "Z");
        param.put("bizdate", DateUtils.getDayStartTime((Date)row.getDate("enddate")));
        param.put("bookdate", DateUtils.getDayStartTime((Date)row.getDate("enddate")));
        param.put("currency", row.getLong("currency"));
        param.put("billsrctype", "D");
        param.put("material", row.getLong("material"));
        param.put("mversion", row.getLong("bomversion"));
        param.put("assist", row.getLong("auxpty"));
        param.put("baseunit", row.getLong("baseunit"));
        param.put("invtype", 688884005529250816L);
        param.put("invstatus", 691928582720825344L);
        param.put("ownertype", "bos_org");
        param.put("costelement", row.getLong("element"));
        param.put("costsubelement", row.getLong("subelement"));
        BigDecimal adjustamt = row.getBigDecimal("amount").setScale(amtprecision, 5);
        param.put("adjustamt", adjustamt);
        param.put("ddiff_r", adjustamt);
        param.put("invbizentityobject", "im_mdc_mftmanuinbill");
        param.put("srcbillnum", row.getString("billno"));
        param.put("srcentryseq", row.getLong("seq"));
        param.put("srcbillid", row.getLong("id"));
        param.put("srcbillentryid", row.getLong("entryid"));
        param.put("srcbizentityobject", "sca_unabsorbdiff");
        param.put("srcsys", "B");
    }

    private static List<Map<String, Object>> checkCostAdjustamt(List<CostAdjustamt> entryRowParams, BigDecimal totalAmount) {
        ArrayList<Map<String, Object>> passParams = new ArrayList<Map<String, Object>>(entryRowParams.size());
        if (entryRowParams.isEmpty()) {
            return passParams;
        }
        CostAdjustamt maxAmountRow = entryRowParams.get(entryRowParams.size() - 1);
        BigDecimal sumAmount = BigDecimal.ZERO;
        for (CostAdjustamt row : entryRowParams) {
            if (row.getAdjustamt().compareTo(maxAmountRow.getAdjustamt()) > 0) {
                maxAmountRow = row;
            }
            sumAmount = sumAmount.add(row.getAdjustamt());
        }
        BigDecimal diffAmount = totalAmount.subtract(sumAmount);
        maxAmountRow.setAdjustamt(diffAmount.add(maxAmountRow.getAdjustamt()));
        for (CostAdjustamt row : entryRowParams) {
            if (BigDecimal.ZERO.compareTo(row.getAdjustamt()) == 0) continue;
            row.getParam().put("adjustamt", row.getAdjustamt());
            row.getParam().put("ddiff_r", row.getAdjustamt());
            passParams.add(row.getParam());
        }
        return passParams;
    }

    private static String unionField2Key(String fields, Row row) {
        StringBuilder sb = new StringBuilder();
        for (String field : fields.split(",")) {
            sb.append(row.get(field)).append(SPILTSIGN);
        }
        return sb.toString();
    }

    private static Map<Long, Long> getStorageOrg(Set<String> sourceBill) {
        HashMap<Long, Long> storageOrg = new HashMap<Long, Long>(16);
        HashSet<Long> ids = new HashSet<Long>(16);
        for (String bill : sourceBill) {
            String[] bls = bill.split(SPILTSIGN);
            if (bls.length != 9 || "0".equals(bls[7])) continue;
            ids.add(Long.valueOf(bls[7]));
        }
        if (ids.size() == 0) {
            return storageOrg;
        }
        DynamicObjectCollection mftManu = QueryServiceHelper.query((String)"im_mdc_mftmanuinbill", (String)"id,org", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        for (DynamicObject manu : mftManu) {
            storageOrg.put(manu.getLong("id"), manu.getLong("org"));
        }
        return storageOrg;
    }

    private static Map<String, Object> getDetailInfo(String detailRateKey) {
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        String[] rateKeyInfos = detailRateKey.split(SPILTSIGN);
        if (rateKeyInfos.length != 9) {
            return result;
        }
        result.put("warehouse", StringUtils.isEmpty((String)rateKeyInfos[3]) ? 0L : Long.parseLong(rateKeyInfos[3]));
        result.put("location", StringUtils.isEmpty((String)rateKeyInfos[4]) ? 0L : Long.parseLong(rateKeyInfos[4]));
        result.put("owner", StringUtils.isEmpty((String)rateKeyInfos[5]) ? 0L : Long.parseLong(rateKeyInfos[5]));
        result.put("lot", rateKeyInfos[6]);
        result.put("sourcebill", StringUtils.isEmpty((String)rateKeyInfos[7]) ? 0L : Long.parseLong(rateKeyInfos[7]));
        return result;
    }

    private static void getParam(Map<String, Object> param, Row row, Map<String, Object> info, BigDecimal subRate, int amtprecision, Map<String, Map<String, Object>> invbillInfo, String detailKey, List<CostAdjustamt> subEntryRows) {
        param.put("calorg", row.getLong("org"));
        param.put("costaccount", row.getLong("costaccount"));
        param.put("billtype", 920040553033394176L);
        param.put("biztype", "A");
        param.put("cstype", "bd_supplier");
        param.put("createtype", "Z");
        param.put("bizdate", DateUtils.getDayStartTime((Date)row.getDate("enddate")));
        param.put("bookdate", DateUtils.getDayStartTime((Date)row.getDate("enddate")));
        param.put("currency", row.getLong("currency"));
        param.put("billsrctype", "D");
        param.put("material", row.getLong("material"));
        param.put("configuredcode", row.getLong("configuredcode"));
        param.put("tracknumber", row.getLong("tracknumber"));
        param.put("mversion", row.getLong("bomversion"));
        param.put("assist", row.getLong("auxpty"));
        param.put("baseunit", row.getLong("baseunit"));
        param.put("warehouse", info.get("warehouse"));
        param.put("location", info.get("location"));
        param.put("lot", info.get("lot"));
        param.put("invtype", 688884005529250816L);
        param.put("invstatus", 691928582720825344L);
        param.put("ownertype", "bos_org");
        param.put("owner", info.get("owner"));
        param.put("costelement", row.getLong("element"));
        param.put("costsubelement", row.getLong("subelement"));
        BigDecimal amount = row.getBigDecimal("amount").multiply(subRate);
        BigDecimal adjustamt = amount.setScale(amtprecision, 5);
        param.put("adjustamt", adjustamt);
        param.put("ddiff_r", adjustamt);
        CostAdjustamt adjust = new CostAdjustamt(amount, adjustamt, param, subRate, amtprecision);
        subEntryRows.add(adjust);
        if (invbillInfo.containsKey(detailKey)) {
            Map<String, Object> srcInfomap = invbillInfo.get(detailKey);
            param.put("invbillnum", srcInfomap.get("invbillnum"));
            param.put("inventryseq", srcInfomap.get("inventryseq"));
            param.put("invbillentryid", srcInfomap.get("invbillentryid"));
            param.put("invbillid", srcInfomap.get("invbillid"));
            param.put("ecostcenter", srcInfomap.get("ecostcenter"));
            param.put("storageorgunit", srcInfomap.get("storageorgunit"));
        }
        param.put("invbizentityobject", "im_mdc_mftmanuinbill");
        param.put("srcbillnum", row.getString("billno"));
        param.put("srcentryseq", row.getLong("seq") + 1L);
        param.put("srcbillid", row.getLong("id"));
        param.put("srcbillentryid", row.getLong("entryid"));
        param.put("srcbizentityobject", "sca_unabsorbdiff");
        param.put("srcsys", "B");
    }

    private Integer loadCurrencyAmtPrecision(Long currencyId) {
        if (currencyId == null || Long.compare(0L, currencyId) == 0) {
            return 10;
        }
        if (!this.currencyAmtPrecision.containsKey(currencyId)) {
            int amtprecision = 10;
            QFilter cur = new QFilter("id", "=", (Object)currencyId);
            DynamicObject currency_amt = QueryServiceHelper.queryOne((String)"bd_currency", (String)"amtprecision", (QFilter[])new QFilter[]{cur});
            if (currency_amt != null) {
                amtprecision = currency_amt.getInt("amtprecision");
            }
            this.currencyAmtPrecision.put(currencyId, amtprecision);
        }
        return this.currencyAmtPrecision.get(currencyId);
    }
}

