/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.utils;

import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;

public class MultivariateHelper {
    public static BigDecimal[] resolve(BigDecimal[][] coef, BigDecimal[] b) {
        int n = coef.length;
        int[] shift = new int[n];
        for (int i = 0; i < n; ++i) {
            shift[i] = i;
        }
        for (int rows = 0; rows < n; ++rows) {
            int i;
            BigDecimal rightLowMax = BigDecimal.ZERO;
            int pickedRow = 0;
            int pickedColumn = 0;
            for (i = rows; i < n; ++i) {
                for (int j = rows; j < n; ++j) {
                    if (rightLowMax.compareTo(coef[i][j].abs()) >= 0) continue;
                    rightLowMax = coef[i][j].abs();
                    pickedRow = i;
                    pickedColumn = j;
                }
            }
            if (pickedColumn != rows) {
                for (i = 0; i < n; ++i) {
                    MultivariateHelper.swap(coef, i, rows, i, pickedColumn);
                }
                MultivariateHelper.swap(shift, rows, pickedColumn);
            }
            if (pickedRow != rows) {
                for (int j = rows; j < n; ++j) {
                    MultivariateHelper.swap(coef, rows, j, pickedRow, j);
                }
                MultivariateHelper.swap(b, rows, pickedRow);
            }
            for (int subrows = 0; subrows < n; ++subrows) {
                if (subrows == rows) continue;
                if (BigDecimal.ZERO.compareTo(coef[rows][rows]) == 0) {
                    String errorStr = ResManager.loadKDString((String)"\u4e3b\u5143\u7cfb\u6570\u4e3a\u96f6,\u65b9\u7a0b\u7ec4\u65e0\u89e3\u3002", (String)"MultivariateHelper_0", (String)"macc-sca-algox", (Object[])new Object[0]);
                    throw new KDBizException(errorStr);
                }
                BigDecimal m = MultivariateHelper.divide(coef[subrows][rows], coef[rows][rows], 16, 4);
                for (int rowsRight = rows; rowsRight < n; ++rowsRight) {
                    coef[subrows][rowsRight] = coef[subrows][rowsRight].subtract(coef[rows][rowsRight].multiply(m));
                }
                b[subrows] = b[subrows].subtract(b[rows].multiply(m));
            }
        }
        BigDecimal[] x = new BigDecimal[n];
        for (int rows = 0; rows < n; ++rows) {
            for (int i = 0; i < n; ++i) {
                if (shift[i] != rows) continue;
                x[shift[i]] = BigDecimal.ZERO.compareTo(coef[i][i]) == 0 ? BigDecimal.ZERO : MultivariateHelper.divide(b[i], coef[i][i], 16, 4);
            }
        }
        return x;
    }

    private static void swap(BigDecimal[] a, int x, int y) {
        BigDecimal tmp = a[x];
        a[x] = a[y];
        a[y] = tmp;
    }

    private static void swap(int[] a, int x, int y) {
        int tmp = a[x];
        a[x] = a[y];
        a[y] = tmp;
    }

    private static void swap(BigDecimal[][] a, int x1, int y1, int x2, int y2) {
        BigDecimal tmp = a[x1][y1];
        a[x1][y1] = a[x2][y2];
        a[x2][y2] = tmp;
    }

    private static BigDecimal divide(BigDecimal a, BigDecimal b, int scale, int roundModel) {
        if (BigDecimal.ZERO.equals(b)) {
            return BigDecimal.ZERO;
        }
        return a.divide(b, scale, roundModel);
    }
}

