/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.macc.sca.algox.utils.CadEmptyUtils;

public class PeriodHelper {
    public static DynamicObject getPeriod(Long periodId) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)periodId, (String)"bd_period");
    }

    public static Date[] getPeriodStartAndEndTime(Long periodId) {
        ArrayList<String> selectFields = new ArrayList<String>(2);
        selectFields.add("begindate");
        selectFields.add("enddate");
        MainEntityType type = (MainEntityType)EntityMetadataCache.getSubDataEntityType((String)"bd_period", selectFields);
        Map periods = BusinessDataServiceHelper.loadFromCache((Object[])new Object[]{periodId}, (DynamicObjectType)type);
        if (CadEmptyUtils.isEmpty(periods)) {
            return null;
        }
        DynamicObject period = (DynamicObject)periods.get(periodId);
        if (period == null) {
            return null;
        }
        Date[] dates = new Date[]{period.getDate("begindate"), period.getDate("enddate")};
        return dates;
    }

    public static Map<String, Date> getStartAndEndTimeByPeriod(Long periodId) {
        HashMap<String, Date> date = new HashMap<String, Date>(2);
        ArrayList<String> selectFields = new ArrayList<String>(2);
        selectFields.add("begindate");
        selectFields.add("enddate");
        MainEntityType type = (MainEntityType)EntityMetadataCache.getSubDataEntityType((String)"bd_period", selectFields);
        Map periods = BusinessDataServiceHelper.loadFromCache((Object[])new Object[]{periodId}, (DynamicObjectType)type);
        if (CadEmptyUtils.isEmpty(periods)) {
            return date;
        }
        DynamicObject period = (DynamicObject)periods.get(periodId);
        if (period != null) {
            date.put("begindate", period.getDate("begindate"));
            date.put("enddate", period.getDate("enddate"));
        }
        return date;
    }

    public static Long getPrePeriodId(Object periodId) {
        if (periodId == null) {
            return 0L;
        }
        String entityName = "bd_period";
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicObject currPeriod = BusinessDataServiceHelper.loadSingle((Object)periodId, (DynamicObjectType)type);
        Object periodtypeid = currPeriod.getDynamicObject("periodtype").getPkValue();
        QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
        QFilter filterYear = new QFilter("periodyear", "=", (Object)currPeriod.getInt("periodyear"));
        QFilter filterNum = new QFilter("periodnumber", "<", (Object)currPeriod.getInt("periodnumber"));
        QFilter pfilter = filterYear.and(filterNum);
        QFilter pYear = new QFilter("periodyear", "<", (Object)currPeriod.getInt("periodyear"));
        pfilter.or(pYear);
        QFilter q = new QFilter("isadjustperiod", "=", (Object)false);
        DynamicObjectCollection cols = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{filterType, pfilter, q}, (String)"periodyear desc, periodnumber desc");
        if (cols.size() > 0) {
            return BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)cols.get(0)).getLong("id"), (DynamicObjectType)type).getLong("id");
        }
        return 0L;
    }

    public static Map<String, Date> getPeriodBeginDateAndEndDate(DynamicObject period) {
        HashMap<String, Date> resultPeriod = new HashMap<String, Date>(16);
        Date beginDate = period.getDate("begindate");
        Date endDate = period.getDate("enddate");
        resultPeriod.put("begindate", beginDate);
        Date curDate = TimeServiceHelper.now();
        if (beginDate.compareTo(curDate) <= 0 && curDate.compareTo(endDate) <= 0) {
            resultPeriod.put("enddate", curDate);
        } else {
            resultPeriod.put("enddate", endDate);
        }
        return resultPeriod;
    }

    public static Map<String, Date> getDateByPeriod(Set<Long> periodIds) {
        HashMap<String, Date> date = new HashMap<String, Date>(10);
        ArrayList<String> selectFields = new ArrayList<String>(2);
        selectFields.add("begindate");
        selectFields.add("enddate");
        MainEntityType type = (MainEntityType)EntityMetadataCache.getSubDataEntityType((String)"bd_period", selectFields);
        Map periods = BusinessDataServiceHelper.loadFromCache((Object[])periodIds.toArray(), (DynamicObjectType)type);
        if (CadEmptyUtils.isEmpty(periods)) {
            return date;
        }
        Date beginDate = null;
        Date endDate = null;
        for (DynamicObject period : periods.values()) {
            if (beginDate == null || beginDate.getTime() > period.getDate("begindate").getTime()) {
                beginDate = period.getDate("begindate");
            }
            if (endDate != null && endDate.getTime() >= period.getDate("enddate").getTime()) continue;
            endDate = period.getDate("enddate");
        }
        date.put("begindate", beginDate);
        date.put("enddate", endDate);
        return date;
    }

    public static DynamicObject getNextPeriod(Object curPeriodId) {
        if (curPeriodId == null) {
            return null;
        }
        String entityName = "bd_period";
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicObject currPeriod = BusinessDataServiceHelper.loadSingle((Object)curPeriodId, (DynamicObjectType)type);
        Object periodtypeid = currPeriod.getDynamicObject("periodtype").getPkValue();
        QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
        QFilter filterYear = new QFilter("periodyear", "=", (Object)currPeriod.getInt("periodyear"));
        QFilter filterNum = new QFilter("periodnumber", ">", (Object)currPeriod.getInt("periodnumber"));
        QFilter pfilter = filterYear.and(filterNum);
        QFilter pYear = new QFilter("periodyear", ">", (Object)currPeriod.getInt("periodyear"));
        pfilter.or(pYear);
        QFilter q = new QFilter("isadjustperiod", "=", (Object)false);
        DynamicObjectCollection cols = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{filterType, pfilter, q}, (String)"periodyear asc, periodnumber asc");
        if (cols.size() > 0) {
            return BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)cols.get(0)).getLong("id"), (DynamicObjectType)type);
        }
        return null;
    }

    public static Long getNextPeriodId(Object curPeriodId) {
        DynamicObject rs = PeriodHelper.getNextPeriod(curPeriodId);
        if (rs != null) {
            return rs.getLong("id");
        }
        return null;
    }
}

