/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.PeriodHelper;
import kd.macc.sca.algox.wip.input.CalcDataArgs;

public class PriceDiffHelper {
    public static Set<String> getPriceDiffMats(CalcDataArgs args) {
        HashSet<String> matIds = new HashSet<String>();
        DataSet priceDiffBills = PriceDiffHelper.getPriceDiffBill(args, "entryentity.material.masterid materialId");
        if (priceDiffBills.isEmpty()) {
            return null;
        }
        for (Row priceDiffBill : priceDiffBills) {
            if (matIds.contains(priceDiffBill.getString("materialId"))) continue;
            matIds.add(priceDiffBill.getString("materialId"));
        }
        return matIds;
    }

    public static DataSet getPriceDiffGroupData(CalcDataArgs args) {
        String selectFields = "org.id orgid,costaccount.id costaccountid,createtype,entryentity.material.masterid materialid,entryentity.auxpty.id auxptyid,entryentity.version.id mversionid,entryentity.element.masterid elementid,entryentity.subelement.masterid subelementid,entryentity.adjustamt-entryentity.intoamount nointoamt, entryentity.intoamount intoamt,entryentity.lastperiod";
        DataSet priceDiffDetail = PriceDiffHelper.getPriceDiffBill(args, selectFields);
        GroupbyDataSet groupDataSet = priceDiffDetail.groupBy(new String[]{"orgid", "costaccountid", "createtype", "materialid", "mversionid", "auxptyid", "elementid", "subelementid"});
        groupDataSet.sum("nointoamt");
        groupDataSet.sum("intoamt");
        return groupDataSet.finish();
    }

    public static DynamicObject[] getPriceDiffBills(CalcDataArgs args) {
        String selectFields = "org,costaccount,createtype,bizdate,entryentity.material,entryentity.version,entryentity.auxpty,entryentity.element,entryentity.subelement,entryentity.adjustamt,entryentity.intostatus,entryentity.intoamount,entryentity.lastintoamt,entryentity.lastperiod";
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        args.warpQFilter4Org(filters, "org");
        filters.add(new QFilter("entryentity.intostatus", "!=", (Object)"2"));
        filters.add(new QFilter("billstatus", "=", (Object)"C"));
        Date[] peirodInfos = PeriodHelper.getPeriodStartAndEndTime(Long.parseLong(args.getPeriodId().toString()));
        filters.add(new QFilter("bizdate", "<=", (Object)(peirodInfos != null ? peirodInfos[1] : new Date())));
        filters.remove(2);
        DynamicObject[] priceDiffBills = BusinessDataServiceHelper.load((String)"sca_purchpricediff", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), (String)"bizdate");
        return priceDiffBills;
    }

    public static DynamicObject[] getLastIntoPriceDiffBills(CalcDataArgs args) {
        String selectFields = "org,costaccount,createtype,bizdate,entryentity.material,entryentity.version,entryentity.auxpty,entryentity.element,entryentity.subelement,entryentity.adjustamt,entryentity.intostatus,entryentity.intoamount,entryentity.lastintoamt,entryentity.lastperiod";
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        args.warpQFilter4Org(filters, "org");
        filters.add(new QFilter("entryentity.lastperiod", ">=", args.getPeriodId()));
        filters.remove(2);
        DynamicObject[] priceDiffBills = BusinessDataServiceHelper.load((String)"sca_purchpricediff", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), (String)"bizDate desc");
        return priceDiffBills;
    }

    public static DataSet getMatBalanceData(CalcDataArgs args) {
        String algokey = "kd.macc.sca.algox.utils.PriceDiffHelper.getMatBalanceData";
        String selectFields = "calorg.id orgid,costaccount.id costaccountid,material.masterid materialid,mversion.id matverid,assist.id auxptyid,storageorgunit.masterid storageorgid,periodissueqty,periodendqty";
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        args.warpQFilter4Org(filters, "calorg");
        if (filters.size() == 3) {
            filters.remove(2);
        }
        filters.add(new QFilter("period", "=", (Object)BusinessDataServiceHelper.loadSingle((Object)args.getPeriodId(), (String)"bd_period").getString("number")));
        filters.add(new QFilter("material", "in", PriceDiffHelper.getPriceDiffMats(args)));
        DataSet matBalanceData = QueryServiceHelper.queryDataSet((String)algokey, (String)"cal_balance", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), null);
        GroupbyDataSet groupbyDataSet = matBalanceData.groupBy(new String[]{"orgid", "costaccountid", "materialid", "matverid", "auxptyid"});
        groupbyDataSet.sum("periodissueqty");
        groupbyDataSet.sum("periodendqty");
        return groupbyDataSet.finish();
    }

    public static Map<String, Map<String, BigDecimal>> getMatAllocResult(CalcDataArgs args) {
        String algokey = "kd.macc.sca.algox.utils.PriceDiffHelper.getMatAllocResult";
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        args.warpQFilter4Org(filters, "org");
        filters.add(new QFilter("entryentity.costobejctentry", "in", args.getCostObjects()));
        filters.add(new QFilter("period", "=", args.getPeriodId()));
        String selectFields = "org.id orgid,costaccount.id costaccountid,costcenter.masterid costcenterid,material.masterid materialid,matversion.id matverid,auxpty.id auxptyid,entryentity.costobejctentry.id costobjectid,entryentity.qty qty";
        DataSet matAllocData = QueryServiceHelper.queryDataSet((String)algokey, (String)"sca_matalloc", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), null);
        GroupbyDataSet groupbyDataSet = matAllocData.groupBy(new String[]{"orgid", "costaccountid", "costcenterid", "materialid", "matverid", "auxptyid", "costobjectid"});
        groupbyDataSet.sum("qty");
        matAllocData = groupbyDataSet.finish();
        HashMap<String, Map<String, BigDecimal>> costObjectUseMatQtyMap = new HashMap<String, Map<String, BigDecimal>>();
        for (Row row : matAllocData) {
            StringBuilder matkey = new StringBuilder();
            matkey.append(row.getString("materialid")).append("@");
            matkey.append(row.getString("matverid")).append("@");
            matkey.append(row.getString("auxptyid"));
            Map<String, BigDecimal> costObjectUseQtyMap = null;
            if (!costObjectUseMatQtyMap.containsKey(matkey.toString())) {
                costObjectUseQtyMap = new HashMap();
                costObjectUseMatQtyMap.put(matkey.toString(), costObjectUseQtyMap);
            } else {
                costObjectUseQtyMap = (Map)costObjectUseMatQtyMap.get(matkey.toString());
            }
            costObjectUseQtyMap.put(row.getString("costcenterid") + "@" + row.getString("costobjectid"), row.getBigDecimal("qty"));
        }
        return costObjectUseMatQtyMap;
    }

    public static DataSet getMatUseData(CalcDataArgs args) {
        String algokey = "kd.macc.sca.algox.utils.PriceDiffHelper.getMatAllocResult";
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        args.warpQFilter4Period(filters, "org", true);
        filters.add(new QFilter("entryentity.costobejctentry", "in", args.getCostObjects()));
        String selectFields = "org.id orgid,costaccount.id costaccountid,material.masterid materialid,matversion.id matverid,auxpty.id auxptyid,entryentity.qty qty";
        DataSet matAllocData = QueryServiceHelper.queryDataSet((String)algokey, (String)"sca_matalloc", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), null);
        GroupbyDataSet groupbyDataSet = matAllocData.groupBy(new String[]{"orgid", "costaccountid", "materialid", "matverid", "auxptyid"});
        groupbyDataSet.sum("qty");
        return groupbyDataSet.finish().select("orgid,costaccountid,materialid,matverid,auxptyid,qty");
    }

    public static Map<String, BigDecimal> calcOutRate(DataSet matBalanceData, DataSet matUseData) {
        if (matBalanceData.isEmpty() || matUseData.isEmpty()) {
            return null;
        }
        HashMap<String, BigDecimal> matOutRateInfos = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> matUseQtyInfos = new HashMap<String, BigDecimal>();
        for (Row row : matUseData) {
            StringBuilder matkey = new StringBuilder();
            matkey.append(row.getString("materialid")).append("@");
            matkey.append(row.getString("matverid")).append("@");
            matkey.append(row.getString("auxptyid"));
            if (matUseQtyInfos.containsKey(matkey.toString())) continue;
            matUseQtyInfos.put(matkey.toString(), row.getBigDecimal("qty"));
        }
        for (Row row : matBalanceData) {
            BigDecimal outRate = BigDecimal.ZERO;
            StringBuilder matkey = new StringBuilder();
            matkey.append(row.getString("materialid")).append("@");
            matkey.append(row.getString("matverid")).append("@");
            matkey.append(row.getString("auxptyid"));
            if (BigDecimal.ZERO.compareTo(row.getBigDecimal("periodendqty")) >= 0) {
                outRate = BigDecimal.ONE;
            } else {
                BigDecimal currMatUseQty = (BigDecimal)matUseQtyInfos.get(matkey.toString());
                if (currMatUseQty == null) continue;
                BigDecimal totaMatQty = row.getBigDecimal("periodissueqty").add(row.getBigDecimal("periodendqty"));
                if (BigDecimal.ZERO.compareTo(totaMatQty) != 0) {
                    outRate = currMatUseQty.divide(totaMatQty, RoundingMode.HALF_UP).setScale(10);
                    if (BigDecimal.ZERO.compareTo(outRate) >= 0) {
                        outRate = BigDecimal.ZERO;
                    }
                    if (BigDecimal.ONE.compareTo(outRate) <= 0) {
                        outRate = BigDecimal.ONE;
                    }
                } else {
                    outRate = BigDecimal.ZERO;
                }
            }
            if (matOutRateInfos.containsKey(matkey.toString())) continue;
            matOutRateInfos.put(matkey.toString(), outRate);
        }
        return matOutRateInfos;
    }

    public static void removeAllocResult(CalcDataArgs args) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        args.warpQFilter4Period(filters, "org", true);
        filters.add(new QFilter("costobject", "in", args.getCostObjects()));
        DeleteServiceHelper.delete((String)"sca_pricediffalloc", (QFilter[])filters.toArray(new QFilter[0]));
        Object[] priceDiffBills = PriceDiffHelper.getLastIntoPriceDiffBills(args);
        if (CadEmptyUtils.isEmpty(priceDiffBills)) {
            return;
        }
        for (Object priceDiffBill : priceDiffBills) {
            DynamicObjectCollection entrys = priceDiffBill.getDynamicObjectCollection("entryentity");
            if (CadEmptyUtils.isEmpty(entrys)) continue;
            for (DynamicObject entry : entrys) {
                if (entry.getBigDecimal("lastintoamt") == null || BigDecimal.ZERO.compareTo(entry.getBigDecimal("lastintoamt")) == 0) continue;
                BigDecimal newIntoAmt = entry.getBigDecimal("intoamount").subtract(entry.getBigDecimal("lastintoamt"));
                entry.set("intoamount", (Object)newIntoAmt);
                entry.set("intostatus", (Object)(BigDecimal.ZERO.compareTo(newIntoAmt) == 0 ? "0" : "1"));
            }
        }
        SaveServiceHelper.save((DynamicObject[])priceDiffBills);
    }

    private static DataSet getPriceDiffBill(CalcDataArgs args, String selectFields) {
        String algokey = "kd.macc.sca.algox.utils.PriceDiffHelper.getPriceDiffBill";
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        args.warpQFilter4Org(filters, "org");
        filters.add(new QFilter("entryentity.intostatus", "!=", (Object)"2"));
        filters.add(new QFilter("billstatus", "=", (Object)"C"));
        Date[] peirodInfos = PeriodHelper.getPeriodStartAndEndTime(Long.parseLong(args.getPeriodId().toString()));
        filters.add(new QFilter("bizdate", "<=", (Object)(peirodInfos != null ? peirodInfos[1] : new Date())));
        filters.remove(2);
        DataSet priceDiffBills = QueryServiceHelper.queryDataSet((String)algokey, (String)"sca_purchpricediff", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), null);
        return priceDiffBills;
    }

    private static DataSet getCostCenterData(CalcDataArgs args) {
        String algokey = "kd.macc.sca.algox.utils.PriceDiffHelper.getCostCenterData";
        DataSet costCenters = QueryServiceHelper.queryDataSet((String)algokey, (String)"bos_costcentersource", (String)"data dataid,costcenter.masterid costcenterid", null, null);
        return costCenters;
    }
}

