/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.check.AbstractCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckHelper;
import kd.macc.sca.algox.costrec.CostRecoveryParams;
import kd.macc.sca.algox.enums.CalcReportResultEnum;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.RestoreCheckHelper;
import kd.macc.sca.algox.utils.TimeUtils;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class ReductCheckHelper {
    private static final Log logger = LogFactory.getLog(RestoreCheckHelper.class);

    public static void doCheck(String param, CostRecoveryParams crParams) {
        Date startTime = TimeServiceHelper.now();
        JSONObject jsonObject = JSONObject.fromObject((Object)param);
        JSONArray checkItemList = new ArrayList(10);
        if (jsonObject.get("checkItemList") != null) {
            checkItemList = jsonObject.getJSONArray("checkItemList");
        }
        Long checkReportId = jsonObject.getLong("checkReportId");
        Long taskRecordId = jsonObject.getLong("taskRecordId");
        String calType = "sca_factcostreduction";
        CalcCheckContext calcCheckContext = new CalcCheckContext();
        calcCheckContext.setCheckParamJs(jsonObject);
        calcCheckContext.setCheckResultId(checkReportId);
        calcCheckContext.setTaskId(taskRecordId);
        calcCheckContext.setTaskType(calType);
        calcCheckContext.setGlobalId(Long.valueOf(DBServiceHelper.genGlobalLongId()));
        calcCheckContext.setOrgId(Long.valueOf(crParams.getCalOrgId()));
        calcCheckContext.setCostAccountId(Long.valueOf(crParams.getCostAccountId()));
        calcCheckContext.setPeriodId(Long.valueOf(crParams.getPeriodId()));
        calcCheckContext.setCurrencyId(Long.valueOf(crParams.getCurrencyId()));
        calcCheckContext.setManuOrgId(Long.valueOf(crParams.getManuOrgId()));
        int checkMode = jsonObject.get("checkMode") == null ? 2 : jsonObject.getInt("checkMode");
        calcCheckContext.setCheckMode(checkMode);
        calcCheckContext.setAppNum(jsonObject.getString("appnum"));
        calcCheckContext.getParams().put("relationCostAccountIds", crParams.getRelationCostAccountIds());
        calcCheckContext.getParams().put("calDimension", crParams.getCalDimension());
        List checkActionList = CalcCheckHelper.getCheckActionList((CalcCheckContext)calcCheckContext, (List)checkItemList, (String)calType, (String)jsonObject.getString("appnum"));
        for (AbstractCalcCheckAction action : checkActionList) {
            action.execute();
        }
        Long failCount = 0L;
        Long remindCount = 0L;
        if (!CadEmptyUtils.isEmpty(checkActionList)) {
            failCount = ((AbstractCalcCheckAction)checkActionList.get(0)).getContext().getFailCount();
            remindCount = ((AbstractCalcCheckAction)checkActionList.get(0)).getContext().getRemindCount();
            crParams.setCheckNoPassCount(Integer.parseInt(String.valueOf(failCount)));
            crParams.setCheckRemindCount(Integer.parseInt(String.valueOf(remindCount)));
            crParams.setCheckResultId(checkReportId);
        }
        jsonObject.accumulate("time", TimeUtils.getSecond(startTime, TimeServiceHelper.now()));
        jsonObject.accumulate("checkFailCount", (Object)failCount);
        jsonObject.accumulate("remindCount", (Object)remindCount);
        if (checkMode == 1) {
            ReductCheckHelper.updateTaskRecordNextPagePara(jsonObject, taskRecordId);
        }
        ReductCheckHelper.endDiffCheckCalcReport(checkReportId, failCount, remindCount);
    }

    private static void updateTaskRecordNextPagePara(JSONObject checkparam, Long taskRecordId) {
        QFilter filter = new QFilter("id", "=", (Object)taskRecordId);
        DynamicObject taskRecord = BusinessDataServiceHelper.loadSingle((String)"sca_taskrecord", (String)"nextpagepara,progress,status", (QFilter[])new QFilter[]{filter});
        if (!CadEmptyUtils.isEmpty(taskRecord)) {
            if ("2".equals(taskRecord.getString("status"))) {
                taskRecord.set("status", (Object)"4");
            }
            JSONObject subPagePara = new JSONObject();
            subPagePara.accumulate("checkResultId", (Object)taskRecordId);
            subPagePara.accumulate("checkReportId", checkparam.getLong("checkReportId"));
            taskRecord.set("nextpagepara", (Object)subPagePara.toString());
            SaveServiceHelper.update((DynamicObject)taskRecord);
        }
    }

    private static void endDiffCheckCalcReport(Long checkReportId, Long failCount, Long remindCount) {
        String selectfields = "id,starttime,type,progress,usetime,entryentity.result";
        QFilter filter = new QFilter("id", "=", (Object)checkReportId);
        DynamicObject calcReport = BusinessDataServiceHelper.loadSingle((String)"sca_reductreport", (String)selectfields, (QFilter[])new QFilter[]{filter});
        if (calcReport != null) {
            if (failCount != 0L) {
                calcReport.set("type", (Object)"3");
            } else if (remindCount != 0L) {
                calcReport.set("type", (Object)"7");
            } else {
                calcReport.set("type", (Object)"4");
            }
            calcReport.set("progress", (Object)100);
            long second = TimeUtils.getSecond(calcReport.getDate("starttime"), new Date());
            calcReport.set("usetime", (Object)(second > 0L ? second : 1L));
            SaveServiceHelper.update((DynamicObject)calcReport);
        }
    }

    public static Tuple<Integer, Integer> getCostReductCalcReportEntryFailCount(Long checkResultId) {
        QFilter filter = new QFilter("id", "=", (Object)checkResultId);
        filter.and(new QFilter("entryentity.result", "in", (Object)new String[]{CalcReportResultEnum.CALCREPORT_NOPASS.getValue(), CalcReportResultEnum.CALCREPORT_TIP.getValue()}));
        DynamicObjectCollection checkFailRs = QueryServiceHelper.query((String)"sca_reductreport", (String)"entryentity.id id,entryentity.result result", (QFilter[])new QFilter[]{filter});
        Integer nopassSize = 0;
        Integer tipSize = 0;
        for (DynamicObject dyn : checkFailRs) {
            Integer n;
            Integer n2;
            if (CalcReportResultEnum.CALCREPORT_NOPASS.getValue().equals(dyn.getString("result"))) {
                n2 = nopassSize;
                n = nopassSize = Integer.valueOf(nopassSize + 1);
                continue;
            }
            n2 = tipSize;
            n = tipSize = Integer.valueOf(tipSize + 1);
        }
        return new Tuple((Object)nopassSize, (Object)tipSize);
    }

    public static Map<String, String> getCostReductCalcReportEntryFailInfo(Long checkResultId) {
        HashMap<String, String> resultMap = new HashMap<String, String>(3);
        QFilter filter = new QFilter("id", "=", (Object)checkResultId);
        filter.and(new QFilter("entryentity.result", "=", (Object)CalcReportResultEnum.CALCREPORT_NOPASS.getValue()));
        DynamicObjectCollection checkFailDyn = QueryServiceHelper.query((String)"sca_reductreport", (String)"entryentity.id,entryentity.checkdesc checkdesc", (QFilter[])new QFilter[]{filter});
        if (CadEmptyUtils.isEmpty(checkFailDyn)) {
            resultMap.put("failCount", "0");
            return resultMap;
        }
        resultMap.put("failCount", String.valueOf(checkFailDyn.size()));
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < checkFailDyn.size(); ++i) {
            builder.append(((DynamicObject)checkFailDyn.get(i)).getString("checkdesc"));
        }
        resultMap.put("notPassMsg", builder.length() > 255 ? builder.substring(0, 255) : builder.toString());
        return resultMap;
    }
}

