/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.utils;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.TimeUtils;

public class ReductTaskHelper {
    public static void startRunTask(IFormView view, Long taskConfigId, String param) {
        Long taskRecordId = ReductTaskHelper.initCheckTaskRecord(taskConfigId);
        FormShowParameter lsp = new FormShowParameter();
        lsp.setFormId("sca_costredtaskrunning");
        lsp.setCustomParam("calcParam", (Object)param);
        lsp.setCustomParam("taskConfigId", (Object)taskConfigId);
        lsp.setCustomParam("taskRecordId", (Object)taskRecordId);
        lsp.getOpenStyle().setShowType(ShowType.Floating);
        view.showForm(lsp);
    }

    private static Long initCheckTaskRecord(Long taskId) {
        DynamicObject taskConfig = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"sca_taskconfig");
        DynamicObject taskrecord = BusinessDataServiceHelper.newDynamicObject((String)"sca_taskrecord");
        Long id = DBServiceHelper.genGlobalLongId();
        Date startTime = new Date();
        taskrecord.set("id", (Object)id);
        taskrecord.set("taskname", (Object)taskConfig.getString("name"));
        taskrecord.set("starttime", (Object)startTime);
        taskrecord.set("time", (Object)0);
        taskrecord.set("status", (Object)2);
        taskrecord.set("progress", (Object)0);
        taskrecord.set("executor", (Object)RequestContext.get().getUserId());
        taskrecord.set("nextpage", (Object)taskConfig.getString("nextentity"));
        taskrecord.set("taskconfig", (Object)taskConfig.getLong("id"));
        DynamicObjectCollection taskConfigEntrys = taskConfig.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection taskrecordEntrys = taskrecord.getDynamicObjectCollection("entryentity");
        int seq = 1;
        for (DynamicObject entry : taskConfigEntrys) {
            DynamicObject taskrecordEntry = taskrecordEntrys.addNew();
            taskrecordEntry.set("detailconfig", entry.getPkValue());
            taskrecordEntry.set("subname", (Object)entry.getString("subname"));
            taskrecordEntry.set("subnextentity", (Object)entry.getString("subnextentity"));
            taskrecordEntry.set("substatus", (Object)1);
            if (seq == 1) {
                taskrecordEntry.set("substarttime", (Object)startTime);
            }
            taskrecordEntry.set("seq", (Object)entry.getInt("seq"));
            ++seq;
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskrecord});
        return id;
    }

    public static void upateTaskRecordEntry(Long taskRecordId, Long taskDetailId, String status, Long executor) {
        QFilter filter = new QFilter("id", "=", (Object)taskRecordId);
        Object[] records = BusinessDataServiceHelper.load((String)"sca_taskrecord", (String)"id,progress,time,starttime,status,entryentity.detailconfig,entryentity.substatus,entryentity.substarttime,entryentity.subtime", (QFilter[])new QFilter[]{filter}, (String)"starttime desc");
        if (!CadEmptyUtils.isEmpty(records)) {
            Object record = records[0];
            DynamicObjectCollection entrys = record.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                if (taskDetailId.compareTo(entry.getLong("detailconfig")) != 0) continue;
                entry.set("substatus", (Object)status);
                if ("2".equals(status) && entry.getDate("substarttime") == null) {
                    entry.set("substarttime", (Object)new Date());
                }
                if (!"4".equals(status)) continue;
                entry.set("subtime", (Object)TimeUtils.getMilliSecond(entry.getDate("substarttime"), new Date()));
            }
            SaveServiceHelper.update((DynamicObject)record);
        }
    }

    public static void upateTaskRecord(Long taskRecordId, int mProgess, String status, Long executor) {
        QFilter filter = new QFilter("id", "=", (Object)taskRecordId);
        Object[] records = BusinessDataServiceHelper.load((String)"sca_taskrecord", (String)"id,progress,time,starttime,status", (QFilter[])new QFilter[]{filter}, (String)"starttime desc");
        if (!CadEmptyUtils.isEmpty(records)) {
            Object record = records[0];
            long totalProgress = record.getLong("progress") + (long)mProgess;
            if (totalProgress >= 100L) {
                record.set("progress", (Object)100);
            } else {
                record.set("progress", (Object)totalProgress);
            }
            record.set("time", (Object)TimeUtils.getSecond(record.getDate("starttime"), new Date()));
            record.set("status", (Object)status);
            SaveServiceHelper.update((DynamicObject)record);
        }
    }
}

