/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.utils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.sca.algox.calc.input.CalcDataArgs;
import kd.macc.sca.algox.calc.input.CalcDataArgsByCostRecovery;
import kd.macc.sca.algox.calc.input.CalcMaterial;
import kd.macc.sca.algox.utils.CostTypeHelper;
import kd.macc.sca.algox.utils.CurrencyHelper;
import kd.macc.sca.algox.utils.DataSetHelper;
import kd.macc.sca.algox.utils.PeriodHelper;
import net.sf.json.JSONObject;

public class RestoreCalcByCostRecoveryHelper {
    private static final Log logger = LogFactory.getLog(RestoreCalcByCostRecoveryHelper.class);

    public static CalcDataArgs getCalcDataArgs(String calcParam) {
        calcParam = calcParam.replaceAll("org", "orgId");
        calcParam = calcParam.replaceAll("period", "periodId");
        JSONObject calcParamJs = JSONObject.fromObject((Object)calcParam);
        CalcDataArgs args = (CalcDataArgs)SerializationUtils.fromJsonString((String)calcParam, CalcDataArgs.class);
        args.setCostAccount(calcParamJs.getLong("costaccount"));
        args.setNotUseVersion(!CostTypeHelper.isUseMatVer(calcParamJs.getLong("costaccount")));
        args.setCurrency(CurrencyHelper.getCurrency(calcParamJs.getLong("currencyId")));
        args.setPeriod(calcParamJs.getLong("periodId"));
        args.setValiditycheck(calcParamJs.getBoolean("validitycheck"));
        args.setDomatcoll(calcParamJs.getBoolean("domatcoll"));
        args.setParallel(calcParamJs.getBoolean("parallel"));
        return args;
    }

    public static Set<CalcMaterial> getCalcMaterial(CalcDataArgsByCostRecovery args) {
        Set<CalcMaterial> data = RestoreCalcByCostRecoveryHelper.getCalcMatByCostRecovery(args);
        RestoreCalcByCostRecoveryHelper.dealLevel(data);
        RestoreCalcByCostRecoveryHelper.dealLeaf(data);
        Set<CalcMaterial> leafMats = data.stream().filter(CalcMaterial::getIsleaf).collect(Collectors.toSet());
        int maxMatLevel = RestoreCalcByCostRecoveryHelper.GetMaxLevel(data);
        args.setMaxMatLevel(maxMatLevel);
        RestoreCalcByCostRecoveryHelper.downLeafLevel(leafMats, maxMatLevel);
        return data;
    }

    public static Set<CalcMaterial> getCurLevelMat(int level, Set<CalcMaterial> data) {
        Set<CalcMaterial> curCalcMat = data.stream().filter(cm -> cm.getLevel() == level).collect(Collectors.toSet());
        return curCalcMat;
    }

    public static void downLeafLevel(Set<CalcMaterial> data, int maxLevel) {
        for (CalcMaterial mat : data) {
            mat.setLevel(maxLevel);
        }
    }

    public static int GetMaxLevel(Set<CalcMaterial> data) {
        int maxLevel = 0;
        for (CalcMaterial calcMat : data) {
            if (calcMat.getLevel() <= maxLevel) continue;
            maxLevel = calcMat.getLevel();
        }
        return maxLevel;
    }

    private static void dealLevel(Set<CalcMaterial> data) {
        Set topMat = data.stream().filter(cm -> cm.getLevel() == 0).collect(Collectors.toSet());
        HashMap<CalcMaterial, Integer> matsLevels = new HashMap<CalcMaterial, Integer>();
        for (CalcMaterial mat : topMat) {
            if (!matsLevels.containsKey(mat)) {
                matsLevels.put(mat, 0);
            }
            RestoreCalcByCostRecoveryHelper.setLevel(mat, data, matsLevels);
        }
    }

    private static void dealLevel_new(Set<CalcMaterial> data) {
        String value;
        HashSet<CalcMaterial> topMat = new HashSet<CalcMaterial>(32);
        HashSet<CalcMaterial> farMat = new HashSet<CalcMaterial>(256);
        HashSet<CalcMaterial> sonMat = new HashSet<CalcMaterial>(256);
        HashSet<String> sonMatValue = new HashSet<String>(256);
        for (CalcMaterial mat : data) {
            if (mat.getLevel() == 0) {
                farMat.add(mat);
                continue;
            }
            sonMat.add(mat);
            value = "" + mat.getMaterialId() + mat.getMaterialVer() + mat.getMaterialAuxPropId();
            sonMatValue.add(value);
        }
        for (CalcMaterial mat : farMat) {
            value = "" + mat.getMaterialId() + mat.getMaterialVer() + mat.getMaterialAuxPropId();
            if (sonMatValue.contains(value)) continue;
            topMat.add(mat);
        }
        data.clear();
        data.addAll(topMat);
        data.addAll(sonMat);
        HashMap<CalcMaterial, Integer> matsLevels = new HashMap<CalcMaterial, Integer>();
        for (CalcMaterial mat : topMat) {
            if (!matsLevels.containsKey(mat)) {
                matsLevels.put(mat, 0);
            }
            RestoreCalcByCostRecoveryHelper.setLevel(mat, data, matsLevels);
        }
    }

    private static void setLevel(CalcMaterial mat, Set<CalcMaterial> mats, Map<CalcMaterial, Integer> matsLevels) {
        List<CalcMaterial> subMats = RestoreCalcByCostRecoveryHelper.getSubMaterial(mat, mats);
        for (CalcMaterial calcMat : subMats) {
            if (!matsLevels.containsKey(calcMat) || matsLevels.get(calcMat) < mat.getLevel() + 1) {
                calcMat.setLevel(mat.getLevel() + 1);
                matsLevels.remove(calcMat);
                matsLevels.put(calcMat, mat.getLevel() + 1);
                if (mat.getLevel() > 30) {
                    break;
                }
            } else {
                calcMat.setLevel(matsLevels.get(calcMat));
                if (matsLevels.get(calcMat) > 30) break;
            }
            RestoreCalcByCostRecoveryHelper.setLevel(calcMat, mats, matsLevels);
        }
    }

    public static List<CalcMaterial> getSubMaterial(CalcMaterial curMat, Set<CalcMaterial> mats) {
        ArrayList<CalcMaterial> subMats = new ArrayList<CalcMaterial>(16);
        for (CalcMaterial mat : mats) {
            if (curMat.getMaterialId() != mat.getParentId() || curMat.getMaterialAuxPropId() != mat.getPmaterialAuxPropId() || curMat.getMaterialVer() != mat.getPmaterialVer()) continue;
            subMats.add(mat);
        }
        return subMats;
    }

    private static void dealLeaf(Set<CalcMaterial> data) {
        for (CalcMaterial mat : data) {
            RestoreCalcByCostRecoveryHelper.setLeaf(mat, data);
        }
    }

    private static void setLeaf(CalcMaterial curMat, Set<CalcMaterial> mats) {
        for (CalcMaterial mat : mats) {
            if (curMat.getMaterialId() != mat.getParentId() || curMat.getMaterialAuxPropId() != mat.getPmaterialAuxPropId() || curMat.getMaterialVer() != mat.getPmaterialVer()) continue;
            curMat.setIsleaf(false);
            return;
        }
    }

    private static Set<CalcMaterial> getCalcMatByCostRecovery(CalcDataArgsByCostRecovery args) {
        QFilter[] filters;
        HashSet<CalcMaterial> materials = new HashSet<CalcMaterial>(16);
        QFilter qfStartDate = new QFilter("bizdate", ">=", (Object)args.getStartDate());
        QFilter qfEndDate = new QFilter("bizdate", "<=", (Object)args.getEndDate());
        QFilter qfBillStatus = new QFilter("billstatus", "=", (Object)"C");
        QFilter allocstatus = new QFilter("allocstatus", "=", (Object)"2");
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)"sca");
        QFilter qfOrg = new QFilter("org", "in", args.getCalOrgIds());
        QFilter accountorg = new QFilter("accountorg", "in", args.getCalOrgIds());
        QFilter qfCostAcount = new QFilter("costaccount", "in", args.getCostAccounts());
        QFilter qfPeriod = new QFilter("period", "=", (Object)args.getPeriod());
        String algoKey = "kd.macc.sca.algox.utils.RestoreCalcHelper.getCalcMat";
        StringBuilder selectFields = new StringBuilder();
        selectFields.append("costobject");
        DataSet planned = QueryServiceHelper.queryDataSet((String)(algoKey + "1"), (String)"cad_plannedoutputbill", (String)selectFields.toString(), (QFilter[])new QFilter[]{accountorg, qfStartDate, qfEndDate, qfBillStatus, qfAppNum}, null);
        HashSet<Long> planCostObjectIds = new HashSet<Long>(256);
        for (Row row : planned) {
            planCostObjectIds.add(row.getLong("costobject"));
        }
        HashSet costObjectIds = new HashSet(16);
        HashSet costCenterIds = new HashSet(16);
        if (planCostObjectIds.size() > 0) {
            QFilter qfCostObject = new QFilter("entryentity.costobejctentry", "in", planCostObjectIds);
            QFilter qfMaterialEntry = new QFilter("entryentity.id", ">", (Object)0L);
            selectFields.setLength(0);
            selectFields.append("costcenter,material.masterid AS submaterial,material.number AS submaterialnumber").append(",0L AS subauxpty,0L AS submatversion");
            selectFields.append(",entryentity.costobejctentry AS costobject");
            DataSet matAllocData = QueryServiceHelper.queryDataSet((String)(algoKey + "2"), (String)"sca_matalloc", (String)selectFields.toString(), (QFilter[])new QFilter[]{qfCostObject, qfOrg, qfCostAcount, qfPeriod, allocstatus, qfAppNum, qfMaterialEntry}, null);
            QFilter qfCostObjectId = new QFilter("id", "in", planCostObjectIds);
            selectFields.setLength(0);
            selectFields.append("id,material.masterid AS material,material.number AS materialnumber,0L AS auxpty,0L AS matversion");
            DataSet costObjectData = QueryServiceHelper.queryDataSet((String)(algoKey + "3"), (String)"cad_costobject", (String)selectFields.toString(), (QFilter[])new QFilter[]{qfCostObjectId}, null);
            selectFields.setLength(0);
            selectFields.append("costcenter,submaterial,submaterialnumber,subauxpty,costobject,submatversion");
            String[] matAllocFields = selectFields.toString().split(",");
            selectFields.setLength(0);
            selectFields.append("material,materialnumber,auxpty,matversion");
            String[] costObjectFields = selectFields.toString().split(",");
            DataSet data = matAllocData.leftJoin(costObjectData).on("costobject", "id").select(matAllocFields, costObjectFields).finish();
            QFilter prdStructureFilter = new QFilter("org", "in", args.getCalOrgIds());
            prdStructureFilter.and("costaccount", "in", args.getCostAccounts());
            prdStructureFilter.and("period", "=", (Object)args.getPeriod());
            prdStructureFilter.and("billstatus", "=", (Object)"C");
            DataSet prdStructure = QueryServiceHelper.queryDataSet((String)(algoKey + "4"), (String)"sca_halfprdstructure", (String)"material.id as material,material.number as materialnumber,0L as matversion,0L as auxpty,0L as costcenter,entryentity.submaterial.id as submaterial,entryentity.submaterial.number as submaterialnumber,0L as submatversion,0L as subauxpty,0L as costobject", (QFilter[])prdStructureFilter.toArray(), null);
            prdStructure = prdStructure.filter("material>0L and submaterial>0L and material<>submaterial");
            data = data.filter("material<>submaterial");
            data = DataSetHelper.union(data, prdStructure);
            RestoreCalcByCostRecoveryHelper.dealCurMat(data, materials);
        }
        qfPeriod = new QFilter("period", "=", (Object)PeriodHelper.getPrePeriodId(args.getPeriod()));
        QFilter qfbizstatus = new QFilter("costobject.bizstatus", "=", (Object)"A");
        if (planCostObjectIds.size() == 0) {
            filters = new QFilter[]{qfOrg, qfCostAcount, qfPeriod, qfbizstatus};
        } else {
            QFilter qfCostObject = new QFilter("costobject", "not in", planCostObjectIds);
            filters = new QFilter[]{qfOrg, qfCostAcount, qfCostObject, qfPeriod, qfbizstatus};
        }
        selectFields.setLength(0);
        selectFields.append("costobject");
        DataSet costObj = QueryServiceHelper.queryDataSet((String)(algoKey + "4"), (String)"sca_calcresult", (String)selectFields.toString(), (QFilter[])filters, null);
        if (!costObj.isEmpty()) {
            selectFields.setLength(0);
            selectFields.append("costcenter, 0 AS submaterial,0 AS submaterialnumber").append(",0 AS subauxpty,0 AS submatversion");
            selectFields.append(",costobject").append(",entryentity.material AS material").append(",entryentity.material.number AS materialnumber").append(",0L AS auxpty,0L AS matversion");
            DataSet calcResult = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_calcresult", (String)selectFields.toString(), (QFilter[])filters, null);
            calcResult = calcResult.filter("material<>submaterial");
            RestoreCalcByCostRecoveryHelper.dealCurMat(calcResult, materials);
        }
        args.setTotalCoCount(costObjectIds.size());
        args.setTotalCcCount(costCenterIds.size());
        RestoreCalcByCostRecoveryHelper.addCalMatGroup(args, materials);
        StringBuilder sb = new StringBuilder();
        int index = 1;
        for (CalcMaterial material : materials) {
            sb.append(material.getParentId()).append("->").append(material.getMaterialId()).append("\n");
            if (sb.length() <= 9000) continue;
            logger.error("\u9886\u7528\u5173\u7cfb{}:{}", (Object)index, (Object)sb.toString());
            ++index;
            sb.setLength(0);
        }
        if (sb.length() > 0) {
            logger.error("\u9886\u7528\u5173\u7cfb{}:{}", (Object)index, (Object)sb.toString());
            sb.setLength(0);
        }
        return materials;
    }

    private static void addCalMatGroup(CalcDataArgsByCostRecovery args, Set<CalcMaterial> materials) {
        args.getCostAccount();
        QFilter acctGrpRecordFilter = new QFilter("entryentity.costaccount.id", "=", (Object)Long.getLong("id"));
        DataSet acctGrpRecordData = QueryServiceHelper.queryDataSet((String)"", (String)"cal_account_grouprecord", (String)"entryentity.type as type,bizgrouprecordid,entryentity.costrecordentryid as billentryid,entryentity.material.id as materialid", (QFilter[])new QFilter[]{acctGrpRecordFilter}, null);
        args.getPeriod();
        QFilter filter = new QFilter("period.id", "=", (Object)Long.getLong("id"));
        filter.and("costaccount.id", "in", args.getCostAccounts());
        filter.and("isinitbill", "=", (Object)Boolean.FALSE);
        filter.and("issplitcreate", "=", (Object)Boolean.FALSE);
        filter.and("entry.accounttype", "=", (Object)"D");
        DataSet billData = QueryServiceHelper.queryDataSet((String)"", (String)"cal_costrecord_subentity", (String)"entry.id as costrecordentryid", (QFilter[])new QFilter[]{filter}, null);
        JoinDataSet joinDiffDataSet = acctGrpRecordData.leftJoin(billData).on("billentryid", "costrecordentryid");
        DataSet data = joinDiffDataSet.select(new String[]{"bizgrouprecordid", "type", "materialid"}, new String[]{"costrecordentryid"}).finish().filter(" costrecordentryid is not null").orderBy(new String[]{"bizgrouprecordid", "type"});
        Long lastBizgrouprecordid = 0L;
        HashSet<Long> srcBillMatIDs = new HashSet<Long>(16);
        HashSet<Long> targBillMatIDs = new HashSet<Long>(16);
        StringBuilder groupMatIds = new StringBuilder();
        for (Row row : data) {
            Long currBizgrouprecordid = row.getLong("bizgrouprecordid");
            if (lastBizgrouprecordid.compareTo(0L) == 0 || lastBizgrouprecordid.compareTo(currBizgrouprecordid) == 0) {
                if ("0".equals(row.getString("type"))) {
                    srcBillMatIDs.add(row.getLong("materialid"));
                } else {
                    targBillMatIDs.add(row.getLong("materialid"));
                }
            } else {
                for (Long srcMatId : srcBillMatIDs) {
                    for (Long tarMatId : targBillMatIDs) {
                        if (srcMatId.compareTo(tarMatId) == 0) continue;
                        RestoreCalcByCostRecoveryHelper.addMaterial(materials, tarMatId, srcMatId, groupMatIds);
                    }
                }
                srcBillMatIDs.clear();
                targBillMatIDs.clear();
                if ("0".equals(row.getString("type"))) {
                    srcBillMatIDs.add(row.getLong("materialid"));
                } else {
                    targBillMatIDs.add(row.getLong("materialid"));
                }
            }
            lastBizgrouprecordid = currBizgrouprecordid;
        }
        if (!targBillMatIDs.isEmpty() && !srcBillMatIDs.isEmpty()) {
            for (Long srcMatId : srcBillMatIDs) {
                for (Long tarMatId : targBillMatIDs) {
                    if (srcMatId.compareTo(tarMatId) == 0) continue;
                    RestoreCalcByCostRecoveryHelper.addMaterial(materials, tarMatId, srcMatId, groupMatIds);
                }
            }
        }
        logger.error("########\u4ece\u5b58\u8d27\u589e\u52a0\u9886\u7528\u5173\u7cfb\u7269\u6599\u5982\u4e0b\uff1a" + groupMatIds);
    }

    private static void addMaterial(Set<CalcMaterial> materials, Long tarMatId, Long srcMatId, StringBuilder groupMatIds) {
        CalcMaterial material = new CalcMaterial();
        material.setMaterialId(tarMatId);
        material.setParentId(0L);
        material.setLevel(0);
        if (!RestoreCalcByCostRecoveryHelper.isSameMaterialAndVer(material, materials)) {
            materials.add(material);
        }
        CalcMaterial submaterial = new CalcMaterial();
        submaterial.setMaterialId(srcMatId);
        submaterial.setParentId(tarMatId);
        submaterial.setLevel(1);
        if (!RestoreCalcByCostRecoveryHelper.isSameMaterialAndVer(submaterial, materials)) {
            materials.add(submaterial);
            groupMatIds.append(srcMatId).append("@");
            groupMatIds.append(tarMatId).append("\u2014>");
        }
    }

    private static void dealCurMat(DataSet data, Set<CalcMaterial> materials) {
        for (Row row : data) {
            Long curMatId = row.getLong("material");
            Long subMatId = row.getLong("submaterial");
            if (curMatId == 0L || subMatId == 0L) continue;
            CalcMaterial material = new CalcMaterial();
            material.setMaterialId(curMatId);
            material.setMaterialNumber(row.getString("materialnumber"));
            material.setLevel(0);
            material.setMaterialAuxPropId(row.getLong("auxpty"));
            material.setMaterialVer(row.getLong("matversion"));
            material.setIsleaf(false);
            if (!RestoreCalcByCostRecoveryHelper.isSameMaterialAndVer(material, materials)) {
                materials.add(material);
            }
            CalcMaterial subMaterial = new CalcMaterial();
            subMaterial.setParentId(curMatId);
            subMaterial.setPmaterialAuxPropId(row.getLong("auxpty"));
            subMaterial.setPmaterialVer(row.getLong("matversion"));
            subMaterial.setMaterialId(row.getLong("submaterial"));
            subMaterial.setMaterialNumber(row.getString("submaterialnumber"));
            subMaterial.setMaterialAuxPropId(row.getLong("subauxpty"));
            subMaterial.setMaterialVer(row.getLong("submatversion"));
            subMaterial.setLevel(1);
            if (RestoreCalcByCostRecoveryHelper.isSameMaterialAndVer(subMaterial, materials)) continue;
            materials.add(subMaterial);
        }
    }

    private static CalcMaterial getParentMaterialWithVer(CalcMaterial material, Set<CalcMaterial> mats) {
        for (CalcMaterial mat : mats) {
            if (material.getMaterialId() != mat.getMaterialId() || material.getMaterialAuxPropId() != mat.getMaterialAuxPropId() || material.getMaterialVer() != mat.getMaterialVer() || mat.getParentId() <= 0L) continue;
            return mat;
        }
        return null;
    }

    private static boolean isSameMaterialAndVer(CalcMaterial material, Set<CalcMaterial> materials) {
        for (CalcMaterial mat : materials) {
            if (material.getMaterialId() != mat.getMaterialId() || material.getMaterialAuxPropId() != mat.getMaterialAuxPropId() || material.getMaterialVer() != mat.getMaterialVer() || material.getParentId() != mat.getParentId()) continue;
            return true;
        }
        return false;
    }

    public static Set<CalcMaterial> filterDuplicatedMaterial(Set<CalcMaterial> mats) {
        TreeSet<CalcMaterial> matsForCalculate = new TreeSet<CalcMaterial>(Comparator.comparing(material -> String.valueOf(material.getMaterialId())));
        matsForCalculate.addAll(mats);
        return matsForCalculate;
    }

    public static Set<CalcMaterial> addNoRequestMatProduct(Set<CalcMaterial> mats, CalcDataArgs args) {
        String algoKey = "kd.macc.sca.algox.utils.RestoreCalcHelper.addNoRequestMatProduct";
        QFilter orgIdFilter = new QFilter("org", "=", (Object)args.getOrgId());
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter beginDateFilter = new QFilter("bizdate", ">=", (Object)args.getStartDate());
        QFilter endDateFilter = new QFilter("bizdate", "<=", (Object)args.getEndDate());
        String selectcoField = "entryentity.costobject.material material";
        QFilter[] filters = new QFilter[]{orgIdFilter, beginDateFilter, endDateFilter, statusFilter};
        DataSet resultDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_factnedoutputbill", (String)selectcoField, (QFilter[])filters, null);
        if (resultDs.isEmpty()) {
            return mats;
        }
        HashSet<Long> finshProducts = new HashSet<Long>();
        for (Row row : resultDs) {
            finshProducts.add(row.getLong("material"));
        }
        for (CalcMaterial mat : mats) {
            finshProducts.remove(mat.getMaterialId());
        }
        if (finshProducts.isEmpty()) {
            return mats;
        }
        for (Long productId : finshProducts) {
            CalcMaterial calcMaterial = new CalcMaterial();
            calcMaterial.setMaterialId(productId);
            calcMaterial.setLevel(0);
            mats.add(calcMaterial);
        }
        return mats;
    }
}

