/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.constants.CalcTaskType;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.InFilterHelper;
import kd.macc.sca.algox.utils.BigDecimalUtils;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.DataSetHelper;
import kd.macc.sca.algox.utils.PeriodHelper;
import kd.macc.sca.common.costcalc.CalcResultObjectInfo;
import kd.macc.sca.common.helper.ProAllocStdHelper;

public class ScaCalcHelper {
    private static final Log logger = LogFactory.getLog(ScaCalcHelper.class);

    public static Map<String, String> getProAllocStd(Long orgId, Long costAccountId, CalcTaskType taskType) {
        HashMap<String, String> resultMap = new HashMap<String, String>(16);
        switch (taskType) {
            case FinishCalc: 
            case RealtimeFinishCalc: {
                List costCenters = CostCenterHelper.getCostCenterByOrg((Long)orgId, (Long[])new Long[]{4L});
                if (CadEmptyUtils.isEmpty(costCenters)) break;
                HashMap<String, String> proAllocStdMap = new HashMap<String, String>(costCenters.size());
                for (Long costCenter : costCenters) {
                    proAllocStdMap.put(String.valueOf(costCenter), "5");
                }
                resultMap.putAll(proAllocStdMap);
                break;
            }
            case PeriodEndCalc: {
                Map proAllocStdMap = ProAllocStdHelper.getProAllocStdMap((Long)orgId, (Long)costAccountId, (String)"1", (String)"sca");
                if (CadEmptyUtils.isEmpty(proAllocStdMap)) {
                    return null;
                }
                resultMap.putAll(proAllocStdMap);
            }
        }
        return resultMap;
    }

    public static Map<String, BigDecimal> getEquivalentMap(Long orgId, Long costAccountId, Set<Long> manuOrgIds, List costObjectIds) {
        return ScaCalcHelper.getEquivalentMap(orgId, costAccountId, manuOrgIds, costObjectIds, false);
    }

    public static Map<String, BigDecimal> getEquivalentMap(Long orgId, Long costAccountId, Set<Long> manuOrgIds, Collection<Object> costObjectIds, boolean isDiff) {
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(16);
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("costaccount", "=", (Object)costAccountId);
        if (!CadEmptyUtils.isEmpty(manuOrgIds)) {
            filter.and("manuorg", "in", manuOrgIds);
        }
        filter.and("entryentity.costobject", "in", costObjectIds);
        String selectFields = "billno,period as periodId,manuorg,entryentity.costcenter as costCenterId,entryentity.costobject as costObjectId,entryentity." + (isDiff ? "diffcalctotalvalen" : "totalvalen") + " as totalvalen,entryentity.entryentitydetail.element as elementId,entryentity.entryentitydetail.subelement as subElementId,entryentity.entryentitydetail." + (isDiff ? "diffcalcdetailvalen" : "detailvalen") + " as detailvalen";
        DataSet equivalentsDs = QueryServiceHelper.queryDataSet((String)"CalcAction.initialEquivalent", (String)"sca_equivalent", (String)selectFields, (QFilter[])filter.toArray(), (String)"period asc");
        if (!equivalentsDs.isEmpty()) {
            for (Row equivalent : equivalentsDs) {
                String key;
                String subElementId;
                BigDecimal detailValen;
                String costObjectId = equivalent.get("costObjectId") == null ? "0" : equivalent.getString("costObjectId");
                String costCenterId = equivalent.get("costCenterId") == null ? "0" : equivalent.getString("costCenterId");
                String manuOrgId = equivalent.get("manuorg") == null ? "0" : equivalent.getString("manuorg");
                BigDecimal totalValen = equivalent.getBigDecimal("totalvalen");
                boolean noCostObject = "0".equals(costObjectId);
                boolean noCostCenter = "0".equals(costCenterId);
                boolean noManuOrg = "0".equals(manuOrgId);
                if (noCostObject && !noCostCenter) {
                    resultMap.put(costCenterId, totalValen);
                }
                if (noCostObject && noCostCenter && !noManuOrg) {
                    resultMap.put(manuOrgId, totalValen);
                }
                if (noCostObject && noCostCenter && noManuOrg) {
                    resultMap.put(String.valueOf(costAccountId), totalValen);
                }
                if ((detailValen = equivalent.getBigDecimal("detailvalen")) != null && BigDecimal.ZERO.compareTo(detailValen) != 0) {
                    subElementId = equivalent.getString("subElementId");
                    key = String.format("%s@%s", costObjectId, subElementId);
                    resultMap.put(key, detailValen);
                    continue;
                }
                subElementId = equivalent.getString("subElementId");
                key = String.format("%s@%s", costObjectId, subElementId);
                resultMap.remove(key);
            }
        }
        return resultMap;
    }

    public static BigDecimal getCostobjectEquivalent(Map<String, BigDecimal> resultMap, Long costAccountId, Long manoOrgId, Long costcenterId, Long costobjectId, Long subelementId) {
        String key = String.format("%s@%s", costobjectId, subelementId);
        if (resultMap.containsKey(key)) {
            return resultMap.get(key);
        }
        BigDecimal equivalent = resultMap.get(String.valueOf(costobjectId));
        if (CadEmptyUtils.isEmpty(equivalent)) {
            equivalent = resultMap.get(String.valueOf(costcenterId));
        }
        if (CadEmptyUtils.isEmpty(equivalent)) {
            equivalent = resultMap.get(String.valueOf(manoOrgId));
        }
        if (CadEmptyUtils.isEmpty(equivalent)) {
            equivalent = resultMap.get(String.valueOf(costAccountId));
        }
        return equivalent;
    }

    public static Map<Long, Map<Long, CalcResultObjectInfo>> getMainJoinSideCalcResultInfo(Long orgId, Long costAccountId, Long periodId, Long prePeriodId, Set<Long> costobjectIds) {
        return ScaCalcHelper.getMainJoinSideCalcResultInfo(orgId, costAccountId, periodId, prePeriodId, costobjectIds, null, null);
    }

    public static Set<Long> getMainJoinSideCostObjectIds(Long orgId, Set<Long> costobjectIds) {
        DataSet mainJoinSideDs = ScaCalcHelper.getMainJoinSideCostobjDsFromMainId(orgId, costobjectIds, new String[]{"C", "A", "B"});
        return ScaCalcHelper.getLongIdSetFromDs(mainJoinSideDs, "costObjectId", false);
    }

    public static Set<Long> getMainJoinCostObjectIds(Long orgId, Set<Long> costobjectIds) {
        DataSet mainJoinSideDs = ScaCalcHelper.getMainJoinSideCostobjDsFromMainId(orgId, costobjectIds, new String[]{"C", "A"});
        return ScaCalcHelper.getLongIdSetFromDs(mainJoinSideDs, "costObjectId", false);
    }

    public static Map<Long, Map<Long, CalcResultObjectInfo>> getMainJoinSideCalcResultInfo(Long orgId, Long costAccountId, Long periodId, Long prePeriodId, Set<Long> costobjectIds, Date startDate, Date endDate) {
        if (startDate == null) {
            Date[] dates = PeriodHelper.getPeriodStartAndEndTime(periodId);
            startDate = dates[0];
            endDate = dates[1];
        }
        DataSet mainJoinSideDs = ScaCalcHelper.getMainJoinSideCostobjDsFromMainId(orgId, costobjectIds, new String[]{"C", "A", "B"});
        Set<Long> calcMainJoinSideCostObjectSet = ScaCalcHelper.getLongIdSetFromDs(mainJoinSideDs, "costObjectId", true);
        DataSet costObjectStatusDs = ScaCalcHelper.getCostObjectStatus(costAccountId, costobjectIds);
        mainJoinSideDs = mainJoinSideDs.leftJoin(costObjectStatusDs).on("mainCostObjectId", "costobject").select(mainJoinSideDs.getRowMeta().getFieldNames(), new String[]{"bizstatus"}).finish();
        DataSet planDs = ScaCalcHelper.queryPlanDs(orgId, startDate, endDate, calcMainJoinSideCostObjectSet);
        mainJoinSideDs = mainJoinSideDs.leftJoin(planDs).on("costObjectId", "costObjectId").select(mainJoinSideDs.getRowMeta().getFieldNames(), new String[]{"pdcurrqty"}).finish();
        DataSet factDs = ScaCalcHelper.queryFactDs(orgId, startDate, endDate, calcMainJoinSideCostObjectSet);
        mainJoinSideDs = mainJoinSideDs.leftJoin(factDs).on("costObjectId", "costObjectId").select(mainJoinSideDs.getRowMeta().getFieldNames(), new String[]{"pdcompqty"}).finish();
        DataSet preCalResultDs = ScaCalcHelper.queryPrePeriodDs(orgId, costAccountId, prePeriodId, costobjectIds);
        mainJoinSideDs = mainJoinSideDs.leftJoin(preCalResultDs).on("mainCostObjectId", "mainCostObjectId").on("costObjectId", "costObjectId").select(mainJoinSideDs.getRowMeta().getFieldNames(), new String[]{"totalqty", "stdqty", "pdstartqty"}).finish();
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)costobjectIds.size());
        for (Row row : mainJoinSideDs) {
            Long mainCostObjectId = row.getLong("mainCostObjectId");
            Long costobjectId = row.getLong("costObjectId");
            Long costcenterId = row.getLong("costcenter");
            Long materialId = row.getLong("material");
            Map detailMap = resultMap.computeIfAbsent(mainCostObjectId, t -> Maps.newHashMapWithExpectedSize((int)10));
            CalcResultObjectInfo resultVo = detailMap.computeIfAbsent(costobjectId, t -> new CalcResultObjectInfo());
            String bizStatus = row.getString("bizStatus");
            if (!CadEmptyUtils.isEmpty(bizStatus)) {
                resultVo.setBizStatus(bizStatus);
            }
            resultVo.setCostObjectId(costobjectId.longValue());
            resultVo.setCostCenterId(costcenterId.longValue());
            resultVo.setMaterialId(materialId.longValue());
            resultVo.setWeight(BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal("weight")));
            resultVo.setProductgroupId(row.getLong("productgroup"));
            resultVo.addStartQty(BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal("pdstartqty")));
            resultVo.addPlanQty(BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal("pdcurrqty")));
            resultVo.addFinishQty(BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal("pdcompqty")));
            resultVo.addStdQty(BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal("stdqty")));
            resultVo.addTotalQty(BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal("totalqty")));
            resultVo.setProductType(row.getString("producttype"));
        }
        return resultMap;
    }

    private static DataSet queryPlanDs(Long orgId, Date startDate, Date endDate, Set<Long> costobjectIds) {
        QFilter qFilter = new QFilter("bizdate", "<=", (Object)endDate);
        qFilter.and("bizdate", ">=", (Object)startDate);
        qFilter.and("billstatus", "=", (Object)"C");
        qFilter.and("accountorg", "=", (Object)orgId);
        qFilter.and("appnum", "=", (Object)"sca");
        DataSet ds = InFilterHelper.queryDataSetIn((String)"cad_plannedoutputbill", (String)"costobject costObjectId,qty pdcurrqty", (QFilter)qFilter, (String)"costobject", new ArrayList<Long>(costobjectIds));
        return ds.groupBy(new String[]{"costObjectId"}).sum("pdcurrqty").finish();
    }

    private static DataSet queryFactDs(Long orgId, Date startDate, Date endDate, Set<Long> costobjectIds) {
        QFilter qFilter = new QFilter("bookdate", "<=", (Object)endDate);
        qFilter.and("bookdate", ">=", (Object)startDate);
        qFilter.and("billstatus", "=", (Object)"C");
        qFilter.and("org", "=", (Object)orgId);
        qFilter.and("appnum", "=", (Object)"sca");
        DataSet ds = InFilterHelper.queryDataSetIn((String)"cad_factnedoutputbill", (String)"entryentity.costobject costObjectId,entryentity.qty pdcompqty", (QFilter)qFilter, (String)"entryentity.costobject", new ArrayList<Long>(costobjectIds));
        return ds.groupBy(new String[]{"costObjectId"}).sum("pdcompqty").finish();
    }

    private static DataSet queryPrePeriodDs(Long orgId, Long costaccountId, Long prePeriodId, Set<Long> costobjectIds) {
        QFilter qFilter = new QFilter("period", "=", (Object)prePeriodId);
        qFilter.and("costaccount", "=", (Object)costaccountId);
        qFilter.and("org", "=", (Object)orgId);
        qFilter.and("entryentity.caltype", "=", (Object)"5");
        DataSet ds = InFilterHelper.queryDataSetIn((String)"sca_calcresult", (String)"costobject mainCostObjectId,entryentity.obj costObjectId, entryentity.totalqty totalqty,entryentity.stdqty stdqty,entryentity.pdendqty pdstartqty", (QFilter)qFilter, (String)"costobject", new ArrayList<Long>(costobjectIds));
        return ds.groupBy(new String[]{"mainCostObjectId", "costObjectId"}).max("totalqty").max("stdqty").max("pdstartqty").finish();
    }

    private static DataSet getCostObjectStatus(Long costaccountId, Set<Long> costObjectIds) {
        QFilter commonQF = new QFilter("costaccount", "=", (Object)costaccountId);
        commonQF.and("bizstatus", "=", (Object)"B");
        DataSet ds = InFilterHelper.queryDataSetIn((String)"cad_costobjectaccount", (String)"id, costobject,bizstatus", (QFilter)commonQF, (String)"costobject", new ArrayList<Long>(costObjectIds));
        return ds.groupBy(new String[]{"costobject", "bizstatus"}).finish();
    }

    public static Set<Long> getLongIdSetFromDs(DataSet ds, String colField, boolean isCopy) {
        DataSet result = ds;
        if (isCopy) {
            result = ds.copy();
        }
        HashSet longIdSet = Sets.newHashSetWithExpectedSize((int)16);
        for (Row row : result) {
            longIdSet.add(row.getLong(colField));
        }
        return longIdSet;
    }

    public static List<Long> getLongIdListFromDs(DataSet ds, String colField, boolean isCopy) {
        DataSet result = ds;
        if (isCopy) {
            result = ds.copy();
        }
        ArrayList longIdSet = Lists.newArrayList();
        for (Row row : result) {
            longIdSet.add(row.getLong(colField));
        }
        return longIdSet;
    }

    public static DataSet getMainJoinSideCostobjDsFromMainId(Long orgId, Set<Long> mainCostobjectIds, String[] productTypes) {
        ArrayList<Long> costObjectInIds = new ArrayList<Long>(mainCostobjectIds);
        DataSet mainCostobjectDs = InFilterHelper.queryDataSetIn((String)"cad_costobject", (String)"costcenter,costcenter mainCostCenterId,id mainCostObjectId,id costObjectId,billno,srcbillnumber,productgroup,producttype,material,material.number AS materialnumber,material.baseunit.precision as matunitprecision,bomversion AS matversion,auxpty,weight,probill,isoutsource", null, (String)"id", costObjectInIds);
        DataSet mainJoinSideDs = null;
        mainJoinSideDs = Arrays.asList(productTypes).contains("C") ? mainCostobjectDs.copy().filter("productgroup>0") : mainCostobjectDs.filter("productgroup>0");
        HashSet productgroupIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet poNos = Sets.newHashSetWithExpectedSize((int)16);
        for (Row row : mainJoinSideDs.copy()) {
            productgroupIds.add(row.getLong("productgroup"));
            poNos.add(row.getString("srcbillnumber"));
        }
        DataSet relaCostobjectDs = null;
        if (productgroupIds.isEmpty() && poNos.isEmpty()) {
            relaCostobjectDs = mainJoinSideDs;
        } else {
            ArrayList<String> productTypeList = new ArrayList<String>();
            productTypeList.addAll(Arrays.asList(productTypes));
            productTypeList.remove("C");
            QFilter relaFilter = new QFilter("org", "=", (Object)orgId);
            relaFilter.and("productgroup", "in", (Object)productgroupIds);
            relaFilter.and("srcbillnumber", "in", (Object)poNos);
            relaFilter.and("producttype", "in", productTypeList);
            relaCostobjectDs = QueryServiceHelper.queryDataSet((String)"Calcresult", (String)"cad_costobject", (String)"costcenter,id costObjectId,billno,srcbillnumber,productgroup,producttype,material,material.number AS materialnumber,material.baseunit.precision as matunitprecision,bomversion AS matversion,auxpty,weight,probill,isoutsource,mainproobj", (QFilter[])relaFilter.toArray(), null);
            Object notHasRelaMainDs = relaCostobjectDs.copy().filter("mainproobj=0");
            notHasRelaMainDs = !notHasRelaMainDs.isEmpty() ? mainJoinSideDs.join(notHasRelaMainDs).on("productgroup", "productgroup").on("srcbillnumber", "srcbillnumber").select(new String[]{"mainCostCenterId", "mainCostObjectId"}, new String[]{"costcenter", "costObjectId", "billno", "srcbillnumber", "productgroup", "producttype", "material", "materialnumber", "matunitprecision", "matversion", "auxpty", "weight", "probill", "isoutsource"}).finish() : null;
            relaCostobjectDs = mainJoinSideDs.join(relaCostobjectDs).on("mainCostObjectId", "mainproobj").select(new String[]{"mainCostCenterId", "mainCostObjectId"}, new String[]{"costcenter", "costObjectId", "billno", "srcbillnumber", "productgroup", "producttype", "material", "materialnumber", "matunitprecision", "matversion", "auxpty", "weight", "probill", "isoutsource"}).finish();
            if (notHasRelaMainDs != null) {
                relaCostobjectDs = relaCostobjectDs.union(notHasRelaMainDs);
            }
        }
        if (Arrays.asList(productTypes).contains("C")) {
            relaCostobjectDs = DataSetHelper.union(relaCostobjectDs, mainCostobjectDs);
        }
        return relaCostobjectDs;
    }

    public static boolean isContainsProductFacted(Map<Long, CalcResultObjectInfo> productGroupCostObjMap, String productType) {
        for (Map.Entry<Long, CalcResultObjectInfo> entry : productGroupCostObjMap.entrySet()) {
            if (!productType.equals(entry.getValue().getProductType()) || BigDecimal.ZERO.compareTo(entry.getValue().getFinishQty()) == 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isHasMainJoinFacted(Map<Long, CalcResultObjectInfo> productGroupCostObjMap) {
        return ScaCalcHelper.isContainsProductFacted(productGroupCostObjMap, "C") || ScaCalcHelper.isContainsProductFacted(productGroupCostObjMap, "A");
    }

    public static boolean isMainJoinAllFacted(Map<Long, CalcResultObjectInfo> productGroupCostObjMap) {
        for (CalcResultObjectInfo costobjectInfo : productGroupCostObjMap.values()) {
            if (!"C".equals(costobjectInfo.getProductType()) && !"A".equals(costobjectInfo.getProductType()) || BigDecimal.ZERO.compareTo(costobjectInfo.getEndQty()) >= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isContainsJoinProduct(Map<Long, CalcResultObjectInfo> productGroupCostObjMap) {
        for (Map.Entry<Long, CalcResultObjectInfo> entry : productGroupCostObjMap.entrySet()) {
            if (!"A".equals(entry.getValue().getProductType())) continue;
            return true;
        }
        return false;
    }

    public static BigDecimal getMainAndJoinProEndQty(Map<Long, CalcResultObjectInfo> productGroupCostObjMap) {
        BigDecimal proEndQty = BigDecimal.ZERO;
        for (Map.Entry<Long, CalcResultObjectInfo> entry : productGroupCostObjMap.entrySet()) {
            if ("B".equals(entry.getValue().getProductType())) continue;
            proEndQty = proEndQty.add(entry.getValue().getEndQty());
        }
        return proEndQty;
    }

    public static BigDecimal getMainAndJoinProFinQty(Map<Long, CalcResultObjectInfo> productGroupCostObjMap) {
        BigDecimal proFinQty = BigDecimal.ZERO;
        for (Map.Entry<Long, CalcResultObjectInfo> entry : productGroupCostObjMap.entrySet()) {
            if ("B".equals(entry.getValue().getProductType())) continue;
            proFinQty = proFinQty.add(entry.getValue().getFinishQty());
        }
        return proFinQty;
    }
}

