/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.wip;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.operate.MutexHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class CalcMutexHelper {
    private static final Map<String, List<String>> typeMap = new HashMap<String, List<String>>();
    public static final String PDEND = "pdend";
    public static final String FINISH = "finish";
    public static final String STDCALC = "stdcalc";
    public static final String UPDATE = "update";
    public static final String DIFFCALC = "diffcalc";
    public static final String REDUCTCALC = "reductcalc";
    public static final String MATDIST = "matdist";
    public static final String MANDIST = "mandist";

    private static synchronized boolean requireXMutex(String type, Object costTypeId) {
        StringBuilder errMsg = new StringBuilder();
        return MutexHelper.require((String)typeMap.get(type).get(0), (Object)costTypeId, (String)typeMap.get(type).get(1), (boolean)true, (StringBuilder)errMsg);
    }

    public static synchronized boolean releaseXMutex(String type, Object costTypeId) {
        return MutexHelper.release((String)typeMap.get(type).get(0), (String)typeMap.get(type).get(1), (String)String.valueOf(costTypeId));
    }

    public static String checkAndRequireXMutex(String type, Object costTypeId) {
        return CalcMutexHelper.checkAndRequireXMutex(type, costTypeId, true);
    }

    public static String checkAndRequireXMutex(String type, Object costTypeId, boolean ischeckOther) {
        String checkErr = null;
        if (ischeckOther) {
            Iterator<String> iterator = typeMap.keySet().iterator();
            while (iterator.hasNext()) {
                String typeKey;
                switch (typeKey = iterator.next()) {
                    case "pdend": {
                        checkErr = CalcMutexHelper.enableReentrant(PDEND, costTypeId);
                        break;
                    }
                    case "finish": {
                        checkErr = CalcMutexHelper.enableReentrant(FINISH, costTypeId);
                        break;
                    }
                    case "stdcalc": {
                        checkErr = CalcMutexHelper.enableReentrant(STDCALC, costTypeId);
                        break;
                    }
                    case "update": {
                        checkErr = CalcMutexHelper.enableReentrant(UPDATE, costTypeId);
                        break;
                    }
                    case "diffcalc": {
                        checkErr = CalcMutexHelper.enableReentrant(DIFFCALC, costTypeId);
                        break;
                    }
                    case "reductcalc": {
                        checkErr = CalcMutexHelper.enableReentrant(REDUCTCALC, costTypeId);
                        break;
                    }
                    case "matdist": {
                        checkErr = CalcMutexHelper.enableReentrant(MATDIST, costTypeId);
                        break;
                    }
                    case "mandist": {
                        checkErr = CalcMutexHelper.enableReentrant(MANDIST, costTypeId);
                    }
                }
                if (!StringUtils.isNotEmpty(checkErr)) continue;
                return checkErr;
            }
        }
        if (!CalcMutexHelper.requireXMutex(type, costTypeId)) {
            return CalcMutexHelper.getErrTips(type);
        }
        return null;
    }

    public static synchronized String enableReentrant(String type, Object costTypeId) {
        if (!MutexHelper.enableReentrant((String)typeMap.get(type).get(0), (Object)costTypeId, (String)typeMap.get(type).get(1))) {
            return CalcMutexHelper.getErrTips(type);
        }
        return null;
    }

    public static String getErrTips(String type) {
        switch (type) {
            case "pdend": {
                return ResManager.loadKDString((String)"\u201c%s\u201d\u6b63\u5728\u8fdb\u884c\u671f\u672b\u5728\u4ea7\u54c1\u8ba1\u7b97\uff0c\u8bf7\u7a0d\u540e\u6267\u884c\u3002", (String)"CalcMutexHelper_0", (String)"macc-sca-algox", (Object[])new Object[0]);
            }
            case "finish": {
                return ResManager.loadKDString((String)"\u201c%s\u201d\u6b63\u5728\u8fdb\u884c\u5b8c\u5de5\u4ea7\u54c1\u8ba1\u7b97\uff0c\u8bf7\u7a0d\u540e\u6267\u884c\u3002", (String)"CalcMutexHelper_1", (String)"macc-sca-algox", (Object[])new Object[0]);
            }
            case "stdcalc": {
                return ResManager.loadKDString((String)"\u201c%s\u201d\u6b63\u5728\u8fdb\u884c\u5377\u7b97\uff0c\u8bf7\u7a0d\u540e\u6267\u884c\u3002", (String)"CalcMutexHelper_2", (String)"macc-sca-algox", (Object[])new Object[0]);
            }
            case "update": {
                return ResManager.loadKDString((String)"\u201c%s\u201d\u6b63\u5728\u8fdb\u884c\u6210\u672c\u66f4\u65b0\uff0c\u8bf7\u7a0d\u540e\u6267\u884c\u3002", (String)"CalcMutexHelper_3", (String)"macc-sca-algox", (Object[])new Object[0]);
            }
            case "diffcalc": {
                return ResManager.loadKDString((String)"\u201c%s\u201d\u6b63\u5728\u8fdb\u884c\u5dee\u5f02\u5206\u644a\u8ba1\u7b97\uff0c\u8bf7\u7a0d\u540e\u6267\u884c\u3002", (String)"CalcMutexHelper_4", (String)"macc-sca-algox", (Object[])new Object[0]);
            }
            case "reductcalc": {
                return ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%s\u201d\u6b63\u5728\u8fdb\u884c\u5b9e\u9645\u6210\u672c\u8fd8\u539f\u8ba1\u7b97\uff0c\u8bf7\u7a0d\u540e\u6267\u884c\u3002", (String)"CalcMutexHelper_5", (String)"macc-sca-algox", (Object[])new Object[0]);
            }
            case "matdist": {
                return ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%s\u201d\u6b63\u5728\u8fdb\u884c\u6750\u6599\u8017\u7528\u5206\u914d\uff0c\u8bf7\u7a0d\u540e\u6267\u884c\u3002", (String)"CalcMutexHelper_6", (String)"macc-sca-algox", (Object[])new Object[0]);
            }
            case "mandist": {
                return ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%s\u201d\u6b63\u5728\u8fdb\u884c\u5236\u9020\u8d39\u7528\u5206\u914d\uff0c\u8bf7\u7a0d\u540e\u6267\u884c\u3002", (String)"CalcMutexHelper_7", (String)"macc-sca-algox", (Object[])new Object[0]);
            }
        }
        return null;
    }

    public static String getCostTypeIdBy(Object acctId) {
        QFilter filter = new QFilter("id", "=", acctId);
        DynamicObject acct = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"costtype", (QFilter[])new QFilter[]{filter});
        return acct.getString("costtype");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String checkMutexAndLock(String type, boolean enableMulFactory, Long acctId, String lockStr) {
        boolean releaseFlag = true;
        String lockErr = CalcMutexHelper.checkAndRequireXMutex(type, acctId);
        try {
            if (StringUtils.isNotEmpty((String)lockErr)) {
                releaseFlag = false;
                String string = lockErr;
                return string;
            }
            if (enableMulFactory) {
                lockErr = CalcMutexHelper.checkAndRequireXMutex(type, String.valueOf(acctId).hashCode());
                if (StringUtils.isNotEmpty((String)lockErr)) {
                    lockErr = CalcMutexHelper.checkAndRequireXMutex(type, lockStr.hashCode());
                    if (StringUtils.isNotEmpty((String)lockErr)) {
                        String string = lockErr;
                        return string;
                    }
                } else {
                    CalcMutexHelper.checkAndRequireXMutex(type, lockStr.hashCode());
                }
            }
        }
        finally {
            if (enableMulFactory && releaseFlag) {
                CalcMutexHelper.releaseXMutex(type, acctId);
            }
        }
        return null;
    }

    public static void releaseMuteInFinally(String type, boolean enableMulFactory, Long acctId, String lockStr) {
        if (enableMulFactory) {
            CalcMutexHelper.releaseXMutex(type, String.valueOf(acctId).hashCode());
            CalcMutexHelper.releaseXMutex(type, lockStr.hashCode());
        } else {
            CalcMutexHelper.releaseXMutex(type, acctId);
        }
    }

    public static synchronized String enableReentrantAll(String type, Long costAcctId) {
        if (!MutexHelper.enableReentrant((String)typeMap.get(type).get(0), (Object)costAcctId, (String)typeMap.get(type).get(1))) {
            return CalcMutexHelper.getErrTips(type);
        }
        if (!MutexHelper.enableReentrant((String)typeMap.get(type).get(0), (Object)String.valueOf(costAcctId).hashCode(), (String)typeMap.get(type).get(1))) {
            return CalcMutexHelper.getErrTips(type);
        }
        return null;
    }

    public static String checkAndRequireXMutexNoPrdOrg(String type, Long obj) {
        String checkErr = null;
        Iterator<String> iterator = typeMap.keySet().iterator();
        while (iterator.hasNext()) {
            String typeKey;
            switch (typeKey = iterator.next()) {
                case "pdend": {
                    checkErr = CalcMutexHelper.enableReentrantAll(PDEND, obj);
                    break;
                }
                case "finish": {
                    checkErr = CalcMutexHelper.enableReentrantAll(FINISH, obj);
                    break;
                }
                case "reductcalc": {
                    checkErr = CalcMutexHelper.enableReentrantAll(REDUCTCALC, obj);
                    break;
                }
                case "matdist": {
                    checkErr = CalcMutexHelper.enableReentrantAll(MATDIST, obj);
                    break;
                }
                case "mandist": {
                    checkErr = CalcMutexHelper.enableReentrantAll(MANDIST, obj);
                    break;
                }
                case "stdcalc": {
                    checkErr = CalcMutexHelper.enableReentrantAll(STDCALC, obj);
                    break;
                }
                case "update": {
                    checkErr = CalcMutexHelper.enableReentrantAll(UPDATE, obj);
                    break;
                }
                case "diffcalc": {
                    checkErr = CalcMutexHelper.enableReentrantAll(DIFFCALC, obj);
                }
            }
            if (!StringUtils.isNotEmpty(checkErr)) continue;
            return checkErr;
        }
        if (!CalcMutexHelper.requireXMutex(type, obj)) {
            return CalcMutexHelper.getErrTips(type);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String checkMutexAndLock(String type, boolean enableMulFactory, Long acctId, Set<Long> orgSet) {
        boolean releaseFlag = true;
        boolean cancelFlag = false;
        HashSet<Long> cancelOrgSet = new HashSet<Long>(8);
        String lockErr = CalcMutexHelper.checkAndRequireXMutex(type, acctId);
        try {
            if (StringUtils.isNotEmpty((String)lockErr)) {
                releaseFlag = false;
                String string = lockErr;
                return string;
            }
            if (enableMulFactory) {
                Iterator<Long> ite = orgSet.iterator();
                String lockStr = "";
                while (ite.hasNext()) {
                    Long orgId = ite.next();
                    lockStr = String.valueOf(acctId) + orgId;
                    lockErr = CalcMutexHelper.checkAndRequireXMutex(type, lockStr.hashCode());
                    if (StringUtils.isNotEmpty((String)lockErr)) {
                        cancelFlag = true;
                        String string = lockErr;
                        return string;
                    }
                    cancelOrgSet.add(orgId);
                }
            }
        }
        finally {
            if (enableMulFactory && releaseFlag) {
                CalcMutexHelper.releaseXMutex(type, acctId);
            }
            if (cancelFlag && cancelOrgSet.size() > 0) {
                for (Long orgId : cancelOrgSet) {
                    CalcMutexHelper.releaseXMutex(type, (String.valueOf(acctId) + orgId).hashCode());
                }
            }
        }
        return null;
    }

    public static void releaseMuteFromSet(String type, boolean enableMulFactory, Long acctId, Set<Long> orgSet) {
        if (!enableMulFactory) {
            CalcMutexHelper.releaseXMutex(type, acctId);
            return;
        }
        for (Long orgId : orgSet) {
            CalcMutexHelper.releaseXMutex(type, (String.valueOf(acctId) + orgId).hashCode());
        }
    }

    static {
        typeMap.put(PDEND, Arrays.asList("sca_wipcalwizards", "calculate"));
        typeMap.put(FINISH, Arrays.asList("sca_finishcalwizards", "calc"));
        typeMap.put(STDCALC, Arrays.asList("cad_stdcalcnew", "calculate"));
        typeMap.put(UPDATE, Arrays.asList("cad_costupdateestablished", "liveupdate"));
        typeMap.put(DIFFCALC, Arrays.asList("sca_differencecalcwizards", DIFFCALC));
        typeMap.put(REDUCTCALC, Arrays.asList("sca_factcostreduction", REDUCTCALC));
        typeMap.put(MATDIST, Arrays.asList("sca_matalloc", MATDIST));
        typeMap.put(MANDIST, Arrays.asList("sca_mfgfeealloc", MANDIST));
    }
}

