/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.opplugin.autoexec;

import java.util.ArrayList;
import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class AutoExecSchemeEnableOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("sheduleplanid");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<String> schedulePlanIds = new ArrayList<String>(16);
        for (DynamicObject dataEntity : dataEntities) {
            String sheduleplanid = dataEntity.getString("sheduleplanid");
            schedulePlanIds.add(sheduleplanid);
        }
        if (CadEmptyUtils.isEmpty(schedulePlanIds)) {
            return;
        }
        DynamicObject[] schedules = BusinessDataServiceHelper.load((String)"sch_schedule", (String)"id,entryentity.jobnumber", (QFilter[])new QFilter[]{new QFilter("id", "in", schedulePlanIds)});
        ArrayList scheduleIds = new ArrayList(10);
        ArrayList jobIds = new ArrayList(16);
        Arrays.stream(schedules).forEach(sche -> {
            scheduleIds.add(sche.getString("id"));
            DynamicObjectCollection jobs = sche.getDynamicObjectCollection("entryentity");
            jobs.forEach(p -> jobIds.add(p.getString("jobnumber.id")));
        });
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        for (String scheduleId : scheduleIds) {
            if ("disable".equals(operationKey)) {
                scheduleManager.disableSchedule(scheduleId);
                continue;
            }
            if (!"enable".equals(operationKey)) continue;
            scheduleManager.enableSchedule(scheduleId);
        }
        for (String jobId : jobIds) {
            if ("disable".equals(operationKey)) {
                scheduleManager.disableJob(jobId);
                scheduleManager.afterUpdateJob(jobId);
                continue;
            }
            if (!"enable".equals(operationKey)) continue;
            scheduleManager.enableJob(jobId);
            scheduleManager.afterUpdateJob(jobId);
        }
    }
}

