/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.opplugin.autoexec;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class AutoExectSchemeDeleteOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("ispreset");
        e.getFieldKeys().add("sheduleplanid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity extendedDataEntity : dataEntities = this.dataEntities) {
                    DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                    boolean ispreset = dataEntity.getBoolean("ispreset");
                    if (!ispreset) continue;
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u7f6e\u6570\u636e\u4e0d\u80fd\u5220\u9664\u3002", (String)"AutoExectSchemeDeleteOp_0", (String)"macc-sca-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<Long> scheduleIds = new ArrayList<Long>(16);
        ArrayList<String> schedulePlanIds = new ArrayList<String>(16);
        for (DynamicObject dataEntity : dataEntities) {
            scheduleIds.add(dataEntity.getLong("id"));
            schedulePlanIds.add(dataEntity.getString("sheduleplanid"));
        }
        if (!scheduleIds.isEmpty()) {
            DeleteServiceHelper.delete((String)"sca_schemelog", (QFilter[])new QFilter[]{new QFilter("scheme", "in", scheduleIds)});
        }
        if (schedulePlanIds.isEmpty()) {
            return;
        }
        DynamicObjectCollection schedules = QueryServiceHelper.query((String)"sch_schedule", (String)"job", (QFilter[])new QFilter[]{new QFilter("id", "in", schedulePlanIds)});
        List jobIds = schedules.stream().map(sch -> sch.get("job")).collect(Collectors.toList());
        try (TXHandle h = TX.required((String)"AutoExectSchemeDeleteOp");){
            try {
                DeleteServiceHelper.delete((String)"sch_schedule", (QFilter[])new QFilter[]{new QFilter("id", "in", schedulePlanIds)});
                DeleteServiceHelper.delete((String)"sch_job", (QFilter[])new QFilter[]{new QFilter("id", "in", jobIds)});
            }
            catch (Exception e1) {
                h.markRollback();
                throw e1;
            }
        }
    }
}

