/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.opplugin.checkdata;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.sca.opplugin.checkdata.CheckDataTaskHelper;

public class CheckDataTaskEnablePlugin
extends AbstractOperationServicePlugIn {
    private static final String OP_ENABLE = "enable";
    private static final String OP_DISABLE = "disable";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("number");
        e.getFieldKeys().add("appnum");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        block9: {
            ScheduleManager scheduleManager;
            HashSet<String> ids;
            block8: {
                super.beforeExecuteOperationTransaction(e);
                HashSet<String> numbers = new HashSet<String>(e.getDataEntities().length);
                String appNum = null;
                for (DynamicObject dynamicObject : e.getDataEntities()) {
                    numbers.add(dynamicObject.getString("number"));
                    if (appNum != null) continue;
                    appNum = dynamicObject.getString("appnum");
                }
                Set<String> jobNumbers = CheckDataTaskHelper.getTaskNumbers(numbers, appNum);
                DynamicObject[] jobs = BusinessDataServiceHelper.load((String)"sch_job", (String)"id,status", (QFilter[])new QFilter("number", "in", jobNumbers).toArray());
                ids = new HashSet<String>(jobs.length);
                if (OP_ENABLE.equals(e.getOperationKey())) {
                    for (DynamicObject job : jobs) {
                        job.set("status", (Object)"1");
                        ids.add(job.getString("id"));
                    }
                } else if (OP_DISABLE.equals(e.getOperationKey())) {
                    for (DynamicObject job : jobs) {
                        job.set("status", (Object)"0");
                        ids.add(job.getString("id"));
                    }
                }
                SaveServiceHelper.save((DynamicObject[])jobs);
                scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
                if (!OP_ENABLE.equals(e.getOperationKey())) break block8;
                for (String id : ids) {
                    scheduleManager.afterDeleteJob(id);
                }
                break block9;
            }
            if (!OP_DISABLE.equals(e.getOperationKey())) break block9;
            for (String id : ids) {
                scheduleManager.afterUpdateJob(id);
            }
        }
    }
}

