/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.opplugin.costreduction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.enums.SysParamEnum;
import kd.macc.cad.common.helper.BomRouterHelper;
import kd.macc.cad.common.helper.CalcKeycolHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.common.helper.CostReductHelper;

public class HalfPrdStructureSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List list = e.getFieldKeys();
        list.add("isimport");
        list.add("billno");
        list.add("entryentity");
        list.add("org");
        list.add("costaccount");
        list.add("period");
        list.add("calckeycol");
        list.add("material");
        list.add("prdorg");
        list.add("materialversion");
        list.add("auxprop");
        list.add("storageorgunit");
        list.add("subcalckeycol");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new InnerValidate());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String sql;
        super.afterExecuteOperationTransaction(e);
        if (!e.getOperationKey().equalsIgnoreCase("submit")) {
            return;
        }
        DynamicObject[] dyns = e.getDataEntities();
        HashMap<String, String> costaccountAppnumMap = new HashMap<String, String>(10);
        HashMap<String, List> costaccountIdMap = new HashMap<String, List>(10);
        HashMap<String, Set> costaccountKeyColMap = new HashMap<String, Set>(10);
        ArrayList<Long> ids = new ArrayList<Long>(10);
        ArrayList<Long> subids = new ArrayList<Long>(10);
        for (DynamicObject dyn : dyns) {
            Long orgId = dyn.getLong("org.id");
            Long costaccountId = dyn.getLong("costaccount.id");
            String key = String.format("%s@%s", orgId, costaccountId);
            costaccountAppnumMap.putIfAbsent(key, CalcKeycolHelper.getCostaccountAppnum((Long)costaccountId));
            String appnum = (String)costaccountAppnumMap.get(key);
            Set calcKeys = (Set)costaccountKeyColMap.get(key);
            if (calcKeys == null) {
                if ("sca".equals(appnum) || "aca".equals(appnum)) {
                    calcKeys = CalcKeycolHelper.getCostaccountReductKeyCols((Long)orgId, (Long)costaccountId, (String)appnum);
                    costaccountKeyColMap.put(key, calcKeys);
                } else {
                    costaccountKeyColMap.put(key, new TreeSet());
                }
            }
            if (CadEmptyUtils.isEmpty((Set)calcKeys)) {
                Long calckeycolId = dyn.getLong("calckeycol.id");
                if (CadEmptyUtils.isEmpty((Long)calckeycolId)) continue;
                ids.add(dyn.getLong("id"));
                DynamicObjectCollection entryentity = dyn.getDynamicObjectCollection("entryentity");
                for (DynamicObject subDyn : entryentity) {
                    Long subcalckeycol = subDyn.getLong("subcalckeycol.id");
                    if (CadEmptyUtils.isEmpty((Long)subcalckeycol)) continue;
                    subids.add(subDyn.getLong("id"));
                }
                continue;
            }
            costaccountIdMap.computeIfAbsent(key, t -> new ArrayList(10)).add(dyn.getLong("id"));
        }
        if (!costaccountIdMap.isEmpty()) {
            for (Map.Entry entry : costaccountIdMap.entrySet()) {
                String[] arr = ((String)entry.getKey()).split("@");
                Long orgId = Long.parseLong(arr[0]);
                Long costaccountId = Long.parseLong(arr[1]);
                CalcKeycolHelper.halfPrdStructGenKeycol((Long)orgId, (Long)costaccountId, (List)((List)entry.getValue()), (String)((String)costaccountAppnumMap.get(entry.getKey())), (Set)((Set)costaccountKeyColMap.get(entry.getKey())));
            }
        }
        if (!ids.isEmpty()) {
            sql = String.format("update t_sca_halfprdstructure set fcalckeycolid=0 where fid in (%s)", this.getUpdateInSql(ids));
            DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)sql);
        }
        if (!subids.isEmpty()) {
            sql = String.format("update t_sca_halfprdstructentry set fsubcalckeycolid=0 where fentryid in (%s)", this.getUpdateInSql(subids));
            DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)sql);
        }
    }

    private String getUpdateInSql(List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return "0";
        }
        StringBuilder sb = new StringBuilder();
        for (Long costcenter : ids) {
            sb.append(",").append(costcenter);
        }
        return sb.substring(1);
    }

    private boolean validateBillNo(DynamicObject data) {
        QFilter qFilter;
        boolean exists;
        if (data == null) {
            return false;
        }
        String billno = data.getString("billno");
        return !CadEmptyUtils.isEmpty((String)billno) && (exists = QueryServiceHelper.exists((String)"sca_halfprdstructure", (QFilter[])(qFilter = new QFilter("billno", "=", (Object)billno)).toArray()));
    }

    private boolean validateSubMaterialInfo(DynamicObject data, Map msgMap) {
        if (data == null) {
            return false;
        }
        DynamicObjectCollection entryentity = data.getDynamicObjectCollection("entryentity");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entryentity)) {
            return false;
        }
        DynamicObject material = data.getDynamicObject("material");
        if (material == null) {
            return false;
        }
        for (int i = 0; i < entryentity.size(); ++i) {
            DynamicObject submaterialauxprop;
            String type;
            DynamicObject row = (DynamicObject)entryentity.get(i);
            DynamicObject submaterial = row.getDynamicObject("submaterial");
            DynamicObject element = row.getDynamicObject("element");
            if (element != null && ("001".equals(type = element.getString("type")) || "002".equals(type))) {
                if (submaterial == null) {
                    msgMap.put("validateMsg", ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u5b58\u5728\u6210\u672c\u8981\u7d20\u4e3a\u7269\u6599\u6216\u7269\u6599\u8d39\u7528\uff0c\u5b50\u9879\u7269\u6599\u5374\u4e3a\u7a7a\u7684\u5206\u5f55\u884c\u3002", (String)"HalfPrdStructureSaveOp_0", (String)"macc-sca-opplugin", (Object[])new Object[0]));
                    return true;
                }
                if (material.getPkValue() == submaterial.getPkValue()) {
                    row.set("isunabsorb", (Object)"B");
                }
            }
            if (submaterial == null) continue;
            String number = submaterial.getString("number");
            if (!BomRouterHelper.isEnableAuxprop((DynamicObject)submaterial) || (submaterialauxprop = data.getDynamicObject("submaterialauxprop")) != null) continue;
            msgMap.put("validateMsg", String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u7269\u6599\u201c%s\u201d\u542f\u7528\u4e86\u5f71\u54cd\u6210\u672c\u7684\u8f85\u52a9\u5c5e\u6027\uff0c\u8bf7\u5f55\u5165\u3002", (String)"HalfPrdStructureSaveOp_2", (String)"macc-sca-opplugin", (Object[])new Object[0]), number));
            return true;
        }
        return false;
    }

    private boolean validateDataOnlyOne(DynamicObject data, Map msgMap, DynamicObject costParam, boolean checkRepeat) {
        DynamicObject matVersion;
        if (data == null) {
            return false;
        }
        DynamicObject org = data.getDynamicObject("org");
        if (org == null) {
            return false;
        }
        DynamicObject costaccount = data.getDynamicObject("costaccount");
        if (costaccount == null) {
            return false;
        }
        DynamicObject period = data.getDynamicObject("period");
        if (period == null) {
            return false;
        }
        DynamicObject material = data.getDynamicObject("material");
        if (material == null) {
            return false;
        }
        QFilter finalFilter = new QFilter("org", "=", (Object)org.getLong("id"));
        if (data.getPkValue() != null) {
            finalFilter.and(new QFilter("id", "!=", data.getPkValue()));
        }
        finalFilter.and(new QFilter("costaccount", "=", (Object)costaccount.getLong("id")));
        finalFilter.and(new QFilter("period", "=", (Object)period.getLong("id")));
        finalFilter.and(new QFilter("material", "=", (Object)material.getLong("id")));
        DynamicObject prdorg = data.getDynamicObject("prdorg");
        DynamicObject storageorgunit = data.getDynamicObject("storageorgunit");
        if ("B".equals(costParam.getString("restoredimension"))) {
            if (prdorg == null && storageorgunit == null) {
                msgMap.put("validateMsg", ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\u548c\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"HalfPrdStructureSaveOp_4", (String)"macc-sca-opplugin", (Object[])new Object[0]));
                return true;
            }
            if (prdorg == null) {
                String restoreCalcRange = costParam.getString("restoreCalcRange");
                if (!restoreCalcRange.contains(SysParamEnum.RESTORECALCRANGE_PURINBILL.getValue()) && !restoreCalcRange.contains(SysParamEnum.RESTORECALCRANGE_TRANSDIRBILL.getValue())) {
                    msgMap.put("validateMsg", ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\u4e3a\u7a7a", (String)"HalfPrdStructureSaveOp_5", (String)"macc-sca-opplugin", (Object[])new Object[0]));
                    return true;
                }
                Long storageorgunitId = storageorgunit.getLong("id");
                List stOrgList = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)storageorgunitId, (boolean)true);
                if (CadEmptyUtils.isEmpty((List)stOrgList) || !stOrgList.contains(storageorgunitId)) {
                    msgMap.put("validateMsg", ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\u3002\u5e93\u5b58\u7ec4\u7ec7\u4e0e\u6838\u7b97\u7ec4\u7ec7\u6ca1\u6709\u59d4\u6258\u6838\u7b97\u5173\u7cfb", (String)"HalfPrdStructureSaveOp_13", (String)"macc-sca-opplugin", (Object[])new Object[0]));
                    return true;
                }
                HashSet prdStorgs = new HashSet();
                List productOrgs = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"04", (Long)org.getLong("id"), (boolean)true);
                for (Long porg : productOrgs) {
                    prdStorgs.addAll(OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)porg, (boolean)true));
                }
                if (prdStorgs.contains(storageorgunitId)) {
                    msgMap.put("validateMsg", ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\u3002\u751f\u4ea7\u7ec4\u7ec7\u4e3a\u7a7a\u65f6\uff0c\u5e93\u5b58\u7ec4\u7ec7\u53ea\u80fd\u662f\u4e0e\u751f\u4ea7\u7ec4\u7ec7\u6ca1\u6709\u534f\u4f5c\u5173\u7cfb\u4e14\u672c\u8eab\u6ca1\u6709\u751f\u4ea7\u7ec4\u7ec7\u804c\u80fd\u7ec4\u7ec7", (String)"HalfPrdStructureSaveOp_14", (String)"macc-sca-opplugin", (Object[])new Object[0]));
                    return true;
                }
            } else {
                List prdOrgList = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"04", (Long)org.getLong("id"), (boolean)true);
                if (CadEmptyUtils.isEmpty((List)prdOrgList) || !prdOrgList.contains(prdorg.getLong("id"))) {
                    msgMap.put("validateMsg", ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\u3002\u751f\u4ea7\u7ec4\u7ec7\u4e0e\u6838\u7b97\u7ec4\u7ec7\u6ca1\u6709\u59d4\u6258\u6838\u7b97\u5173\u7cfb", (String)"HalfPrdStructureSaveOp_15", (String)"macc-sca-opplugin", (Object[])new Object[0]));
                    return true;
                }
            }
        }
        String number = material.getString("number");
        boolean isenablematerialversion = material.getBoolean("isenablematerialversion");
        if (isenablematerialversion && (matVersion = data.getDynamicObject("materialversion")) != null) {
            finalFilter.and(new QFilter("materialversion", "=", (Object)matVersion.getLong("id")));
        }
        if (BomRouterHelper.isEnableAuxprop((DynamicObject)material)) {
            DynamicObject auxprop = data.getDynamicObject("auxprop");
            if (auxprop == null) {
                msgMap.put("validateMsg", String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u4ea7\u54c1\u201c%s\u201d\u542f\u7528\u4e86\u5f71\u54cd\u4ef7\u683c\u7684\u8f85\u52a9\u5c5e\u6027\uff0c\u8bf7\u5f55\u5165\u3002", (String)"HalfPrdStructureSaveOp_10", (String)"macc-sca-opplugin", (Object[])new Object[0]), number));
                return true;
            }
            finalFilter.and(new QFilter("auxprop", "=", (Object)auxprop.getLong("id")));
        }
        if (!checkRepeat) {
            return false;
        }
        if (prdorg == null) {
            boolean exists;
            if (storageorgunit != null) {
                finalFilter.and(new QFilter("storageorgunit", "=", (Object)storageorgunit.getLong("id")));
            }
            if (exists = QueryServiceHelper.exists((String)"sca_halfprdstructure", (QFilter[])finalFilter.toArray())) {
                msgMap.put("validateMsg", ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u4e0d\u7b26\u5408\u4ea7\u54c1\u552f\u4e00\u6027\u5224\u65ad\u3002", (String)"HalfPrdStructureSaveOp_11", (String)"macc-sca-opplugin", (Object[])new Object[0]));
                return true;
            }
        } else {
            finalFilter.and(new QFilter("prdorg", "=", (Object)prdorg.getLong("id")));
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"sca_halfprdstructure", (String)"storageorgunit", (QFilter[])finalFilter.toArray());
            boolean exists = false;
            if (collection.size() != 0) {
                if (storageorgunit != null) {
                    for (DynamicObject dyn : collection) {
                        Long curStorageorgunit = dyn.getLong("storageorgunit");
                        if (!CadEmptyUtils.isEmpty((Long)curStorageorgunit) && curStorageorgunit.longValue() != storageorgunit.getLong("id")) continue;
                        exists = true;
                    }
                } else {
                    exists = true;
                }
            }
            if (exists) {
                msgMap.put("validateMsg", ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u4e0d\u7b26\u5408\u4ea7\u54c1\u552f\u4e00\u6027\u5224\u65ad\u3002", (String)"HalfPrdStructureSaveOp_11", (String)"macc-sca-opplugin", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    class InnerValidate
    extends AbstractValidator {
        InnerValidate() {
        }

        public void validate() {
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            HashMap<Long, DynamicObject> costaccountParamMap = new HashMap<Long, DynamicObject>(10);
            for (ExtendedDataEntity ede : dataEntities) {
                DynamicObject data = ede.getDataEntity();
                boolean isimport = data.getBoolean("isimport");
                HashMap msgMap = new HashMap(1);
                Long orgId = data.getLong("org.id");
                Long costaccountId = data.getLong("costaccount.id");
                DynamicObject costParam = null;
                if (costaccountParamMap.containsKey(costaccountId)) {
                    costParam = (DynamicObject)costaccountParamMap.get(costaccountId);
                } else {
                    costParam = CostReductHelper.getCostParam((Long)orgId, (Long)costaccountId, null);
                    costaccountParamMap.put(costaccountId, costParam);
                }
                if (costParam == null) {
                    this.addErrorMessage(ede, ResManager.loadKDString((String)"\u5f53\u524d\u6210\u672c\u8d26\u7c3f\u6ca1\u6709\u7ef4\u62a4\u5b9e\u9645\u6210\u672c\u8fd8\u539f\u8ba1\u7b97\u7ef4\u5ea6\uff0c\u8bf7\u5148\u5728\u201c\u6210\u672c\u53c2\u6570>\u6210\u672c\u6838\u7b97\u53c2\u6570\u201d\u8fdb\u884c\u7ef4\u62a4.", (String)"HalfPrdStructureSaveOp_3", (String)"macc-sca-opplugin", (Object[])new Object[0]));
                    continue;
                }
                if (HalfPrdStructureSaveOp.this.validateDataOnlyOne(data, msgMap, costParam, false)) {
                    this.addErrorMessage(ede, (String)msgMap.get("validateMsg"));
                    continue;
                }
                if (!isimport) continue;
                if (HalfPrdStructureSaveOp.this.validateSubMaterialInfo(data, msgMap)) {
                    this.addErrorMessage(ede, (String)msgMap.get("validateMsg"));
                    continue;
                }
                if (!HalfPrdStructureSaveOp.this.validateBillNo(data)) continue;
                this.addErrorMessage(ede, ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u5df2\u5b58\u5728\u3002", (String)"HalfPrdStructureSaveOp_12", (String)"macc-sca-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

