/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CostReductionItemQueryPlugin
extends AbstractReportListDataPlugin {
    private boolean onlysumrow = false;
    private boolean onlymaterialtype = false;
    private boolean topsumrow = false;

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        this.initBooleanValue();
        DataSet dataSet = this.queryDataSet();
        return dataSet;
    }

    private DataSet excludeZeroRows(DataSet nomralJoin) {
        StringBuilder sb = new StringBuilder();
        sb.append("!(");
        sb.append("curqty==0 and curamt==0 and sumqty==0 and sumprice==0 ");
        if (this.getQueryParam().getFilter().getBoolean("viewtransincost")) {
            sb.append("and transinqty==0 and transinamt==0 ");
        }
        if (this.getQueryParam().getFilter().getBoolean("viewpurcost")) {
            sb.append("and purqty==0 and puramt==0 ");
        }
        sb.append(")");
        return nomralJoin.filter(sb.toString());
    }

    private void initBooleanValue() {
        ReportQueryParam queyParam = this.getQueryParam();
        FilterInfo filter = queyParam.getFilter();
        this.onlysumrow = filter.getBoolean("onlysumrow");
        this.onlymaterialtype = filter.getBoolean("onlymaterialtype");
        this.topsumrow = filter.getBoolean("topsumrow");
    }

    private DataSet queryDataSet() {
        List<QFilter> filters = this.getRptQFilter();
        DynamicObjectCollection mulperiod = this.getQueryParam().getFilter().getDynamicObjectCollection("mulperiod");
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)mulperiod)) {
            Set collect = mulperiod.stream().map(a -> (Long)a.getPkValue()).collect(Collectors.toSet());
            filters.add(new QFilter("period", "in", collect));
        }
        DataSet dsByPeriodAndPrd = this.dealDsByGroupByPeriodAndPrd(filters);
        dsByPeriodAndPrd = this.excludeZeroRows(dsByPeriodAndPrd);
        filters.add(new QFilter("entryentity.level", ">", (Object)0));
        DataSet normalDataRow = this.getNormalDataRow(filters, dsByPeriodAndPrd);
        normalDataRow = this.excludeZeroRows(normalDataRow);
        DataSet dsByPeriod = this.dealDsByGroupByPeriodFromPrd(dsByPeriodAndPrd);
        DataSet sumAllDs = this.dealDsBySumAllFromLitSum(dsByPeriod);
        DataSet halfUnion = dsByPeriodAndPrd.union(normalDataRow).union(dsByPeriod).orderBy(this.getOrderbyField().split(",", -1));
        DataSet result = null;
        if (this.onlymaterialtype) {
            DataSet matGroupDs = this.doAsMaterialGroup(normalDataRow, dsByPeriodAndPrd);
            DataSet matHalfDs = dsByPeriodAndPrd.union(matGroupDs).union(dsByPeriod).orderBy(this.getOrderbyField().split(",", -1));
            result = this.topsumrow ? sumAllDs.union(matHalfDs) : matHalfDs.union(sumAllDs);
            if (this.onlysumrow) {
                result = sumAllDs;
            }
        } else {
            result = this.topsumrow ? sumAllDs.union(halfUnion) : halfUnion.union(sumAllDs);
            if (this.onlysumrow) {
                result = sumAllDs;
            }
        }
        return result;
    }

    private DataSet dealDsByGroupByPeriodAndPrd(List<QFilter> filters) {
        DataSet srcDs = QueryServiceHelper.queryDataSet((String)"CostReductionItemQueryPlugin.getNormalDataRow", (String)"sca_costrecovry", (String)this.getPrdClassString(), (QFilter[])filters.toArray(new QFilter[0]), null).orderBy(new String[]{"prdname"}).addNullField(new String[]{"elementcode", "subelementcode", "entrymaterialtypecode", "materialname"});
        DataSet dataSet = srcDs.groupBy(this.getPrdGroupByString().split(",", -1)).finish();
        DataSet perLineDs = dataSet.select(this.getPrdGroupByString()).groupBy(this.getPrdGroupByStringSum().split(",", -1)).sum("curqty").sum("curamt").sum("transinqty").sum("transinamt").sum("purqty").sum("puramt").finish().select("entryperiod,l_entryperiod,periodname, periodyear,periodnumber,baseunit, entrycurrency, productnum, materialver, auxprop,elementcode, element,subelementcode, subelement, entrymaterialtypecode,entrymaterialtype, material,materialname, submaterialver, submaterialauxprop,materialbaseunit,1 as perqty, curqty, case when curqty=0 then 0 else curamt/curqty end as curprice, case when curqty=0 then 0 else curamt/curqty end as curunitamt, curamt,case when transinamt =0 and transinqty=0 then 0 else 1 end transinperqty,transinqty,case when transinqty = 0 then 0 else transinamt/transinqty end transinprice,case when transinqty = 0 then 0 else transinamt/transinqty end transinunitamt,transinamt,case when puramt =0 and purqty=0 then 0 else 1 end purperqty,purqty,case when purqty = 0 then 0 else puramt/purqty end purprice,case when purqty = 0 then 0 else puramt/purqty end purunitamt,puramt");
        DataSet normal = this.getPrdClassNormalSumRow();
        DataSet nomralJoin = perLineDs.join(normal, JoinType.LEFT).on("periodyear", "periodyear").on("periodnumber", "periodnumber").on("productnum", "productnum").on("materialver", "materialver").on("auxprop", "auxprop").on("material", "material").on("submaterialver", "submaterialver").on("element", "element").on("subelement", "subelement").select(perLineDs.getRowMeta().getFieldNames(), new String[]{"sumqty", "sumamt", "sumunitamt", "sumperqty", "sumprice"}).finish();
        DataSet finalOtherDs = null;
        if (normal != null) {
            DataSet SumPartDs = normal.join(perLineDs, JoinType.LEFT).on("periodyear", "periodyear").on("periodnumber", "periodnumber").on("productnum", "productnum").on("materialver", "materialver").on("auxprop", "auxprop").on("material", "material").on("submaterialver", "submaterialver").on("element", "element").on("subelement", "subelement").select(normal.getRowMeta().getFieldNames(), new String[]{"l_entryperiod", "curqty", "curamt", "curunitamt", "perqty", "curprice", "transinqty", "transinamt", "transinunitamt", "transinperqty", "transinprice", "purqty", "puramt", "purunitamt", "purperqty", "purprice"}).finish().filter("l_entryperiod is null").filter("contains(periodname,cast(periodyear as String))");
            DataSet otherDs = SumPartDs.addNullField(new String[]{"elementcode", "subelementcode", "entrymaterialtypecode", "materialname"}).select(this.getRptPageBaseLineCurString() + ", sumqty, sumamt, sumunitamt, sumperqty, sumprice").filter(" !(sumqty==0 and sumamt==0 and sumunitamt==0  and sumprice==0)");
            if (perLineDs.copy().isEmpty()) {
                return normal.copy().addNullField(new String[]{"l_entryperiod", "curqty", "curamt", "curunitamt", "perqty", "curprice", "transinqty", "transinamt", "transinunitamt", "transinperqty", "transinprice", "purqty", "puramt", "purunitamt", "purperqty", "purprice"}).select(this.getRptPageBaseLineString());
            }
            DataSet entryperiodDs = perLineDs.copy().groupBy(new String[]{"periodyear"}).max("periodyear").finish().select("periodyear");
            String periodyear = "";
            while (entryperiodDs.hasNext()) {
                periodyear = entryperiodDs.next().getString("periodyear");
            }
            DataSet periodNoDs = perLineDs.copy().filter("periodyear =" + periodyear).groupBy(new String[]{"periodyear"}).min("periodnumber").finish().select("periodnumber");
            Integer periodNo = 0;
            while (periodNoDs.hasNext()) {
                periodNo = periodNoDs.next().getInteger("periodnumber");
            }
            finalOtherDs = otherDs.filter("periodnumber >= " + periodNo);
        }
        return nomralJoin.union(finalOtherDs).orderBy(new String[]{"periodname", "productnum"});
    }

    private DataSet getPrdClassNormalSumRow() {
        List<QFilter> filters = this.getRptQFilter();
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        DynamicObjectCollection mulperiod = filterInfo.getDynamicObjectCollection("mulperiod");
        DataSet mulSumDs = null;
        for (int i = 0; i < mulperiod.size(); ++i) {
            ArrayList<QFilter> queryFilters = new ArrayList<QFilter>(filters);
            DynamicObject periodDyn = (DynamicObject)mulperiod.get(i);
            QFilter periodFilter = this.getPeriodFilter(periodDyn);
            queryFilters.add(periodFilter);
            DataSet srcDs = QueryServiceHelper.queryDataSet((String)"CostReductionItemQueryPlugin.getPrdClassNormalSumRow", (String)"sca_costrecovry", (String)this.getPrdClassString(), (QFilter[])queryFilters.toArray(new QFilter[0]), null).addNullField(new String[]{"elementcode", "subelementcode", "entrymaterialtypecode", "materialname"});
            DataSet dataSet = srcDs.orderBy(new String[]{"prdname"}).groupBy(this.getPrdGroupByString().split(",", -1)).finish().select(this.getPrdGroupByString()).filter("!(curqty==0 and curprice==0 and curunitamt==0 and curamt==0)");
            int periodnumber = periodDyn.getInt("periodnumber");
            String periodName = periodDyn.getString("name");
            long id = periodDyn.getLong("id");
            DataSet oneGroupDs = dataSet.groupBy(new String[]{"productnum", "baseunit", "materialver", "periodyear", "material", "materialname", "submaterialver", "submaterialauxprop", "auxprop", "materialbaseunit", "elementcode", "element", "subelementcode", "subelement", "entrycurrency", "entrymaterialtypecode", "entrymaterialtype"}).sum("curqty", "sumqty").sum("curamt", "sumamt").finish().select(id + " as entryperiod,'" + periodName + "' as periodname,periodyear," + periodnumber + " as periodnumber,entrycurrency,productnum,baseunit,materialver,auxprop,elementcode,element,subelementcode,subelement,entrymaterialtypecode,entrymaterialtype,material,materialname,submaterialver,submaterialauxprop,materialbaseunit, 1 as sumperqty,sumqty,case when sumqty = 0 then 0 else sumamt/sumqty end sumprice,case when sumqty = 0 then 0 else sumamt/sumqty end sumunitamt,sumamt");
            mulSumDs = mulSumDs == null ? oneGroupDs : mulSumDs.union(oneGroupDs);
        }
        return mulSumDs;
    }

    private DataSet dealDsBySumAllFromLitSum(DataSet dataSet) {
        String year;
        String maxPeriod;
        String strSum = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"CostReductionItemQueryPlugin_8", (String)"macc-sca-report", (Object[])new Object[0]);
        DataSet ds = dataSet.groupBy(this.getSumAllField().split(",", -1)).sum("curqty").sum("curamt").sum("transinqty").sum("transinamt").sum("purqty").sum("puramt").finish().select(this.getSumAllField() + ",'" + strSum + "' as periodname,curqty,curamt,transinqty,transinamt,purqty,puramt").addNullField(new String[]{"entryperiod", "periodyear", "productnum", "materialver", "auxprop", "element", "subelement", "entrymaterialtype", "material", "submaterialver", "submaterialauxprop", "l_entryperiod", "periodnumber", "baseunit", "materialbaseunit"}).addNullField(new String[]{"perqty", "curprice", "curunitamt", "sumperqty", "sumprice", "sumunitamt", "transinperqty", "transinprice", "transinunitamt", "purperqty", "purprice", "purunitamt"}).select("entryperiod,l_entryperiod,periodname, periodyear,periodnumber,baseunit, entrycurrency,  productnum,materialver, auxprop, element, subelement, entrymaterialtype, material, submaterialver, submaterialauxprop,materialbaseunit, perqty, curqty, curprice, curunitamt, curamt,transinperqty,transinqty,transinprice,transinunitamt,transinamt,purperqty,purqty,purprice,purunitamt,puramt, sumunitamt, sumperqty, sumprice");
        Iterator iterator = dataSet.copy().iterator();
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        HashSet<String> yearSet = new HashSet<String>();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            String periodyear = row.getString("periodyear");
            String periodnumber = row.getString("periodnumber");
            treeSet.add(Integer.valueOf(periodyear + periodnumber));
            yearSet.add(periodyear);
        }
        if (treeSet.size() == 0) {
            return dataSet.filter("1 >2");
        }
        DataSet filterDs = null;
        if (yearSet.size() == 1) {
            maxPeriod = String.valueOf(treeSet.last());
            year = maxPeriod.substring(0, 4);
            String periodnumber = maxPeriod.substring(4);
            filterDs = dataSet.filter("periodyear =" + year + " and periodnumber=" + periodnumber).select("'" + strSum + "' as periodname,sumqty,sumamt");
        } else {
            String subperiodnumber;
            maxPeriod = String.valueOf(treeSet.last());
            year = maxPeriod.substring(0, 4);
            String periodnumber = maxPeriod.substring(4);
            iterator = dataSet.copy().iterator();
            TreeSet<Integer> subtreeSet = new TreeSet<Integer>();
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                String subperiodyear = row.getString("periodyear");
                subperiodnumber = row.getString("periodnumber");
                if (subperiodyear.equals(year)) continue;
                subtreeSet.add(Integer.valueOf(subperiodyear + subperiodnumber));
            }
            String submaxPeriod = String.valueOf(subtreeSet.last());
            String subyear = submaxPeriod.substring(0, 4);
            subperiodnumber = submaxPeriod.substring(4);
            filterDs = dataSet.filter("(periodyear =" + year + " and periodnumber=" + periodnumber + ") or (periodyear =" + subyear + " and periodnumber=" + subperiodnumber + ")").groupBy(null).sum("sumqty").sum("sumamt").finish().select("'" + strSum + "' as periodname,sumqty,sumamt");
        }
        return ds.join(filterDs, JoinType.INNER).on("periodname", "periodname").select(ds.getRowMeta().getFieldNames(), new String[]{"sumqty", "sumamt"}).finish().addNullField(new String[]{"elementcode", "subelementcode", "entrymaterialtypecode", "materialname"}).select(this.getRptPageBaseLineString());
    }

    private String getSumAllField() {
        return "entrycurrency";
    }

    private DataSet dealDsByGroupByPeriodFromPrd(DataSet dataSet) {
        String strSum = ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"CostReductionItemQueryPlugin_9", (String)"macc-sca-report", (Object[])new Object[0]);
        String groupByField = this.getGroupByPeriodFieldnew();
        String[] split = groupByField.split(",", -1);
        DataSet ds = dataSet.groupBy(split).sum("curqty").sum("curamt").sum("transinqty").sum("transinamt").sum("purqty").sum("puramt").sum("sumqty").sum("sumamt").finish().select(this.getGroupByPeriodFieldnew() + ",'" + strSum + "' as periodname,curqty,curamt,sumqty,sumamt,transinqty,transinamt,purqty,puramt");
        DataSet resDs = ds.addNullField(new String[]{"productnum", "materialver", "auxprop", "element", "subelement", "entrymaterialtype", "material", "submaterialver", "submaterialauxprop", "l_entryperiod", "baseunit", "materialbaseunit"}).addNullField(new String[]{"perqty", "curprice", "sumperqty", "curunitamt", "sumunitamt", "sumprice", "transinperqty", "transinprice", "transinunitamt", "purperqty", "purprice", "purunitamt"}).addNullField(new String[]{"elementcode", "subelementcode", "entrymaterialtypecode", "materialname"});
        return resDs.select(this.getRptPageBaseLineString());
    }

    private String getGroupByPeriodFieldnew() {
        String str = "entryperiod,entrycurrency,periodyear,periodnumber";
        return str;
    }

    private String getOrderbyField() {
        return "entryperiod,periodname,productnum";
    }

    private DataSet doAsMaterialGroup(DataSet dataSet, DataSet prdDs) {
        String groupByField = this.getGroupByField();
        String[] split = groupByField.split(",", -1);
        DataSet ds = dataSet.groupBy(split).sum("curqty").sum("curamt").sum("transinqty").sum("transinamt").sum("purqty").sum("puramt").sum("sumqty").sum("sumamt").finish().select(this.getGroupByField() + ",curqty,curamt,case when curqty=0 then 0 else curamt/curqty end as curprice, transinqty,transinamt,case when transinqty=0 then 0 else transinamt/transinqty end as transinprice, purqty,puramt,case when purqty=0 then 0 else puramt/purqty end as purprice, sumqty,sumamt,case when sumqty=0 then 0 else sumamt/sumqty end as sumprice");
        DataSet midDs = ds.join(prdDs).on("periodname", "periodname").on("productnum", "productnum").on("materialver", "materialver").on("auxprop", "auxprop").select(ds.getRowMeta().getFieldNames(), new String[]{"curqty as prdcurqty", "curamt as prdcuramt", "transinqty as prdtransinqty", "transinamt as prdtransinamt", "purqty as prdpurqty", "puramt as prdpuramt", "sumqty as prdsumqty", "sumamt as prdsumamt"}).finish().addNullField(new String[]{"material", "submaterialver", "submaterialauxprop", "l_entryperiod", "periodnumber", "baseunit", "materialbaseunit", "materialname"}).select(this.getPrdGroupByStringSum() + ",curqty,curprice,curamt,sumqty,sumprice,sumamt,case when prdcurqty=0 then 0 else curqty/prdcurqty end as perqty,transinqty,transinamt,transinprice,case when prdtransinqty=0 then 0 else transinqty/prdtransinqty end as transinperqty, case when prdtransinqty=0 then 0 else transinamt/prdtransinqty end as transinunitamt,purqty,puramt,purprice,case when prdpurqty=0 then 0 else purqty/prdpurqty end as purperqty, case when prdpurqty=0 then 0 else puramt/prdpurqty end as purunitamt,case when prdsumqty=0 then 0 else sumqty/prdsumqty end as sumperqty, case when prdcurqty=0 then 0 else curamt/prdcurqty end as curunitamt,case when prdsumqty=0 then 0 else sumamt/prdsumqty end as sumunitamt");
        return midDs.select(this.getRptPageBaseLineString()).orderBy(new String[]{"entryperiod", "elementcode", "subelementcode", "entrymaterialtypecode"});
    }

    private List<QFilter> getRptQFilter() {
        DynamicObject currency;
        DynamicObject materialgrpstd;
        DynamicObjectCollection mulmaterialtype;
        DynamicObjectCollection mulmaterial;
        DynamicObjectCollection mulproduct;
        DynamicObjectCollection storageorgunitCol;
        DynamicObjectCollection prodorgCol;
        DynamicObjectCollection costaccountCol;
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        DynamicObjectCollection orgCol = filterInfo.getDynamicObjectCollection("org");
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)orgCol)) {
            Set orgSet = orgCol.stream().map(r -> r.getLong("id")).collect(Collectors.toSet());
            list.add(new QFilter("org", "in", orgSet));
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(costaccountCol = filterInfo.getDynamicObjectCollection("costaccount")))) {
            Set costaccountSet = costaccountCol.stream().map(r -> r.getLong("id")).collect(Collectors.toSet());
            list.add(new QFilter("costaccount", "in", costaccountSet));
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(prodorgCol = filterInfo.getDynamicObjectCollection("prdorg")))) {
            Set prodorgSet = prodorgCol.stream().map(r -> r.getLong("id")).collect(Collectors.toSet());
            list.add(new QFilter("manuorg", "in", prodorgSet));
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(storageorgunitCol = filterInfo.getDynamicObjectCollection("storageorgunit")))) {
            Set storgSet = storageorgunitCol.stream().map(r -> r.getLong("id")).collect(Collectors.toSet());
            list.add(new QFilter("storageorgunit", "in", storgSet));
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(mulproduct = filterInfo.getDynamicObjectCollection("mulproduct")))) {
            Set collect = mulproduct.stream().map(a -> (Long)a.getPkValue()).collect(Collectors.toSet());
            list.add(new QFilter("material", "in", collect));
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(mulmaterial = filterInfo.getDynamicObjectCollection("mulmaterial")))) {
            Set collect = mulmaterial.stream().map(a -> (Long)a.getPkValue()).collect(Collectors.toSet());
            list.add(new QFilter("entryentity.submaterial", "in", collect));
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(mulmaterialtype = filterInfo.getDynamicObjectCollection("mulmaterialtype")))) {
            Set collect = mulmaterialtype.stream().map(a -> (Long)a.getPkValue()).collect(Collectors.toSet());
            list.add(new QFilter("entryentity.submaterial.group", "in", collect));
        }
        if ((materialgrpstd = filterInfo.getDynamicObject("materialgrpstd")) != null) {
            list.add(new QFilter("entryentity.submaterial.group.standard", "=", materialgrpstd.getPkValue()));
        }
        if ((currency = filterInfo.getDynamicObject("currency")) != null) {
            list.add(new QFilter("currency", "=", (Object)currency.getLong("id")));
        }
        list.add(new QFilter("entryentity.isleaf", "=", (Object)Boolean.TRUE));
        return list;
    }

    private DataSet getNormalDataRow(List<QFilter> filters, DataSet prdDs) {
        DataSet srcDs = QueryServiceHelper.queryDataSet((String)"CostReductionItemQueryPlugin.getNormalDataRow", (String)"sca_costrecovry", (String)this.getNormRowString(), (QFilter[])filters.toArray(new QFilter[0]), null);
        DataSet DsAfterGroupBy = srcDs.groupBy(this.getRptPageBaseGroupString().split(",", -1)).sum("curqty").sum("curamt").sum("transinqty").sum("transinamt").sum("purqty").sum("puramt").finish().select(this.getRptPageBaseGroupString() + ",entryperiod as l_entryperiod,curqty,curamt,transinqty,transinamt,purqty,puramt").orderBy(new String[]{"elementcode", "subelementcode", "entrymaterialtypecode", "materialname"});
        DataSet midDs = DsAfterGroupBy.join(prdDs).on("entryperiod", "entryperiod").on("productnum", "productnum").on("materialver", "materialver").on("auxprop", "auxprop").select(DsAfterGroupBy.getRowMeta().getFieldNames(), new String[]{"curqty as prdqty", "curamt as prdamt", "transinqty as prdtransinqty", "purqty as prdpurqty"}).finish().select(this.getPrdGroupByStringSum() + ",curqty,curamt,case when prdqty = 0 then 0 else curqty/prdqty end perqty,case when curqty = 0 then 0 else curamt/curqty end curprice,case when prdqty = 0 then 0 else curamt/prdqty end curunitamt,case when prdtransinqty=0 then 0 else transinqty/prdtransinqty end transinperqty,transinqty,case when transinqty = 0 then 0 else transinamt/transinqty end transinprice,case when prdtransinqty = 0 then 0 else transinamt/prdtransinqty end transinunitamt,transinamt,case when prdpurqty=0 then 0 else purqty/prdpurqty end purperqty,purqty,case when purqty = 0 then 0 else puramt/purqty end purprice,case when prdpurqty = 0 then 0 else puramt/prdpurqty end purunitamt,puramt");
        DataSet perLineDs = midDs.select(this.getRptPageBaseLineCurString()).filter("!(curqty==0 and curprice==0 and curunitamt==0 and curamt==0 and transinqty==0 and transinamt==0 and purqty==0 and puramt==0)");
        DataSet normal = this.getNormalSumRow(prdDs);
        if (normal == null) {
            return perLineDs.addNullField(new String[]{"sumqty", "sumamt", "sumunitamt", "sumperqty", "sumprice"}).orderBy(new String[]{"periodname"});
        }
        DataSet nomralJoin = perLineDs.join(normal, JoinType.LEFT).on("periodyear", "periodyear").on("periodnumber", "periodnumber").on("productnum", "productnum").on("materialver", "materialver").on("auxprop", "auxprop").on("material", "material").on("submaterialver", "submaterialver").on("element", "element").on("subelement", "subelement").select(perLineDs.getRowMeta().getFieldNames(), new String[]{"sumqty", "sumamt", "sumunitamt", "sumperqty", "sumprice"}).finish();
        DataSet SumPartDs = normal.join(perLineDs, JoinType.LEFT).on("periodyear", "periodyear").on("periodnumber", "periodnumber").on("productnum", "productnum").on("materialver", "materialver").on("auxprop", "auxprop").on("material", "material").on("submaterialver", "submaterialver").on("element", "element").on("subelement", "subelement").select(normal.getRowMeta().getFieldNames(), new String[]{"l_entryperiod", "curqty", "curamt", "curunitamt", "perqty", "curprice", "transinqty", "transinamt", "transinunitamt", "transinperqty", "transinprice", "purqty", "puramt", "purunitamt", "purperqty", "purprice"}).finish().filter("l_entryperiod is null");
        DataSet otherDs = SumPartDs.select(this.getRptPageBaseLineCurString() + ", sumqty, sumamt, sumunitamt, sumperqty, sumprice").filter(" !(sumqty==0 and sumamt==0 and sumunitamt==0  and sumprice==0)");
        return nomralJoin.union(otherDs).orderBy(new String[]{"periodname", "elementcode", "subelementcode", "entrymaterialtypecode", "materialname"});
    }

    private String getRptPageBaseGroupString() {
        String str = "entryperiod,periodname, periodyear,periodnumber,baseunit, entrycurrency, productnum, materialver, auxprop,elementcode, element, subelementcode,subelement,entrymaterialtypecode, entrymaterialtype, material,materialname, submaterialver, submaterialauxprop,materialbaseunit";
        return str;
    }

    private String getRptPageBaseLineCurString() {
        String str = "entryperiod,l_entryperiod,periodname, periodyear,periodnumber,baseunit, entrycurrency, productnum, materialver, auxprop,elementcode, element,subelementcode, subelement, entrymaterialtypecode,entrymaterialtype, material,materialname, submaterialver, submaterialauxprop,materialbaseunit, perqty, curqty, curprice, curunitamt, curamt,transinperqty,transinqty,transinprice,transinunitamt,transinamt,purperqty,purqty,purprice,purunitamt,puramt";
        return str;
    }

    private String getRptPageBaseLineString() {
        String str = "entryperiod,l_entryperiod,periodname, periodyear,periodnumber,baseunit, entrycurrency,  productnum,materialver, auxprop, elementcode,element,subelementcode, subelement,entrymaterialtypecode, entrymaterialtype, material,materialname, submaterialver, submaterialauxprop,materialbaseunit, perqty, curqty, curprice, curunitamt, curamt,transinperqty,transinqty,transinprice,transinunitamt,transinamt,purperqty,purqty,purprice,purunitamt,puramt, sumqty, sumamt, sumunitamt, sumperqty, sumprice";
        return str;
    }

    private String getPrdGroupByString() {
        String str = "org,manuorg,costaccount,entryperiod,l_entryperiod,periodname, periodyear,periodnumber,baseunit, entrycurrency, productnum, materialver, auxprop,elementcode, element,subelementcode, subelement, entrymaterialtypecode,entrymaterialtype, material,materialname, submaterialver, submaterialauxprop,materialbaseunit, perqty, curqty, curprice, curunitamt, curamt,transinperqty,transinqty,transinprice,transinunitamt,transinamt,purperqty,purqty,purprice,purunitamt,puramt";
        return str;
    }

    private String getPrdGroupByStringSum() {
        String str = "entryperiod,l_entryperiod,periodname, periodyear,periodnumber,baseunit, entrycurrency, productnum, materialver, auxprop,elementcode, element,subelementcode, subelement, entrymaterialtypecode,entrymaterialtype, material,materialname, submaterialver, submaterialauxprop,materialbaseunit";
        return str;
    }

    private DataSet getNormalSumRow(DataSet prdDs) {
        List<QFilter> filters = this.getRptQFilter();
        filters.add(new QFilter("entryentity.level", ">", (Object)0));
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        DynamicObjectCollection mulperiod = filterInfo.getDynamicObjectCollection("mulperiod");
        DataSet mulSumDs = null;
        for (int i = 0; i < mulperiod.size(); ++i) {
            ArrayList<QFilter> queryFilters = new ArrayList<QFilter>(filters);
            DynamicObject periodDyn = (DynamicObject)mulperiod.get(i);
            QFilter periodFilter = this.getPeriodFilter(periodDyn);
            queryFilters.add(periodFilter);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"CostReductionItemQueryPlugin.getNormalSumRow", (String)"sca_costrecovry", (String)this.getNormRowSumString(), (QFilter[])queryFilters.toArray(new QFilter[0]), null);
            int periodnumber = periodDyn.getInt("periodnumber");
            String periodName = periodDyn.getString("name");
            long id = periodDyn.getLong("id");
            DataSet oneGroupDs = dataSet.groupBy(new String[]{"productnum", "baseunit", "materialver", "periodyear", "material", "materialname", "submaterialver", "submaterialauxprop", "auxprop", "materialbaseunit", "elementcode", "element", "subelementcode", "subelement", "entrycurrency", "entrymaterialtypecode", "entrymaterialtype"}).sum("sumqty").sum("sumamt").finish().select(id + " as entryperiod,'" + periodName + "' as periodname,periodyear," + periodnumber + " as periodnumber,entrycurrency,productnum,baseunit,materialver,auxprop,elementcode,element,subelementcode,subelement,entrymaterialtypecode,entrymaterialtype,material,materialname,submaterialver,submaterialauxprop,materialbaseunit,sumqty,sumamt");
            DataSet midDs = oneGroupDs.join(prdDs).on("periodname", "periodname").on("productnum", "productnum").on("materialver", "materialver").on("auxprop", "auxprop").select(oneGroupDs.getRowMeta().getFieldNames(), new String[]{"sumqty as prdqty", "sumamt as prdamt"}).finish().select(this.getRptPageBaseGroupString() + ",sumqty,sumamt,case when prdqty = 0 then 0 else sumqty/prdqty end sumperqty,case when sumqty = 0 then 0 else sumamt/sumqty end sumprice,case when prdqty = 0 then 0 else sumamt/prdqty end sumunitamt").orderBy(new String[]{"elementcode", "subelementcode", "entrymaterialtypecode", "materialname"});
            mulSumDs = mulSumDs == null ? midDs : mulSumDs.union(midDs);
        }
        return mulSumDs;
    }

    private QFilter getPeriodFilter(DynamicObject periodDyn) {
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        DynamicObjectCollection costaccount = filterInfo.getDynamicObjectCollection("costaccount");
        DynamicObjectCollection org = filterInfo.getDynamicObjectCollection("org");
        QFilter period = StartCostHelper.getPeriodTypeFilter((String)filterInfo.getString("appnum"), (Long)Long.valueOf(String.valueOf(((DynamicObject)org.get(0)).getPkValue())), (Long)Long.valueOf(String.valueOf(((DynamicObject)costaccount.get(0)).getPkValue())));
        period.and(new QFilter("periodyear", "=", (Object)periodDyn.getInt("periodyear")));
        period.and(new QFilter("enddate", "<=", (Object)periodDyn.getDate("enddate")));
        DataSet periods = QueryServiceHelper.queryDataSet((String)"CostReductionItemQueryPlugin.getPeriodFilter", (String)"bd_period", (String)"number,id", (QFilter[])period.toArray(), null);
        HashSet<Long> set = new HashSet<Long>();
        while (periods.hasNext()) {
            set.add(periods.next().getLong("id"));
        }
        if (set.size() > 0) {
            return new QFilter("period", "in", set);
        }
        return null;
    }

    private String getNormRowString() {
        String selectField = "period as entryperiod,period.name as periodname,period.periodyear as periodyear,period.periodnumber as periodnumber,currency as entrycurrency,material as productnum,material.baseunit as baseunit,materialver as materialver,auxprop,entryentity.element.number as elementcode,entryentity.element.name as element,entryentity.subelement.number as subelementcode,entryentity.subelement.name as subelement,entryentity.submaterial.group as entrymaterialtype,entryentity.submaterial.group.number as entrymaterialtypecode,entryentity.submaterial as material,entryentity.submaterial.name as materialname,entryentity.submaterial.baseunit as materialbaseunit,entryentity.submaterialver as submaterialver ,entryentity.submaterialauxprop as submaterialauxprop ,entryentity.qty as curqty,entryentity.amount as curamt,entryentity.transinqty transinqty,entryentity.transinamount transinamt,entryentity.purqty purqty,entryentity.puramount puramt";
        return selectField;
    }

    private String getGroupByField() {
        String str = "entryperiod,periodname, periodyear, entrycurrency, productnum, materialver, auxprop,elementcode, element,subelementcode, subelement,entrymaterialtypecode, entrymaterialtype";
        return str;
    }

    private String getNormRowSumString() {
        String selectField = "period as entryperiod,period.periodnumber as periodnumber,period.periodyear as periodyear,currency as entrycurrency,material as productnum,material.baseunit as baseunit,materialver as materialver,auxprop,entryentity.element.number as elementcode,entryentity.element.name as element,entryentity.subelement.number as subelementcode,entryentity.subelement.name as subelement,entryentity.submaterial.group as entrymaterialtype,entryentity.submaterial.group.number as entrymaterialtypecode,entryentity.submaterial as material,entryentity.submaterial.name as materialname,entryentity.submaterial.baseunit as materialbaseunit,entryentity.submaterialver as submaterialver ,entryentity.submaterialauxprop as submaterialauxprop ,0 as sumperqty,entryentity.qty as sumqty,0 as sumprice,0 as sumunitamt,entryentity.amount as sumamt";
        return selectField;
    }

    private String getPrdClassString() {
        String mat = ResManager.loadKDString((String)"\u7269\u6599", (String)"CostReductionItemQueryPlugin_10", (String)"macc-sca-report", (Object[])new Object[0]);
        String pro = ResManager.loadKDString((String)"\u4ea7\u54c1\u7ea7", (String)"CostReductionItemQueryPlugin_11", (String)"macc-sca-report", (Object[])new Object[0]);
        String selectField = "org,manuorg,costaccount,period as entryperiod,period as l_entryperiod,period.name as periodname,period.periodyear as periodyear,period.periodnumber as periodnumber,currency as entrycurrency,material as productnum,material.name as prdname,material.baseunit as baseunit,materialver as materialver,auxprop,'" + mat + "' as element,'" + pro + "' as subelement,material.group as entrymaterialtype,material as material,material.baseunit as materialbaseunit,materialver as submaterialver ,auxprop as submaterialauxprop ,headqty as curqty,0 as perqty,0 as  curprice,0 as  curunitamt,headamount as curamt,headtransinqty as transinqty,0 as transinperqty,0 as  transinprice,0 as  transinunitamt,headtransinamt as transinamt,headpurqty as purqty,0 as purperqty,0 as  purprice,0 as  purunitamt,headpuramt as puramt";
        return selectField;
    }
}

