/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.InFilterHelper;
import kd.macc.cad.common.helper.MaterialGroupHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import org.apache.commons.lang.StringUtils;

public class CostReductionLevelQueryPlugin
extends AbstractReportListDataPlugin {
    private static List<String> QTYS = Collections.unmodifiableList(Arrays.asList("perqty", "curqty", "sumqty", "sumperqty", "transinqty", "transinperqty", "purqty", "purperqty"));
    private static List<String> AMTS = Collections.unmodifiableList(Arrays.asList("curprice", "curamt", "sumamt", "sumprice", "transinamt", "transinprice", "puramt", "purprice"));

    public DataSet query(ReportQueryParam param, Object o) throws Throwable {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        this.init(params);
        if (params.containsKey("notQuery")) {
            return Algo.create((String)"dataset").createDataSet(new ArrayList(10).iterator(), new RowMeta(new Field[]{new Field("entryperiod", (DataType)DataType.StringType)}));
        }
        DataSet dataSet = this.queryData(params);
        if (dataSet.isEmpty()) {
            return Algo.create((String)"dataset").createDataSet(new ArrayList(10).iterator(), dataSet.getRowMeta());
        }
        Boolean onlySumRow = (Boolean)params.get("onlysumrow");
        Boolean onlyMaterialType = (Boolean)params.get("onlymaterialtype");
        if (!onlyMaterialType.booleanValue()) {
            dataSet = this.dealMaterialGroup(dataSet);
            dataSet = onlySumRow != false ? dataSet.orderBy(new String[]{"istop asc", "productOrder", "productnum", "entryperiod"}) : (0 == this.getQueryParam().getFilter().getInt("displaylevel") ? dataSet.orderBy(new String[]{"istop asc", "entryperiod", "productOrder", "productnum", "materialver", "auxprop", "datatype desc"}) : dataSet.orderBy(new String[]{"istop asc", "entryperiod", "productOrder", "productnum", "materialver", "auxprop", "datatype desc", "treepath", "level"}));
        }
        DataSet copy = dataSet.copy();
        HashSet<Long> extMaterials = new HashSet<Long>(16);
        while (copy.hasNext()) {
            Row row = copy.next();
            extMaterials.add(row.getLong("material"));
        }
        QFilter idFilter = new QFilter("id", "in", extMaterials);
        DataSet materialDataSet = QueryServiceHelper.queryDataSet((String)"mm", (String)"bd_material", (String)"masterid as materialid,baseunit as unitid,baseunit.name as unit", (QFilter[])idFilter.toArray(), null);
        DataSet unitDataSet = QueryServiceHelper.queryDataSet((String)"mm", (String)"bd_measureunits", (String)"id as unitid,precision,precisionaccount", null, null);
        DataSet matUnitDataSet = materialDataSet.join(unitDataSet, JoinType.INNER).on("unitid", "unitid").select(new String[]{"materialid", "precision", "precisionaccount"}).finish();
        HashMap precisionMap = new HashMap(16);
        while (matUnitDataSet.hasNext()) {
            Row unitRow = matUnitDataSet.next();
            ArrayList<Integer> precisionList = new ArrayList<Integer>(3);
            precisionList.add(unitRow.getInteger("precision"));
            int precisonacct = 4;
            if ("2".equals(unitRow.getString("precisionaccount"))) {
                precisonacct = 1;
            }
            if ("3".equals(unitRow.getString("precisionaccount"))) {
                precisonacct = 0;
            }
            precisionList.add(precisonacct);
            precisionMap.put(unitRow.getLong("materialid"), precisionList);
        }
        ArrayList<Object[]> datasetlist = new ArrayList<Object[]>(10);
        RowMeta rowMeta = dataSet.getRowMeta();
        Field[] fields = rowMeta.getFields();
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Object[] rowData = new Object[fields.length];
            boolean isZero = true;
            for (int i = 0; i < fields.length; ++i) {
                BigDecimal amt;
                String name = fields[i].getName();
                Object val = row.get(name);
                if (QTYS.contains(name)) {
                    String element = row.getString("element");
                    BigDecimal qty = row.getBigDecimal(i);
                    if (qty == null || BigDecimal.ZERO.compareTo(qty) == 0) {
                        rowData[i] = BigDecimal.ZERO;
                        continue;
                    }
                    Long material = row.getLong("material");
                    if ((ResManager.loadKDString((String)"\u7269\u6599", (String)"CostReductionLevelQueryPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]).equals(element) || ResManager.loadKDString((String)"\u7269\u6599\u8d39\u7528", (String)"CostReductionLevelQueryPlugin_9", (String)"macc-sca-report", (Object[])new Object[0]).equals(element)) && precisionMap.get(material) != null) {
                        int precision = (Integer)((List)precisionMap.get(material)).get(0);
                        int precisionacct = (Integer)((List)precisionMap.get(material)).get(1);
                        rowData[i] = qty.setScale(precision, precisionacct);
                        if (BigDecimal.ZERO.compareTo((BigDecimal)rowData[i]) == 0) continue;
                        isZero = false;
                        continue;
                    }
                    rowData[i] = qty.setScale(10, 4);
                    if (BigDecimal.ZERO.compareTo((BigDecimal)rowData[i]) == 0) continue;
                    isZero = false;
                    continue;
                }
                if (AMTS.contains(name) && (amt = row.getBigDecimal(i)) != null && BigDecimal.ZERO.compareTo(amt) != 0) {
                    isZero = false;
                }
                rowData[i] = val;
            }
            if (isZero) continue;
            datasetlist.add(rowData);
        }
        String selectFields = "id,entryperiod,periodyear,productnum,materialver,auxprop,level,element,subelement,material,submaterialver,subauxprop,entrymaterialtype,entrycurrency,treepath,case when perqty=0 then '' else cast(perqty as String) end perqty,case when curqty=0 then '' else cast(curqty as String) end curqty,curprice,curunitamt,curamt,datatype,case when sumqty=0 then '' else cast(sumqty as String) end sumqty,case when sumperqty=0 then '' else cast(sumperqty as String) end sumperqty,sumamt,sumunitamt,sumprice,istop,case when transinqty=0 then '' else cast(transinqty as String) end transinqty,case when transinperqty=0 then '' else cast(transinperqty as String) end transinperqty,transinamt,transinunitamt,transinprice,case when purqty=0 then '' else cast(purqty as String) end purqty,case when purperqty=0 then '' else cast(purperqty as String) end purperqty,puramt,purunitamt,purprice";
        DataSet ds = Algo.create((String)"mm").createDataSet(datasetlist.iterator(), rowMeta).select(selectFields);
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        ArrayList orgList = new ArrayList();
        DynamicObjectCollection org = filterInfo.getDynamicObjectCollection("org");
        if (org != null) {
            orgList.addAll(org.stream().map(s -> (Long)s.getPkValue()).collect(Collectors.toSet()));
        }
        if (orgList.size() > 0) {
            ds.addField(orgList.get(0) + "", "settleorg");
        }
        return ds;
    }

    private DataSet dealMaterialGroup(DataSet resultDs) {
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        DynamicObject materialgrpstd = filterInfo.getDynamicObject("materialgrpstd");
        if (materialgrpstd != null && materialgrpstd.getLong("id") != 730148448254487552L) {
            DataSet materialDataSet = MaterialGroupHelper.getClassifiedMaterialDataSet(null, (boolean)false, (DynamicObject)materialgrpstd);
            ArrayList<String> fieldNames = new ArrayList<String>(Arrays.asList(resultDs.getRowMeta().getFieldNames()));
            fieldNames.remove("entrymaterialtype");
            fieldNames.add("case when materialgroupname is null then entrymaterialtype else materialgroupname end as entrymaterialtype");
            return resultDs.leftJoin(materialDataSet).on("material", "material").select(resultDs.getRowMeta().getFieldNames(), new String[]{"materialgroupname"}).finish().select(fieldNames.toArray(new String[0]));
        }
        return resultDs;
    }

    private DataSet queryData(Map<String, Object> params) {
        Boolean onlySumRow = (Boolean)params.get("onlysumrow");
        Boolean onlyMaterialType = (Boolean)params.get("onlymaterialtype");
        Boolean topSumRow = (Boolean)params.get("topsumrow");
        DynamicObjectCollection mulperiod = this.getQueryParam().getFilter().getDynamicObjectCollection("mulperiod");
        int displaylevel = this.getQueryParam().getFilter().getInt("displaylevel");
        Set collect = mulperiod.stream().map(a -> (Long)a.getPkValue()).collect(Collectors.toSet());
        List<QFilter> filters = this.getQFilter();
        filters.add(new QFilter("period", "in", collect));
        DataSet zeroLevel = this.getProductDataRow(filters);
        zeroLevel = zeroLevel.addField("0", "productOrder");
        if (displaylevel != 0) {
            filters.add(new QFilter("entryentity.level", "<=", (Object)displaylevel));
        }
        filters.add(new QFilter("entryentity.level", ">", (Object)0));
        DataSet nomralJoin = this.getNormalDataRow(filters);
        nomralJoin = nomralJoin.addField("0", "productOrder");
        DataSet subtotal = this.getSubTotalDataRow(zeroLevel);
        subtotal = subtotal.addField("1", "productOrder");
        DataSet total = this.getTotalDataRow(zeroLevel, topSumRow);
        total = total.addField("2", "productOrder");
        if (onlySumRow.booleanValue()) {
            return subtotal.union(total);
        }
        if (0 == this.getQueryParam().getFilter().getInt("displaylevel")) {
            return zeroLevel.union(subtotal).union(total);
        }
        if (onlyMaterialType.booleanValue()) {
            DataSet materialType = this.showWithMaterialTypeNew(nomralJoin);
            materialType = materialType.addField("0", "productOrder");
            zeroLevel = this.dealMaterialGroup(zeroLevel);
            DataSet dataSet = materialType.union(zeroLevel.select(materialType.getRowMeta().getFieldNames())).union(subtotal).union(total).select("id,entryperiod,periodyear,productnum,materialver,auxprop,level,element,subelement,0 material,0 submaterialver,0 subauxprop,entrymaterialtype,perqty,curqty,curprice,curunitamt,curamt,transinperqty,transinqty,transinprice,transinunitamt,transinamt,purperqty,purqty,purprice,purunitamt,puramt,entrycurrency,treepath,datatype,sumqty,sumamt,sumunitamt,sumperqty,sumprice,istop,productOrder").orderBy(new String[]{"istop asc", "entryperiod", "productOrder", "productnum", "materialver", "datatype desc", "treepath"});
            return dataSet;
        }
        return nomralJoin.union(zeroLevel).union(subtotal).union(total);
    }

    private DataSet getTotalDataRow(DataSet zeroLevel, Boolean topSumRow) {
        String istop = "2 as istop";
        if (topSumRow.booleanValue()) {
            istop = "-1 as istop";
        }
        String strSum = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"CostReductionLevelQueryPlugin_6", (String)"macc-sca-report", (Object[])new Object[0]);
        DataSet total = zeroLevel.copy().groupBy(new String[]{"periodyear", "productnum", "materialver", "auxprop", "entrycurrency"}).sum("curamt").sum("curqty").max("sumamt").max("sumqty").sum("transinqty").sum("transinamt").sum("purqty").sum("puramt").finish().select("periodyear,productnum,materialver,auxprop,entrycurrency,curamt,sumamt,curqty,sumqty,transinqty,transinamt,purqty,puramt");
        total = total.groupBy(new String[]{"entrycurrency"}).sum("curamt").sum("sumamt").sum("curqty").sum("sumqty").sum("transinqty").sum("transinamt").sum("purqty").sum("puramt").finish().select(new String[]{"0 as id", "0 as entryperiod", "0 as periodyear", "0 as productnum", "0 as materialver", "0 as auxprop", "'" + strSum + "' as level", "'' as element", "'' as subelement", "0 as material", "0 as submaterialver", "0 as subauxprop", "'' as entrymaterialtype", "0 as perqty", "curqty", "0 as curprice", "0 as curunitamt", "curamt", "0 as transinperqty", "transinqty", "0 as transinprice", "0 as transinunitamt", "transinamt", "0 as purperqty", "purqty", "0 as purprice", "0 as purunitamt", "puramt", "entrycurrency", "'' as treepath", "'-2' as datatype", "sumqty", "sumamt", "0 as sumunitamt", "0 as sumperqty", "0 as sumprice", istop});
        return total;
    }

    private DataSet getSubTotalDataRow(DataSet zeroLevel) {
        String strSum = ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"CostReductionLevelQueryPlugin_7", (String)"macc-sca-report", (Object[])new Object[0]);
        return zeroLevel.copy().groupBy(new String[]{"entryperiod", "periodyear", "entrycurrency"}).sum("curamt").sum("sumamt").sum("curqty").sum("sumqty").sum("transinqty").sum("transinamt").sum("purqty").sum("puramt").finish().select(new String[]{"0 as id", "entryperiod", "periodyear", "0 as productnum", "0 as materialver", "0 as auxprop", "'" + strSum + "' as level", "'' as element", "'' as subelement", "0 as material", "0 as submaterialver", "0 as subauxprop", "'' as entrymaterialtype", "0 as perqty", "curqty", "0 as curprice", "0 as curunitamt", "curamt", "0 as transinperqty", "transinqty", "0 as transinprice", "0 as transinunitamt", "transinamt", "0 as purperqty", "purqty", "0 as purprice", "0 as purunitamt", "puramt", "entrycurrency", "'' as treepath", "'-1' as datatype", "sumqty", "sumamt", "0 as sumunitamt", "0 as sumperqty", "0 as sumprice", "1 as istop"});
    }

    private DataSet getProductDataRow(List<QFilter> filters) {
        String mat = ResManager.loadKDString((String)"\u7269\u6599", (String)"CostReductionLevelQueryPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]);
        String pro = ResManager.loadKDString((String)"\u4ea7\u54c1\u7ea7", (String)"CostReductionLevelQueryPlugin_8", (String)"macc-sca-report", (Object[])new Object[0]);
        DataSet curSum = QueryServiceHelper.queryDataSet((String)"bb", (String)"sca_costrecovry", (String)"id,period as entryperiod,period.periodyear as periodyear,material as productnum,materialver as materialver,auxprop,material as material,materialver as submaterialver,auxprop as subauxprop,material.group.name as entrymaterialtype,headqty as curqty,headamount as curamt,headtransinqty as transinqty,headtransinamt as transinamt,headpurqty as purqty,headpuramt as puramt,currency as entrycurrency", (QFilter[])filters.toArray(new QFilter[0]), null);
        curSum = curSum.groupBy(new String[]{"id", "entryperiod", "periodyear", "productnum", "materialver", "auxprop", "material", "submaterialver", "subauxprop", "entrymaterialtype", "curqty", "curamt", "transinqty", "transinamt", "purqty", "puramt", "entrycurrency"}).finish();
        curSum = curSum.groupBy(new String[]{"entryperiod", "periodyear", "productnum", "materialver", "auxprop", "material", "submaterialver", "subauxprop", "entrymaterialtype", "entrycurrency"}).sum("curqty").sum("curamt").sum("transinqty").sum("transinamt").sum("purqty").sum("puramt").finish();
        curSum = curSum.select("0 as id,entryperiod,periodyear,productnum,materialver,auxprop,'0' as level,'" + mat + "' as element,'" + pro + "' as subelement,material,submaterialver,subauxprop,entrymaterialtype,case when curamt =0 and curqty=0 then 0 else 1 end perqty,curqty,case when curqty = 0 then 0 else curamt/curqty end curprice,case when curqty = 0 then 0 else curamt/curqty end curunitamt,curamt,case when transinamt =0 and transinqty=0 then 0 else 1 end transinperqty,transinqty,case when transinqty = 0 then 0 else transinamt/transinqty end transinprice,case when transinqty = 0 then 0 else transinamt/transinqty end transinunitamt,transinamt,case when puramt =0 and purqty=0 then 0 else 1 end purperqty,purqty,case when purqty = 0 then 0 else puramt/purqty end purprice,case when purqty = 0 then 0 else puramt/purqty end purunitamt,puramt,entrycurrency,'' as treepath,'1' as datatype");
        DynamicObjectCollection mulperiod = this.getQueryParam().getFilter().getDynamicObjectCollection("mulperiod");
        ArrayList<DataSet> sum = new ArrayList<DataSet>();
        DataSet totalSum = null;
        boolean firstflag = true;
        for (DynamicObject period : mulperiod) {
            QFilter qfperiod = new QFilter("period", "<=", (Object)period.getLong("id"));
            qfperiod.and("period.periodyear", "=", (Object)period.getInt("periodyear"));
            DataSet perioddata = this.getProductPeriodSum(qfperiod, period.getLong("id"));
            if (firstflag) {
                totalSum = perioddata;
            } else {
                sum.add(perioddata);
            }
            firstflag = false;
        }
        if (sum.size() > 0 && totalSum != null) {
            totalSum = totalSum.union(sum.toArray(new DataSet[0]));
        }
        if (totalSum == null) {
            return curSum;
        }
        DataSet zeroLevel = curSum.join(totalSum, JoinType.LEFT).on("periodyear", "periodyear").on("productnum", "productnum").on("materialver", "materialver").on("auxprop", "auxprop").on("entryperiod", "entryperiod").select(curSum.getRowMeta().getFieldNames(), new String[]{"sumqty", "sumamt", "sumunitamt", "sumperqty", "sumprice", "1 as istop"}).finish();
        DataSet zerolevel1 = curSum.join(totalSum, JoinType.RIGHT).on("periodyear", "periodyear").on("productnum", "productnum").on("materialver", "materialver").on("auxprop", "auxprop").on("entryperiod", "entryperiod").select(new String[]{"id as id1", "curqty", "curamt", "curunitamt", "perqty", "curprice", "transinperqty", "transinqty", "transinprice", "transinunitamt", "transinamt", "purperqty", "purqty", "purprice", "purunitamt", "puramt", "1 as istop"}, totalSum.getRowMeta().getFieldNames()).finish();
        zerolevel1 = zerolevel1.filter("id1 is null").select(zeroLevel.getRowMeta().getFieldNames());
        zeroLevel = zeroLevel.union(zerolevel1);
        zeroLevel = this.excludeZeroRows(zeroLevel);
        return zeroLevel;
    }

    private DataSet getProductPeriodSum(QFilter qfperiod, Long periodid) {
        List<QFilter> filters2 = this.getQFilter();
        filters2.add(qfperiod);
        QFilter periodFilter = this.getPeriodFilter();
        if (periodFilter != null) {
            filters2.add(periodFilter);
        }
        DataSet totalSumRow = QueryServiceHelper.queryDataSet((String)"aa", (String)"sca_costrecovry", (String)("id,period as entryperiod,period.periodyear as periodyear,material as productnum,materialver as materialver,auxprop," + ResManager.loadKDString((String)"'0' as level,'\u7269\u6599' as element,'\u4ea7\u54c1\u7ea7' as subelement,material as material,materialver as submaterialver,auxprop as subauxprop,material.group.name as entrymaterialtype,headamount as sumamt,headqty as sumqty,1 as sumperqty,currency as entrycurrency,'' as treepath", (String)"CostReductionLevelQueryPlugin_10", (String)"macc-sca-report", (Object[])new Object[0])), (QFilter[])filters2.toArray(new QFilter[0]), null);
        totalSumRow = totalSumRow.groupBy(new String[]{"id", "entryperiod", "periodyear", "productnum", "materialver", "auxprop", "level", "element", "subelement", "material", "submaterialver", "subauxprop", "entrymaterialtype", "sumamt", "sumqty", "sumperqty", "entrycurrency", "treepath"}).finish();
        totalSumRow = totalSumRow.groupBy(new String[]{"periodyear", "productnum", "materialver", "auxprop", "level", "element", "subelement", "material", "submaterialver", "subauxprop", "entrymaterialtype", "entrycurrency", "treepath"}).sum("sumqty").sum("sumamt").avg("sumperqty").finish();
        return totalSumRow.select("1 id,periodyear,productnum,materialver,auxprop,level,element,subelement,material,submaterialver,subauxprop,entrymaterialtype,sumqty,sumamt,sumperqty,case when sumqty =0 then 0 else sumamt/sumqty end sumunitamt,case when sumqty =0 or sumperqty = 0 then 0 else sumamt/sumqty/sumperqty end sumprice," + periodid + "L entryperiod,entrycurrency,treepath,'1' as datatype");
    }

    private DataSet getNormalDataRow(List<QFilter> filters) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"aa", (String)"sca_costrecovry", (String)"id,period as entryperiod,period.periodyear as periodyear,material as productnum,materialver as materialver,auxprop,headqty,headtransinqty,headpurqty,concat('',entryentity.level) as level,entryentity.element.name as element,entryentity.subelement.name as subelement,entryentity.submaterial as material,entryentity.submaterialver as submaterialver,entryentity.submaterialauxprop as subauxprop,entryentity.submaterial.group.name as entrymaterialtype,entryentity.qty as curqty,entryentity.amount as curamt,entryentity.transinqty transinqty,entryentity.transinamount transinamt,entryentity.purqty purqty,entryentity.puramount puramt,currency as entrycurrency,entryentity.treepath as treepath", (QFilter[])filters.toArray(new QFilter[0]), null);
        DataSet productqty = dataSet.copy().groupBy(new String[]{"id", "entryperiod", "periodyear", "productnum", "materialver", "auxprop", "headqty", "headtransinqty", "headpurqty"}).finish().groupBy(new String[]{"entryperiod", "periodyear", "productnum", "materialver", "auxprop"}).sum("headqty").sum("headtransinqty").sum("headpurqty").finish();
        dataSet = dataSet.groupBy(new String[]{"entryperiod", "periodyear", "productnum", "materialver", "auxprop", "level", "element", "subelement", "material", "submaterialver", "subauxprop", "entrymaterialtype", "entrycurrency", "treepath"}).sum("headqty").sum("curqty").sum("curamt").sum("transinqty").sum("transinamt").sum("purqty").sum("puramt").finish();
        dataSet = dataSet.removeFields(new String[]{"headqty"});
        dataSet = dataSet.join(productqty, JoinType.LEFT).on("entryperiod", "entryperiod").on("productnum", "productnum").on("materialver", "materialver").on("auxprop", "auxprop").select(dataSet.getRowMeta().getFieldNames(), new String[]{"headqty", "headtransinqty", "headpurqty"}).finish();
        dataSet = dataSet.select("0 id,entryperiod,periodyear,productnum,materialver,auxprop,level,element,subelement,material,submaterialver,subauxprop,entrymaterialtype ,case when headqty = 0 then 0 else curqty/headqty end perqty,curqty,case when curqty = 0 then 0 else curamt/curqty end curprice,case when headqty = 0 then 0 else curamt/headqty end curunitamt,curamt,case when headtransinqty=0 then 0 else transinqty/headtransinqty end transinperqty,transinqty,case when transinqty = 0 then 0 else transinamt/transinqty end transinprice,case when headtransinqty = 0 then 0 else transinamt/headtransinqty end transinunitamt,transinamt,case when headpurqty=0 then 0 else purqty/headpurqty end purperqty,purqty,case when purqty = 0 then 0 else puramt/purqty end purprice,case when headpurqty = 0 then 0 else puramt/headpurqty end purunitamt,puramt,entrycurrency,treepath,'0' as datatype");
        DataSet normal = this.getNormalSumRow();
        DataSet nomralJoin = dataSet.join(normal, JoinType.LEFT).on("periodyear", "periodyear").on("productnum", "productnum").on("materialver", "materialver").on("auxprop", "auxprop").on("material", "material").on("submaterialver", "submaterialver").on("subauxprop", "subauxprop").on("level", "level").on("element", "element").on("subelement", "subelement").on("periodyear", "periodyear").on("entryperiod", "entryperiod").on("treepath", "treepath").select(dataSet.getRowMeta().getFieldNames(), new String[]{"sumqty", "sumamt", "sumunitamt", "sumperqty", "sumprice", "1 as istop"}).finish();
        if (normal == null) {
            return nomralJoin;
        }
        DataSet nomralJoin1 = dataSet.join(normal, JoinType.RIGHT).on("periodyear", "periodyear").on("productnum", "productnum").on("materialver", "materialver").on("auxprop", "auxprop").on("material", "material").on("submaterialver", "submaterialver").on("subauxprop", "subauxprop").on("level", "level").on("element", "element").on("subelement", "subelement").on("periodyear", "periodyear").on("entryperiod", "entryperiod").on("treepath", "treepath").select(new String[]{"id as id1", "curqty", "curamt", "curunitamt", "perqty", "curprice", "transinperqty", "transinqty", "transinprice", "transinunitamt", "transinamt", "purperqty", "purqty", "purprice", "purunitamt", "puramt", "1 as istop"}, normal.getRowMeta().getFieldNames()).finish();
        nomralJoin1 = nomralJoin1.filter("id1 is null").select(nomralJoin.getRowMeta().getFieldNames());
        nomralJoin = nomralJoin.union(nomralJoin1);
        nomralJoin = this.excludeZeroRows(nomralJoin);
        return nomralJoin;
    }

    private DataSet excludeZeroRows(DataSet nomralJoin) {
        StringBuilder sb = new StringBuilder();
        sb.append("!(");
        sb.append("curqty==0 and curamt==0 and sumqty==0 and sumprice==0 ");
        if (this.getQueryParam().getFilter().getBoolean("viewtransincost")) {
            sb.append("and transinqty==0 and transinamt==0 ");
        }
        if (this.getQueryParam().getFilter().getBoolean("viewpurcost")) {
            sb.append("and purqty==0 and puramt==0 ");
        }
        sb.append(")");
        return nomralJoin.filter(sb.toString());
    }

    private DataSet showWithMaterialTypeNew(DataSet normalJoin) {
        normalJoin = this.dealMaterialGroup(normalJoin);
        RowMeta rowMeta = normalJoin.getRowMeta();
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
        Field[] fields = rowMeta.getFields();
        HashSet<Long> materialSet = new HashSet<Long>(16);
        HashMap<String, String> matToType = new HashMap<String, String>(16);
        DataSet copy = normalJoin.copy();
        while (copy.hasNext()) {
            Row next = copy.next();
            materialSet.add(next.getLong("material"));
        }
        QFilter filter = new QFilter("material", "in", materialSet);
        DynamicObject materialgrpstd = this.getQueryParam().getFilter().getDynamicObject("materialgrpstd");
        if (materialgrpstd == null) {
            filter.and(new QFilter("standard", "=", (Object)730148448254487552L));
        } else {
            filter.and(new QFilter("standard", "=", (Object)materialgrpstd.getLong("id")));
        }
        DataSet materialDOs = QueryServiceHelper.queryDataSet((String)MaterialGroupHelper.class.getName(), (String)"bd_materialgroupdetail", (String)"material id,group.id typeid", (QFilter[])filter.toArray(), null);
        for (Row matDO : materialDOs) {
            matToType.put(matDO.getString("id"), matDO.getString("typeid"));
        }
        String appnum = this.getQueryParam().getFilter().getString("appnum");
        while (normalJoin.hasNext()) {
            Row row = normalJoin.next();
            Object[] rowData = new Object[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                String name = fields[i].getName();
                Object val = row.get(name);
                if ("treepath".equals(name) && val != null) {
                    String val1 = (String)val;
                    Object[] split = val1.split("@");
                    int len = split.length;
                    boolean isResurce = false;
                    if (len >= 2 && "0".equals(split[len - 2])) {
                        isResurce = true;
                    }
                    for (int j = 0; j < len; ++j) {
                        split[j] = matToType.containsKey(split[j]) ? (String)matToType.get(split[j]) : "0";
                    }
                    val = isResurce ? StringUtils.join((Object[])split, (String)"@", (int)0, (int)(len - 1)) : StringUtils.join((Object[])split, (String)"@", (int)0, (int)len);
                }
                rowData[i] = val;
            }
            dataList.add(rowData);
        }
        DataSet treepathDeal = Algo.create((String)"macc.sca.treepath").createDataSet(dataList.iterator(), rowMeta);
        DataSet matType = treepathDeal.groupBy(new String[]{"entryperiod", "periodyear", "productnum", "materialver", "auxprop", "level", "element", "subelement", "entrymaterialtype", "entrycurrency", "treepath", "datatype", "istop"}).sum("perqty").sum("curqty").sum("curunitamt").sum("curamt").sum("sumqty").sum("sumamt").sum("sumunitamt").sum("sumperqty").sum("transinperqty").sum("transinqty").sum("transinprice").sum("transinunitamt").sum("transinamt").sum("purperqty").sum("purqty").sum("purprice").sum("purunitamt").sum("puramt").finish().select("0 id,entryperiod,periodyear,productnum,materialver,auxprop,level,element,subelement,0 material,0 submaterialver,0 subauxprop,entrymaterialtype,perqty,curqty,case when curqty=0 then 0 else curamt/curqty end curprice,curunitamt,curamt,transinperqty,transinqty,case when transinqty=0 then 0 else transinamt/transinqty end transinprice,transinunitamt,transinamt,purperqty,purqty,case when purperqty=0 then 0 else puramt/puramt end purprice,purunitamt,puramt,entrycurrency,treepath,datatype,sumqty,sumamt,sumunitamt,sumperqty,case when sumqty=0 then 0 else sumamt/sumqty end sumprice,istop");
        return matType;
    }

    private DataSet getNormalSumRow() {
        DynamicObjectCollection mulperiod = this.getQueryParam().getFilter().getDynamicObjectCollection("mulperiod");
        ArrayList<DataSet> sum = new ArrayList<DataSet>();
        DataSet result = null;
        boolean firstflag = true;
        for (DynamicObject period : mulperiod) {
            QFilter qfperiod = new QFilter("period", "<=", (Object)period.getLong("id"));
            qfperiod.and("period.periodyear", "=", (Object)period.getInt("periodyear"));
            DataSet perioddata = this.getPeriodSum(qfperiod, period.getLong("id"));
            if (firstflag) {
                result = perioddata;
            } else {
                sum.add(perioddata);
            }
            firstflag = false;
        }
        if (sum.size() > 0 && result != null) {
            return result.union(sum.toArray(new DataSet[0]));
        }
        return result;
    }

    private DataSet getPeriodSum(QFilter qfperiod, Long periodid) {
        List<QFilter> filters = this.getQFilter();
        int displaylevel = this.getQueryParam().getFilter().getInt("displaylevel");
        if (displaylevel != 0) {
            filters.add(new QFilter("entryentity.level", "<=", (Object)displaylevel));
        }
        filters.add(new QFilter("entryentity.level", ">", (Object)0));
        filters.add(qfperiod);
        QFilter periodFilter = this.getPeriodFilter();
        if (periodFilter != null) {
            filters.add(periodFilter);
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"dd", (String)"sca_costrecovry", (String)"id,period.periodyear as periodyear,material as productnum,materialver as materialver,auxprop,concat('',entryentity.level) as level,entryentity.element.name as element,entryentity.subelement.name as subelement,entryentity.submaterial as material,entryentity.submaterialver as submaterialver ,entryentity.submaterialauxprop as subauxprop,entryentity.submaterial.group.name as entrymaterialtype,headqty,entryentity.qty as sumqty,entryentity.amount as sumamt,currency as entrycurrency,entryentity.treepath as treepath", (QFilter[])filters.toArray(new QFilter[0]), null);
        DataSet productQty = dataSet.copy().groupBy(new String[]{"id", "productnum", "materialver", "auxprop", "headqty"}).finish().groupBy(new String[]{"productnum", "materialver", "auxprop"}).sum("headqty").finish();
        dataSet = dataSet.groupBy(new String[]{"productnum", "materialver", "periodyear", "material", "submaterialver", "subauxprop", "entrymaterialtype", "auxprop", "level", "element", "subelement", "entrycurrency", "treepath"}).sum("sumqty").sum("sumamt").sum("headqty").finish();
        dataSet = dataSet.removeFields(new String[]{"headqty"});
        dataSet = dataSet.join(productQty, JoinType.LEFT).on("productnum", "productnum").on("materialver", "materialver").on("auxprop", "auxprop").select(dataSet.getRowMeta().getFieldNames(), new String[]{"headqty"}).finish();
        dataSet = dataSet.select("1 id,productnum,materialver,entrymaterialtype,auxprop,level,element,subelement," + periodid + "L as entryperiod,material,submaterialver,subauxprop,periodyear,entrycurrency,treepath,case when headqty = 0 then 0 else sumqty/headqty end sumperqty,sumqty,case when sumqty = 0 then 0 else sumamt/sumqty end sumprice,case when headqty = 0 then 0 else sumamt/headqty end sumunitamt,sumamt,'0' as datatype");
        return dataSet;
    }

    private DataSet calcPeriodSum(DataSet dataset) {
        DataSet copy = dataset.copy();
        RowMeta rowMeta = dataset.getRowMeta();
        Field[] fields = rowMeta.getFields();
        ArrayList<Object[]> listdataset = new ArrayList<Object[]>(16);
        while (dataset.hasNext()) {
            Row row = dataset.next();
            Object[] rowData = new Object[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                Object val;
                String name = fields[i].getName();
                rowData[i] = val = row.get(name);
            }
            listdataset.add(rowData);
        }
        for (int i = 0; i < listdataset.size(); ++i) {
            for (int j = 0; j < listdataset.size(); ++j) {
            }
        }
        return null;
    }

    private QFilter getPeriodFilter() {
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        DynamicObjectCollection costaccount = filterInfo.getDynamicObjectCollection("costaccount");
        DynamicObjectCollection mulperiod = filterInfo.getDynamicObjectCollection("mulperiod");
        Set collect = mulperiod.stream().map(a -> a.getInt("periodyear")).collect(Collectors.toSet());
        QFilter period = StartCostHelper.getPeriodTypeFilter((String)filterInfo.getString("appnum"), (Long)((Long)((DynamicObject)costaccount.get(0)).getPkValue()));
        period.and(new QFilter("periodyear", "in", collect));
        DataSet periods = QueryServiceHelper.queryDataSet((String)"aa", (String)"bd_period", (String)"id", (QFilter[])period.toArray(), null);
        HashSet<Long> set = new HashSet<Long>();
        while (periods.hasNext()) {
            set.add(periods.next().getLong("id"));
        }
        if (set.size() > 0) {
            return new QFilter("period", "in", set);
        }
        return null;
    }

    private void init(Map<String, Object> params) {
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        params.put("onlysumrow", filterInfo.getBoolean("onlysumrow"));
        params.put("onlymaterialtype", filterInfo.getBoolean("onlymaterialtype"));
        params.put("topsumrow", filterInfo.getBoolean("topsumrow"));
        if (filterInfo.containProp("notQuery")) {
            params.put("notQuery", "true");
        }
    }

    private List<QFilter> getQFilter() {
        DynamicObjectCollection mulmaterial;
        DynamicObjectCollection mulproduct;
        DynamicObjectCollection storageorgunitCol;
        DynamicObjectCollection prodorg;
        DynamicObjectCollection costaccount;
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        DynamicObjectCollection org = filterInfo.getDynamicObjectCollection("org");
        if (org != null) {
            Set orgSet = org.stream().map(s -> (Long)s.getPkValue()).collect(Collectors.toSet());
            list.add(new QFilter("org", "in", orgSet));
        }
        if ((costaccount = filterInfo.getDynamicObjectCollection("costaccount")) != null) {
            Set accSet = costaccount.stream().map(s -> (Long)s.getPkValue()).collect(Collectors.toSet());
            list.add(new QFilter("costaccount", "in", accSet));
        }
        if ((prodorg = filterInfo.getDynamicObjectCollection("prdorg")) != null) {
            Set prodorgSet = prodorg.stream().map(s -> (Long)s.getPkValue()).collect(Collectors.toSet());
            list.add(new QFilter("manuorg", "in", prodorgSet));
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(storageorgunitCol = filterInfo.getDynamicObjectCollection("storageorgunit")))) {
            Set storgSet = storageorgunitCol.stream().map(r -> r.getLong("id")).collect(Collectors.toSet());
            list.add(new QFilter("storageorgunit", "in", storgSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(mulproduct = filterInfo.getDynamicObjectCollection("mulproduct")))) {
            Set collect = mulproduct.stream().map(a -> (Long)a.getPkValue()).collect(Collectors.toSet());
            list.add(new QFilter("material", "in", collect));
        }
        if (!CollectionUtils.isEmpty((Collection)(mulmaterial = filterInfo.getDynamicObjectCollection("mulmaterial")))) {
            Set collect = mulmaterial.stream().map(a -> (Long)a.getPkValue()).collect(Collectors.toSet());
            list.add(new QFilter("entryentity.submaterial", "in", collect));
        } else {
            DynamicObjectCollection materialtype = filterInfo.getDynamicObjectCollection("mulmaterialtype");
            DynamicObject materialgrpstd = filterInfo.getDynamicObject("materialgrpstd");
            if (materialtype != null || materialgrpstd != null && materialgrpstd.getLong("id") != 730148448254487552L) {
                Set materialIds = MaterialGroupHelper.getClassifiedMaterialId((DynamicObjectCollection)materialtype, (boolean)false, (DynamicObject)materialgrpstd, (boolean)true);
                list.add(InFilterHelper.getQFilterByBachSize((String)"entryentity.submaterial", new ArrayList(materialIds), (String)"in", (int)20000));
            }
        }
        return list;
    }
}

